/* GNU moe - My Own Editor
   Copyright (C) 2005-2026 Antonio Diaz Diaz.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace RC {

class Options
  {
  int indent_step_, keep_lines_, max_windows_;
public:
  int show_code_lpos;			// 1 show code, 2 show lpos
  bool auto_unmark, backup, /*beep,*/ exit_ask, ignore_case;
  bool preserve_links, rectangle_mode, search_wrap, smart_home;

  Options()
    : indent_step_( 2 ), keep_lines_( -1 ), max_windows_( 0 ),
    show_code_lpos( 0 ),
    auto_unmark( false ), backup( true ), /*beep( false ),*/ exit_ask( false ),
    ignore_case( false ), preserve_links( false ), rectangle_mode( false ),
    search_wrap( false ), smart_home( true ) {}

  int indent_step() const { return indent_step_; }
  int keep_lines() const { return keep_lines_; }
  int max_windows() const { return max_windows_; }
  bool set_indent_step( const int n )
    { if( n < 1 || n > 99 ) { return false; } indent_step_ = n; return true; }
  bool set_keep_lines( const int n )
    { if( n < -1 || n > 99 ) { return false; } keep_lines_ = n; return true; }
  bool set_max_windows( const int n )
    { if( n < 0 || n > 99 ) { return false; } max_windows_ = n; return true; }

  void reset() { *this = Options(); }
  };


Options & editor_options();			// global editor options

void apply_all_file_options( Buffer & buffer );

// Return true if first non-whitespace character is '+' or '-'.
bool issigned( const char * ptr );

// Return the number of bytes read, or 0 if error.
int parse_int( const char * const ptr, int & result );
int parse_long( const char * const ptr, long & result, const bool last = true );
int parse_relative_long( const char * const ptr, long & result );

// Return 0 if success, 1 if file not found, 2 if syntax error.
int process_rcfile( const char * const name );

// Return 0 if success, 1 if invalid option, 2 if a file can't be read.
int process_options();

int read_options( const int argc, const char * const argv[] );

void reset();

// defined in main.cc
const std::string & home_directory();
void show_error( const char * const msg, const int errcode = 0,
                 const bool help = false );

} // end namespace RC

// defined in window.cc
const char * format_num3( unsigned long long num, const bool negative = false );
