/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.gui;

import com.puppycrawl.tools.checkstyle.gui.TreeTable;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    private static final long serialVersionUID = 4324031590789321581L;
    private final TreeTable treeTable;
    private int visibleRow;

    TreeTableCellRenderer(TreeTable treeTable, TreeModel model) {
        super(model);
        this.treeTable = treeTable;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        TreeCellRenderer tcr = this.getCellRenderer();
        if (tcr instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)tcr;
            renderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
            renderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
        }
    }

    @Override
    public void setRowHeight(int newRowHeight) {
        if (newRowHeight > 0) {
            super.setRowHeight(newRowHeight);
            if (this.treeTable != null && this.treeTable.getRowHeight() != newRowHeight) {
                this.treeTable.setRowHeight(this.getRowHeight());
            }
        }
    }

    @Override
    public void setBounds(int x, int y, int w, int h2) {
        super.setBounds(x, 0, w, this.treeTable.getHeight());
    }

    @Override
    public void paint(Graphics graph) {
        graph.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(graph);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(table.getBackground());
        }
        this.visibleRow = row;
        return this;
    }
}

