/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.addins;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.internal.texteditor.spelling.NoCompletionsProposal;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.addins.SQLEditorQuickFixProcessorDescriptor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLEditorQuickAssistProcessor
implements IQuickAssistProcessor {
    private static final Log log = Log.getLog(SQLEditorQuickAssistProcessor.class);
    @NotNull
    private static final ICompletionProposal[] noSuggestionsProposal = new ICompletionProposal[]{new NoCompletionsProposal()};
    @NotNull
    private final List<QuickFixHandler> processors = new ArrayList<QuickFixHandler>();
    @NotNull
    private final SQLEditorBase editor;

    public SQLEditorQuickAssistProcessor(@NotNull SQLEditorBase editor) {
        this.editor = editor;
    }

    public void appendProcessor(@NotNull IQuickAssistProcessor quickAssistProcessor) {
        this.processors.add(new QuickFixHandler(null, quickAssistProcessor));
    }

    public void appendProcessors(@NotNull Collection<SQLEditorQuickFixProcessorDescriptor> quickFixProcessorDescriptors) {
        for (SQLEditorQuickFixProcessorDescriptor d : quickFixProcessorDescriptors) {
            try {
                this.processors.add(new QuickFixHandler(d, d.createInstance()));
            }
            catch (DBException e) {
                log.error((Object)("Can't load quick fix handler '" + d.getId() + "'"), (Throwable)e);
            }
        }
    }

    @Nullable
    public String getErrorMessage() {
        List<String> errorMessages = this.processors.stream().map(p -> p.processor.getErrorMessage()).toList();
        if (errorMessages.stream().anyMatch(CommonUtils::isEmpty)) {
            return null;
        }
        return errorMessages.stream().filter(CommonUtils::isNotEmpty).distinct().collect(Collectors.joining("\n"));
    }

    public boolean canFix(@NotNull Annotation annotation) {
        return this.processors.stream().anyMatch(p -> (p.descriptor == null || p.descriptor.handlesAnnotation(annotation)) && p.processor.canFix(annotation));
    }

    public boolean canAssist(@NotNull IQuickAssistInvocationContext invocationContext) {
        return this.processors.stream().anyMatch(p -> (p.descriptor == null || p.descriptor.isEnabled((IWorkbenchSite)this.editor.getEditorSite())) && p.processor.canAssist(invocationContext));
    }

    @NotNull
    public ICompletionProposal[] computeQuickAssistProposals(@NotNull IQuickAssistInvocationContext invocationContext) {
        Object[] proposals = (ICompletionProposal[])this.processors.stream().flatMap(p -> Arrays.stream(p.processor.computeQuickAssistProposals(invocationContext))).filter(p -> !(p instanceof NoCompletionsProposal)).toArray(ICompletionProposal[]::new);
        return ArrayUtils.isEmpty((Object[])proposals) ? noSuggestionsProposal : proposals;
    }

    private record QuickFixHandler(@Nullable SQLEditorQuickFixProcessorDescriptor descriptor, @NotNull IQuickAssistProcessor processor) {
    }
}

