/* automatically generated by rust-bindgen */

pub const MDB_VERSION_MAJOR: ::libc::c_uint = 0;
pub const MDB_VERSION_MINOR: ::libc::c_uint = 9;
pub const MDB_VERSION_PATCH: ::libc::c_uint = 24;
pub const MDB_VERSION_DATE: &'static [u8; 14usize] = b"July 24, 2019\0";
pub const MDB_FIXEDMAP: ::libc::c_uint = 1;
pub const MDB_NOSUBDIR: ::libc::c_uint = 16384;
pub const MDB_NOSYNC: ::libc::c_uint = 65536;
pub const MDB_RDONLY: ::libc::c_uint = 131072;
pub const MDB_NOMETASYNC: ::libc::c_uint = 262144;
pub const MDB_WRITEMAP: ::libc::c_uint = 524288;
pub const MDB_MAPASYNC: ::libc::c_uint = 1048576;
pub const MDB_NOTLS: ::libc::c_uint = 2097152;
pub const MDB_NOLOCK: ::libc::c_uint = 4194304;
pub const MDB_NORDAHEAD: ::libc::c_uint = 8388608;
pub const MDB_NOMEMINIT: ::libc::c_uint = 16777216;
pub const MDB_REVERSEKEY: ::libc::c_uint = 2;
pub const MDB_DUPSORT: ::libc::c_uint = 4;
pub const MDB_INTEGERKEY: ::libc::c_uint = 8;
pub const MDB_DUPFIXED: ::libc::c_uint = 16;
pub const MDB_INTEGERDUP: ::libc::c_uint = 32;
pub const MDB_REVERSEDUP: ::libc::c_uint = 64;
pub const MDB_CREATE: ::libc::c_uint = 262144;
pub const MDB_NOOVERWRITE: ::libc::c_uint = 16;
pub const MDB_NODUPDATA: ::libc::c_uint = 32;
pub const MDB_CURRENT: ::libc::c_uint = 64;
pub const MDB_RESERVE: ::libc::c_uint = 65536;
pub const MDB_APPEND: ::libc::c_uint = 131072;
pub const MDB_APPENDDUP: ::libc::c_uint = 262144;
pub const MDB_MULTIPLE: ::libc::c_uint = 524288;
pub const MDB_CP_COMPACT: ::libc::c_uint = 1;
pub const MDB_SUCCESS: ::libc::c_int = 0;
pub const MDB_KEYEXIST: ::libc::c_int = -30799;
pub const MDB_NOTFOUND: ::libc::c_int = -30798;
pub const MDB_PAGE_NOTFOUND: ::libc::c_int = -30797;
pub const MDB_CORRUPTED: ::libc::c_int = -30796;
pub const MDB_PANIC: ::libc::c_int = -30795;
pub const MDB_VERSION_MISMATCH: ::libc::c_int = -30794;
pub const MDB_INVALID: ::libc::c_int = -30793;
pub const MDB_MAP_FULL: ::libc::c_int = -30792;
pub const MDB_DBS_FULL: ::libc::c_int = -30791;
pub const MDB_READERS_FULL: ::libc::c_int = -30790;
pub const MDB_TLS_FULL: ::libc::c_int = -30789;
pub const MDB_TXN_FULL: ::libc::c_int = -30788;
pub const MDB_CURSOR_FULL: ::libc::c_int = -30787;
pub const MDB_PAGE_FULL: ::libc::c_int = -30786;
pub const MDB_MAP_RESIZED: ::libc::c_int = -30785;
pub const MDB_INCOMPATIBLE: ::libc::c_int = -30784;
pub const MDB_BAD_RSLOT: ::libc::c_int = -30783;
pub const MDB_BAD_TXN: ::libc::c_int = -30782;
pub const MDB_BAD_VALSIZE: ::libc::c_int = -30781;
pub const MDB_BAD_DBI: ::libc::c_int = -30780;
pub const MDB_LAST_ERRCODE: ::libc::c_int = -30780;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MDB_env {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MDB_txn {
    _unused: [u8; 0],
}
#[doc = " @brief A handle for an individual database in the DB environment."]
pub type MDB_dbi = ::libc::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MDB_cursor {
    _unused: [u8; 0],
}
#[doc = " @brief Generic structure used for passing keys and data in and out"]
#[doc = " of the database."]
#[doc = ""]
#[doc = " Values returned from the database are valid only until a subsequent"]
#[doc = " update operation, or the end of the transaction. Do not modify or"]
#[doc = " free them, they commonly point into the database itself."]
#[doc = ""]
#[doc = " Key sizes must be between 1 and #mdb_env_get_maxkeysize() inclusive."]
#[doc = " The same applies to data sizes in databases with the #MDB_DUPSORT flag."]
#[doc = " Other data items can in theory be from 0 to 0xffffffff bytes long."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MDB_val {
    #[doc = "< size of the data item"]
    pub mv_size: usize,
    #[doc = "< address of the data item"]
    pub mv_data: *mut ::libc::c_void,
}
#[doc = " @brief A callback function used to compare two keys in a database"]
pub type MDB_cmp_func = ::std::option::Option<
    unsafe extern "C" fn(a: *const MDB_val, b: *const MDB_val) -> ::libc::c_int,
>;
#[doc = " @brief A callback function used to relocate a position-dependent data item"]
#[doc = " in a fixed-address database."]
#[doc = ""]
#[doc = " The \\b newptr gives the item's desired address in"]
#[doc = " the memory map, and \\b oldptr gives its previous address. The item's actual"]
#[doc = " data resides at the address in \\b item.  This callback is expected to walk"]
#[doc = " through the fields of the record in \\b item and modify any"]
#[doc = " values based at the \\b oldptr address to be relative to the \\b newptr address."]
#[doc = " @param[in,out] item The item that is to be relocated."]
#[doc = " @param[in] oldptr The previous address."]
#[doc = " @param[in] newptr The new address to relocate to."]
#[doc = " @param[in] relctx An application-provided context, set by #mdb_set_relctx()."]
#[doc = " @todo This feature is currently unimplemented."]
pub type MDB_rel_func = ::std::option::Option<
    unsafe extern "C" fn(
        item: *mut MDB_val,
        oldptr: *mut ::libc::c_void,
        newptr: *mut ::libc::c_void,
        relctx: *mut ::libc::c_void,
    ),
>;
#[doc = "< Position at first key/data item"]
pub const MDB_FIRST: MDB_cursor_op = 0;
#[doc = "< Position at first data item of current key."]
#[doc = "Only for #MDB_DUPSORT"]
pub const MDB_FIRST_DUP: MDB_cursor_op = 1;
#[doc = "< Position at key/data pair. Only for #MDB_DUPSORT"]
pub const MDB_GET_BOTH: MDB_cursor_op = 2;
#[doc = "< position at key, nearest data. Only for #MDB_DUPSORT"]
pub const MDB_GET_BOTH_RANGE: MDB_cursor_op = 3;
#[doc = "< Return key/data at current cursor position"]
pub const MDB_GET_CURRENT: MDB_cursor_op = 4;
#[doc = "< Return up to a page of duplicate data items"]
#[doc = "from current cursor position. Move cursor to prepare"]
#[doc = "for #MDB_NEXT_MULTIPLE. Only for #MDB_DUPFIXED"]
pub const MDB_GET_MULTIPLE: MDB_cursor_op = 5;
#[doc = "< Position at last key/data item"]
pub const MDB_LAST: MDB_cursor_op = 6;
#[doc = "< Position at last data item of current key."]
#[doc = "Only for #MDB_DUPSORT"]
pub const MDB_LAST_DUP: MDB_cursor_op = 7;
#[doc = "< Position at next data item"]
pub const MDB_NEXT: MDB_cursor_op = 8;
#[doc = "< Position at next data item of current key."]
#[doc = "Only for #MDB_DUPSORT"]
pub const MDB_NEXT_DUP: MDB_cursor_op = 9;
#[doc = "< Return up to a page of duplicate data items"]
#[doc = "from next cursor position. Move cursor to prepare"]
#[doc = "for #MDB_NEXT_MULTIPLE. Only for #MDB_DUPFIXED"]
pub const MDB_NEXT_MULTIPLE: MDB_cursor_op = 10;
#[doc = "< Position at first data item of next key"]
pub const MDB_NEXT_NODUP: MDB_cursor_op = 11;
#[doc = "< Position at previous data item"]
pub const MDB_PREV: MDB_cursor_op = 12;
#[doc = "< Position at previous data item of current key."]
#[doc = "Only for #MDB_DUPSORT"]
pub const MDB_PREV_DUP: MDB_cursor_op = 13;
#[doc = "< Position at last data item of previous key"]
pub const MDB_PREV_NODUP: MDB_cursor_op = 14;
#[doc = "< Position at specified key"]
pub const MDB_SET: MDB_cursor_op = 15;
#[doc = "< Position at specified key, return key + data"]
pub const MDB_SET_KEY: MDB_cursor_op = 16;
#[doc = "< Position at first key greater than or equal to specified key."]
pub const MDB_SET_RANGE: MDB_cursor_op = 17;
#[doc = "< Position at previous page and return up to"]
#[doc = "a page of duplicate data items. Only for #MDB_DUPFIXED"]
pub const MDB_PREV_MULTIPLE: MDB_cursor_op = 18;
#[doc = " @brief Cursor Get operations."]
#[doc = ""]
#[doc = "\tThis is the set of all operations for retrieving data"]
#[doc = "\tusing a cursor."]
pub type MDB_cursor_op = u32;
#[doc = " @brief Statistics for a database in the environment"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MDB_stat {
    #[doc = "< Size of a database page."]
    #[doc = "This is currently the same for all databases."]
    pub ms_psize: ::libc::c_uint,
    #[doc = "< Depth (height) of the B-tree"]
    pub ms_depth: ::libc::c_uint,
    #[doc = "< Number of internal (non-leaf) pages"]
    pub ms_branch_pages: usize,
    #[doc = "< Number of leaf pages"]
    pub ms_leaf_pages: usize,
    #[doc = "< Number of overflow pages"]
    pub ms_overflow_pages: usize,
    #[doc = "< Number of data items"]
    pub ms_entries: usize,
}
#[doc = " @brief Information about the environment"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MDB_envinfo {
    #[doc = "< Address of map, if fixed"]
    pub me_mapaddr: *mut ::libc::c_void,
    #[doc = "< Size of the data memory map"]
    pub me_mapsize: usize,
    #[doc = "< ID of the last used page"]
    pub me_last_pgno: usize,
    #[doc = "< ID of the last committed transaction"]
    pub me_last_txnid: usize,
    #[doc = "< max reader slots in the environment"]
    pub me_maxreaders: ::libc::c_uint,
    #[doc = "< max reader slots used in the environment"]
    pub me_numreaders: ::libc::c_uint,
}
extern "C" {
    #[doc = " @brief Return the LMDB library version information."]
    #[doc = ""]
    #[doc = " @param[out] major if non-NULL, the library major version number is copied here"]
    #[doc = " @param[out] minor if non-NULL, the library minor version number is copied here"]
    #[doc = " @param[out] patch if non-NULL, the library patch version number is copied here"]
    #[doc = " @retval \"version string\" The library version as a string"]
    pub fn mdb_version(
        major: *mut ::libc::c_int,
        minor: *mut ::libc::c_int,
        patch: *mut ::libc::c_int,
    ) -> *mut ::libc::c_char;
}
extern "C" {
    #[doc = " @brief Return a string describing a given error code."]
    #[doc = ""]
    #[doc = " This function is a superset of the ANSI C X3.159-1989 (ANSI C) strerror(3)"]
    #[doc = " function. If the error code is greater than or equal to 0, then the string"]
    #[doc = " returned by the system function strerror(3) is returned. If the error code"]
    #[doc = " is less than 0, an error string corresponding to the LMDB library error is"]
    #[doc = " returned. See @ref errors for a list of LMDB-specific error codes."]
    #[doc = " @param[in] err The error code"]
    #[doc = " @retval \"error message\" The description of the error"]
    pub fn mdb_strerror(err: ::libc::c_int) -> *mut ::libc::c_char;
}
extern "C" {
    #[doc = " @brief Create an LMDB environment handle."]
    #[doc = ""]
    #[doc = " This function allocates memory for a #MDB_env structure. To release"]
    #[doc = " the allocated memory and discard the handle, call #mdb_env_close()."]
    #[doc = " Before the handle may be used, it must be opened using #mdb_env_open()."]
    #[doc = " Various other options may also need to be set before opening the handle,"]
    #[doc = " e.g. #mdb_env_set_mapsize(), #mdb_env_set_maxreaders(), #mdb_env_set_maxdbs(),"]
    #[doc = " depending on usage requirements."]
    #[doc = " @param[out] env The address where the new handle will be stored"]
    #[doc = " @return A non-zero error value on failure and 0 on success."]
    pub fn mdb_env_create(env: *mut *mut MDB_env) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Open an environment handle."]
    #[doc = ""]
    #[doc = " If this function fails, #mdb_env_close() must be called to discard the #MDB_env handle."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[in] path The directory in which the database files reside. This"]
    #[doc = " directory must already exist and be writable."]
    #[doc = " @param[in] flags Special options for this environment. This parameter"]
    #[doc = " must be set to 0 or by bitwise OR'ing together one or more of the"]
    #[doc = " values described here."]
    #[doc = " Flags set by mdb_env_set_flags() are also used."]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_FIXEDMAP"]
    #[doc = "      use a fixed address for the mmap region. This flag must be specified"]
    #[doc = "      when creating the environment, and is stored persistently in the environment."]
    #[doc = "\t\tIf successful, the memory map will always reside at the same virtual address"]
    #[doc = "\t\tand pointers used to reference data items in the database will be constant"]
    #[doc = "\t\tacross multiple invocations. This option may not always work, depending on"]
    #[doc = "\t\thow the operating system has allocated memory to shared libraries and other uses."]
    #[doc = "\t\tThe feature is highly experimental."]
    #[doc = "\t<li>#MDB_NOSUBDIR"]
    #[doc = "\t\tBy default, LMDB creates its environment in a directory whose"]
    #[doc = "\t\tpathname is given in \\b path, and creates its data and lock files"]
    #[doc = "\t\tunder that directory. With this option, \\b path is used as-is for"]
    #[doc = "\t\tthe database main data file. The database lock file is the \\b path"]
    #[doc = "\t\twith \"-lock\" appended."]
    #[doc = "\t<li>#MDB_RDONLY"]
    #[doc = "\t\tOpen the environment in read-only mode. No write operations will be"]
    #[doc = "\t\tallowed. LMDB will still modify the lock file - except on read-only"]
    #[doc = "\t\tfilesystems, where LMDB does not use locks."]
    #[doc = "\t<li>#MDB_WRITEMAP"]
    #[doc = "\t\tUse a writeable memory map unless MDB_RDONLY is set. This uses"]
    #[doc = "\t\tfewer mallocs but loses protection from application bugs"]
    #[doc = "\t\tlike wild pointer writes and other bad updates into the database."]
    #[doc = "\t\tThis may be slightly faster for DBs that fit entirely in RAM, but"]
    #[doc = "\t\tis slower for DBs larger than RAM."]
    #[doc = "\t\tIncompatible with nested transactions."]
    #[doc = "\t\tDo not mix processes with and without MDB_WRITEMAP on the same"]
    #[doc = "\t\tenvironment.  This can defeat durability (#mdb_env_sync etc)."]
    #[doc = "\t<li>#MDB_NOMETASYNC"]
    #[doc = "\t\tFlush system buffers to disk only once per transaction, omit the"]
    #[doc = "\t\tmetadata flush. Defer that until the system flushes files to disk,"]
    #[doc = "\t\tor next non-MDB_RDONLY commit or #mdb_env_sync(). This optimization"]
    #[doc = "\t\tmaintains database integrity, but a system crash may undo the last"]
    #[doc = "\t\tcommitted transaction. I.e. it preserves the ACI (atomicity,"]
    #[doc = "\t\tconsistency, isolation) but not D (durability) database property."]
    #[doc = "\t\tThis flag may be changed at any time using #mdb_env_set_flags()."]
    #[doc = "\t<li>#MDB_NOSYNC"]
    #[doc = "\t\tDon't flush system buffers to disk when committing a transaction."]
    #[doc = "\t\tThis optimization means a system crash can corrupt the database or"]
    #[doc = "\t\tlose the last transactions if buffers are not yet flushed to disk."]
    #[doc = "\t\tThe risk is governed by how often the system flushes dirty buffers"]
    #[doc = "\t\tto disk and how often #mdb_env_sync() is called.  However, if the"]
    #[doc = "\t\tfilesystem preserves write order and the #MDB_WRITEMAP flag is not"]
    #[doc = "\t\tused, transactions exhibit ACI (atomicity, consistency, isolation)"]
    #[doc = "\t\tproperties and only lose D (durability).  I.e. database integrity"]
    #[doc = "\t\tis maintained, but a system crash may undo the final transactions."]
    #[doc = "\t\tNote that (#MDB_NOSYNC | #MDB_WRITEMAP) leaves the system with no"]
    #[doc = "\t\thint for when to write transactions to disk, unless #mdb_env_sync()"]
    #[doc = "\t\tis called. (#MDB_MAPASYNC | #MDB_WRITEMAP) may be preferable."]
    #[doc = "\t\tThis flag may be changed at any time using #mdb_env_set_flags()."]
    #[doc = "\t<li>#MDB_MAPASYNC"]
    #[doc = "\t\tWhen using #MDB_WRITEMAP, use asynchronous flushes to disk."]
    #[doc = "\t\tAs with #MDB_NOSYNC, a system crash can then corrupt the"]
    #[doc = "\t\tdatabase or lose the last transactions. Calling #mdb_env_sync()"]
    #[doc = "\t\tensures on-disk database integrity until next commit."]
    #[doc = "\t\tThis flag may be changed at any time using #mdb_env_set_flags()."]
    #[doc = "\t<li>#MDB_NOTLS"]
    #[doc = "\t\tDon't use Thread-Local Storage. Tie reader locktable slots to"]
    #[doc = "\t\t#MDB_txn objects instead of to threads. I.e. #mdb_txn_reset() keeps"]
    #[doc = "\t\tthe slot reseved for the #MDB_txn object. A thread may use parallel"]
    #[doc = "\t\tread-only transactions. A read-only transaction may span threads if"]
    #[doc = "\t\tthe user synchronizes its use. Applications that multiplex many"]
    #[doc = "\t\tuser threads over individual OS threads need this option. Such an"]
    #[doc = "\t\tapplication must also serialize the write transactions in an OS"]
    #[doc = "\t\tthread, since LMDB's write locking is unaware of the user threads."]
    #[doc = "\t<li>#MDB_NOLOCK"]
    #[doc = "\t\tDon't do any locking. If concurrent access is anticipated, the"]
    #[doc = "\t\tcaller must manage all concurrency itself. For proper operation"]
    #[doc = "\t\tthe caller must enforce single-writer semantics, and must ensure"]
    #[doc = "\t\tthat no readers are using old transactions while a writer is"]
    #[doc = "\t\tactive. The simplest approach is to use an exclusive lock so that"]
    #[doc = "\t\tno readers may be active at all when a writer begins."]
    #[doc = "\t<li>#MDB_NORDAHEAD"]
    #[doc = "\t\tTurn off readahead. Most operating systems perform readahead on"]
    #[doc = "\t\tread requests by default. This option turns it off if the OS"]
    #[doc = "\t\tsupports it. Turning it off may help random read performance"]
    #[doc = "\t\twhen the DB is larger than RAM and system RAM is full."]
    #[doc = "\t\tThe option is not implemented on Windows."]
    #[doc = "\t<li>#MDB_NOMEMINIT"]
    #[doc = "\t\tDon't initialize malloc'd memory before writing to unused spaces"]
    #[doc = "\t\tin the data file. By default, memory for pages written to the data"]
    #[doc = "\t\tfile is obtained using malloc. While these pages may be reused in"]
    #[doc = "\t\tsubsequent transactions, freshly malloc'd pages will be initialized"]
    #[doc = "\t\tto zeroes before use. This avoids persisting leftover data from other"]
    #[doc = "\t\tcode (that used the heap and subsequently freed the memory) into the"]
    #[doc = "\t\tdata file. Note that many other system libraries may allocate"]
    #[doc = "\t\tand free memory from the heap for arbitrary uses. E.g., stdio may"]
    #[doc = "\t\tuse the heap for file I/O buffers. This initialization step has a"]
    #[doc = "\t\tmodest performance cost so some applications may want to disable"]
    #[doc = "\t\tit using this flag. This option can be a problem for applications"]
    #[doc = "\t\twhich handle sensitive data like passwords, and it makes memory"]
    #[doc = "\t\tcheckers like Valgrind noisy. This flag is not needed with #MDB_WRITEMAP,"]
    #[doc = "\t\twhich writes directly to the mmap instead of using malloc for pages. The"]
    #[doc = "\t\tinitialization is also skipped if #MDB_RESERVE is used; the"]
    #[doc = "\t\tcaller is expected to overwrite all of the memory that was"]
    #[doc = "\t\treserved in that case."]
    #[doc = "\t\tThis flag may be changed at any time using #mdb_env_set_flags()."]
    #[doc = " </ul>"]
    #[doc = " @param[in] mode The UNIX permissions to set on created files and semaphores."]
    #[doc = " This parameter is ignored on Windows."]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_VERSION_MISMATCH - the version of the LMDB library doesn't match the"]
    #[doc = "\tversion that created the database environment."]
    #[doc = "\t<li>#MDB_INVALID - the environment file headers are corrupted."]
    #[doc = "\t<li>ENOENT - the directory specified by the path parameter doesn't exist."]
    #[doc = "\t<li>EACCES - the user didn't have permission to access the environment files."]
    #[doc = "\t<li>EAGAIN - the environment was locked by another process."]
    #[doc = " </ul>"]
    pub fn mdb_env_open(
        env: *mut MDB_env,
        path: *const ::libc::c_char,
        flags: ::libc::c_uint,
        mode: mdb_mode_t,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Copy an LMDB environment to the specified path."]
    #[doc = ""]
    #[doc = " This function may be used to make a backup of an existing environment."]
    #[doc = " No lockfile is created, since it gets recreated at need."]
    #[doc = " @note This call can trigger significant file size growth if run in"]
    #[doc = " parallel with write transactions, because it employs a read-only"]
    #[doc = " transaction. See long-lived transactions under @ref caveats_sec."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create(). It"]
    #[doc = " must have already been opened successfully."]
    #[doc = " @param[in] path The directory in which the copy will reside. This"]
    #[doc = " directory must already exist and be writable but must otherwise be"]
    #[doc = " empty."]
    #[doc = " @return A non-zero error value on failure and 0 on success."]
    pub fn mdb_env_copy(env: *mut MDB_env, path: *const ::libc::c_char) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Copy an LMDB environment to the specified file descriptor."]
    #[doc = ""]
    #[doc = " This function may be used to make a backup of an existing environment."]
    #[doc = " No lockfile is created, since it gets recreated at need."]
    #[doc = " @note This call can trigger significant file size growth if run in"]
    #[doc = " parallel with write transactions, because it employs a read-only"]
    #[doc = " transaction. See long-lived transactions under @ref caveats_sec."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create(). It"]
    #[doc = " must have already been opened successfully."]
    #[doc = " @param[in] fd The filedescriptor to write the copy to. It must"]
    #[doc = " have already been opened for Write access."]
    #[doc = " @return A non-zero error value on failure and 0 on success."]
    pub fn mdb_env_copyfd(env: *mut MDB_env, fd: mdb_filehandle_t) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Copy an LMDB environment to the specified path, with options."]
    #[doc = ""]
    #[doc = " This function may be used to make a backup of an existing environment."]
    #[doc = " No lockfile is created, since it gets recreated at need."]
    #[doc = " @note This call can trigger significant file size growth if run in"]
    #[doc = " parallel with write transactions, because it employs a read-only"]
    #[doc = " transaction. See long-lived transactions under @ref caveats_sec."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create(). It"]
    #[doc = " must have already been opened successfully."]
    #[doc = " @param[in] path The directory in which the copy will reside. This"]
    #[doc = " directory must already exist and be writable but must otherwise be"]
    #[doc = " empty."]
    #[doc = " @param[in] flags Special options for this operation. This parameter"]
    #[doc = " must be set to 0 or by bitwise OR'ing together one or more of the"]
    #[doc = " values described here."]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_CP_COMPACT - Perform compaction while copying: omit free"]
    #[doc = "\t\tpages and sequentially renumber all pages in output. This option"]
    #[doc = "\t\tconsumes more CPU and runs more slowly than the default."]
    #[doc = "\t\tCurrently it fails if the environment has suffered a page leak."]
    #[doc = " </ul>"]
    #[doc = " @return A non-zero error value on failure and 0 on success."]
    pub fn mdb_env_copy2(
        env: *mut MDB_env,
        path: *const ::libc::c_char,
        flags: ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Copy an LMDB environment to the specified file descriptor,"]
    #[doc = "\twith options."]
    #[doc = ""]
    #[doc = " This function may be used to make a backup of an existing environment."]
    #[doc = " No lockfile is created, since it gets recreated at need. See"]
    #[doc = " #mdb_env_copy2() for further details."]
    #[doc = " @note This call can trigger significant file size growth if run in"]
    #[doc = " parallel with write transactions, because it employs a read-only"]
    #[doc = " transaction. See long-lived transactions under @ref caveats_sec."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create(). It"]
    #[doc = " must have already been opened successfully."]
    #[doc = " @param[in] fd The filedescriptor to write the copy to. It must"]
    #[doc = " have already been opened for Write access."]
    #[doc = " @param[in] flags Special options for this operation."]
    #[doc = " See #mdb_env_copy2() for options."]
    #[doc = " @return A non-zero error value on failure and 0 on success."]
    pub fn mdb_env_copyfd2(
        env: *mut MDB_env,
        fd: mdb_filehandle_t,
        flags: ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Return statistics about the LMDB environment."]
    #[doc = ""]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[out] stat The address of an #MDB_stat structure"]
    #[doc = " \twhere the statistics will be copied"]
    pub fn mdb_env_stat(env: *mut MDB_env, stat: *mut MDB_stat) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Return information about the LMDB environment."]
    #[doc = ""]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[out] stat The address of an #MDB_envinfo structure"]
    #[doc = " \twhere the information will be copied"]
    pub fn mdb_env_info(env: *mut MDB_env, stat: *mut MDB_envinfo) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Flush the data buffers to disk."]
    #[doc = ""]
    #[doc = " Data is always written to disk when #mdb_txn_commit() is called,"]
    #[doc = " but the operating system may keep it buffered. LMDB always flushes"]
    #[doc = " the OS buffers upon commit as well, unless the environment was"]
    #[doc = " opened with #MDB_NOSYNC or in part #MDB_NOMETASYNC. This call is"]
    #[doc = " not valid if the environment was opened with #MDB_RDONLY."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[in] force If non-zero, force a synchronous flush.  Otherwise"]
    #[doc = "  if the environment has the #MDB_NOSYNC flag set the flushes"]
    #[doc = "\twill be omitted, and with #MDB_MAPASYNC they will be asynchronous."]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EACCES - the environment is read-only."]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = "\t<li>EIO - an error occurred during synchronization."]
    #[doc = " </ul>"]
    pub fn mdb_env_sync(env: *mut MDB_env, force: ::libc::c_int) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Close the environment and release the memory map."]
    #[doc = ""]
    #[doc = " Only a single thread may call this function. All transactions, databases,"]
    #[doc = " and cursors must already be closed before calling this function. Attempts to"]
    #[doc = " use any such handles after calling this function will cause a SIGSEGV."]
    #[doc = " The environment handle will be freed and must not be used again after this call."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    pub fn mdb_env_close(env: *mut MDB_env);
}
extern "C" {
    #[doc = " @brief Set environment flags."]
    #[doc = ""]
    #[doc = " This may be used to set some flags in addition to those from"]
    #[doc = " #mdb_env_open(), or to unset these flags.  If several threads"]
    #[doc = " change the flags at the same time, the result is undefined."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[in] flags The flags to change, bitwise OR'ed together"]
    #[doc = " @param[in] onoff A non-zero value sets the flags, zero clears them."]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_env_set_flags(
        env: *mut MDB_env,
        flags: ::libc::c_uint,
        onoff: ::libc::c_int,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Get environment flags."]
    #[doc = ""]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[out] flags The address of an integer to store the flags"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_env_get_flags(env: *mut MDB_env, flags: *mut ::libc::c_uint) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Return the path that was used in #mdb_env_open()."]
    #[doc = ""]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[out] path Address of a string pointer to contain the path. This"]
    #[doc = " is the actual string in the environment, not a copy. It should not be"]
    #[doc = " altered in any way."]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_env_get_path(env: *mut MDB_env, path: *mut *const ::libc::c_char) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Return the filedescriptor for the given environment."]
    #[doc = ""]
    #[doc = " This function may be called after fork(), so the descriptor can be"]
    #[doc = " closed before exec*().  Other LMDB file descriptors have FD_CLOEXEC."]
    #[doc = " (Until LMDB 0.9.18, only the lockfile had that.)"]
    #[doc = ""]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[out] fd Address of a mdb_filehandle_t to contain the descriptor."]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_env_get_fd(env: *mut MDB_env, fd: *mut mdb_filehandle_t) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Set the size of the memory map to use for this environment."]
    #[doc = ""]
    #[doc = " The size should be a multiple of the OS page size. The default is"]
    #[doc = " 10485760 bytes. The size of the memory map is also the maximum size"]
    #[doc = " of the database. The value should be chosen as large as possible,"]
    #[doc = " to accommodate future growth of the database."]
    #[doc = " This function should be called after #mdb_env_create() and before #mdb_env_open()."]
    #[doc = " It may be called at later times if no transactions are active in"]
    #[doc = " this process. Note that the library does not check for this condition,"]
    #[doc = " the caller must ensure it explicitly."]
    #[doc = ""]
    #[doc = " The new size takes effect immediately for the current process but"]
    #[doc = " will not be persisted to any others until a write transaction has been"]
    #[doc = " committed by the current process. Also, only mapsize increases are"]
    #[doc = " persisted into the environment."]
    #[doc = ""]
    #[doc = " If the mapsize is increased by another process, and data has grown"]
    #[doc = " beyond the range of the current mapsize, #mdb_txn_begin() will"]
    #[doc = " return #MDB_MAP_RESIZED. This function may be called with a size"]
    #[doc = " of zero to adopt the new size."]
    #[doc = ""]
    #[doc = " Any attempt to set a size smaller than the space already consumed"]
    #[doc = " by the environment will be silently changed to the current size of the used space."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[in] size The size in bytes"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified, or the environment has"]
    #[doc = "   \tan active write transaction."]
    #[doc = " </ul>"]
    pub fn mdb_env_set_mapsize(env: *mut MDB_env, size: usize) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Set the maximum number of threads/reader slots for the environment."]
    #[doc = ""]
    #[doc = " This defines the number of slots in the lock table that is used to track readers in the"]
    #[doc = " the environment. The default is 126."]
    #[doc = " Starting a read-only transaction normally ties a lock table slot to the"]
    #[doc = " current thread until the environment closes or the thread exits. If"]
    #[doc = " MDB_NOTLS is in use, #mdb_txn_begin() instead ties the slot to the"]
    #[doc = " MDB_txn object until it or the #MDB_env object is destroyed."]
    #[doc = " This function may only be called after #mdb_env_create() and before #mdb_env_open()."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[in] readers The maximum number of reader lock table slots"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified, or the environment is already open."]
    #[doc = " </ul>"]
    pub fn mdb_env_set_maxreaders(env: *mut MDB_env, readers: ::libc::c_uint) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Get the maximum number of threads/reader slots for the environment."]
    #[doc = ""]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[out] readers Address of an integer to store the number of readers"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_env_get_maxreaders(env: *mut MDB_env, readers: *mut ::libc::c_uint)
        -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Set the maximum number of named databases for the environment."]
    #[doc = ""]
    #[doc = " This function is only needed if multiple databases will be used in the"]
    #[doc = " environment. Simpler applications that use the environment as a single"]
    #[doc = " unnamed database can ignore this option."]
    #[doc = " This function may only be called after #mdb_env_create() and before #mdb_env_open()."]
    #[doc = ""]
    #[doc = " Currently a moderate number of slots are cheap but a huge number gets"]
    #[doc = " expensive: 7-120 words per transaction, and every #mdb_dbi_open()"]
    #[doc = " does a linear search of the opened slots."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[in] dbs The maximum number of databases"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified, or the environment is already open."]
    #[doc = " </ul>"]
    pub fn mdb_env_set_maxdbs(env: *mut MDB_env, dbs: MDB_dbi) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Get the maximum size of keys and #MDB_DUPSORT data we can write."]
    #[doc = ""]
    #[doc = " Depends on the compile-time constant #MDB_MAXKEYSIZE. Default 511."]
    #[doc = " See @ref MDB_val."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @return The maximum size of a key we can write"]
    pub fn mdb_env_get_maxkeysize(env: *mut MDB_env) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Set application information associated with the #MDB_env."]
    #[doc = ""]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[in] ctx An arbitrary pointer for whatever the application needs."]
    #[doc = " @return A non-zero error value on failure and 0 on success."]
    pub fn mdb_env_set_userctx(env: *mut MDB_env, ctx: *mut ::libc::c_void) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Get the application information associated with the #MDB_env."]
    #[doc = ""]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @return The pointer set by #mdb_env_set_userctx()."]
    pub fn mdb_env_get_userctx(env: *mut MDB_env) -> *mut ::libc::c_void;
}
#[doc = " @brief A callback function for most LMDB assert() failures,"]
#[doc = " called before printing the message and aborting."]
#[doc = ""]
#[doc = " @param[in] env An environment handle returned by #mdb_env_create()."]
#[doc = " @param[in] msg The assertion message, not including newline."]
pub type MDB_assert_func =
    ::std::option::Option<unsafe extern "C" fn(env: *mut MDB_env, msg: *const ::libc::c_char)>;
extern "C" {
    #[doc = " Set or reset the assert() callback of the environment."]
    #[doc = " Disabled if liblmdb is buillt with NDEBUG."]
    #[doc = " @note This hack should become obsolete as lmdb's error handling matures."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()."]
    #[doc = " @param[in] func An #MDB_assert_func function, or 0."]
    #[doc = " @return A non-zero error value on failure and 0 on success."]
    pub fn mdb_env_set_assert(env: *mut MDB_env, func: MDB_assert_func) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Create a transaction for use with the environment."]
    #[doc = ""]
    #[doc = " The transaction handle may be discarded using #mdb_txn_abort() or #mdb_txn_commit()."]
    #[doc = " @note A transaction and its cursors must only be used by a single"]
    #[doc = " thread, and a thread may only have a single transaction at a time."]
    #[doc = " If #MDB_NOTLS is in use, this does not apply to read-only transactions."]
    #[doc = " @note Cursors may not span transactions."]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[in] parent If this parameter is non-NULL, the new transaction"]
    #[doc = " will be a nested transaction, with the transaction indicated by \\b parent"]
    #[doc = " as its parent. Transactions may be nested to any level. A parent"]
    #[doc = " transaction and its cursors may not issue any other operations than"]
    #[doc = " mdb_txn_commit and mdb_txn_abort while it has active child transactions."]
    #[doc = " @param[in] flags Special options for this transaction. This parameter"]
    #[doc = " must be set to 0 or by bitwise OR'ing together one or more of the"]
    #[doc = " values described here."]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_RDONLY"]
    #[doc = "\t\tThis transaction will not perform any write operations."]
    #[doc = " </ul>"]
    #[doc = " @param[out] txn Address where the new #MDB_txn handle will be stored"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_PANIC - a fatal error occurred earlier and the environment"]
    #[doc = "\t\tmust be shut down."]
    #[doc = "\t<li>#MDB_MAP_RESIZED - another process wrote data beyond this MDB_env's"]
    #[doc = "\t\tmapsize and this environment's map must be resized as well."]
    #[doc = "\t\tSee #mdb_env_set_mapsize()."]
    #[doc = "\t<li>#MDB_READERS_FULL - a read-only transaction was requested and"]
    #[doc = "\t\tthe reader lock table is full. See #mdb_env_set_maxreaders()."]
    #[doc = "\t<li>ENOMEM - out of memory."]
    #[doc = " </ul>"]
    pub fn mdb_txn_begin(
        env: *mut MDB_env,
        parent: *mut MDB_txn,
        flags: ::libc::c_uint,
        txn: *mut *mut MDB_txn,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Returns the transaction's #MDB_env"]
    #[doc = ""]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    pub fn mdb_txn_env(txn: *mut MDB_txn) -> *mut MDB_env;
}
extern "C" {
    #[doc = " @brief Return the transaction's ID."]
    #[doc = ""]
    #[doc = " This returns the identifier associated with this transaction. For a"]
    #[doc = " read-only transaction, this corresponds to the snapshot being read;"]
    #[doc = " concurrent readers will frequently have the same transaction ID."]
    #[doc = ""]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @return A transaction ID, valid if input is an active transaction."]
    pub fn mdb_txn_id(txn: *mut MDB_txn) -> usize;
}
extern "C" {
    #[doc = " @brief Commit all the operations of a transaction into the database."]
    #[doc = ""]
    #[doc = " The transaction handle is freed. It and its cursors must not be used"]
    #[doc = " again after this call, except with #mdb_cursor_renew()."]
    #[doc = " @note Earlier documentation incorrectly said all cursors would be freed."]
    #[doc = " Only write-transactions free cursors."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = "\t<li>ENOSPC - no more disk space."]
    #[doc = "\t<li>EIO - a low-level I/O error occurred while writing."]
    #[doc = "\t<li>ENOMEM - out of memory."]
    #[doc = " </ul>"]
    pub fn mdb_txn_commit(txn: *mut MDB_txn) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Abandon all the operations of the transaction instead of saving them."]
    #[doc = ""]
    #[doc = " The transaction handle is freed. It and its cursors must not be used"]
    #[doc = " again after this call, except with #mdb_cursor_renew()."]
    #[doc = " @note Earlier documentation incorrectly said all cursors would be freed."]
    #[doc = " Only write-transactions free cursors."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    pub fn mdb_txn_abort(txn: *mut MDB_txn);
}
extern "C" {
    #[doc = " @brief Reset a read-only transaction."]
    #[doc = ""]
    #[doc = " Abort the transaction like #mdb_txn_abort(), but keep the transaction"]
    #[doc = " handle. #mdb_txn_renew() may reuse the handle. This saves allocation"]
    #[doc = " overhead if the process will start a new read-only transaction soon,"]
    #[doc = " and also locking overhead if #MDB_NOTLS is in use. The reader table"]
    #[doc = " lock is released, but the table slot stays tied to its thread or"]
    #[doc = " #MDB_txn. Use mdb_txn_abort() to discard a reset handle, and to free"]
    #[doc = " its lock table slot if MDB_NOTLS is in use."]
    #[doc = " Cursors opened within the transaction must not be used"]
    #[doc = " again after this call, except with #mdb_cursor_renew()."]
    #[doc = " Reader locks generally don't interfere with writers, but they keep old"]
    #[doc = " versions of database pages allocated. Thus they prevent the old pages"]
    #[doc = " from being reused when writers commit new data, and so under heavy load"]
    #[doc = " the database size may grow much more rapidly than otherwise."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    pub fn mdb_txn_reset(txn: *mut MDB_txn);
}
extern "C" {
    #[doc = " @brief Renew a read-only transaction."]
    #[doc = ""]
    #[doc = " This acquires a new reader lock for a transaction handle that had been"]
    #[doc = " released by #mdb_txn_reset(). It must be called before a reset transaction"]
    #[doc = " may be used again."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_PANIC - a fatal error occurred earlier and the environment"]
    #[doc = "\t\tmust be shut down."]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_txn_renew(txn: *mut MDB_txn) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Open a database in the environment."]
    #[doc = ""]
    #[doc = " A database handle denotes the name and parameters of a database,"]
    #[doc = " independently of whether such a database exists."]
    #[doc = " The database handle may be discarded by calling #mdb_dbi_close()."]
    #[doc = " The old database handle is returned if the database was already open."]
    #[doc = " The handle may only be closed once."]
    #[doc = ""]
    #[doc = " The database handle will be private to the current transaction until"]
    #[doc = " the transaction is successfully committed. If the transaction is"]
    #[doc = " aborted the handle will be closed automatically."]
    #[doc = " After a successful commit the handle will reside in the shared"]
    #[doc = " environment, and may be used by other transactions."]
    #[doc = ""]
    #[doc = " This function must not be called from multiple concurrent"]
    #[doc = " transactions in the same process. A transaction that uses"]
    #[doc = " this function must finish (either commit or abort) before"]
    #[doc = " any other transaction in the process may use this function."]
    #[doc = ""]
    #[doc = " To use named databases (with name != NULL), #mdb_env_set_maxdbs()"]
    #[doc = " must be called before opening the environment.  Database names are"]
    #[doc = " keys in the unnamed database, and may be read but not written."]
    #[doc = ""]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] name The name of the database to open. If only a single"]
    #[doc = " \tdatabase is needed in the environment, this value may be NULL."]
    #[doc = " @param[in] flags Special options for this database. This parameter"]
    #[doc = " must be set to 0 or by bitwise OR'ing together one or more of the"]
    #[doc = " values described here."]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_REVERSEKEY"]
    #[doc = "\t\tKeys are strings to be compared in reverse order, from the end"]
    #[doc = "\t\tof the strings to the beginning. By default, Keys are treated as strings and"]
    #[doc = "\t\tcompared from beginning to end."]
    #[doc = "\t<li>#MDB_DUPSORT"]
    #[doc = "\t\tDuplicate keys may be used in the database. (Or, from another perspective,"]
    #[doc = "\t\tkeys may have multiple data items, stored in sorted order.) By default"]
    #[doc = "\t\tkeys must be unique and may have only a single data item."]
    #[doc = "\t<li>#MDB_INTEGERKEY"]
    #[doc = "\t\tKeys are binary integers in native byte order, either unsigned int"]
    #[doc = "\t\tor size_t, and will be sorted as such."]
    #[doc = "\t\tThe keys must all be of the same size."]
    #[doc = "\t<li>#MDB_DUPFIXED"]
    #[doc = "\t\tThis flag may only be used in combination with #MDB_DUPSORT. This option"]
    #[doc = "\t\ttells the library that the data items for this database are all the same"]
    #[doc = "\t\tsize, which allows further optimizations in storage and retrieval. When"]
    #[doc = "\t\tall data items are the same size, the #MDB_GET_MULTIPLE, #MDB_NEXT_MULTIPLE"]
    #[doc = "\t\tand #MDB_PREV_MULTIPLE cursor operations may be used to retrieve multiple"]
    #[doc = "\t\titems at once."]
    #[doc = "\t<li>#MDB_INTEGERDUP"]
    #[doc = "\t\tThis option specifies that duplicate data items are binary integers,"]
    #[doc = "\t\tsimilar to #MDB_INTEGERKEY keys."]
    #[doc = "\t<li>#MDB_REVERSEDUP"]
    #[doc = "\t\tThis option specifies that duplicate data items should be compared as"]
    #[doc = "\t\tstrings in reverse order."]
    #[doc = "\t<li>#MDB_CREATE"]
    #[doc = "\t\tCreate the named database if it doesn't exist. This option is not"]
    #[doc = "\t\tallowed in a read-only transaction or a read-only environment."]
    #[doc = " </ul>"]
    #[doc = " @param[out] dbi Address where the new #MDB_dbi handle will be stored"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_NOTFOUND - the specified database doesn't exist in the environment"]
    #[doc = "\t\tand #MDB_CREATE was not specified."]
    #[doc = "\t<li>#MDB_DBS_FULL - too many databases have been opened. See #mdb_env_set_maxdbs()."]
    #[doc = " </ul>"]
    pub fn mdb_dbi_open(
        txn: *mut MDB_txn,
        name: *const ::libc::c_char,
        flags: ::libc::c_uint,
        dbi: *mut MDB_dbi,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Retrieve statistics for a database."]
    #[doc = ""]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[out] stat The address of an #MDB_stat structure"]
    #[doc = " \twhere the statistics will be copied"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_stat(txn: *mut MDB_txn, dbi: MDB_dbi, stat: *mut MDB_stat) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Retrieve the DB flags for a database handle."]
    #[doc = ""]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[out] flags Address where the flags will be returned."]
    #[doc = " @return A non-zero error value on failure and 0 on success."]
    pub fn mdb_dbi_flags(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        flags: *mut ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Close a database handle. Normally unnecessary. Use with care:"]
    #[doc = ""]
    #[doc = " This call is not mutex protected. Handles should only be closed by"]
    #[doc = " a single thread, and only if no other threads are going to reference"]
    #[doc = " the database handle or one of its cursors any further. Do not close"]
    #[doc = " a handle if an existing transaction has modified its database."]
    #[doc = " Doing so can cause misbehavior from database corruption to errors"]
    #[doc = " like MDB_BAD_VALSIZE (since the DB name is gone)."]
    #[doc = ""]
    #[doc = " Closing a database handle is not necessary, but lets #mdb_dbi_open()"]
    #[doc = " reuse the handle value.  Usually it's better to set a bigger"]
    #[doc = " #mdb_env_set_maxdbs(), unless that value would be large."]
    #[doc = ""]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    pub fn mdb_dbi_close(env: *mut MDB_env, dbi: MDB_dbi);
}
extern "C" {
    #[doc = " @brief Empty or delete+close a database."]
    #[doc = ""]
    #[doc = " See #mdb_dbi_close() for restrictions about closing the DB handle."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[in] del 0 to empty the DB, 1 to delete it from the"]
    #[doc = " environment and close the DB handle."]
    #[doc = " @return A non-zero error value on failure and 0 on success."]
    pub fn mdb_drop(txn: *mut MDB_txn, dbi: MDB_dbi, del: ::libc::c_int) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Set a custom key comparison function for a database."]
    #[doc = ""]
    #[doc = " The comparison function is called whenever it is necessary to compare a"]
    #[doc = " key specified by the application with a key currently stored in the database."]
    #[doc = " If no comparison function is specified, and no special key flags were specified"]
    #[doc = " with #mdb_dbi_open(), the keys are compared lexically, with shorter keys collating"]
    #[doc = " before longer keys."]
    #[doc = " @warning This function must be called before any data access functions are used,"]
    #[doc = " otherwise data corruption may occur. The same comparison function must be used by every"]
    #[doc = " program accessing the database, every time the database is used."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[in] cmp A #MDB_cmp_func function"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_set_compare(txn: *mut MDB_txn, dbi: MDB_dbi, cmp: MDB_cmp_func) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Set a custom data comparison function for a #MDB_DUPSORT database."]
    #[doc = ""]
    #[doc = " This comparison function is called whenever it is necessary to compare a data"]
    #[doc = " item specified by the application with a data item currently stored in the database."]
    #[doc = " This function only takes effect if the database was opened with the #MDB_DUPSORT"]
    #[doc = " flag."]
    #[doc = " If no comparison function is specified, and no special key flags were specified"]
    #[doc = " with #mdb_dbi_open(), the data items are compared lexically, with shorter items collating"]
    #[doc = " before longer items."]
    #[doc = " @warning This function must be called before any data access functions are used,"]
    #[doc = " otherwise data corruption may occur. The same comparison function must be used by every"]
    #[doc = " program accessing the database, every time the database is used."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[in] cmp A #MDB_cmp_func function"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_set_dupsort(txn: *mut MDB_txn, dbi: MDB_dbi, cmp: MDB_cmp_func) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Set a relocation function for a #MDB_FIXEDMAP database."]
    #[doc = ""]
    #[doc = " @todo The relocation function is called whenever it is necessary to move the data"]
    #[doc = " of an item to a different position in the database (e.g. through tree"]
    #[doc = " balancing operations, shifts as a result of adds or deletes, etc.). It is"]
    #[doc = " intended to allow address/position-dependent data items to be stored in"]
    #[doc = " a database in an environment opened with the #MDB_FIXEDMAP option."]
    #[doc = " Currently the relocation feature is unimplemented and setting"]
    #[doc = " this function has no effect."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[in] rel A #MDB_rel_func function"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_set_relfunc(txn: *mut MDB_txn, dbi: MDB_dbi, rel: MDB_rel_func) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Set a context pointer for a #MDB_FIXEDMAP database's relocation function."]
    #[doc = ""]
    #[doc = " See #mdb_set_relfunc and #MDB_rel_func for more details."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[in] ctx An arbitrary pointer for whatever the application needs."]
    #[doc = " It will be passed to the callback function set by #mdb_set_relfunc"]
    #[doc = " as its \\b relctx parameter whenever the callback is invoked."]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_set_relctx(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Get items from a database."]
    #[doc = ""]
    #[doc = " This function retrieves key/data pairs from the database. The address"]
    #[doc = " and length of the data associated with the specified \\b key are returned"]
    #[doc = " in the structure to which \\b data refers."]
    #[doc = " If the database supports duplicate keys (#MDB_DUPSORT) then the"]
    #[doc = " first data item for the key will be returned. Retrieval of other"]
    #[doc = " items requires the use of #mdb_cursor_get()."]
    #[doc = ""]
    #[doc = " @note The memory pointed to by the returned values is owned by the"]
    #[doc = " database. The caller need not dispose of the memory, and may not"]
    #[doc = " modify it in any way. For values returned in a read-only transaction"]
    #[doc = " any modification attempts will cause a SIGSEGV."]
    #[doc = " @note Values returned from the database are valid only until a"]
    #[doc = " subsequent update operation, or the end of the transaction."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[in] key The key to search for in the database"]
    #[doc = " @param[out] data The data corresponding to the key"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_NOTFOUND - the key was not in the database."]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_get(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        key: *mut MDB_val,
        data: *mut MDB_val,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Store items into a database."]
    #[doc = ""]
    #[doc = " This function stores key/data pairs in the database. The default behavior"]
    #[doc = " is to enter the new key/data pair, replacing any previously existing key"]
    #[doc = " if duplicates are disallowed, or adding a duplicate data item if"]
    #[doc = " duplicates are allowed (#MDB_DUPSORT)."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[in] key The key to store in the database"]
    #[doc = " @param[in,out] data The data to store"]
    #[doc = " @param[in] flags Special options for this operation. This parameter"]
    #[doc = " must be set to 0 or by bitwise OR'ing together one or more of the"]
    #[doc = " values described here."]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_NODUPDATA - enter the new key/data pair only if it does not"]
    #[doc = "\t\talready appear in the database. This flag may only be specified"]
    #[doc = "\t\tif the database was opened with #MDB_DUPSORT. The function will"]
    #[doc = "\t\treturn #MDB_KEYEXIST if the key/data pair already appears in the"]
    #[doc = "\t\tdatabase."]
    #[doc = "\t<li>#MDB_NOOVERWRITE - enter the new key/data pair only if the key"]
    #[doc = "\t\tdoes not already appear in the database. The function will return"]
    #[doc = "\t\t#MDB_KEYEXIST if the key already appears in the database, even if"]
    #[doc = "\t\tthe database supports duplicates (#MDB_DUPSORT). The \\b data"]
    #[doc = "\t\tparameter will be set to point to the existing item."]
    #[doc = "\t<li>#MDB_RESERVE - reserve space for data of the given size, but"]
    #[doc = "\t\tdon't copy the given data. Instead, return a pointer to the"]
    #[doc = "\t\treserved space, which the caller can fill in later - before"]
    #[doc = "\t\tthe next update operation or the transaction ends. This saves"]
    #[doc = "\t\tan extra memcpy if the data is being generated later."]
    #[doc = "\t\tLMDB does nothing else with this memory, the caller is expected"]
    #[doc = "\t\tto modify all of the space requested. This flag must not be"]
    #[doc = "\t\tspecified if the database was opened with #MDB_DUPSORT."]
    #[doc = "\t<li>#MDB_APPEND - append the given key/data pair to the end of the"]
    #[doc = "\t\tdatabase. This option allows fast bulk loading when keys are"]
    #[doc = "\t\talready known to be in the correct order. Loading unsorted keys"]
    #[doc = "\t\twith this flag will cause a #MDB_KEYEXIST error."]
    #[doc = "\t<li>#MDB_APPENDDUP - as above, but for sorted dup data."]
    #[doc = " </ul>"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_MAP_FULL - the database is full, see #mdb_env_set_mapsize()."]
    #[doc = "\t<li>#MDB_TXN_FULL - the transaction has too many dirty pages."]
    #[doc = "\t<li>EACCES - an attempt was made to write in a read-only transaction."]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_put(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        key: *mut MDB_val,
        data: *mut MDB_val,
        flags: ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Delete items from a database."]
    #[doc = ""]
    #[doc = " This function removes key/data pairs from the database."]
    #[doc = " If the database does not support sorted duplicate data items"]
    #[doc = " (#MDB_DUPSORT) the data parameter is ignored."]
    #[doc = " If the database supports sorted duplicates and the data parameter"]
    #[doc = " is NULL, all of the duplicate data items for the key will be"]
    #[doc = " deleted. Otherwise, if the data parameter is non-NULL"]
    #[doc = " only the matching data item will be deleted."]
    #[doc = " This function will return #MDB_NOTFOUND if the specified key/data"]
    #[doc = " pair is not in the database."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[in] key The key to delete from the database"]
    #[doc = " @param[in] data The data to delete"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EACCES - an attempt was made to write in a read-only transaction."]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_del(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        key: *mut MDB_val,
        data: *mut MDB_val,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Create a cursor handle."]
    #[doc = ""]
    #[doc = " A cursor is associated with a specific transaction and database."]
    #[doc = " A cursor cannot be used when its database handle is closed.  Nor"]
    #[doc = " when its transaction has ended, except with #mdb_cursor_renew()."]
    #[doc = " It can be discarded with #mdb_cursor_close()."]
    #[doc = " A cursor in a write-transaction can be closed before its transaction"]
    #[doc = " ends, and will otherwise be closed when its transaction ends."]
    #[doc = " A cursor in a read-only transaction must be closed explicitly, before"]
    #[doc = " or after its transaction ends. It can be reused with"]
    #[doc = " #mdb_cursor_renew() before finally closing it."]
    #[doc = " @note Earlier documentation said that cursors in every transaction"]
    #[doc = " were closed when the transaction committed or aborted."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[out] cursor Address where the new #MDB_cursor handle will be stored"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_cursor_open(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        cursor: *mut *mut MDB_cursor,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Close a cursor handle."]
    #[doc = ""]
    #[doc = " The cursor handle will be freed and must not be used again after this call."]
    #[doc = " Its transaction must still be live if it is a write-transaction."]
    #[doc = " @param[in] cursor A cursor handle returned by #mdb_cursor_open()"]
    pub fn mdb_cursor_close(cursor: *mut MDB_cursor);
}
extern "C" {
    #[doc = " @brief Renew a cursor handle."]
    #[doc = ""]
    #[doc = " A cursor is associated with a specific transaction and database."]
    #[doc = " Cursors that are only used in read-only"]
    #[doc = " transactions may be re-used, to avoid unnecessary malloc/free overhead."]
    #[doc = " The cursor may be associated with a new read-only transaction, and"]
    #[doc = " referencing the same database handle as it was created with."]
    #[doc = " This may be done whether the previous transaction is live or dead."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] cursor A cursor handle returned by #mdb_cursor_open()"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_cursor_renew(txn: *mut MDB_txn, cursor: *mut MDB_cursor) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Return the cursor's transaction handle."]
    #[doc = ""]
    #[doc = " @param[in] cursor A cursor handle returned by #mdb_cursor_open()"]
    pub fn mdb_cursor_txn(cursor: *mut MDB_cursor) -> *mut MDB_txn;
}
extern "C" {
    #[doc = " @brief Return the cursor's database handle."]
    #[doc = ""]
    #[doc = " @param[in] cursor A cursor handle returned by #mdb_cursor_open()"]
    pub fn mdb_cursor_dbi(cursor: *mut MDB_cursor) -> MDB_dbi;
}
extern "C" {
    #[doc = " @brief Retrieve by cursor."]
    #[doc = ""]
    #[doc = " This function retrieves key/data pairs from the database. The address and length"]
    #[doc = " of the key are returned in the object to which \\b key refers (except for the"]
    #[doc = " case of the #MDB_SET option, in which the \\b key object is unchanged), and"]
    #[doc = " the address and length of the data are returned in the object to which \\b data"]
    #[doc = " refers."]
    #[doc = " See #mdb_get() for restrictions on using the output values."]
    #[doc = " @param[in] cursor A cursor handle returned by #mdb_cursor_open()"]
    #[doc = " @param[in,out] key The key for a retrieved item"]
    #[doc = " @param[in,out] data The data of a retrieved item"]
    #[doc = " @param[in] op A cursor operation #MDB_cursor_op"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_NOTFOUND - no matching key found."]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_cursor_get(
        cursor: *mut MDB_cursor,
        key: *mut MDB_val,
        data: *mut MDB_val,
        op: MDB_cursor_op,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Store by cursor."]
    #[doc = ""]
    #[doc = " This function stores key/data pairs into the database."]
    #[doc = " The cursor is positioned at the new item, or on failure usually near it."]
    #[doc = " @note Earlier documentation incorrectly said errors would leave the"]
    #[doc = " state of the cursor unchanged."]
    #[doc = " @param[in] cursor A cursor handle returned by #mdb_cursor_open()"]
    #[doc = " @param[in] key The key operated on."]
    #[doc = " @param[in] data The data operated on."]
    #[doc = " @param[in] flags Options for this operation. This parameter"]
    #[doc = " must be set to 0 or one of the values described here."]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_CURRENT - replace the item at the current cursor position."]
    #[doc = "\t\tThe \\b key parameter must still be provided, and must match it."]
    #[doc = "\t\tIf using sorted duplicates (#MDB_DUPSORT) the data item must still"]
    #[doc = "\t\tsort into the same place. This is intended to be used when the"]
    #[doc = "\t\tnew data is the same size as the old. Otherwise it will simply"]
    #[doc = "\t\tperform a delete of the old record followed by an insert."]
    #[doc = "\t<li>#MDB_NODUPDATA - enter the new key/data pair only if it does not"]
    #[doc = "\t\talready appear in the database. This flag may only be specified"]
    #[doc = "\t\tif the database was opened with #MDB_DUPSORT. The function will"]
    #[doc = "\t\treturn #MDB_KEYEXIST if the key/data pair already appears in the"]
    #[doc = "\t\tdatabase."]
    #[doc = "\t<li>#MDB_NOOVERWRITE - enter the new key/data pair only if the key"]
    #[doc = "\t\tdoes not already appear in the database. The function will return"]
    #[doc = "\t\t#MDB_KEYEXIST if the key already appears in the database, even if"]
    #[doc = "\t\tthe database supports duplicates (#MDB_DUPSORT)."]
    #[doc = "\t<li>#MDB_RESERVE - reserve space for data of the given size, but"]
    #[doc = "\t\tdon't copy the given data. Instead, return a pointer to the"]
    #[doc = "\t\treserved space, which the caller can fill in later - before"]
    #[doc = "\t\tthe next update operation or the transaction ends. This saves"]
    #[doc = "\t\tan extra memcpy if the data is being generated later. This flag"]
    #[doc = "\t\tmust not be specified if the database was opened with #MDB_DUPSORT."]
    #[doc = "\t<li>#MDB_APPEND - append the given key/data pair to the end of the"]
    #[doc = "\t\tdatabase. No key comparisons are performed. This option allows"]
    #[doc = "\t\tfast bulk loading when keys are already known to be in the"]
    #[doc = "\t\tcorrect order. Loading unsorted keys with this flag will cause"]
    #[doc = "\t\ta #MDB_KEYEXIST error."]
    #[doc = "\t<li>#MDB_APPENDDUP - as above, but for sorted dup data."]
    #[doc = "\t<li>#MDB_MULTIPLE - store multiple contiguous data elements in a"]
    #[doc = "\t\tsingle request. This flag may only be specified if the database"]
    #[doc = "\t\twas opened with #MDB_DUPFIXED. The \\b data argument must be an"]
    #[doc = "\t\tarray of two MDB_vals. The mv_size of the first MDB_val must be"]
    #[doc = "\t\tthe size of a single data element. The mv_data of the first MDB_val"]
    #[doc = "\t\tmust point to the beginning of the array of contiguous data elements."]
    #[doc = "\t\tThe mv_size of the second MDB_val must be the count of the number"]
    #[doc = "\t\tof data elements to store. On return this field will be set to"]
    #[doc = "\t\tthe count of the number of elements actually written. The mv_data"]
    #[doc = "\t\tof the second MDB_val is unused."]
    #[doc = " </ul>"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_MAP_FULL - the database is full, see #mdb_env_set_mapsize()."]
    #[doc = "\t<li>#MDB_TXN_FULL - the transaction has too many dirty pages."]
    #[doc = "\t<li>EACCES - an attempt was made to write in a read-only transaction."]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_cursor_put(
        cursor: *mut MDB_cursor,
        key: *mut MDB_val,
        data: *mut MDB_val,
        flags: ::libc::c_uint,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Delete current key/data pair"]
    #[doc = ""]
    #[doc = " This function deletes the key/data pair to which the cursor refers."]
    #[doc = " This does not invalidate the cursor, so operations such as MDB_NEXT"]
    #[doc = " can still be used on it."]
    #[doc = " Both MDB_NEXT and MDB_GET_CURRENT will return the same record after"]
    #[doc = " this operation."]
    #[doc = " @param[in] cursor A cursor handle returned by #mdb_cursor_open()"]
    #[doc = " @param[in] flags Options for this operation. This parameter"]
    #[doc = " must be set to 0 or one of the values described here."]
    #[doc = " <ul>"]
    #[doc = "\t<li>#MDB_NODUPDATA - delete all of the data items for the current key."]
    #[doc = "\t\tThis flag may only be specified if the database was opened with #MDB_DUPSORT."]
    #[doc = " </ul>"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EACCES - an attempt was made to write in a read-only transaction."]
    #[doc = "\t<li>EINVAL - an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_cursor_del(cursor: *mut MDB_cursor, flags: ::libc::c_uint) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Return count of duplicates for current key."]
    #[doc = ""]
    #[doc = " This call is only valid on databases that support sorted duplicate"]
    #[doc = " data items #MDB_DUPSORT."]
    #[doc = " @param[in] cursor A cursor handle returned by #mdb_cursor_open()"]
    #[doc = " @param[out] countp Address where the count will be stored"]
    #[doc = " @return A non-zero error value on failure and 0 on success. Some possible"]
    #[doc = " errors are:"]
    #[doc = " <ul>"]
    #[doc = "\t<li>EINVAL - cursor is not initialized, or an invalid parameter was specified."]
    #[doc = " </ul>"]
    pub fn mdb_cursor_count(cursor: *mut MDB_cursor, countp: *mut usize) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Compare two data items according to a particular database."]
    #[doc = ""]
    #[doc = " This returns a comparison as if the two data items were keys in the"]
    #[doc = " specified database."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[in] a The first item to compare"]
    #[doc = " @param[in] b The second item to compare"]
    #[doc = " @return < 0 if a < b, 0 if a == b, > 0 if a > b"]
    pub fn mdb_cmp(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        a: *const MDB_val,
        b: *const MDB_val,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Compare two data items according to a particular database."]
    #[doc = ""]
    #[doc = " This returns a comparison as if the two items were data items of"]
    #[doc = " the specified database. The database must have the #MDB_DUPSORT flag."]
    #[doc = " @param[in] txn A transaction handle returned by #mdb_txn_begin()"]
    #[doc = " @param[in] dbi A database handle returned by #mdb_dbi_open()"]
    #[doc = " @param[in] a The first item to compare"]
    #[doc = " @param[in] b The second item to compare"]
    #[doc = " @return < 0 if a < b, 0 if a == b, > 0 if a > b"]
    pub fn mdb_dcmp(
        txn: *mut MDB_txn,
        dbi: MDB_dbi,
        a: *const MDB_val,
        b: *const MDB_val,
    ) -> ::libc::c_int;
}
#[doc = " @brief A callback function used to print a message from the library."]
#[doc = ""]
#[doc = " @param[in] msg The string to be printed."]
#[doc = " @param[in] ctx An arbitrary context pointer for the callback."]
#[doc = " @return < 0 on failure, >= 0 on success."]
pub type MDB_msg_func = ::std::option::Option<
    unsafe extern "C" fn(msg: *const ::libc::c_char, ctx: *mut ::libc::c_void) -> ::libc::c_int,
>;
extern "C" {
    #[doc = " @brief Dump the entries in the reader lock table."]
    #[doc = ""]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[in] func A #MDB_msg_func function"]
    #[doc = " @param[in] ctx Anything the message function needs"]
    #[doc = " @return < 0 on failure, >= 0 on success."]
    pub fn mdb_reader_list(
        env: *mut MDB_env,
        func: MDB_msg_func,
        ctx: *mut ::libc::c_void,
    ) -> ::libc::c_int;
}
extern "C" {
    #[doc = " @brief Check for stale entries in the reader lock table."]
    #[doc = ""]
    #[doc = " @param[in] env An environment handle returned by #mdb_env_create()"]
    #[doc = " @param[out] dead Number of stale slots that were cleared"]
    #[doc = " @return 0 on success, non-zero on failure."]
    pub fn mdb_reader_check(env: *mut MDB_env, dead: *mut ::libc::c_int) -> ::libc::c_int;
}
