/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.impl;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.ai.impl.LinkPosition;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;

public sealed interface MessageChunk {
    @NotNull
    public String toRawString();

    @Nullable
    default public DBRRunnableWithReturn<?> getCallback() {
        return null;
    }

    public record Link(@NotNull String text, @Nullable DBRRunnableWithReturn<?> callback) implements MessageChunk
    {
        @Override
        @Nullable
        public DBRRunnableWithReturn<?> getCallback() {
            return this.callback;
        }

        @Override
        @NotNull
        public String toRawString() {
            return this.text;
        }
    }

    public record Code(@NotNull String text, @NotNull String language) implements MessageChunk
    {
        @Override
        @NotNull
        public String toRawString() {
            return "```" + this.language + "\n" + this.text + "\n```";
        }
    }

    public record Text(@NotNull String text, @NotNull List<LinkPosition> links) implements MessageChunk
    {
        @Override
        @NotNull
        public String toRawString() {
            return this.text;
        }

        @NotNull
        public List<LinkPosition> getLinks() {
            return this.links;
        }
    }
}

