/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.dameng.DamengConstants;
import org.jkiss.dbeaver.model.DBPObjectWithLongId;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;

public class DamengUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDDL(DBRProgressMonitor monitor, DBSObject object, DamengConstants.ObjectType objectType, String schema) throws DBException {
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)object, (String)("Load source code for " + String.valueOf((Object)objectType) + " '" + object.getName() + "'"));){
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT DBMS_METADATA.GET_DDL(?,?,?)");
            dbStat.setString(1, objectType.name());
            dbStat.setString(2, object.getName());
            dbStat.setString(3, schema);
            JDBCResultSet dbResult = dbStat.executeQuery();
            if (!dbResult.next()) return null;
            String string = dbResult.getString(1);
            return string;
        }
        catch (SQLException e) {
            throw new DBException("Load source code for " + String.valueOf((Object)objectType) + " '" + object.getName() + "' failed", (Throwable)e);
        }
    }

    @Nullable
    public static <OWNER extends DBSObject, OBJECT extends DBPObjectWithLongId & DBSObject> OBJECT getObjectById(@NotNull DBRProgressMonitor monitor, @NotNull AbstractObjectCache<OWNER, OBJECT> cache, @NotNull OWNER owner, long objectId) throws DBException {
        for (DBPObjectWithLongId object : cache.getAllObjects(monitor, owner)) {
            if (object.getObjectId() != objectId) continue;
            return (OBJECT)object;
        }
        return null;
    }
}

