/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.controls.VariablesHintLabel;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLNewScriptTemplateVariablesResolver;
import org.jkiss.dbeaver.ui.editors.sql.SQLPreferenceConstants;
import org.jkiss.dbeaver.ui.editors.sql.SQLScriptBindingType;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageSQLResources
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sql.resources";
    private static final Log log = Log.getLog(PrefPageSQLResources.class);
    private final boolean isStandaloneApp = !DBWorkbench.isDistributed();
    private Combo deleteEmptyCombo;
    private Button autoFoldersCheck;
    private Button connectionFoldersCheck;
    private Text scriptTitlePattern;
    private Text scriptFileNamePattern;
    private Spinner bigScriptFileSizeBoundarySpinner;
    private Button bindEmbeddedReadCheck;
    private Button bindEmbeddedWriteCheck;
    private Composite commentTypeComposite;
    private ControlEnableState commentTypeEnableBlock;
    private SQLScriptBindingType curScriptBindingType;
    private Composite sqlTemplateViewerComposite;
    private Button sqlTemplateEnabledCheckbox;
    private SQLEditorBase sqlTemplateViewer;

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        Composite scriptsGroup = UIUtils.createTitledComposite((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_resources, (int)2, (int)768);
        if (this.isStandaloneApp) {
            this.deleteEmptyCombo = UIUtils.createLabelCombo((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_delete_empty_scripts, (int)12);
            for (SQLPreferenceConstants.EmptyScriptCloseBehavior escb : SQLPreferenceConstants.EmptyScriptCloseBehavior.values()) {
                this.deleteEmptyCombo.add(escb.getTitle());
            }
            this.deleteEmptyCombo.setLayoutData((Object)new GridData(32));
            this.deleteEmptyCombo.select(0);
        }
        this.autoFoldersCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_put_new_scripts, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_put_new_scripts_tip, (boolean)store.getBoolean("script.auto.folders"), (int)2);
        this.connectionFoldersCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_create_script_folders, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_create_script_folders_tip, (boolean)store.getBoolean("script.auto.connection.folders"), (int)2);
        this.scriptTitlePattern = UIUtils.createLabelText((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_title_pattern, (String)store.getString("script.title.pattern"));
        this.scriptFileNamePattern = UIUtils.createLabelText((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_file_name_pattern, (String)store.getString("script.file.name.pattern"));
        ContentAssistUtils.installContentProposal((Control)this.scriptFileNamePattern, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"connectionName"), GeneralUtils.variablePattern((String)"driverName"), GeneralUtils.variablePattern((String)"database"), GeneralUtils.variablePattern((String)"schema"), GeneralUtils.variablePattern((String)"projectName")}));
        UIUtils.setContentProposalToolTip((Control)this.scriptFileNamePattern, (String)SQLEditorMessages.pref_page_sql_editor_file_name_pattern_tip, (String[])new String[]{"connectionName", "driverName", "database", "schema", "projectName"});
        ContentAssistUtils.installContentProposal((Control)this.scriptTitlePattern, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider(new String[]{GeneralUtils.variablePattern((String)"connectionName"), GeneralUtils.variablePattern((String)"driverName"), GeneralUtils.variablePattern((String)"fileName"), GeneralUtils.variablePattern((String)"fileExt"), GeneralUtils.variablePattern((String)"database"), GeneralUtils.variablePattern((String)"projectName"), GeneralUtils.variablePattern((String)"schema")}));
        UIUtils.setContentProposalToolTip((Control)this.scriptTitlePattern, (String)SQLEditorMessages.pref_page_sql_editor_file_name_pattern_tip, (String[])new String[]{"connectionName", "driverName", "fileName", "fileExt", "database", "schema", "projectName"});
        UIUtils.createControlLabel((Composite)scriptsGroup, (String)SQLEditorMessages.sql_editor_prefs_script_disable_sql_syntax_parsing_for_scripts_bigger_than);
        this.bigScriptFileSizeBoundarySpinner = new Spinner(scriptsGroup, 2048);
        this.bigScriptFileSizeBoundarySpinner.setDigits(0);
        this.bigScriptFileSizeBoundarySpinner.setIncrement(50);
        this.bigScriptFileSizeBoundarySpinner.setMinimum(0);
        this.bigScriptFileSizeBoundarySpinner.setMaximum(Integer.MAX_VALUE);
        long bigScriptSize = store.getLong("SQLEditor.script.bigFileLengthBoundary");
        this.bigScriptFileSizeBoundarySpinner.setSelection((int)(bigScriptSize / 1024L));
        Composite group = UIUtils.createTitledComposite((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_new_script_template_group, (int)1, (int)1808);
        this.sqlTemplateEnabledCheckbox = UIUtils.createCheckbox((Composite)group, (String)SQLEditorMessages.pref_page_sql_editor_new_script_template_enable_checkbox, (boolean)store.getBoolean("new.script.template.enabled"));
        this.sqlTemplateViewerComposite = UIUtils.createPlaceholder((Composite)group, (int)1);
        this.sqlTemplateViewerComposite.setLayoutData((Object)new GridData(1808));
        this.sqlTemplateViewerComposite.setLayout((Layout)new FillLayout());
        ((GridData)this.sqlTemplateViewerComposite.getLayoutData()).heightHint = 200;
        this.sqlTemplateViewer = new SQLEditorBase(this){

            @Nullable
            public DBCExecutionContext getExecutionContext() {
                return null;
            }
        };
        this.setSQLTemplateText("", true);
        this.sqlTemplateViewer.createPartControl(this.sqlTemplateViewerComposite);
        this.sqlTemplateViewerComposite.addDisposeListener(e -> this.sqlTemplateViewer.dispose());
        this.sqlTemplateEnabledCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.enableWithChildren((Control)PrefPageSQLResources.this.sqlTemplateViewerComposite, (boolean)PrefPageSQLResources.this.sqlTemplateEnabledCheckbox.getSelection());
            }
        });
        new VariablesHintLabel(group, SQLEditorMessages.pref_page_sql_editor_new_script_template_variables_tip, SQLEditorMessages.pref_page_sql_editor_new_script_template_variables, SQLNewScriptTemplateVariablesResolver.ALL_VARIABLES_INFO, false);
        ExpandableComposite expander = new ExpandableComposite(composite, 0);
        expander.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        expander.setText(SQLEditorMessages.sql_editor_prefs_script_advanced_settings);
        Composite connGroup = UIUtils.createTitledComposite((Composite)expander, (String)SQLEditorMessages.pref_page_sql_editor_group_connection_association, (int)2, (int)768);
        expander.setClient((Control)connGroup.getParent());
        Label tipLabel = new Label(connGroup, 64);
        tipLabel.setText(SQLEditorMessages.pref_page_sql_editor_checkbox_bind_connection_hint);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        tipLabel.setLayoutData((Object)gd);
        this.bindEmbeddedReadCheck = UIUtils.createCheckbox((Composite)connGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_bind_embedded_read, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_bind_embedded_read_tip, (boolean)store.getBoolean("SQLEditor.script.bind.embedded.read"), (int)2);
        this.bindEmbeddedWriteCheck = UIUtils.createCheckbox((Composite)connGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_bind_embedded_write, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_bind_embedded_write_tip, (boolean)store.getBoolean("SQLEditor.script.bind.embedded.write"), (int)2);
        this.bindEmbeddedWriteCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageSQLResources.this.enableCommentType();
            }
        });
        this.commentTypeComposite = UIUtils.createComposite((Composite)connGroup, (int)1);
        for (SQLScriptBindingType bt : SQLScriptBindingType.values()) {
            if (bt == SQLScriptBindingType.EXTERNAL) continue;
            UIUtils.createRadioButton((Composite)this.commentTypeComposite, (String)bt.getDescription(), (Object)((Object)bt), (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> {
                this.curScriptBindingType = (SQLScriptBindingType)((Object)((Object)selectionEvent.widget.getData()));
            }));
        }
        this.setSettings(store);
        return composite;
    }

    private void setSettings(@NotNull DBPPreferenceStore store) {
        this.setScriptBindingTypes(SQLScriptBindingType.valueOf(store.getString("SQLEditor.script.bind.commentType")));
        this.enableCommentType();
        if (this.isStandaloneApp) {
            UIUtils.setComboSelection((Combo)this.deleteEmptyCombo, (String)SQLPreferenceConstants.EmptyScriptCloseBehavior.getByName(store.getString("script.delete.empty")).getTitle());
        }
        this.setSQLTemplateText(SQLEditorUtils.getNewScriptTemplate(store), false);
        UIUtils.enableWithChildren((Control)this.sqlTemplateViewerComposite, (boolean)this.sqlTemplateEnabledCheckbox.getSelection());
    }

    private void setScriptBindingTypes(SQLScriptBindingType bindingType) {
        try {
            for (Control ch : this.commentTypeComposite.getChildren()) {
                if (!(ch instanceof Button) || ch.getData() != bindingType) continue;
                ((Button)ch).setSelection(true);
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e);
        }
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.bindEmbeddedReadCheck.setSelection(store.getDefaultBoolean("SQLEditor.script.bind.embedded.read"));
        this.bindEmbeddedWriteCheck.setSelection(store.getDefaultBoolean("SQLEditor.script.bind.embedded.write"));
        this.setScriptBindingTypes(SQLScriptBindingType.NAME);
        this.enableCommentType();
        if (this.isStandaloneApp) {
            this.deleteEmptyCombo.setText(store.getDefaultString("script.delete.empty"));
        }
        this.autoFoldersCheck.setSelection(store.getDefaultBoolean("script.auto.folders"));
        this.connectionFoldersCheck.setSelection(store.getDefaultBoolean("script.auto.connection.folders"));
        this.scriptTitlePattern.setText(store.getDefaultString("script.title.pattern"));
        this.scriptFileNamePattern.setText(store.getDefaultString("script.file.name.pattern"));
        this.bigScriptFileSizeBoundarySpinner.setSelection((int)(store.getDefaultLong("SQLEditor.script.bigFileLengthBoundary") / 1024L));
        this.setSQLTemplateText(SQLUtils.generateCommentLine(null, (String)SQLEditorMessages.pref_page_sql_editor_new_script_template_template), false);
        this.sqlTemplateEnabledCheckbox.setSelection(store.getDefaultBoolean("new.script.template.enabled"));
        UIUtils.enableWithChildren((Control)this.sqlTemplateViewerComposite, (boolean)this.sqlTemplateEnabledCheckbox.getSelection());
        super.performDefaults();
    }

    private void enableCommentType() {
        if (this.bindEmbeddedWriteCheck.getSelection()) {
            if (this.commentTypeEnableBlock != null) {
                this.commentTypeEnableBlock.restore();
                this.commentTypeEnableBlock = null;
            }
        } else if (this.commentTypeEnableBlock == null) {
            this.commentTypeEnableBlock = ControlEnableState.disable((Control)this.commentTypeComposite);
        }
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("SQLEditor.script.bind.embedded.read", this.bindEmbeddedReadCheck.getSelection());
        store.setValue("SQLEditor.script.bind.embedded.write", this.bindEmbeddedWriteCheck.getSelection());
        try {
            for (Control ch : this.commentTypeComposite.getChildren()) {
                if (!(ch instanceof Button) || !((Button)ch).getSelection()) continue;
                store.setValue("SQLEditor.script.bind.commentType", ch.getData().toString());
            }
        }
        catch (IllegalArgumentException e) {
            log.error((Object)e);
        }
        if (this.isStandaloneApp) {
            store.setValue("script.delete.empty", SQLPreferenceConstants.EmptyScriptCloseBehavior.getByTitle(this.deleteEmptyCombo.getText()).name());
        }
        store.setValue("script.auto.folders", this.autoFoldersCheck.getSelection());
        store.setValue("script.auto.connection.folders", this.connectionFoldersCheck.getSelection());
        store.setValue("script.title.pattern", this.scriptTitlePattern.getText());
        store.setValue("script.file.name.pattern", this.scriptFileNamePattern.getText());
        store.setValue("SQLEditor.script.bigFileLengthBoundary", (long)this.bigScriptFileSizeBoundarySpinner.getSelection() * 1024L);
        store.setValue("new.script.template.enabled", this.sqlTemplateEnabledCheckbox.getSelection());
        IDocument document = this.sqlTemplateViewer.getDocument();
        if (document != null) {
            store.setValue("new.script.template", document.get());
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }

    private void setSQLTemplateText(@NotNull String text, boolean readOnly) {
        try {
            SubEditorSite subSite = new SubEditorSite(UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite());
            StringEditorInput sqlInput = new StringEditorInput("SQL preview", (CharSequence)text, readOnly, GeneralUtils.getDefaultFileEncoding());
            this.sqlTemplateViewer.init((IEditorSite)subSite, (IEditorInput)sqlInput);
            this.sqlTemplateViewer.reloadSyntaxRules();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

