/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.iotdb.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBAbstractUser;
import org.jkiss.dbeaver.ext.iotdb.model.IoTDBDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class IoTDBRelationalUser
extends IoTDBAbstractUser {
    private static final Log log = Log.getLog(IoTDBRelationalUser.class);
    private List<IoTDBDatabase> databases;
    private IoTDBDatabase allDatabase;

    public IoTDBRelationalUser(IoTDBDataSource dataSource, String userName, DBRProgressMonitor monitor) throws DBException {
        super(dataSource, userName);
        try {
            this.loadDatabases(monitor);
        }
        catch (DBException e) {
            log.error((Object)"Error loading databases and tables", (Throwable)e);
            throw new DBDatabaseException((Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    public IoTDBDatabase getDatabaseAll() {
        if (this.allDatabase == null) {
            ArrayList<String> tables = new ArrayList<String>();
            tables.add("(ALL)");
            this.allDatabase = new IoTDBDatabase("(ALL)", tables);
        }
        return this.allDatabase;
    }

    public List<IoTDBDatabase> getDatabases() {
        return this.databases;
    }

    /*
     * Unable to fully structure code
     */
    public void loadDatabases(DBRProgressMonitor monitor) throws DBException {
        this.databases = new ArrayList<IoTDBDatabase>();
        isTree = this.dataSource.isTree();
        try {
            var3_3 = null;
            var4_6 = null;
            try {
                session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load Databases and Tables Info");
                try {
                    sql = "show databases";
                    stmt = session.createStatement();
                    rs = stmt.executeQuery((String)sql);
                    while (rs.next()) {
                        block15: {
                            currentDatabase = rs.getString("Database");
                            currentTables = new ArrayList<String>();
                            sql = isTree != false ? "show devices " + currentDatabase + ".**" : "show tables in " + currentDatabase;
                            stmt2 = session.createStatement();
                            rs2 = stmt2.executeQuery((String)sql);
                            if (!isTree) ** GOTO lbl27
                            prefixLength = currentDatabase.length() + 1;
                            while (rs2.next()) {
                                currentTables.add(rs2.getString("Device").substring(prefixLength));
                            }
                            break block15;
lbl-1000:
                            // 1 sources

                            {
                                currentTables.add(rs2.getString("TableName"));
lbl27:
                                // 2 sources

                                ** while (rs2.next())
                            }
                        }
                        newDatabase = new IoTDBDatabase(currentDatabase, currentTables);
                        this.databases.add(newDatabase);
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable var4_7) {
                if (var3_3 == null) {
                    var3_3 = var4_7;
                } else if (var3_3 != var4_7) {
                    var3_3.addSuppressed(var4_7);
                }
                throw var3_3;
            }
        }
        catch (Exception e) {
            IoTDBRelationalUser.log.error((Object)"Error loading databases and tables", (Throwable)e);
        }
    }

    public static class IoTDBDatabase {
        public final String name;
        public final List<String> tables;

        public IoTDBDatabase(String name, List<String> tables) {
            this.name = name;
            this.tables = tables;
        }
    }
}

