// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`RegisterClient`](crate::operation::register_client::builders::RegisterClientFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`client_name(impl Into<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::client_name) / [`set_client_name(Option<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::set_client_name):<br>required: **true**<br><p>The friendly name of the client.</p><br>
    ///   - [`client_type(impl Into<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::client_type) / [`set_client_type(Option<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::set_client_type):<br>required: **true**<br><p>The type of client. The service supports only <code>public</code> as a client type. Anything other than public will be rejected by the service.</p><br>
    ///   - [`scopes(impl Into<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::scopes) / [`set_scopes(Option<Vec::<String>>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::set_scopes):<br>required: **false**<br><p>The list of scopes that are defined by the client. Upon authorization, this list is used to restrict permissions when granting an access token.</p><br>
    ///   - [`redirect_uris(impl Into<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::redirect_uris) / [`set_redirect_uris(Option<Vec::<String>>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::set_redirect_uris):<br>required: **false**<br><p>The list of redirect URI that are defined by the client. At completion of authorization, this list is used to restrict what locations the user agent can be redirected back to.</p><br>
    ///   - [`grant_types(impl Into<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::grant_types) / [`set_grant_types(Option<Vec::<String>>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::set_grant_types):<br>required: **false**<br><p>The list of OAuth 2.0 grant types that are defined by the client. This list is used to restrict the token granting flows available to the client. Supports the following OAuth 2.0 grant types: Authorization Code, Device Code, and Refresh Token.</p> <p>* Authorization Code - <code>authorization_code</code></p> <p>* Device Code - <code>urn:ietf:params:oauth:grant-type:device_code</code></p> <p>* Refresh Token - <code>refresh_token</code></p><br>
    ///   - [`issuer_url(impl Into<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::issuer_url) / [`set_issuer_url(Option<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::set_issuer_url):<br>required: **false**<br><p>The IAM Identity Center Issuer URL associated with an instance of IAM Identity Center. This value is needed for user access to resources through the client.</p><br>
    ///   - [`entitled_application_arn(impl Into<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::entitled_application_arn) / [`set_entitled_application_arn(Option<String>)`](crate::operation::register_client::builders::RegisterClientFluentBuilder::set_entitled_application_arn):<br>required: **false**<br><p>This IAM Identity Center application ARN is used to define administrator-managed configuration for public client access to resources. At authorization, the scopes, grants, and redirect URI available to this client will be restricted by this application resource.</p><br>
    /// - On success, responds with [`RegisterClientOutput`](crate::operation::register_client::RegisterClientOutput) with field(s):
    ///   - [`client_id(Option<String>)`](crate::operation::register_client::RegisterClientOutput::client_id): <p>The unique identifier string for each client. This client uses this identifier to get authenticated by the service in subsequent calls.</p>
    ///   - [`client_secret(Option<String>)`](crate::operation::register_client::RegisterClientOutput::client_secret): <p>A secret string generated for the client. The client will use this string to get authenticated by the service in subsequent calls.</p>
    ///   - [`client_id_issued_at(i64)`](crate::operation::register_client::RegisterClientOutput::client_id_issued_at): <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> were issued.</p>
    ///   - [`client_secret_expires_at(i64)`](crate::operation::register_client::RegisterClientOutput::client_secret_expires_at): <p>Indicates the time at which the <code>clientId</code> and <code>clientSecret</code> will become invalid.</p>
    ///   - [`authorization_endpoint(Option<String>)`](crate::operation::register_client::RegisterClientOutput::authorization_endpoint): <p>An endpoint that the client can use to request authorization.</p>
    ///   - [`token_endpoint(Option<String>)`](crate::operation::register_client::RegisterClientOutput::token_endpoint): <p>An endpoint that the client can use to create tokens.</p>
    /// - On failure, responds with [`SdkError<RegisterClientError>`](crate::operation::register_client::RegisterClientError)
    pub fn register_client(&self) -> crate::operation::register_client::builders::RegisterClientFluentBuilder {
        crate::operation::register_client::builders::RegisterClientFluentBuilder::new(self.handle.clone())
    }
}
