package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ImAudit invokes the mts.ImAudit API synchronously
func (client *Client) ImAudit(request *ImAuditRequest) (response *ImAuditResponse, err error) {
	response = CreateImAuditResponse()
	err = client.DoAction(request, response)
	return
}

// ImAuditWithChan invokes the mts.ImAudit API asynchronously
func (client *Client) ImAuditWithChan(request *ImAuditRequest) (<-chan *ImAuditResponse, <-chan error) {
	responseChan := make(chan *ImAuditResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ImAudit(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ImAuditWithCallback invokes the mts.ImAudit API asynchronously
func (client *Client) ImAuditWithCallback(request *ImAuditRequest, callback func(response *ImAuditResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ImAuditResponse
		var err error
		defer close(result)
		response, err = client.ImAudit(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ImAuditRequest is the request struct for api ImAudit
type ImAuditRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Images               string           `position:"Query" name:"Images"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	BizType              string           `position:"Query" name:"BizType"`
	Contents             string           `position:"Query" name:"Contents"`
	Scenes               string           `position:"Query" name:"Scenes"`
}

// ImAuditResponse is the response struct for api ImAudit
type ImAuditResponse struct {
	*responses.BaseResponse
	TextQuotaExceed  bool         `json:"TextQuotaExceed" xml:"TextQuotaExceed"`
	ImageQuotaExceed bool         `json:"ImageQuotaExceed" xml:"ImageQuotaExceed"`
	RequestId        string       `json:"RequestId" xml:"RequestId"`
	ImageResults     ImageResults `json:"ImageResults" xml:"ImageResults"`
	TextResults      TextResults  `json:"TextResults" xml:"TextResults"`
}

// CreateImAuditRequest creates a request to invoke ImAudit API
func CreateImAuditRequest() (request *ImAuditRequest) {
	request = &ImAuditRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "ImAudit", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateImAuditResponse creates a response to parse from ImAudit response
func CreateImAuditResponse() (response *ImAuditResponse) {
	response = &ImAuditResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
