package rdc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetCustomFieldsByTemplateId invokes the rdc.GetCustomFieldsByTemplateId API synchronously
// api document: https://help.aliyun.com/api/rdc/getcustomfieldsbytemplateid.html
func (client *Client) GetCustomFieldsByTemplateId(request *GetCustomFieldsByTemplateIdRequest) (response *GetCustomFieldsByTemplateIdResponse, err error) {
	response = CreateGetCustomFieldsByTemplateIdResponse()
	err = client.DoAction(request, response)
	return
}

// GetCustomFieldsByTemplateIdWithChan invokes the rdc.GetCustomFieldsByTemplateId API asynchronously
// api document: https://help.aliyun.com/api/rdc/getcustomfieldsbytemplateid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCustomFieldsByTemplateIdWithChan(request *GetCustomFieldsByTemplateIdRequest) (<-chan *GetCustomFieldsByTemplateIdResponse, <-chan error) {
	responseChan := make(chan *GetCustomFieldsByTemplateIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetCustomFieldsByTemplateId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetCustomFieldsByTemplateIdWithCallback invokes the rdc.GetCustomFieldsByTemplateId API asynchronously
// api document: https://help.aliyun.com/api/rdc/getcustomfieldsbytemplateid.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetCustomFieldsByTemplateIdWithCallback(request *GetCustomFieldsByTemplateIdRequest, callback func(response *GetCustomFieldsByTemplateIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetCustomFieldsByTemplateIdResponse
		var err error
		defer close(result)
		response, err = client.GetCustomFieldsByTemplateId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetCustomFieldsByTemplateIdRequest is the request struct for api GetCustomFieldsByTemplateId
type GetCustomFieldsByTemplateIdRequest struct {
	*requests.RpcRequest
	CorpIdentifier string           `position:"Query" name:"CorpIdentifier"`
	AKProjectId    requests.Integer `position:"Body" name:"AKProjectId"`
	TemplateId     requests.Integer `position:"Body" name:"TemplateId"`
}

// GetCustomFieldsByTemplateIdResponse is the response struct for api GetCustomFieldsByTemplateId
type GetCustomFieldsByTemplateIdResponse struct {
	*responses.BaseResponse
	Code      int        `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetCustomFieldsByTemplateIdRequest creates a request to invoke GetCustomFieldsByTemplateId API
func CreateGetCustomFieldsByTemplateIdRequest() (request *GetCustomFieldsByTemplateIdRequest) {
	request = &GetCustomFieldsByTemplateIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rdc", "2018-08-21", "GetCustomFieldsByTemplateId", "rdc", "openAPI")
	return
}

// CreateGetCustomFieldsByTemplateIdResponse creates a response to parse from GetCustomFieldsByTemplateId response
func CreateGetCustomFieldsByTemplateIdResponse() (response *GetCustomFieldsByTemplateIdResponse) {
	response = &GetCustomFieldsByTemplateIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
