package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEntityRoute invokes the scsp.DeleteEntityRoute API synchronously
func (client *Client) DeleteEntityRoute(request *DeleteEntityRouteRequest) (response *DeleteEntityRouteResponse, err error) {
	response = CreateDeleteEntityRouteResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEntityRouteWithChan invokes the scsp.DeleteEntityRoute API asynchronously
func (client *Client) DeleteEntityRouteWithChan(request *DeleteEntityRouteRequest) (<-chan *DeleteEntityRouteResponse, <-chan error) {
	responseChan := make(chan *DeleteEntityRouteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEntityRoute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEntityRouteWithCallback invokes the scsp.DeleteEntityRoute API asynchronously
func (client *Client) DeleteEntityRouteWithCallback(request *DeleteEntityRouteRequest, callback func(response *DeleteEntityRouteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEntityRouteResponse
		var err error
		defer close(result)
		response, err = client.DeleteEntityRoute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEntityRouteRequest is the request struct for api DeleteEntityRoute
type DeleteEntityRouteRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Body"`
	UniqueId   requests.Integer `position:"Body"`
}

// DeleteEntityRouteResponse is the response struct for api DeleteEntityRoute
type DeleteEntityRouteResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteEntityRouteRequest creates a request to invoke DeleteEntityRoute API
func CreateDeleteEntityRouteRequest() (request *DeleteEntityRouteRequest) {
	request = &DeleteEntityRouteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "DeleteEntityRoute", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteEntityRouteResponse creates a response to parse from DeleteEntityRoute response
func CreateDeleteEntityRouteResponse() (response *DeleteEntityRouteResponse) {
	response = &DeleteEntityRouteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
