package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FinishHotlineService invokes the scsp.FinishHotlineService API synchronously
func (client *Client) FinishHotlineService(request *FinishHotlineServiceRequest) (response *FinishHotlineServiceResponse, err error) {
	response = CreateFinishHotlineServiceResponse()
	err = client.DoAction(request, response)
	return
}

// FinishHotlineServiceWithChan invokes the scsp.FinishHotlineService API asynchronously
func (client *Client) FinishHotlineServiceWithChan(request *FinishHotlineServiceRequest) (<-chan *FinishHotlineServiceResponse, <-chan error) {
	responseChan := make(chan *FinishHotlineServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FinishHotlineService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FinishHotlineServiceWithCallback invokes the scsp.FinishHotlineService API asynchronously
func (client *Client) FinishHotlineServiceWithCallback(request *FinishHotlineServiceRequest, callback func(response *FinishHotlineServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FinishHotlineServiceResponse
		var err error
		defer close(result)
		response, err = client.FinishHotlineService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FinishHotlineServiceRequest is the request struct for api FinishHotlineService
type FinishHotlineServiceRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Body"`
	InstanceId  string `position:"Body"`
	AccountName string `position:"Body"`
}

// FinishHotlineServiceResponse is the response struct for api FinishHotlineService
type FinishHotlineServiceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateFinishHotlineServiceRequest creates a request to invoke FinishHotlineService API
func CreateFinishHotlineServiceRequest() (request *FinishHotlineServiceRequest) {
	request = &FinishHotlineServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "FinishHotlineService", "", "")
	request.Method = requests.POST
	return
}

// CreateFinishHotlineServiceResponse creates a response to parse from FinishHotlineService response
func CreateFinishHotlineServiceResponse() (response *FinishHotlineServiceResponse) {
	response = &FinishHotlineServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
