/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataFile;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleGlobalObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleSegment;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectLazy;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class OracleTablespace
extends OracleGlobalObject
implements DBPRefreshableObject,
DBPObjectStatistics,
DBPScriptObject {
    private static final Log log = Log.getLog(OracleTablespace.class);
    private String name;
    private long blockSize;
    private long initialExtent;
    private long nextExtent;
    private long minExtents;
    private long maxExtents;
    private long pctIncrease;
    private long minExtLen;
    private Status status;
    private Contents contents;
    private Logging logging;
    private boolean forceLogging;
    private ExtentManagement extentManagement;
    private AllocationType allocationType;
    private boolean pluggedIn;
    private SegmentSpaceManagement segmentSpaceManagement;
    private boolean defTableCompression;
    private Retention retention;
    private boolean bigFile;
    private volatile Long availableSize;
    private volatile Long usedSize;
    private final FileCache fileCache = new FileCache();
    private final SegmentCache segmentCache = new SegmentCache();
    private String ddlStringHolder = null;

    protected OracleTablespace(OracleDataSource dataSource, ResultSet dbResult) {
        super(dataSource, true);
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLESPACE_NAME");
        this.blockSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"BLOCK_SIZE");
        this.initialExtent = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"INITIAL_EXTENT");
        this.nextExtent = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NEXT_EXTENT");
        this.minExtents = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MIN_EXTENTS");
        this.maxExtents = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MAX_EXTENTS");
        this.pctIncrease = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"PCT_INCREASE");
        this.minExtLen = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"MIN_EXTLEN");
        this.status = (Status)CommonUtils.valueOf(Status.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATUS"), (Enum)Status.OFFLINE, (boolean)true);
        this.contents = (Contents)CommonUtils.valueOf(Contents.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CONTENTS"), null, (boolean)true);
        this.logging = (Logging)CommonUtils.valueOf(Logging.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"LOGGING"), null, (boolean)true);
        this.forceLogging = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"FORCE_LOGGING", (String)"Y");
        this.extentManagement = (ExtentManagement)CommonUtils.valueOf(ExtentManagement.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"EXTENT_MANAGEMENT"), null, (boolean)true);
        this.allocationType = (AllocationType)CommonUtils.valueOf(AllocationType.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ALLOCATION_TYPE"), null, (boolean)true);
        this.pluggedIn = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"PLUGGED_IN", (String)"Y");
        this.segmentSpaceManagement = (SegmentSpaceManagement)CommonUtils.valueOf(SegmentSpaceManagement.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SEGMENT_SPACE_MANAGEMENT"), null, (boolean)true);
        this.defTableCompression = "ENABLED".equals(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DEF_TAB_COMPRESSION"));
        this.retention = (Retention)CommonUtils.valueOf(Retention.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"RETENTION"), null, (boolean)true);
        this.bigFile = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"BIGFILE", (String)"Y");
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=4, formatter=ByteNumberFormat.class)
    public Long getAvailableSize(DBRProgressMonitor monitor) throws DBException {
        if (this.availableSize == null) {
            this.loadSizes(monitor);
        }
        return this.availableSize;
    }

    @Property(viewable=true, order=5, formatter=ByteNumberFormat.class)
    public Long getUsedSize(DBRProgressMonitor monitor) throws DBException {
        if (this.usedSize == null) {
            this.loadSizes(monitor);
        }
        return this.usedSize;
    }

    @Property(viewable=true, editable=true, order=22, formatter=ByteNumberFormat.class)
    public long getBlockSize() {
        return this.blockSize;
    }

    @Property(editable=true, order=23)
    public long getInitialExtent() {
        return this.initialExtent;
    }

    @Property(editable=true, order=24)
    public long getNextExtent() {
        return this.nextExtent;
    }

    @Property(editable=true, order=25)
    public long getMinExtents() {
        return this.minExtents;
    }

    @Property(editable=true, order=26)
    public long getMaxExtents() {
        return this.maxExtents;
    }

    @Property(editable=true, order=27)
    public long getPctIncrease() {
        return this.pctIncrease;
    }

    @Property(editable=true, order=28)
    public long getMinExtLen() {
        return this.minExtLen;
    }

    @Property(viewable=true, editable=true, order=29)
    public Status getStatus() {
        return this.status;
    }

    @Property(editable=true, order=30)
    public Contents getContents() {
        return this.contents;
    }

    @Property(editable=true, order=31)
    public Logging isLogging() {
        return this.logging;
    }

    @Property(editable=true, order=32)
    public boolean isForceLogging() {
        return this.forceLogging;
    }

    @Property(editable=true, order=33)
    public ExtentManagement getExtentManagement() {
        return this.extentManagement;
    }

    @Property(editable=true, order=34)
    public AllocationType getAllocationType() {
        return this.allocationType;
    }

    @Property(editable=true, order=35)
    public boolean isPluggedIn() {
        return this.pluggedIn;
    }

    @Property(editable=true, order=36)
    public SegmentSpaceManagement getSegmentSpaceManagement() {
        return this.segmentSpaceManagement;
    }

    @Property(editable=true, order=37)
    public boolean isDefTableCompression() {
        return this.defTableCompression;
    }

    @Property(editable=true, order=38)
    public Retention getRetention() {
        return this.retention;
    }

    @Property(editable=true, order=39)
    public boolean isBigFile() {
        return this.bigFile;
    }

    @Association
    public Collection<OracleDataFile> getFiles(DBRProgressMonitor monitor) throws DBException {
        return this.fileCache.getAllObjects(monitor, this);
    }

    public OracleDataFile getFile(DBRProgressMonitor monitor, long relativeFileNo) throws DBException {
        for (OracleDataFile file : this.fileCache.getAllObjects(monitor, this)) {
            if (file.getRelativeNo() != relativeFileNo) continue;
            return file;
        }
        return null;
    }

    public FileCache getFileCache() {
        return this.fileCache;
    }

    @Association
    public Collection<OracleSegment<OracleTablespace>> getSegments(DBRProgressMonitor monitor) throws DBException {
        return this.segmentCache.getAllObjects(monitor, this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.availableSize = null;
        this.usedSize = null;
        this.ddlStringHolder = null;
        this.fileCache.clearCache();
        this.segmentCache.clearCache();
        this.getDataSource().resetStatistics();
        return this;
    }

    public boolean hasStatistics() {
        return this.usedSize != null;
    }

    public long getStatObjectSize() {
        return this.usedSize == null ? 0L : this.usedSize;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    private void loadSizes(DBRProgressMonitor monitor) throws DBException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Load tablespace '" + this.getName() + "' statistics"));){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM\n(SELECT SUM(F.BYTES) AVAILABLE_SPACE FROM " + OracleUtils.getSysSchemaPrefix(this.getDataSource()) + "DBA_DATA_FILES F WHERE F.TABLESPACE_NAME=?) XDF,\n(SELECT SUM(S.BYTES) USED_SPACE FROM " + OracleUtils.getSysSchemaPrefix(this.getDataSource()) + "DBA_SEGMENTS S WHERE S.TABLESPACE_NAME=?) XS");){
                    dbStat.setString(1, this.getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.fetchSizes(dbResult);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException("Can't read tablespace statistics", (Throwable)e, (DBPDataSource)this.getDataSource());
        }
    }

    void fetchSizes(JDBCResultSet dbResult) throws SQLException {
        this.availableSize = dbResult.getLong("AVAILABLE_SPACE");
        this.usedSize = dbResult.getLong("USED_SPACE");
    }

    static Object resolveTablespaceReference(DBRProgressMonitor monitor, DBSObjectLazy<OracleDataSource> referrer, @Nullable Object propertyId) throws DBException {
        OracleDataSource dataSource = (OracleDataSource)referrer.getDataSource();
        if (!dataSource.isAdmin()) {
            return referrer.getLazyReference(propertyId);
        }
        return OracleUtils.resolveLazyReference(monitor, dataSource, dataSource.tablespaceCache, referrer, propertyId);
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        if (this.ddlStringHolder != null) {
            return this.ddlStringHolder;
        }
        String objectType = "TABLESPACE";
        String objectName = this.getName();
        String ddl = null;
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)("Load source code for " + objectType + " '" + objectName + "'"));){
                if (this.getDataSource().isAtLeastV9()) {
                    try {
                        JDBCUtils.executeProcedure((Connection)session, (String)"begin\nDBMS_METADATA.SET_TRANSFORM_PARAM(DBMS_METADATA.SESSION_TRANSFORM,'SQLTERMINATOR',true);\nend;");
                    }
                    catch (SQLException e) {
                        log.error((Object)"Can't apply DDL transform parameters", (Throwable)e);
                    }
                }
                ddl = OracleUtils.fetchDDL(session, objectType, objectName);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.error((Object)("Can't fetch DDL for " + objectType + ":" + objectName), (Throwable)e);
        }
        if (ddl == null) {
            ddl = "-- EMPTY DDL";
        }
        this.ddlStringHolder = ddl.trim();
        return this.ddlStringHolder;
    }

    public static enum AllocationType {
        SYSTEM,
        UNIFORM,
        USER;

    }

    public static enum Contents {
        PERMANENT,
        TEMPORARY,
        UNDO;

    }

    public static enum ExtentManagement {
        DICTIONARY,
        LOCAL;

    }

    static class FileCache
    extends JDBCObjectCache<OracleTablespace, OracleDataFile> {
        FileCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleTablespace owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getSysSchemaPrefix(owner.getDataSource()) + "DBA_" + (owner.getContents() == Contents.TEMPORARY ? "TEMP" : "DATA") + "_FILES WHERE TABLESPACE_NAME=? ORDER BY FILE_NAME");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OracleDataFile fetchObject(@NotNull JDBCSession session, @NotNull OracleTablespace owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleDataFile(owner, (ResultSet)resultSet, owner.getContents() == Contents.TEMPORARY);
        }
    }

    public static enum Logging {
        LOGGING,
        NOLOGGING;

    }

    public static enum Retention {
        GUARANTEE,
        NOGUARANTEE,
        NOT_APPLY;

    }

    static class SegmentCache
    extends JDBCObjectCache<OracleTablespace, OracleSegment<OracleTablespace>> {
        SegmentCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleTablespace owner) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT * FROM " + OracleUtils.getSysUserViewName(session.getProgressMonitor(), owner.getDataSource(), "SEGMENTS") + " WHERE TABLESPACE_NAME=? ORDER BY SEGMENT_NAME");
            dbStat.setString(1, owner.getName());
            return dbStat;
        }

        protected OracleSegment<OracleTablespace> fetchObject(@NotNull JDBCSession session, @NotNull OracleTablespace owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleSegment<OracleTablespace>(session.getProgressMonitor(), owner, (ResultSet)resultSet);
        }
    }

    public static enum SegmentSpaceManagement {
        MANUAL,
        AUTO;

    }

    public static enum Status {
        ONLINE,
        OFFLINE,
        READ_ONLY;

    }

    public static class TablespaceReferenceValidator
    implements IPropertyCacheValidator<DBSObjectLazy<OracleDataSource>> {
        public boolean isPropertyCached(DBSObjectLazy<OracleDataSource> object, Object propertyId) {
            return object.getLazyReference(propertyId) instanceof OracleTablespace || object.getLazyReference(propertyId) == null || ((OracleDataSource)object.getDataSource()).tablespaceCache.isFullyCached() || !((OracleDataSource)object.getDataSource()).isAdmin();
        }
    }
}

