#include "catch2/catch_test_macros.hpp"

#include <optional>
#include <utils/parse_duration.hpp>

TEST_CASE("parse_duration - 2d")
{
  const long expected = (60 * 60 * 24) * 2;
  const std::optional<long> output = utils::parse_duration("2d");

  CHECK(expected == output);
}

TEST_CASE("parse_duration - 5w")
{
  const long expected = ((60 * 60 * 24) * 7) * 5;
  const std::optional<long> output = utils::parse_duration("5w");

  CHECK(expected == output);
}

TEST_CASE("parse_duration - asdf")
{
  const std::optional<long> expected;
  const std::optional<long> output = utils::parse_duration("asdf");

  CHECK(expected == output);
}

TEST_CASE("parse_duration - 1s")
{
  const long expected = 1;
  const std::optional<long> output = utils::parse_duration("1s");

  CHECK(expected == output);
}

TEST_CASE("parse_duration - 2mon")
{
  const long expected = ((60 * 60 * 24) * 31) * 2;
  const std::optional<long> output = utils::parse_duration("2mon");

  CHECK(expected == output);
}

TEST_CASE("parse_duration - 5y")
{
  const long expected = (long)((60 * 60 * 24) * 365.2425) * 5;
  const std::optional<long> output = utils::parse_duration("5y");

  CHECK(expected == output);
}

TEST_CASE("parse_duration - 5")
{
  const std::optional<long> expected;
  const std::optional<long> output = utils::parse_duration("5");

  CHECK(expected == output);
}

TEST_CASE("parse_duration - <empty>")
{
  const std::optional<long> expected;
  const std::optional<long> output = utils::parse_duration("");

  CHECK(expected == output);
}

TEST_CASE("parse_duration - 5blorbs")
{
  const std::optional<long> expected;
  const std::optional<long> output = utils::parse_duration("5blorbs");

  CHECK(expected == output);
}

TEST_CASE("parse_duration - 5y2d")
{
  const std::optional<long> expected;
  const std::optional<long> output = utils::parse_duration("5y2d");

  CHECK(expected == output);
}
