// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cleanroomsml

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateAudienceModel = "CreateAudienceModel"

// CreateAudienceModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateAudienceModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAudienceModel for more information on using the CreateAudienceModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAudienceModelRequest method.
//	req, resp := client.CreateAudienceModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateAudienceModel
func (c *CleanRoomsML) CreateAudienceModelRequest(input *CreateAudienceModelInput) (req *request.Request, output *CreateAudienceModelOutput) {
	op := &request.Operation{
		Name:       opCreateAudienceModel,
		HTTPMethod: "POST",
		HTTPPath:   "/audience-model",
	}

	if input == nil {
		input = &CreateAudienceModelInput{}
	}

	output = &CreateAudienceModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAudienceModel API operation for AWS Clean Rooms ML.
//
// Defines the information necessary to create an audience model. An audience
// model is a machine learning model that Clean Rooms ML trains to measure similarity
// between users. Clean Rooms ML manages training and storing the audience model.
// The audience model can be used in multiple calls to the StartAudienceGenerationJob
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation CreateAudienceModel for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     You can't complete this action because another resource depends on this resource.
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateAudienceModel
func (c *CleanRoomsML) CreateAudienceModel(input *CreateAudienceModelInput) (*CreateAudienceModelOutput, error) {
	req, out := c.CreateAudienceModelRequest(input)
	return out, req.Send()
}

// CreateAudienceModelWithContext is the same as CreateAudienceModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAudienceModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) CreateAudienceModelWithContext(ctx aws.Context, input *CreateAudienceModelInput, opts ...request.Option) (*CreateAudienceModelOutput, error) {
	req, out := c.CreateAudienceModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConfiguredAudienceModel = "CreateConfiguredAudienceModel"

// CreateConfiguredAudienceModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateConfiguredAudienceModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConfiguredAudienceModel for more information on using the CreateConfiguredAudienceModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateConfiguredAudienceModelRequest method.
//	req, resp := client.CreateConfiguredAudienceModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredAudienceModel
func (c *CleanRoomsML) CreateConfiguredAudienceModelRequest(input *CreateConfiguredAudienceModelInput) (req *request.Request, output *CreateConfiguredAudienceModelOutput) {
	op := &request.Operation{
		Name:       opCreateConfiguredAudienceModel,
		HTTPMethod: "POST",
		HTTPPath:   "/configured-audience-model",
	}

	if input == nil {
		input = &CreateConfiguredAudienceModelInput{}
	}

	output = &CreateConfiguredAudienceModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConfiguredAudienceModel API operation for AWS Clean Rooms ML.
//
// Defines the information necessary to create a configured audience model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation CreateConfiguredAudienceModel for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     You can't complete this action because another resource depends on this resource.
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateConfiguredAudienceModel
func (c *CleanRoomsML) CreateConfiguredAudienceModel(input *CreateConfiguredAudienceModelInput) (*CreateConfiguredAudienceModelOutput, error) {
	req, out := c.CreateConfiguredAudienceModelRequest(input)
	return out, req.Send()
}

// CreateConfiguredAudienceModelWithContext is the same as CreateConfiguredAudienceModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConfiguredAudienceModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) CreateConfiguredAudienceModelWithContext(ctx aws.Context, input *CreateConfiguredAudienceModelInput, opts ...request.Option) (*CreateConfiguredAudienceModelOutput, error) {
	req, out := c.CreateConfiguredAudienceModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrainingDataset = "CreateTrainingDataset"

// CreateTrainingDatasetRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrainingDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrainingDataset for more information on using the CreateTrainingDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTrainingDatasetRequest method.
//	req, resp := client.CreateTrainingDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainingDataset
func (c *CleanRoomsML) CreateTrainingDatasetRequest(input *CreateTrainingDatasetInput) (req *request.Request, output *CreateTrainingDatasetOutput) {
	op := &request.Operation{
		Name:       opCreateTrainingDataset,
		HTTPMethod: "POST",
		HTTPPath:   "/training-dataset",
	}

	if input == nil {
		input = &CreateTrainingDatasetInput{}
	}

	output = &CreateTrainingDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrainingDataset API operation for AWS Clean Rooms ML.
//
// Defines the information necessary to create a training dataset. In Clean
// Rooms ML, the TrainingDataset is metadata that points to a Glue table, which
// is read only during AudienceModel creation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation CreateTrainingDataset for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     You can't complete this action because another resource depends on this resource.
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/CreateTrainingDataset
func (c *CleanRoomsML) CreateTrainingDataset(input *CreateTrainingDatasetInput) (*CreateTrainingDatasetOutput, error) {
	req, out := c.CreateTrainingDatasetRequest(input)
	return out, req.Send()
}

// CreateTrainingDatasetWithContext is the same as CreateTrainingDataset with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrainingDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) CreateTrainingDatasetWithContext(ctx aws.Context, input *CreateTrainingDatasetInput, opts ...request.Option) (*CreateTrainingDatasetOutput, error) {
	req, out := c.CreateTrainingDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAudienceGenerationJob = "DeleteAudienceGenerationJob"

// DeleteAudienceGenerationJobRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAudienceGenerationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAudienceGenerationJob for more information on using the DeleteAudienceGenerationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAudienceGenerationJobRequest method.
//	req, resp := client.DeleteAudienceGenerationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceGenerationJob
func (c *CleanRoomsML) DeleteAudienceGenerationJobRequest(input *DeleteAudienceGenerationJobInput) (req *request.Request, output *DeleteAudienceGenerationJobOutput) {
	op := &request.Operation{
		Name:       opDeleteAudienceGenerationJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/audience-generation-job/{audienceGenerationJobArn}",
	}

	if input == nil {
		input = &DeleteAudienceGenerationJobInput{}
	}

	output = &DeleteAudienceGenerationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAudienceGenerationJob API operation for AWS Clean Rooms ML.
//
// Deletes the specified audience generation job, and removes all data associated
// with the job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation DeleteAudienceGenerationJob for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     You can't complete this action because another resource depends on this resource.
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceGenerationJob
func (c *CleanRoomsML) DeleteAudienceGenerationJob(input *DeleteAudienceGenerationJobInput) (*DeleteAudienceGenerationJobOutput, error) {
	req, out := c.DeleteAudienceGenerationJobRequest(input)
	return out, req.Send()
}

// DeleteAudienceGenerationJobWithContext is the same as DeleteAudienceGenerationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAudienceGenerationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) DeleteAudienceGenerationJobWithContext(ctx aws.Context, input *DeleteAudienceGenerationJobInput, opts ...request.Option) (*DeleteAudienceGenerationJobOutput, error) {
	req, out := c.DeleteAudienceGenerationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAudienceModel = "DeleteAudienceModel"

// DeleteAudienceModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAudienceModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAudienceModel for more information on using the DeleteAudienceModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAudienceModelRequest method.
//	req, resp := client.DeleteAudienceModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceModel
func (c *CleanRoomsML) DeleteAudienceModelRequest(input *DeleteAudienceModelInput) (req *request.Request, output *DeleteAudienceModelOutput) {
	op := &request.Operation{
		Name:       opDeleteAudienceModel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/audience-model/{audienceModelArn}",
	}

	if input == nil {
		input = &DeleteAudienceModelInput{}
	}

	output = &DeleteAudienceModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAudienceModel API operation for AWS Clean Rooms ML.
//
// Specifies an audience model that you want to delete. You can't delete an
// audience model if there are any configured audience models that depend on
// the audience model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation DeleteAudienceModel for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     You can't complete this action because another resource depends on this resource.
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteAudienceModel
func (c *CleanRoomsML) DeleteAudienceModel(input *DeleteAudienceModelInput) (*DeleteAudienceModelOutput, error) {
	req, out := c.DeleteAudienceModelRequest(input)
	return out, req.Send()
}

// DeleteAudienceModelWithContext is the same as DeleteAudienceModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAudienceModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) DeleteAudienceModelWithContext(ctx aws.Context, input *DeleteAudienceModelInput, opts ...request.Option) (*DeleteAudienceModelOutput, error) {
	req, out := c.DeleteAudienceModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfiguredAudienceModel = "DeleteConfiguredAudienceModel"

// DeleteConfiguredAudienceModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfiguredAudienceModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfiguredAudienceModel for more information on using the DeleteConfiguredAudienceModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConfiguredAudienceModelRequest method.
//	req, resp := client.DeleteConfiguredAudienceModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModel
func (c *CleanRoomsML) DeleteConfiguredAudienceModelRequest(input *DeleteConfiguredAudienceModelInput) (req *request.Request, output *DeleteConfiguredAudienceModelOutput) {
	op := &request.Operation{
		Name:       opDeleteConfiguredAudienceModel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/configured-audience-model/{configuredAudienceModelArn}",
	}

	if input == nil {
		input = &DeleteConfiguredAudienceModelInput{}
	}

	output = &DeleteConfiguredAudienceModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfiguredAudienceModel API operation for AWS Clean Rooms ML.
//
// Deletes the specified configured audience model. You can't delete a configured
// audience model if there are any lookalike models that use the configured
// audience model. If you delete a configured audience model, it will be removed
// from any collaborations that it is associated to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation DeleteConfiguredAudienceModel for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     You can't complete this action because another resource depends on this resource.
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModel
func (c *CleanRoomsML) DeleteConfiguredAudienceModel(input *DeleteConfiguredAudienceModelInput) (*DeleteConfiguredAudienceModelOutput, error) {
	req, out := c.DeleteConfiguredAudienceModelRequest(input)
	return out, req.Send()
}

// DeleteConfiguredAudienceModelWithContext is the same as DeleteConfiguredAudienceModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfiguredAudienceModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) DeleteConfiguredAudienceModelWithContext(ctx aws.Context, input *DeleteConfiguredAudienceModelInput, opts ...request.Option) (*DeleteConfiguredAudienceModelOutput, error) {
	req, out := c.DeleteConfiguredAudienceModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConfiguredAudienceModelPolicy = "DeleteConfiguredAudienceModelPolicy"

// DeleteConfiguredAudienceModelPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConfiguredAudienceModelPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConfiguredAudienceModelPolicy for more information on using the DeleteConfiguredAudienceModelPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteConfiguredAudienceModelPolicyRequest method.
//	req, resp := client.DeleteConfiguredAudienceModelPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModelPolicy
func (c *CleanRoomsML) DeleteConfiguredAudienceModelPolicyRequest(input *DeleteConfiguredAudienceModelPolicyInput) (req *request.Request, output *DeleteConfiguredAudienceModelPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteConfiguredAudienceModelPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/configured-audience-model/{configuredAudienceModelArn}/policy",
	}

	if input == nil {
		input = &DeleteConfiguredAudienceModelPolicyInput{}
	}

	output = &DeleteConfiguredAudienceModelPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConfiguredAudienceModelPolicy API operation for AWS Clean Rooms ML.
//
// Deletes the specified configured audience model policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation DeleteConfiguredAudienceModelPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteConfiguredAudienceModelPolicy
func (c *CleanRoomsML) DeleteConfiguredAudienceModelPolicy(input *DeleteConfiguredAudienceModelPolicyInput) (*DeleteConfiguredAudienceModelPolicyOutput, error) {
	req, out := c.DeleteConfiguredAudienceModelPolicyRequest(input)
	return out, req.Send()
}

// DeleteConfiguredAudienceModelPolicyWithContext is the same as DeleteConfiguredAudienceModelPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConfiguredAudienceModelPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) DeleteConfiguredAudienceModelPolicyWithContext(ctx aws.Context, input *DeleteConfiguredAudienceModelPolicyInput, opts ...request.Option) (*DeleteConfiguredAudienceModelPolicyOutput, error) {
	req, out := c.DeleteConfiguredAudienceModelPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrainingDataset = "DeleteTrainingDataset"

// DeleteTrainingDatasetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrainingDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrainingDataset for more information on using the DeleteTrainingDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTrainingDatasetRequest method.
//	req, resp := client.DeleteTrainingDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainingDataset
func (c *CleanRoomsML) DeleteTrainingDatasetRequest(input *DeleteTrainingDatasetInput) (req *request.Request, output *DeleteTrainingDatasetOutput) {
	op := &request.Operation{
		Name:       opDeleteTrainingDataset,
		HTTPMethod: "DELETE",
		HTTPPath:   "/training-dataset/{trainingDatasetArn}",
	}

	if input == nil {
		input = &DeleteTrainingDatasetInput{}
	}

	output = &DeleteTrainingDatasetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTrainingDataset API operation for AWS Clean Rooms ML.
//
// Specifies a training dataset that you want to delete. You can't delete a
// training dataset if there are any audience models that depend on the training
// dataset. In Clean Rooms ML, the TrainingDataset is metadata that points to
// a Glue table, which is read only during AudienceModel creation. This action
// deletes the metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation DeleteTrainingDataset for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     You can't complete this action because another resource depends on this resource.
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/DeleteTrainingDataset
func (c *CleanRoomsML) DeleteTrainingDataset(input *DeleteTrainingDatasetInput) (*DeleteTrainingDatasetOutput, error) {
	req, out := c.DeleteTrainingDatasetRequest(input)
	return out, req.Send()
}

// DeleteTrainingDatasetWithContext is the same as DeleteTrainingDataset with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrainingDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) DeleteTrainingDatasetWithContext(ctx aws.Context, input *DeleteTrainingDatasetInput, opts ...request.Option) (*DeleteTrainingDatasetOutput, error) {
	req, out := c.DeleteTrainingDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAudienceGenerationJob = "GetAudienceGenerationJob"

// GetAudienceGenerationJobRequest generates a "aws/request.Request" representing the
// client's request for the GetAudienceGenerationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAudienceGenerationJob for more information on using the GetAudienceGenerationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAudienceGenerationJobRequest method.
//	req, resp := client.GetAudienceGenerationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceGenerationJob
func (c *CleanRoomsML) GetAudienceGenerationJobRequest(input *GetAudienceGenerationJobInput) (req *request.Request, output *GetAudienceGenerationJobOutput) {
	op := &request.Operation{
		Name:       opGetAudienceGenerationJob,
		HTTPMethod: "GET",
		HTTPPath:   "/audience-generation-job/{audienceGenerationJobArn}",
	}

	if input == nil {
		input = &GetAudienceGenerationJobInput{}
	}

	output = &GetAudienceGenerationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAudienceGenerationJob API operation for AWS Clean Rooms ML.
//
// Returns information about an audience generation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation GetAudienceGenerationJob for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceGenerationJob
func (c *CleanRoomsML) GetAudienceGenerationJob(input *GetAudienceGenerationJobInput) (*GetAudienceGenerationJobOutput, error) {
	req, out := c.GetAudienceGenerationJobRequest(input)
	return out, req.Send()
}

// GetAudienceGenerationJobWithContext is the same as GetAudienceGenerationJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetAudienceGenerationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) GetAudienceGenerationJobWithContext(ctx aws.Context, input *GetAudienceGenerationJobInput, opts ...request.Option) (*GetAudienceGenerationJobOutput, error) {
	req, out := c.GetAudienceGenerationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAudienceModel = "GetAudienceModel"

// GetAudienceModelRequest generates a "aws/request.Request" representing the
// client's request for the GetAudienceModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAudienceModel for more information on using the GetAudienceModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAudienceModelRequest method.
//	req, resp := client.GetAudienceModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceModel
func (c *CleanRoomsML) GetAudienceModelRequest(input *GetAudienceModelInput) (req *request.Request, output *GetAudienceModelOutput) {
	op := &request.Operation{
		Name:       opGetAudienceModel,
		HTTPMethod: "GET",
		HTTPPath:   "/audience-model/{audienceModelArn}",
	}

	if input == nil {
		input = &GetAudienceModelInput{}
	}

	output = &GetAudienceModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAudienceModel API operation for AWS Clean Rooms ML.
//
// # Returns information about an audience model
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation GetAudienceModel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetAudienceModel
func (c *CleanRoomsML) GetAudienceModel(input *GetAudienceModelInput) (*GetAudienceModelOutput, error) {
	req, out := c.GetAudienceModelRequest(input)
	return out, req.Send()
}

// GetAudienceModelWithContext is the same as GetAudienceModel with the addition of
// the ability to pass a context and additional request options.
//
// See GetAudienceModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) GetAudienceModelWithContext(ctx aws.Context, input *GetAudienceModelInput, opts ...request.Option) (*GetAudienceModelOutput, error) {
	req, out := c.GetAudienceModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfiguredAudienceModel = "GetConfiguredAudienceModel"

// GetConfiguredAudienceModelRequest generates a "aws/request.Request" representing the
// client's request for the GetConfiguredAudienceModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfiguredAudienceModel for more information on using the GetConfiguredAudienceModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConfiguredAudienceModelRequest method.
//	req, resp := client.GetConfiguredAudienceModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModel
func (c *CleanRoomsML) GetConfiguredAudienceModelRequest(input *GetConfiguredAudienceModelInput) (req *request.Request, output *GetConfiguredAudienceModelOutput) {
	op := &request.Operation{
		Name:       opGetConfiguredAudienceModel,
		HTTPMethod: "GET",
		HTTPPath:   "/configured-audience-model/{configuredAudienceModelArn}",
	}

	if input == nil {
		input = &GetConfiguredAudienceModelInput{}
	}

	output = &GetConfiguredAudienceModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfiguredAudienceModel API operation for AWS Clean Rooms ML.
//
// Returns information about a specified configured audience model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation GetConfiguredAudienceModel for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModel
func (c *CleanRoomsML) GetConfiguredAudienceModel(input *GetConfiguredAudienceModelInput) (*GetConfiguredAudienceModelOutput, error) {
	req, out := c.GetConfiguredAudienceModelRequest(input)
	return out, req.Send()
}

// GetConfiguredAudienceModelWithContext is the same as GetConfiguredAudienceModel with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfiguredAudienceModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) GetConfiguredAudienceModelWithContext(ctx aws.Context, input *GetConfiguredAudienceModelInput, opts ...request.Option) (*GetConfiguredAudienceModelOutput, error) {
	req, out := c.GetConfiguredAudienceModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetConfiguredAudienceModelPolicy = "GetConfiguredAudienceModelPolicy"

// GetConfiguredAudienceModelPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetConfiguredAudienceModelPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetConfiguredAudienceModelPolicy for more information on using the GetConfiguredAudienceModelPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetConfiguredAudienceModelPolicyRequest method.
//	req, resp := client.GetConfiguredAudienceModelPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModelPolicy
func (c *CleanRoomsML) GetConfiguredAudienceModelPolicyRequest(input *GetConfiguredAudienceModelPolicyInput) (req *request.Request, output *GetConfiguredAudienceModelPolicyOutput) {
	op := &request.Operation{
		Name:       opGetConfiguredAudienceModelPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/configured-audience-model/{configuredAudienceModelArn}/policy",
	}

	if input == nil {
		input = &GetConfiguredAudienceModelPolicyInput{}
	}

	output = &GetConfiguredAudienceModelPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetConfiguredAudienceModelPolicy API operation for AWS Clean Rooms ML.
//
// Returns information about a configured audience model policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation GetConfiguredAudienceModelPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetConfiguredAudienceModelPolicy
func (c *CleanRoomsML) GetConfiguredAudienceModelPolicy(input *GetConfiguredAudienceModelPolicyInput) (*GetConfiguredAudienceModelPolicyOutput, error) {
	req, out := c.GetConfiguredAudienceModelPolicyRequest(input)
	return out, req.Send()
}

// GetConfiguredAudienceModelPolicyWithContext is the same as GetConfiguredAudienceModelPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetConfiguredAudienceModelPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) GetConfiguredAudienceModelPolicyWithContext(ctx aws.Context, input *GetConfiguredAudienceModelPolicyInput, opts ...request.Option) (*GetConfiguredAudienceModelPolicyOutput, error) {
	req, out := c.GetConfiguredAudienceModelPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrainingDataset = "GetTrainingDataset"

// GetTrainingDatasetRequest generates a "aws/request.Request" representing the
// client's request for the GetTrainingDataset operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrainingDataset for more information on using the GetTrainingDataset
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTrainingDatasetRequest method.
//	req, resp := client.GetTrainingDatasetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainingDataset
func (c *CleanRoomsML) GetTrainingDatasetRequest(input *GetTrainingDatasetInput) (req *request.Request, output *GetTrainingDatasetOutput) {
	op := &request.Operation{
		Name:       opGetTrainingDataset,
		HTTPMethod: "GET",
		HTTPPath:   "/training-dataset/{trainingDatasetArn}",
	}

	if input == nil {
		input = &GetTrainingDatasetInput{}
	}

	output = &GetTrainingDatasetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrainingDataset API operation for AWS Clean Rooms ML.
//
// Returns information about a training dataset.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation GetTrainingDataset for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/GetTrainingDataset
func (c *CleanRoomsML) GetTrainingDataset(input *GetTrainingDatasetInput) (*GetTrainingDatasetOutput, error) {
	req, out := c.GetTrainingDatasetRequest(input)
	return out, req.Send()
}

// GetTrainingDatasetWithContext is the same as GetTrainingDataset with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrainingDataset for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) GetTrainingDatasetWithContext(ctx aws.Context, input *GetTrainingDatasetInput, opts ...request.Option) (*GetTrainingDatasetOutput, error) {
	req, out := c.GetTrainingDatasetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAudienceExportJobs = "ListAudienceExportJobs"

// ListAudienceExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListAudienceExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAudienceExportJobs for more information on using the ListAudienceExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAudienceExportJobsRequest method.
//	req, resp := client.ListAudienceExportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs
func (c *CleanRoomsML) ListAudienceExportJobsRequest(input *ListAudienceExportJobsInput) (req *request.Request, output *ListAudienceExportJobsOutput) {
	op := &request.Operation{
		Name:       opListAudienceExportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/audience-export-job",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAudienceExportJobsInput{}
	}

	output = &ListAudienceExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAudienceExportJobs API operation for AWS Clean Rooms ML.
//
// Returns a list of the audience export jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation ListAudienceExportJobs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceExportJobs
func (c *CleanRoomsML) ListAudienceExportJobs(input *ListAudienceExportJobsInput) (*ListAudienceExportJobsOutput, error) {
	req, out := c.ListAudienceExportJobsRequest(input)
	return out, req.Send()
}

// ListAudienceExportJobsWithContext is the same as ListAudienceExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListAudienceExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) ListAudienceExportJobsWithContext(ctx aws.Context, input *ListAudienceExportJobsInput, opts ...request.Option) (*ListAudienceExportJobsOutput, error) {
	req, out := c.ListAudienceExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAudienceExportJobsPages iterates over the pages of a ListAudienceExportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAudienceExportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAudienceExportJobs operation.
//	pageNum := 0
//	err := client.ListAudienceExportJobsPages(params,
//	    func(page *cleanroomsml.ListAudienceExportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRoomsML) ListAudienceExportJobsPages(input *ListAudienceExportJobsInput, fn func(*ListAudienceExportJobsOutput, bool) bool) error {
	return c.ListAudienceExportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAudienceExportJobsPagesWithContext same as ListAudienceExportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) ListAudienceExportJobsPagesWithContext(ctx aws.Context, input *ListAudienceExportJobsInput, fn func(*ListAudienceExportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAudienceExportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAudienceExportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAudienceExportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAudienceGenerationJobs = "ListAudienceGenerationJobs"

// ListAudienceGenerationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListAudienceGenerationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAudienceGenerationJobs for more information on using the ListAudienceGenerationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAudienceGenerationJobsRequest method.
//	req, resp := client.ListAudienceGenerationJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs
func (c *CleanRoomsML) ListAudienceGenerationJobsRequest(input *ListAudienceGenerationJobsInput) (req *request.Request, output *ListAudienceGenerationJobsOutput) {
	op := &request.Operation{
		Name:       opListAudienceGenerationJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/audience-generation-job",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAudienceGenerationJobsInput{}
	}

	output = &ListAudienceGenerationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAudienceGenerationJobs API operation for AWS Clean Rooms ML.
//
// Returns a list of audience generation jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation ListAudienceGenerationJobs for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceGenerationJobs
func (c *CleanRoomsML) ListAudienceGenerationJobs(input *ListAudienceGenerationJobsInput) (*ListAudienceGenerationJobsOutput, error) {
	req, out := c.ListAudienceGenerationJobsRequest(input)
	return out, req.Send()
}

// ListAudienceGenerationJobsWithContext is the same as ListAudienceGenerationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListAudienceGenerationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) ListAudienceGenerationJobsWithContext(ctx aws.Context, input *ListAudienceGenerationJobsInput, opts ...request.Option) (*ListAudienceGenerationJobsOutput, error) {
	req, out := c.ListAudienceGenerationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAudienceGenerationJobsPages iterates over the pages of a ListAudienceGenerationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAudienceGenerationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAudienceGenerationJobs operation.
//	pageNum := 0
//	err := client.ListAudienceGenerationJobsPages(params,
//	    func(page *cleanroomsml.ListAudienceGenerationJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRoomsML) ListAudienceGenerationJobsPages(input *ListAudienceGenerationJobsInput, fn func(*ListAudienceGenerationJobsOutput, bool) bool) error {
	return c.ListAudienceGenerationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAudienceGenerationJobsPagesWithContext same as ListAudienceGenerationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) ListAudienceGenerationJobsPagesWithContext(ctx aws.Context, input *ListAudienceGenerationJobsInput, fn func(*ListAudienceGenerationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAudienceGenerationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAudienceGenerationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAudienceGenerationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAudienceModels = "ListAudienceModels"

// ListAudienceModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListAudienceModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAudienceModels for more information on using the ListAudienceModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAudienceModelsRequest method.
//	req, resp := client.ListAudienceModelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels
func (c *CleanRoomsML) ListAudienceModelsRequest(input *ListAudienceModelsInput) (req *request.Request, output *ListAudienceModelsOutput) {
	op := &request.Operation{
		Name:       opListAudienceModels,
		HTTPMethod: "GET",
		HTTPPath:   "/audience-model",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAudienceModelsInput{}
	}

	output = &ListAudienceModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAudienceModels API operation for AWS Clean Rooms ML.
//
// Returns a list of audience models.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation ListAudienceModels for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListAudienceModels
func (c *CleanRoomsML) ListAudienceModels(input *ListAudienceModelsInput) (*ListAudienceModelsOutput, error) {
	req, out := c.ListAudienceModelsRequest(input)
	return out, req.Send()
}

// ListAudienceModelsWithContext is the same as ListAudienceModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListAudienceModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) ListAudienceModelsWithContext(ctx aws.Context, input *ListAudienceModelsInput, opts ...request.Option) (*ListAudienceModelsOutput, error) {
	req, out := c.ListAudienceModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAudienceModelsPages iterates over the pages of a ListAudienceModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAudienceModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAudienceModels operation.
//	pageNum := 0
//	err := client.ListAudienceModelsPages(params,
//	    func(page *cleanroomsml.ListAudienceModelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRoomsML) ListAudienceModelsPages(input *ListAudienceModelsInput, fn func(*ListAudienceModelsOutput, bool) bool) error {
	return c.ListAudienceModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAudienceModelsPagesWithContext same as ListAudienceModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) ListAudienceModelsPagesWithContext(ctx aws.Context, input *ListAudienceModelsInput, fn func(*ListAudienceModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAudienceModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAudienceModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAudienceModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListConfiguredAudienceModels = "ListConfiguredAudienceModels"

// ListConfiguredAudienceModelsRequest generates a "aws/request.Request" representing the
// client's request for the ListConfiguredAudienceModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListConfiguredAudienceModels for more information on using the ListConfiguredAudienceModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListConfiguredAudienceModelsRequest method.
//	req, resp := client.ListConfiguredAudienceModelsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels
func (c *CleanRoomsML) ListConfiguredAudienceModelsRequest(input *ListConfiguredAudienceModelsInput) (req *request.Request, output *ListConfiguredAudienceModelsOutput) {
	op := &request.Operation{
		Name:       opListConfiguredAudienceModels,
		HTTPMethod: "GET",
		HTTPPath:   "/configured-audience-model",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfiguredAudienceModelsInput{}
	}

	output = &ListConfiguredAudienceModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListConfiguredAudienceModels API operation for AWS Clean Rooms ML.
//
// Returns a list of the configured audience models.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation ListConfiguredAudienceModels for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListConfiguredAudienceModels
func (c *CleanRoomsML) ListConfiguredAudienceModels(input *ListConfiguredAudienceModelsInput) (*ListConfiguredAudienceModelsOutput, error) {
	req, out := c.ListConfiguredAudienceModelsRequest(input)
	return out, req.Send()
}

// ListConfiguredAudienceModelsWithContext is the same as ListConfiguredAudienceModels with the addition of
// the ability to pass a context and additional request options.
//
// See ListConfiguredAudienceModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) ListConfiguredAudienceModelsWithContext(ctx aws.Context, input *ListConfiguredAudienceModelsInput, opts ...request.Option) (*ListConfiguredAudienceModelsOutput, error) {
	req, out := c.ListConfiguredAudienceModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListConfiguredAudienceModelsPages iterates over the pages of a ListConfiguredAudienceModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListConfiguredAudienceModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListConfiguredAudienceModels operation.
//	pageNum := 0
//	err := client.ListConfiguredAudienceModelsPages(params,
//	    func(page *cleanroomsml.ListConfiguredAudienceModelsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRoomsML) ListConfiguredAudienceModelsPages(input *ListConfiguredAudienceModelsInput, fn func(*ListConfiguredAudienceModelsOutput, bool) bool) error {
	return c.ListConfiguredAudienceModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListConfiguredAudienceModelsPagesWithContext same as ListConfiguredAudienceModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) ListConfiguredAudienceModelsPagesWithContext(ctx aws.Context, input *ListConfiguredAudienceModelsInput, fn func(*ListConfiguredAudienceModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListConfiguredAudienceModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListConfiguredAudienceModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListConfiguredAudienceModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTagsForResource
func (c *CleanRoomsML) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Clean Rooms ML.
//
// Returns a list of tags for a provided resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTagsForResource
func (c *CleanRoomsML) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTrainingDatasets = "ListTrainingDatasets"

// ListTrainingDatasetsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrainingDatasets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrainingDatasets for more information on using the ListTrainingDatasets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTrainingDatasetsRequest method.
//	req, resp := client.ListTrainingDatasetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets
func (c *CleanRoomsML) ListTrainingDatasetsRequest(input *ListTrainingDatasetsInput) (req *request.Request, output *ListTrainingDatasetsOutput) {
	op := &request.Operation{
		Name:       opListTrainingDatasets,
		HTTPMethod: "GET",
		HTTPPath:   "/training-dataset",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrainingDatasetsInput{}
	}

	output = &ListTrainingDatasetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrainingDatasets API operation for AWS Clean Rooms ML.
//
// Returns a list of training datasets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation ListTrainingDatasets for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets
func (c *CleanRoomsML) ListTrainingDatasets(input *ListTrainingDatasetsInput) (*ListTrainingDatasetsOutput, error) {
	req, out := c.ListTrainingDatasetsRequest(input)
	return out, req.Send()
}

// ListTrainingDatasetsWithContext is the same as ListTrainingDatasets with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrainingDatasets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) ListTrainingDatasetsWithContext(ctx aws.Context, input *ListTrainingDatasetsInput, opts ...request.Option) (*ListTrainingDatasetsOutput, error) {
	req, out := c.ListTrainingDatasetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrainingDatasetsPages iterates over the pages of a ListTrainingDatasets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrainingDatasets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTrainingDatasets operation.
//	pageNum := 0
//	err := client.ListTrainingDatasetsPages(params,
//	    func(page *cleanroomsml.ListTrainingDatasetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *CleanRoomsML) ListTrainingDatasetsPages(input *ListTrainingDatasetsInput, fn func(*ListTrainingDatasetsOutput, bool) bool) error {
	return c.ListTrainingDatasetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrainingDatasetsPagesWithContext same as ListTrainingDatasetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) ListTrainingDatasetsPagesWithContext(ctx aws.Context, input *ListTrainingDatasetsInput, fn func(*ListTrainingDatasetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrainingDatasetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrainingDatasetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrainingDatasetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutConfiguredAudienceModelPolicy = "PutConfiguredAudienceModelPolicy"

// PutConfiguredAudienceModelPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutConfiguredAudienceModelPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutConfiguredAudienceModelPolicy for more information on using the PutConfiguredAudienceModelPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutConfiguredAudienceModelPolicyRequest method.
//	req, resp := client.PutConfiguredAudienceModelPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutConfiguredAudienceModelPolicy
func (c *CleanRoomsML) PutConfiguredAudienceModelPolicyRequest(input *PutConfiguredAudienceModelPolicyInput) (req *request.Request, output *PutConfiguredAudienceModelPolicyOutput) {
	op := &request.Operation{
		Name:       opPutConfiguredAudienceModelPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/configured-audience-model/{configuredAudienceModelArn}/policy",
	}

	if input == nil {
		input = &PutConfiguredAudienceModelPolicyInput{}
	}

	output = &PutConfiguredAudienceModelPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutConfiguredAudienceModelPolicy API operation for AWS Clean Rooms ML.
//
// Create or update the resource policy for a configured audience model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation PutConfiguredAudienceModelPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/PutConfiguredAudienceModelPolicy
func (c *CleanRoomsML) PutConfiguredAudienceModelPolicy(input *PutConfiguredAudienceModelPolicyInput) (*PutConfiguredAudienceModelPolicyOutput, error) {
	req, out := c.PutConfiguredAudienceModelPolicyRequest(input)
	return out, req.Send()
}

// PutConfiguredAudienceModelPolicyWithContext is the same as PutConfiguredAudienceModelPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutConfiguredAudienceModelPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) PutConfiguredAudienceModelPolicyWithContext(ctx aws.Context, input *PutConfiguredAudienceModelPolicyInput, opts ...request.Option) (*PutConfiguredAudienceModelPolicyOutput, error) {
	req, out := c.PutConfiguredAudienceModelPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAudienceExportJob = "StartAudienceExportJob"

// StartAudienceExportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartAudienceExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAudienceExportJob for more information on using the StartAudienceExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartAudienceExportJobRequest method.
//	req, resp := client.StartAudienceExportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceExportJob
func (c *CleanRoomsML) StartAudienceExportJobRequest(input *StartAudienceExportJobInput) (req *request.Request, output *StartAudienceExportJobOutput) {
	op := &request.Operation{
		Name:       opStartAudienceExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/audience-export-job",
	}

	if input == nil {
		input = &StartAudienceExportJobInput{}
	}

	output = &StartAudienceExportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartAudienceExportJob API operation for AWS Clean Rooms ML.
//
// Export an audience of a specified size after you have generated an audience.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation StartAudienceExportJob for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     You can't complete this action because another resource depends on this resource.
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceExportJob
func (c *CleanRoomsML) StartAudienceExportJob(input *StartAudienceExportJobInput) (*StartAudienceExportJobOutput, error) {
	req, out := c.StartAudienceExportJobRequest(input)
	return out, req.Send()
}

// StartAudienceExportJobWithContext is the same as StartAudienceExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartAudienceExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) StartAudienceExportJobWithContext(ctx aws.Context, input *StartAudienceExportJobInput, opts ...request.Option) (*StartAudienceExportJobOutput, error) {
	req, out := c.StartAudienceExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartAudienceGenerationJob = "StartAudienceGenerationJob"

// StartAudienceGenerationJobRequest generates a "aws/request.Request" representing the
// client's request for the StartAudienceGenerationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartAudienceGenerationJob for more information on using the StartAudienceGenerationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartAudienceGenerationJobRequest method.
//	req, resp := client.StartAudienceGenerationJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceGenerationJob
func (c *CleanRoomsML) StartAudienceGenerationJobRequest(input *StartAudienceGenerationJobInput) (req *request.Request, output *StartAudienceGenerationJobOutput) {
	op := &request.Operation{
		Name:       opStartAudienceGenerationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/audience-generation-job",
	}

	if input == nil {
		input = &StartAudienceGenerationJobInput{}
	}

	output = &StartAudienceGenerationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartAudienceGenerationJob API operation for AWS Clean Rooms ML.
//
// Information necessary to start the audience generation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation StartAudienceGenerationJob for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     You can't complete this action because another resource depends on this resource.
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
//   - ServiceQuotaExceededException
//     You have exceeded your service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/StartAudienceGenerationJob
func (c *CleanRoomsML) StartAudienceGenerationJob(input *StartAudienceGenerationJobInput) (*StartAudienceGenerationJobOutput, error) {
	req, out := c.StartAudienceGenerationJobRequest(input)
	return out, req.Send()
}

// StartAudienceGenerationJobWithContext is the same as StartAudienceGenerationJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartAudienceGenerationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) StartAudienceGenerationJobWithContext(ctx aws.Context, input *StartAudienceGenerationJobInput, opts ...request.Option) (*StartAudienceGenerationJobOutput, error) {
	req, out := c.StartAudienceGenerationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/TagResource
func (c *CleanRoomsML) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Clean Rooms ML.
//
// Adds metadata tags to a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/TagResource
func (c *CleanRoomsML) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UntagResource
func (c *CleanRoomsML) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Clean Rooms ML.
//
// Removes metadata tags from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UntagResource
func (c *CleanRoomsML) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConfiguredAudienceModel = "UpdateConfiguredAudienceModel"

// UpdateConfiguredAudienceModelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConfiguredAudienceModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConfiguredAudienceModel for more information on using the UpdateConfiguredAudienceModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateConfiguredAudienceModelRequest method.
//	req, resp := client.UpdateConfiguredAudienceModelRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UpdateConfiguredAudienceModel
func (c *CleanRoomsML) UpdateConfiguredAudienceModelRequest(input *UpdateConfiguredAudienceModelInput) (req *request.Request, output *UpdateConfiguredAudienceModelOutput) {
	op := &request.Operation{
		Name:       opUpdateConfiguredAudienceModel,
		HTTPMethod: "PATCH",
		HTTPPath:   "/configured-audience-model/{configuredAudienceModelArn}",
	}

	if input == nil {
		input = &UpdateConfiguredAudienceModelInput{}
	}

	output = &UpdateConfiguredAudienceModelOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateConfiguredAudienceModel API operation for AWS Clean Rooms ML.
//
// Provides the information necessary to update a configured audience model.
// Updates that impact audience generation jobs take effect when a new job starts,
// but do not impact currently running jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Clean Rooms ML's
// API operation UpdateConfiguredAudienceModel for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     You can't complete this action because another resource depends on this resource.
//
//   - ValidationException
//     The request parameters for this request are incorrect.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ResourceNotFoundException
//     The resource you are requesting does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/UpdateConfiguredAudienceModel
func (c *CleanRoomsML) UpdateConfiguredAudienceModel(input *UpdateConfiguredAudienceModelInput) (*UpdateConfiguredAudienceModelOutput, error) {
	req, out := c.UpdateConfiguredAudienceModelRequest(input)
	return out, req.Send()
}

// UpdateConfiguredAudienceModelWithContext is the same as UpdateConfiguredAudienceModel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConfiguredAudienceModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CleanRoomsML) UpdateConfiguredAudienceModelWithContext(ctx aws.Context, input *UpdateConfiguredAudienceModelInput, opts ...request.Option) (*UpdateConfiguredAudienceModelOutput, error) {
	req, out := c.UpdateConfiguredAudienceModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Defines the Amazon S3 bucket where the configured audience is stored.
type AudienceDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket and path for the configured audience.
	//
	// S3Destination is a required field
	S3Destination *S3ConfigMap `locationName:"s3Destination" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceDestination) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudienceDestination) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudienceDestination"}
	if s.S3Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Destination"))
	}
	if s.S3Destination != nil {
		if err := s.S3Destination.Validate(); err != nil {
			invalidParams.AddNested("S3Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Destination sets the S3Destination field's value.
func (s *AudienceDestination) SetS3Destination(v *S3ConfigMap) *AudienceDestination {
	s.S3Destination = v
	return s
}

// Provides information about the audience export job.
type AudienceExportJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the audience generation job that was exported.
	//
	// AudienceGenerationJobArn is a required field
	AudienceGenerationJobArn *string `locationName:"audienceGenerationJobArn" min:"20" type:"string" required:"true"`

	// The size of the generated audience. Must match one of the sizes in the configured
	// audience model.
	//
	// AudienceSize is a required field
	AudienceSize *AudienceSize `locationName:"audienceSize" type:"structure" required:"true"`

	// The time at which the audience export job was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the audience export job.
	Description *string `locationName:"description" type:"string"`

	// The name of the audience export job.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon S3 bucket where the audience export is stored.
	OutputLocation *string `locationName:"outputLocation" min:"1" type:"string"`

	// The status of the audience export job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AudienceExportJobStatus"`

	// Details about the status of a resource.
	StatusDetails *StatusDetails `locationName:"statusDetails" type:"structure"`

	// The most recent time at which the audience export job was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceExportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceExportJobSummary) GoString() string {
	return s.String()
}

// SetAudienceGenerationJobArn sets the AudienceGenerationJobArn field's value.
func (s *AudienceExportJobSummary) SetAudienceGenerationJobArn(v string) *AudienceExportJobSummary {
	s.AudienceGenerationJobArn = &v
	return s
}

// SetAudienceSize sets the AudienceSize field's value.
func (s *AudienceExportJobSummary) SetAudienceSize(v *AudienceSize) *AudienceExportJobSummary {
	s.AudienceSize = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AudienceExportJobSummary) SetCreateTime(v time.Time) *AudienceExportJobSummary {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AudienceExportJobSummary) SetDescription(v string) *AudienceExportJobSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AudienceExportJobSummary) SetName(v string) *AudienceExportJobSummary {
	s.Name = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *AudienceExportJobSummary) SetOutputLocation(v string) *AudienceExportJobSummary {
	s.OutputLocation = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AudienceExportJobSummary) SetStatus(v string) *AudienceExportJobSummary {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *AudienceExportJobSummary) SetStatusDetails(v *StatusDetails) *AudienceExportJobSummary {
	s.StatusDetails = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *AudienceExportJobSummary) SetUpdateTime(v time.Time) *AudienceExportJobSummary {
	s.UpdateTime = &v
	return s
}

// Defines the Amazon S3 bucket where the seed audience for the generating audience
// is stored.
type AudienceGenerationJobDataSource struct {
	_ struct{} `type:"structure"`

	// Defines the Amazon S3 bucket where the seed audience for the generating audience
	// is stored. A valid data source is a JSON line file in the following format:
	//
	// {"user_id": "111111"}
	//
	// {"user_id": "222222"}
	//
	// ...
	//
	// DataSource is a required field
	DataSource *S3ConfigMap `locationName:"dataSource" type:"structure" required:"true"`

	// The ARN of the IAM role that can read the Amazon S3 bucket where the training
	// data is stored.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceGenerationJobDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceGenerationJobDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudienceGenerationJobDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudienceGenerationJobDataSource"}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *AudienceGenerationJobDataSource) SetDataSource(v *S3ConfigMap) *AudienceGenerationJobDataSource {
	s.DataSource = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *AudienceGenerationJobDataSource) SetRoleArn(v string) *AudienceGenerationJobDataSource {
	s.RoleArn = &v
	return s
}

// Provides information about the configured audience generation job.
type AudienceGenerationJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the audience generation job.
	//
	// AudienceGenerationJobArn is a required field
	AudienceGenerationJobArn *string `locationName:"audienceGenerationJobArn" min:"20" type:"string" required:"true"`

	// The identifier of the collaboration that contains this audience generation
	// job.
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string"`

	// The Amazon Resource Name (ARN) of the configured audience model that was
	// used for this audience generation job.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`

	// The time at which the audience generation job was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the audience generation job.
	Description *string `locationName:"description" type:"string"`

	// The name of the audience generation job.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The AWS Account that submitted the job.
	StartedBy *string `locationName:"startedBy" min:"12" type:"string"`

	// The status of the audience generation job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AudienceGenerationJobStatus"`

	// The most recent time at which the audience generation job was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceGenerationJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceGenerationJobSummary) GoString() string {
	return s.String()
}

// SetAudienceGenerationJobArn sets the AudienceGenerationJobArn field's value.
func (s *AudienceGenerationJobSummary) SetAudienceGenerationJobArn(v string) *AudienceGenerationJobSummary {
	s.AudienceGenerationJobArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *AudienceGenerationJobSummary) SetCollaborationId(v string) *AudienceGenerationJobSummary {
	s.CollaborationId = &v
	return s
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *AudienceGenerationJobSummary) SetConfiguredAudienceModelArn(v string) *AudienceGenerationJobSummary {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AudienceGenerationJobSummary) SetCreateTime(v time.Time) *AudienceGenerationJobSummary {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AudienceGenerationJobSummary) SetDescription(v string) *AudienceGenerationJobSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AudienceGenerationJobSummary) SetName(v string) *AudienceGenerationJobSummary {
	s.Name = &v
	return s
}

// SetStartedBy sets the StartedBy field's value.
func (s *AudienceGenerationJobSummary) SetStartedBy(v string) *AudienceGenerationJobSummary {
	s.StartedBy = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AudienceGenerationJobSummary) SetStatus(v string) *AudienceGenerationJobSummary {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *AudienceGenerationJobSummary) SetUpdateTime(v time.Time) *AudienceGenerationJobSummary {
	s.UpdateTime = &v
	return s
}

// Information about the audience model.
type AudienceModelSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the audience model.
	//
	// AudienceModelArn is a required field
	AudienceModelArn *string `locationName:"audienceModelArn" min:"20" type:"string" required:"true"`

	// The time at which the audience model was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the audience model.
	Description *string `locationName:"description" type:"string"`

	// The name of the audience model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of the audience model.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AudienceModelStatus"`

	// The Amazon Resource Name (ARN) of the training dataset that was used for
	// the audience model.
	//
	// TrainingDatasetArn is a required field
	TrainingDatasetArn *string `locationName:"trainingDatasetArn" min:"20" type:"string" required:"true"`

	// The most recent time at which the audience model was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceModelSummary) GoString() string {
	return s.String()
}

// SetAudienceModelArn sets the AudienceModelArn field's value.
func (s *AudienceModelSummary) SetAudienceModelArn(v string) *AudienceModelSummary {
	s.AudienceModelArn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AudienceModelSummary) SetCreateTime(v time.Time) *AudienceModelSummary {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AudienceModelSummary) SetDescription(v string) *AudienceModelSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *AudienceModelSummary) SetName(v string) *AudienceModelSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AudienceModelSummary) SetStatus(v string) *AudienceModelSummary {
	s.Status = &v
	return s
}

// SetTrainingDatasetArn sets the TrainingDatasetArn field's value.
func (s *AudienceModelSummary) SetTrainingDatasetArn(v string) *AudienceModelSummary {
	s.TrainingDatasetArn = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *AudienceModelSummary) SetUpdateTime(v time.Time) *AudienceModelSummary {
	s.UpdateTime = &v
	return s
}

// Metrics that describe the quality of the generated audience.
type AudienceQualityMetrics struct {
	_ struct{} `type:"structure"`

	// The recall score of the generated audience. Recall is the percentage of the
	// most similar users (by default, the most similar 20%) from a sample of the
	// training data that are included in the seed audience by the audience generation
	// job. Values range from 0-1, larger values indicate a better audience. A recall
	// value approximately equal to the maximum bin size indicates that the audience
	// model is equivalent to random selection.
	RecallMetric *float64 `locationName:"recallMetric" type:"double"`

	// The relevance scores of the generated audience.
	//
	// RelevanceMetrics is a required field
	RelevanceMetrics []*RelevanceMetric `locationName:"relevanceMetrics" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceQualityMetrics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceQualityMetrics) GoString() string {
	return s.String()
}

// SetRecallMetric sets the RecallMetric field's value.
func (s *AudienceQualityMetrics) SetRecallMetric(v float64) *AudienceQualityMetrics {
	s.RecallMetric = &v
	return s
}

// SetRelevanceMetrics sets the RelevanceMetrics field's value.
func (s *AudienceQualityMetrics) SetRelevanceMetrics(v []*RelevanceMetric) *AudienceQualityMetrics {
	s.RelevanceMetrics = v
	return s
}

// The size of the generated audience. Must match one of the sizes in the configured
// audience model.
type AudienceSize struct {
	_ struct{} `type:"structure"`

	// Whether the audience size is defined in absolute terms or as a percentage.
	// You can use the ABSOLUTE AudienceSize to configure out audience sizes using
	// the count of identifiers in the output. You can use the Percentage AudienceSize
	// to configure sizes in the range 1-100 percent.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AudienceSizeType"`

	// Specify an audience size value.
	//
	// Value is a required field
	Value *int64 `locationName:"value" min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceSize) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceSize) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudienceSize) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudienceSize"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && *s.Value < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *AudienceSize) SetType(v string) *AudienceSize {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AudienceSize) SetValue(v int64) *AudienceSize {
	s.Value = &v
	return s
}

// Configure the list of audience output sizes that can be created. A request
// to StartAudienceGenerationJob that uses this configured audience model must
// have an audienceSize selected from this list. You can use the ABSOLUTE AudienceSize
// to configure out audience sizes using the count of identifiers in the output.
// You can use the Percentage AudienceSize to configure sizes in the range 1-100
// percent.
type AudienceSizeConfig struct {
	_ struct{} `type:"structure"`

	// An array of the different audience output sizes.
	//
	// AudienceSizeBins is a required field
	AudienceSizeBins []*int64 `locationName:"audienceSizeBins" min:"1" type:"list" required:"true"`

	// Whether the audience output sizes are defined as an absolute number or a
	// percentage.
	//
	// AudienceSizeType is a required field
	AudienceSizeType *string `locationName:"audienceSizeType" type:"string" required:"true" enum:"AudienceSizeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceSizeConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AudienceSizeConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AudienceSizeConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AudienceSizeConfig"}
	if s.AudienceSizeBins == nil {
		invalidParams.Add(request.NewErrParamRequired("AudienceSizeBins"))
	}
	if s.AudienceSizeBins != nil && len(s.AudienceSizeBins) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AudienceSizeBins", 1))
	}
	if s.AudienceSizeType == nil {
		invalidParams.Add(request.NewErrParamRequired("AudienceSizeType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudienceSizeBins sets the AudienceSizeBins field's value.
func (s *AudienceSizeConfig) SetAudienceSizeBins(v []*int64) *AudienceSizeConfig {
	s.AudienceSizeBins = v
	return s
}

// SetAudienceSizeType sets the AudienceSizeType field's value.
func (s *AudienceSizeConfig) SetAudienceSizeType(v string) *AudienceSizeConfig {
	s.AudienceSizeType = &v
	return s
}

// Metadata for a column.
type ColumnSchema struct {
	_ struct{} `type:"structure"`

	// The name of a column.
	//
	// ColumnName is a required field
	ColumnName *string `locationName:"columnName" min:"1" type:"string" required:"true"`

	// The data type of column.
	//
	// ColumnTypes is a required field
	ColumnTypes []*string `locationName:"columnTypes" min:"1" type:"list" required:"true" enum:"ColumnType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnSchema) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ColumnSchema) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ColumnSchema) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ColumnSchema"}
	if s.ColumnName == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnName"))
	}
	if s.ColumnName != nil && len(*s.ColumnName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnName", 1))
	}
	if s.ColumnTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("ColumnTypes"))
	}
	if s.ColumnTypes != nil && len(s.ColumnTypes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ColumnTypes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetColumnName sets the ColumnName field's value.
func (s *ColumnSchema) SetColumnName(v string) *ColumnSchema {
	s.ColumnName = &v
	return s
}

// SetColumnTypes sets the ColumnTypes field's value.
func (s *ColumnSchema) SetColumnTypes(v []*string) *ColumnSchema {
	s.ColumnTypes = v
	return s
}

// Configuration information necessary for the configure audience model output.
type ConfiguredAudienceModelOutputConfig struct {
	_ struct{} `type:"structure"`

	// Defines the Amazon S3 bucket where the configured audience is stored.
	//
	// Destination is a required field
	Destination *AudienceDestination `locationName:"destination" type:"structure" required:"true"`

	// The ARN of the IAM role that can write the Amazon S3 bucket.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredAudienceModelOutputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredAudienceModelOutputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfiguredAudienceModelOutputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfiguredAudienceModelOutputConfig"}
	if s.Destination == nil {
		invalidParams.Add(request.NewErrParamRequired("Destination"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.Destination != nil {
		if err := s.Destination.Validate(); err != nil {
			invalidParams.AddNested("Destination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestination sets the Destination field's value.
func (s *ConfiguredAudienceModelOutputConfig) SetDestination(v *AudienceDestination) *ConfiguredAudienceModelOutputConfig {
	s.Destination = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ConfiguredAudienceModelOutputConfig) SetRoleArn(v string) *ConfiguredAudienceModelOutputConfig {
	s.RoleArn = &v
	return s
}

// Information about the configured audience model.
type ConfiguredAudienceModelSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the audience model that was used to create
	// the configured audience model.
	//
	// AudienceModelArn is a required field
	AudienceModelArn *string `locationName:"audienceModelArn" min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the configured audience model that you
	// are interested in.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`

	// The time at which the configured audience model was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the configured audience model.
	Description *string `locationName:"description" type:"string"`

	// The name of the configured audience model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The output configuration of the configured audience model.
	//
	// OutputConfig is a required field
	OutputConfig *ConfiguredAudienceModelOutputConfig `locationName:"outputConfig" type:"structure" required:"true"`

	// The status of the configured audience model.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ConfiguredAudienceModelStatus"`

	// The most recent time at which the configured audience model was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredAudienceModelSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfiguredAudienceModelSummary) GoString() string {
	return s.String()
}

// SetAudienceModelArn sets the AudienceModelArn field's value.
func (s *ConfiguredAudienceModelSummary) SetAudienceModelArn(v string) *ConfiguredAudienceModelSummary {
	s.AudienceModelArn = &v
	return s
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *ConfiguredAudienceModelSummary) SetConfiguredAudienceModelArn(v string) *ConfiguredAudienceModelSummary {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ConfiguredAudienceModelSummary) SetCreateTime(v time.Time) *ConfiguredAudienceModelSummary {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ConfiguredAudienceModelSummary) SetDescription(v string) *ConfiguredAudienceModelSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConfiguredAudienceModelSummary) SetName(v string) *ConfiguredAudienceModelSummary {
	s.Name = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *ConfiguredAudienceModelSummary) SetOutputConfig(v *ConfiguredAudienceModelOutputConfig) *ConfiguredAudienceModelSummary {
	s.OutputConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ConfiguredAudienceModelSummary) SetStatus(v string) *ConfiguredAudienceModelSummary {
	s.Status = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ConfiguredAudienceModelSummary) SetUpdateTime(v time.Time) *ConfiguredAudienceModelSummary {
	s.UpdateTime = &v
	return s
}

// You can't complete this action because another resource depends on this resource.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAudienceModelInput struct {
	_ struct{} `type:"structure"`

	// The description of the audience model.
	Description *string `locationName:"description" type:"string"`

	// The Amazon Resource Name (ARN) of the KMS key. This key is used to encrypt
	// and decrypt customer-owned data in the trained ML model and the associated
	// data.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`

	// The name of the audience model resource.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The optional metadata that you apply to the resource to help you categorize
	// and organize them. Each tag consists of a key and an optional value, both
	// of which you define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50.
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8.
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8.
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for keys as it is reserved for AWS use. You cannot edit or
	//    delete tag keys with this prefix. Values can have this prefix. If a tag
	//    value has aws as its prefix but the key does not, then Clean Rooms ML
	//    considers it to be a user tag and will count against the limit of 50 tags.
	//    Tags with only the key prefix of aws do not count against your tags per
	//    resource limit.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The end date and time of the training window.
	TrainingDataEndTime *time.Time `locationName:"trainingDataEndTime" type:"timestamp" timestampFormat:"iso8601"`

	// The start date and time of the training window.
	TrainingDataStartTime *time.Time `locationName:"trainingDataStartTime" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Resource Name (ARN) of the training dataset for this audience
	// model.
	//
	// TrainingDatasetArn is a required field
	TrainingDatasetArn *string `locationName:"trainingDatasetArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAudienceModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAudienceModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAudienceModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAudienceModelInput"}
	if s.KmsKeyArn != nil && len(*s.KmsKeyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKeyArn", 20))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TrainingDatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingDatasetArn"))
	}
	if s.TrainingDatasetArn != nil && len(*s.TrainingDatasetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TrainingDatasetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateAudienceModelInput) SetDescription(v string) *CreateAudienceModelInput {
	s.Description = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateAudienceModelInput) SetKmsKeyArn(v string) *CreateAudienceModelInput {
	s.KmsKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAudienceModelInput) SetName(v string) *CreateAudienceModelInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAudienceModelInput) SetTags(v map[string]*string) *CreateAudienceModelInput {
	s.Tags = v
	return s
}

// SetTrainingDataEndTime sets the TrainingDataEndTime field's value.
func (s *CreateAudienceModelInput) SetTrainingDataEndTime(v time.Time) *CreateAudienceModelInput {
	s.TrainingDataEndTime = &v
	return s
}

// SetTrainingDataStartTime sets the TrainingDataStartTime field's value.
func (s *CreateAudienceModelInput) SetTrainingDataStartTime(v time.Time) *CreateAudienceModelInput {
	s.TrainingDataStartTime = &v
	return s
}

// SetTrainingDatasetArn sets the TrainingDatasetArn field's value.
func (s *CreateAudienceModelInput) SetTrainingDatasetArn(v string) *CreateAudienceModelInput {
	s.TrainingDatasetArn = &v
	return s
}

type CreateAudienceModelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the audience model.
	//
	// AudienceModelArn is a required field
	AudienceModelArn *string `locationName:"audienceModelArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAudienceModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAudienceModelOutput) GoString() string {
	return s.String()
}

// SetAudienceModelArn sets the AudienceModelArn field's value.
func (s *CreateAudienceModelOutput) SetAudienceModelArn(v string) *CreateAudienceModelOutput {
	s.AudienceModelArn = &v
	return s
}

type CreateConfiguredAudienceModelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the audience model to use for the configured
	// audience model.
	//
	// AudienceModelArn is a required field
	AudienceModelArn *string `locationName:"audienceModelArn" min:"20" type:"string" required:"true"`

	// Configure the list of output sizes of audiences that can be created using
	// this configured audience model. A request to StartAudienceGenerationJob that
	// uses this configured audience model must have an audienceSize selected from
	// this list. You can use the ABSOLUTE AudienceSize to configure out audience
	// sizes using the count of identifiers in the output. You can use the Percentage
	// AudienceSize to configure sizes in the range 1-100 percent.
	AudienceSizeConfig *AudienceSizeConfig `locationName:"audienceSizeConfig" type:"structure"`

	// Configure how the service tags audience generation jobs created using this
	// configured audience model. If you specify NONE, the tags from the StartAudienceGenerationJob
	// request determine the tags of the audience generation job. If you specify
	// FROM_PARENT_RESOURCE, the audience generation job inherits the tags from
	// the configured audience model, by default. Tags in the StartAudienceGenerationJob
	// will override the default.
	//
	// When the client is in a different account than the configured audience model,
	// the tags from the client are never applied to a resource in the caller's
	// account.
	ChildResourceTagOnCreatePolicy *string `locationName:"childResourceTagOnCreatePolicy" type:"string" enum:"TagOnCreatePolicy"`

	// The description of the configured audience model.
	Description *string `locationName:"description" type:"string"`

	// The minimum number of users from the seed audience that must match with users
	// in the training data of the audience model. The default value is 500.
	MinMatchingSeedSize *int64 `locationName:"minMatchingSeedSize" min:"25" type:"integer"`

	// The name of the configured audience model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Configure the Amazon S3 location and IAM Role for audiences created using
	// this configured audience model. Each audience will have a unique location.
	// The IAM Role must have s3:PutObject permission on the destination Amazon
	// S3 location. If the destination is protected with Amazon S3 KMS-SSE, then
	// the Role must also have the required KMS permissions.
	//
	// OutputConfig is a required field
	OutputConfig *ConfiguredAudienceModelOutputConfig `locationName:"outputConfig" type:"structure" required:"true"`

	// Whether audience metrics are shared.
	//
	// SharedAudienceMetrics is a required field
	SharedAudienceMetrics []*string `locationName:"sharedAudienceMetrics" min:"1" type:"list" required:"true" enum:"SharedAudienceMetrics"`

	// The optional metadata that you apply to the resource to help you categorize
	// and organize them. Each tag consists of a key and an optional value, both
	// of which you define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50.
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8.
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8.
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for keys as it is reserved for AWS use. You cannot edit or
	//    delete tag keys with this prefix. Values can have this prefix. If a tag
	//    value has aws as its prefix but the key does not, then Clean Rooms ML
	//    considers it to be a user tag and will count against the limit of 50 tags.
	//    Tags with only the key prefix of aws do not count against your tags per
	//    resource limit.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredAudienceModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredAudienceModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfiguredAudienceModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConfiguredAudienceModelInput"}
	if s.AudienceModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AudienceModelArn"))
	}
	if s.AudienceModelArn != nil && len(*s.AudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AudienceModelArn", 20))
	}
	if s.MinMatchingSeedSize != nil && *s.MinMatchingSeedSize < 25 {
		invalidParams.Add(request.NewErrParamMinValue("MinMatchingSeedSize", 25))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.OutputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputConfig"))
	}
	if s.SharedAudienceMetrics == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedAudienceMetrics"))
	}
	if s.SharedAudienceMetrics != nil && len(s.SharedAudienceMetrics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SharedAudienceMetrics", 1))
	}
	if s.AudienceSizeConfig != nil {
		if err := s.AudienceSizeConfig.Validate(); err != nil {
			invalidParams.AddNested("AudienceSizeConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudienceModelArn sets the AudienceModelArn field's value.
func (s *CreateConfiguredAudienceModelInput) SetAudienceModelArn(v string) *CreateConfiguredAudienceModelInput {
	s.AudienceModelArn = &v
	return s
}

// SetAudienceSizeConfig sets the AudienceSizeConfig field's value.
func (s *CreateConfiguredAudienceModelInput) SetAudienceSizeConfig(v *AudienceSizeConfig) *CreateConfiguredAudienceModelInput {
	s.AudienceSizeConfig = v
	return s
}

// SetChildResourceTagOnCreatePolicy sets the ChildResourceTagOnCreatePolicy field's value.
func (s *CreateConfiguredAudienceModelInput) SetChildResourceTagOnCreatePolicy(v string) *CreateConfiguredAudienceModelInput {
	s.ChildResourceTagOnCreatePolicy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateConfiguredAudienceModelInput) SetDescription(v string) *CreateConfiguredAudienceModelInput {
	s.Description = &v
	return s
}

// SetMinMatchingSeedSize sets the MinMatchingSeedSize field's value.
func (s *CreateConfiguredAudienceModelInput) SetMinMatchingSeedSize(v int64) *CreateConfiguredAudienceModelInput {
	s.MinMatchingSeedSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateConfiguredAudienceModelInput) SetName(v string) *CreateConfiguredAudienceModelInput {
	s.Name = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *CreateConfiguredAudienceModelInput) SetOutputConfig(v *ConfiguredAudienceModelOutputConfig) *CreateConfiguredAudienceModelInput {
	s.OutputConfig = v
	return s
}

// SetSharedAudienceMetrics sets the SharedAudienceMetrics field's value.
func (s *CreateConfiguredAudienceModelInput) SetSharedAudienceMetrics(v []*string) *CreateConfiguredAudienceModelInput {
	s.SharedAudienceMetrics = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConfiguredAudienceModelInput) SetTags(v map[string]*string) *CreateConfiguredAudienceModelInput {
	s.Tags = v
	return s
}

type CreateConfiguredAudienceModelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configured audience model.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredAudienceModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConfiguredAudienceModelOutput) GoString() string {
	return s.String()
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *CreateConfiguredAudienceModelOutput) SetConfiguredAudienceModelArn(v string) *CreateConfiguredAudienceModelOutput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

type CreateTrainingDatasetInput struct {
	_ struct{} `type:"structure"`

	// The description of the training dataset.
	Description *string `locationName:"description" type:"string"`

	// The name of the training dataset. This name must be unique in your account
	// and region.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Clean Rooms ML can assume to read the data referred
	// to in the dataSource field of each dataset.
	//
	// Passing a role across AWS accounts is not allowed. If you pass a role that
	// isn't in your account, you get an AccessDeniedException error.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The optional metadata that you apply to the resource to help you categorize
	// and organize them. Each tag consists of a key and an optional value, both
	// of which you define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50.
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8.
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8.
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for keys as it is reserved for AWS use. You cannot edit or
	//    delete tag keys with this prefix. Values can have this prefix. If a tag
	//    value has aws as its prefix but the key does not, then Clean Rooms ML
	//    considers it to be a user tag and will count against the limit of 50 tags.
	//    Tags with only the key prefix of aws do not count against your tags per
	//    resource limit.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// An array of information that lists the Dataset objects, which specifies the
	// dataset type and details on its location and schema. You must provide a role
	// that has read access to these tables.
	//
	// TrainingData is a required field
	TrainingData []*Dataset `locationName:"trainingData" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrainingDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrainingDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrainingDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrainingDatasetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.TrainingData == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingData"))
	}
	if s.TrainingData != nil && len(s.TrainingData) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TrainingData", 1))
	}
	if s.TrainingData != nil {
		for i, v := range s.TrainingData {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TrainingData", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateTrainingDatasetInput) SetDescription(v string) *CreateTrainingDatasetInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTrainingDatasetInput) SetName(v string) *CreateTrainingDatasetInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateTrainingDatasetInput) SetRoleArn(v string) *CreateTrainingDatasetInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTrainingDatasetInput) SetTags(v map[string]*string) *CreateTrainingDatasetInput {
	s.Tags = v
	return s
}

// SetTrainingData sets the TrainingData field's value.
func (s *CreateTrainingDatasetInput) SetTrainingData(v []*Dataset) *CreateTrainingDatasetInput {
	s.TrainingData = v
	return s
}

type CreateTrainingDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the training dataset resource.
	//
	// TrainingDatasetArn is a required field
	TrainingDatasetArn *string `locationName:"trainingDatasetArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrainingDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrainingDatasetOutput) GoString() string {
	return s.String()
}

// SetTrainingDatasetArn sets the TrainingDatasetArn field's value.
func (s *CreateTrainingDatasetOutput) SetTrainingDatasetArn(v string) *CreateTrainingDatasetOutput {
	s.TrainingDatasetArn = &v
	return s
}

// Defines information about the Glue data source that contains the training
// data.
type DataSource struct {
	_ struct{} `type:"structure"`

	// A GlueDataSource object that defines the catalog ID, database name, and table
	// name for the training data.
	//
	// GlueDataSource is a required field
	GlueDataSource *GlueDataSource `locationName:"glueDataSource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSource"}
	if s.GlueDataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("GlueDataSource"))
	}
	if s.GlueDataSource != nil {
		if err := s.GlueDataSource.Validate(); err != nil {
			invalidParams.AddNested("GlueDataSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGlueDataSource sets the GlueDataSource field's value.
func (s *DataSource) SetGlueDataSource(v *GlueDataSource) *DataSource {
	s.GlueDataSource = v
	return s
}

// Defines where the training dataset is located, what type of data it contains,
// and how to access the data.
type Dataset struct {
	_ struct{} `type:"structure"`

	// A DatasetInputConfig object that defines the data source and schema mapping.
	//
	// InputConfig is a required field
	InputConfig *DatasetInputConfig `locationName:"inputConfig" type:"structure" required:"true"`

	// What type of information is found in the dataset.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DatasetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dataset) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Dataset) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Dataset) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Dataset"}
	if s.InputConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("InputConfig"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.InputConfig != nil {
		if err := s.InputConfig.Validate(); err != nil {
			invalidParams.AddNested("InputConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInputConfig sets the InputConfig field's value.
func (s *Dataset) SetInputConfig(v *DatasetInputConfig) *Dataset {
	s.InputConfig = v
	return s
}

// SetType sets the Type field's value.
func (s *Dataset) SetType(v string) *Dataset {
	s.Type = &v
	return s
}

// Defines the Glue data source and schema mapping information.
type DatasetInputConfig struct {
	_ struct{} `type:"structure"`

	// A DataSource object that specifies the Glue data source for the training
	// data.
	//
	// DataSource is a required field
	DataSource *DataSource `locationName:"dataSource" type:"structure" required:"true"`

	// The schema information for the training data.
	//
	// Schema is a required field
	Schema []*ColumnSchema `locationName:"schema" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetInputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DatasetInputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DatasetInputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DatasetInputConfig"}
	if s.DataSource == nil {
		invalidParams.Add(request.NewErrParamRequired("DataSource"))
	}
	if s.Schema == nil {
		invalidParams.Add(request.NewErrParamRequired("Schema"))
	}
	if s.Schema != nil && len(s.Schema) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Schema", 1))
	}
	if s.DataSource != nil {
		if err := s.DataSource.Validate(); err != nil {
			invalidParams.AddNested("DataSource", err.(request.ErrInvalidParams))
		}
	}
	if s.Schema != nil {
		for i, v := range s.Schema {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Schema", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataSource sets the DataSource field's value.
func (s *DatasetInputConfig) SetDataSource(v *DataSource) *DatasetInputConfig {
	s.DataSource = v
	return s
}

// SetSchema sets the Schema field's value.
func (s *DatasetInputConfig) SetSchema(v []*ColumnSchema) *DatasetInputConfig {
	s.Schema = v
	return s
}

type DeleteAudienceGenerationJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the audience generation job that you want
	// to delete.
	//
	// AudienceGenerationJobArn is a required field
	AudienceGenerationJobArn *string `location:"uri" locationName:"audienceGenerationJobArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAudienceGenerationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAudienceGenerationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAudienceGenerationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAudienceGenerationJobInput"}
	if s.AudienceGenerationJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AudienceGenerationJobArn"))
	}
	if s.AudienceGenerationJobArn != nil && len(*s.AudienceGenerationJobArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AudienceGenerationJobArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudienceGenerationJobArn sets the AudienceGenerationJobArn field's value.
func (s *DeleteAudienceGenerationJobInput) SetAudienceGenerationJobArn(v string) *DeleteAudienceGenerationJobInput {
	s.AudienceGenerationJobArn = &v
	return s
}

type DeleteAudienceGenerationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAudienceGenerationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAudienceGenerationJobOutput) GoString() string {
	return s.String()
}

type DeleteAudienceModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the audience model that you want to delete.
	//
	// AudienceModelArn is a required field
	AudienceModelArn *string `location:"uri" locationName:"audienceModelArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAudienceModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAudienceModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAudienceModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAudienceModelInput"}
	if s.AudienceModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AudienceModelArn"))
	}
	if s.AudienceModelArn != nil && len(*s.AudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AudienceModelArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudienceModelArn sets the AudienceModelArn field's value.
func (s *DeleteAudienceModelInput) SetAudienceModelArn(v string) *DeleteAudienceModelInput {
	s.AudienceModelArn = &v
	return s
}

type DeleteAudienceModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAudienceModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAudienceModelOutput) GoString() string {
	return s.String()
}

type DeleteConfiguredAudienceModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the configured audience model that you
	// want to delete.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `location:"uri" locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredAudienceModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredAudienceModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfiguredAudienceModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfiguredAudienceModelInput"}
	if s.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if s.ConfiguredAudienceModelArn != nil && len(*s.ConfiguredAudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *DeleteConfiguredAudienceModelInput) SetConfiguredAudienceModelArn(v string) *DeleteConfiguredAudienceModelInput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

type DeleteConfiguredAudienceModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredAudienceModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredAudienceModelOutput) GoString() string {
	return s.String()
}

type DeleteConfiguredAudienceModelPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the configured audience model policy that
	// you want to delete.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `location:"uri" locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredAudienceModelPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredAudienceModelPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConfiguredAudienceModelPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConfiguredAudienceModelPolicyInput"}
	if s.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if s.ConfiguredAudienceModelArn != nil && len(*s.ConfiguredAudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *DeleteConfiguredAudienceModelPolicyInput) SetConfiguredAudienceModelArn(v string) *DeleteConfiguredAudienceModelPolicyInput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

type DeleteConfiguredAudienceModelPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredAudienceModelPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConfiguredAudienceModelPolicyOutput) GoString() string {
	return s.String()
}

type DeleteTrainingDatasetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the training dataset that you want to delete.
	//
	// TrainingDatasetArn is a required field
	TrainingDatasetArn *string `location:"uri" locationName:"trainingDatasetArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrainingDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrainingDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrainingDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrainingDatasetInput"}
	if s.TrainingDatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingDatasetArn"))
	}
	if s.TrainingDatasetArn != nil && len(*s.TrainingDatasetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TrainingDatasetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrainingDatasetArn sets the TrainingDatasetArn field's value.
func (s *DeleteTrainingDatasetInput) SetTrainingDatasetArn(v string) *DeleteTrainingDatasetInput {
	s.TrainingDatasetArn = &v
	return s
}

type DeleteTrainingDatasetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrainingDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrainingDatasetOutput) GoString() string {
	return s.String()
}

type GetAudienceGenerationJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the audience generation job that you are
	// interested in.
	//
	// AudienceGenerationJobArn is a required field
	AudienceGenerationJobArn *string `location:"uri" locationName:"audienceGenerationJobArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAudienceGenerationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAudienceGenerationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAudienceGenerationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAudienceGenerationJobInput"}
	if s.AudienceGenerationJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AudienceGenerationJobArn"))
	}
	if s.AudienceGenerationJobArn != nil && len(*s.AudienceGenerationJobArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AudienceGenerationJobArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudienceGenerationJobArn sets the AudienceGenerationJobArn field's value.
func (s *GetAudienceGenerationJobInput) SetAudienceGenerationJobArn(v string) *GetAudienceGenerationJobInput {
	s.AudienceGenerationJobArn = &v
	return s
}

type GetAudienceGenerationJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the audience generation job.
	//
	// AudienceGenerationJobArn is a required field
	AudienceGenerationJobArn *string `locationName:"audienceGenerationJobArn" min:"20" type:"string" required:"true"`

	// The identifier of the collaboration that this audience generation job is
	// associated with.
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string"`

	// The Amazon Resource Name (ARN) of the configured audience model used for
	// this audience generation job.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`

	// The time at which the audience generation job was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the audience generation job.
	Description *string `locationName:"description" type:"string"`

	// Configure whether the seed users are included in the output audience. By
	// default, Clean Rooms ML removes seed users from the output audience. If you
	// specify TRUE, the seed users will appear first in the output. Clean Rooms
	// ML does not explicitly reveal whether a user was in the seed, but the recipient
	// of the audience will know that the first minimumSeedSize count of users are
	// from the seed.
	IncludeSeedInOutput *bool `locationName:"includeSeedInOutput" type:"boolean"`

	// The relevance scores for different audience sizes and the recall score of
	// the generated audience.
	Metrics *AudienceQualityMetrics `locationName:"metrics" type:"structure"`

	// The name of the audience generation job.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The seed audience that was used for this audience generation job. This field
	// will be null if the account calling the API is the account that started this
	// audience generation job.
	SeedAudience *AudienceGenerationJobDataSource `locationName:"seedAudience" type:"structure"`

	// The AWS account that started this audience generation job.
	StartedBy *string `locationName:"startedBy" min:"12" type:"string"`

	// The status of the audience generation job.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AudienceGenerationJobStatus"`

	// Details about the status of the audience generation job.
	StatusDetails *StatusDetails `locationName:"statusDetails" type:"structure"`

	// The tags that are associated to this audience generation job.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The most recent time at which the audience generation job was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAudienceGenerationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAudienceGenerationJobOutput) GoString() string {
	return s.String()
}

// SetAudienceGenerationJobArn sets the AudienceGenerationJobArn field's value.
func (s *GetAudienceGenerationJobOutput) SetAudienceGenerationJobArn(v string) *GetAudienceGenerationJobOutput {
	s.AudienceGenerationJobArn = &v
	return s
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *GetAudienceGenerationJobOutput) SetCollaborationId(v string) *GetAudienceGenerationJobOutput {
	s.CollaborationId = &v
	return s
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *GetAudienceGenerationJobOutput) SetConfiguredAudienceModelArn(v string) *GetAudienceGenerationJobOutput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetAudienceGenerationJobOutput) SetCreateTime(v time.Time) *GetAudienceGenerationJobOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetAudienceGenerationJobOutput) SetDescription(v string) *GetAudienceGenerationJobOutput {
	s.Description = &v
	return s
}

// SetIncludeSeedInOutput sets the IncludeSeedInOutput field's value.
func (s *GetAudienceGenerationJobOutput) SetIncludeSeedInOutput(v bool) *GetAudienceGenerationJobOutput {
	s.IncludeSeedInOutput = &v
	return s
}

// SetMetrics sets the Metrics field's value.
func (s *GetAudienceGenerationJobOutput) SetMetrics(v *AudienceQualityMetrics) *GetAudienceGenerationJobOutput {
	s.Metrics = v
	return s
}

// SetName sets the Name field's value.
func (s *GetAudienceGenerationJobOutput) SetName(v string) *GetAudienceGenerationJobOutput {
	s.Name = &v
	return s
}

// SetSeedAudience sets the SeedAudience field's value.
func (s *GetAudienceGenerationJobOutput) SetSeedAudience(v *AudienceGenerationJobDataSource) *GetAudienceGenerationJobOutput {
	s.SeedAudience = v
	return s
}

// SetStartedBy sets the StartedBy field's value.
func (s *GetAudienceGenerationJobOutput) SetStartedBy(v string) *GetAudienceGenerationJobOutput {
	s.StartedBy = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetAudienceGenerationJobOutput) SetStatus(v string) *GetAudienceGenerationJobOutput {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *GetAudienceGenerationJobOutput) SetStatusDetails(v *StatusDetails) *GetAudienceGenerationJobOutput {
	s.StatusDetails = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetAudienceGenerationJobOutput) SetTags(v map[string]*string) *GetAudienceGenerationJobOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetAudienceGenerationJobOutput) SetUpdateTime(v time.Time) *GetAudienceGenerationJobOutput {
	s.UpdateTime = &v
	return s
}

type GetAudienceModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the audience model that you are interested
	// in.
	//
	// AudienceModelArn is a required field
	AudienceModelArn *string `location:"uri" locationName:"audienceModelArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAudienceModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAudienceModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAudienceModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAudienceModelInput"}
	if s.AudienceModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AudienceModelArn"))
	}
	if s.AudienceModelArn != nil && len(*s.AudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AudienceModelArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudienceModelArn sets the AudienceModelArn field's value.
func (s *GetAudienceModelInput) SetAudienceModelArn(v string) *GetAudienceModelInput {
	s.AudienceModelArn = &v
	return s
}

type GetAudienceModelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the audience model.
	//
	// AudienceModelArn is a required field
	AudienceModelArn *string `locationName:"audienceModelArn" min:"20" type:"string" required:"true"`

	// The time at which the audience model was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the audience model.
	Description *string `locationName:"description" type:"string"`

	// The KMS key ARN used for the audience model.
	KmsKeyArn *string `locationName:"kmsKeyArn" min:"20" type:"string"`

	// The name of the audience model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of the audience model.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"AudienceModelStatus"`

	// Details about the status of the audience model.
	StatusDetails *StatusDetails `locationName:"statusDetails" type:"structure"`

	// The tags that are assigned to the audience model.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The end date specified for the training window.
	TrainingDataEndTime *time.Time `locationName:"trainingDataEndTime" type:"timestamp" timestampFormat:"iso8601"`

	// The start date specified for the training window.
	TrainingDataStartTime *time.Time `locationName:"trainingDataStartTime" type:"timestamp" timestampFormat:"iso8601"`

	// The Amazon Resource Name (ARN) of the training dataset that was used for
	// this audience model.
	//
	// TrainingDatasetArn is a required field
	TrainingDatasetArn *string `locationName:"trainingDatasetArn" min:"20" type:"string" required:"true"`

	// The most recent time at which the audience model was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAudienceModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAudienceModelOutput) GoString() string {
	return s.String()
}

// SetAudienceModelArn sets the AudienceModelArn field's value.
func (s *GetAudienceModelOutput) SetAudienceModelArn(v string) *GetAudienceModelOutput {
	s.AudienceModelArn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetAudienceModelOutput) SetCreateTime(v time.Time) *GetAudienceModelOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetAudienceModelOutput) SetDescription(v string) *GetAudienceModelOutput {
	s.Description = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *GetAudienceModelOutput) SetKmsKeyArn(v string) *GetAudienceModelOutput {
	s.KmsKeyArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAudienceModelOutput) SetName(v string) *GetAudienceModelOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetAudienceModelOutput) SetStatus(v string) *GetAudienceModelOutput {
	s.Status = &v
	return s
}

// SetStatusDetails sets the StatusDetails field's value.
func (s *GetAudienceModelOutput) SetStatusDetails(v *StatusDetails) *GetAudienceModelOutput {
	s.StatusDetails = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetAudienceModelOutput) SetTags(v map[string]*string) *GetAudienceModelOutput {
	s.Tags = v
	return s
}

// SetTrainingDataEndTime sets the TrainingDataEndTime field's value.
func (s *GetAudienceModelOutput) SetTrainingDataEndTime(v time.Time) *GetAudienceModelOutput {
	s.TrainingDataEndTime = &v
	return s
}

// SetTrainingDataStartTime sets the TrainingDataStartTime field's value.
func (s *GetAudienceModelOutput) SetTrainingDataStartTime(v time.Time) *GetAudienceModelOutput {
	s.TrainingDataStartTime = &v
	return s
}

// SetTrainingDatasetArn sets the TrainingDatasetArn field's value.
func (s *GetAudienceModelOutput) SetTrainingDatasetArn(v string) *GetAudienceModelOutput {
	s.TrainingDatasetArn = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetAudienceModelOutput) SetUpdateTime(v time.Time) *GetAudienceModelOutput {
	s.UpdateTime = &v
	return s
}

type GetConfiguredAudienceModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the configured audience model that you
	// are interested in.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `location:"uri" locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredAudienceModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredAudienceModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfiguredAudienceModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfiguredAudienceModelInput"}
	if s.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if s.ConfiguredAudienceModelArn != nil && len(*s.ConfiguredAudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *GetConfiguredAudienceModelInput) SetConfiguredAudienceModelArn(v string) *GetConfiguredAudienceModelInput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

type GetConfiguredAudienceModelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the audience model used for this configured
	// audience model.
	//
	// AudienceModelArn is a required field
	AudienceModelArn *string `locationName:"audienceModelArn" min:"20" type:"string" required:"true"`

	// The list of output sizes of audiences that can be created using this configured
	// audience model. A request to StartAudienceGenerationJob that uses this configured
	// audience model must have an audienceSize selected from this list. You can
	// use the ABSOLUTE AudienceSize to configure out audience sizes using the count
	// of identifiers in the output. You can use the Percentage AudienceSize to
	// configure sizes in the range 1-100 percent.
	AudienceSizeConfig *AudienceSizeConfig `locationName:"audienceSizeConfig" type:"structure"`

	// Provides the childResourceTagOnCreatePolicy that was used for this configured
	// audience model.
	ChildResourceTagOnCreatePolicy *string `locationName:"childResourceTagOnCreatePolicy" type:"string" enum:"TagOnCreatePolicy"`

	// The Amazon Resource Name (ARN) of the configured audience model.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`

	// The time at which the configured audience model was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the configured audience model.
	Description *string `locationName:"description" type:"string"`

	// The minimum number of users from the seed audience that must match with users
	// in the training data of the audience model.
	MinMatchingSeedSize *int64 `locationName:"minMatchingSeedSize" min:"25" type:"integer"`

	// The name of the configured audience model.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The output configuration of the configured audience model
	//
	// OutputConfig is a required field
	OutputConfig *ConfiguredAudienceModelOutputConfig `locationName:"outputConfig" type:"structure" required:"true"`

	// Whether audience metrics are shared.
	//
	// SharedAudienceMetrics is a required field
	SharedAudienceMetrics []*string `locationName:"sharedAudienceMetrics" min:"1" type:"list" required:"true" enum:"SharedAudienceMetrics"`

	// The status of the configured audience model.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"ConfiguredAudienceModelStatus"`

	// The tags that are associated to this configured audience model.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The most recent time at which the configured audience model was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredAudienceModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredAudienceModelOutput) GoString() string {
	return s.String()
}

// SetAudienceModelArn sets the AudienceModelArn field's value.
func (s *GetConfiguredAudienceModelOutput) SetAudienceModelArn(v string) *GetConfiguredAudienceModelOutput {
	s.AudienceModelArn = &v
	return s
}

// SetAudienceSizeConfig sets the AudienceSizeConfig field's value.
func (s *GetConfiguredAudienceModelOutput) SetAudienceSizeConfig(v *AudienceSizeConfig) *GetConfiguredAudienceModelOutput {
	s.AudienceSizeConfig = v
	return s
}

// SetChildResourceTagOnCreatePolicy sets the ChildResourceTagOnCreatePolicy field's value.
func (s *GetConfiguredAudienceModelOutput) SetChildResourceTagOnCreatePolicy(v string) *GetConfiguredAudienceModelOutput {
	s.ChildResourceTagOnCreatePolicy = &v
	return s
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *GetConfiguredAudienceModelOutput) SetConfiguredAudienceModelArn(v string) *GetConfiguredAudienceModelOutput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetConfiguredAudienceModelOutput) SetCreateTime(v time.Time) *GetConfiguredAudienceModelOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetConfiguredAudienceModelOutput) SetDescription(v string) *GetConfiguredAudienceModelOutput {
	s.Description = &v
	return s
}

// SetMinMatchingSeedSize sets the MinMatchingSeedSize field's value.
func (s *GetConfiguredAudienceModelOutput) SetMinMatchingSeedSize(v int64) *GetConfiguredAudienceModelOutput {
	s.MinMatchingSeedSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetConfiguredAudienceModelOutput) SetName(v string) *GetConfiguredAudienceModelOutput {
	s.Name = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *GetConfiguredAudienceModelOutput) SetOutputConfig(v *ConfiguredAudienceModelOutputConfig) *GetConfiguredAudienceModelOutput {
	s.OutputConfig = v
	return s
}

// SetSharedAudienceMetrics sets the SharedAudienceMetrics field's value.
func (s *GetConfiguredAudienceModelOutput) SetSharedAudienceMetrics(v []*string) *GetConfiguredAudienceModelOutput {
	s.SharedAudienceMetrics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetConfiguredAudienceModelOutput) SetStatus(v string) *GetConfiguredAudienceModelOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetConfiguredAudienceModelOutput) SetTags(v map[string]*string) *GetConfiguredAudienceModelOutput {
	s.Tags = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetConfiguredAudienceModelOutput) SetUpdateTime(v time.Time) *GetConfiguredAudienceModelOutput {
	s.UpdateTime = &v
	return s
}

type GetConfiguredAudienceModelPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the configured audience model that you
	// are interested in.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `location:"uri" locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredAudienceModelPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredAudienceModelPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetConfiguredAudienceModelPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetConfiguredAudienceModelPolicyInput"}
	if s.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if s.ConfiguredAudienceModelArn != nil && len(*s.ConfiguredAudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *GetConfiguredAudienceModelPolicyInput) SetConfiguredAudienceModelArn(v string) *GetConfiguredAudienceModelPolicyInput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

type GetConfiguredAudienceModelPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configured audience model.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`

	// The configured audience model policy. This is a JSON IAM resource policy.
	//
	// ConfiguredAudienceModelPolicy is a required field
	ConfiguredAudienceModelPolicy *string `locationName:"configuredAudienceModelPolicy" min:"1" type:"string" required:"true"`

	// A cryptographic hash of the contents of the policy used to prevent unexpected
	// concurrent modification of the policy.
	//
	// PolicyHash is a required field
	PolicyHash *string `locationName:"policyHash" min:"64" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredAudienceModelPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetConfiguredAudienceModelPolicyOutput) GoString() string {
	return s.String()
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *GetConfiguredAudienceModelPolicyOutput) SetConfiguredAudienceModelArn(v string) *GetConfiguredAudienceModelPolicyOutput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetConfiguredAudienceModelPolicy sets the ConfiguredAudienceModelPolicy field's value.
func (s *GetConfiguredAudienceModelPolicyOutput) SetConfiguredAudienceModelPolicy(v string) *GetConfiguredAudienceModelPolicyOutput {
	s.ConfiguredAudienceModelPolicy = &v
	return s
}

// SetPolicyHash sets the PolicyHash field's value.
func (s *GetConfiguredAudienceModelPolicyOutput) SetPolicyHash(v string) *GetConfiguredAudienceModelPolicyOutput {
	s.PolicyHash = &v
	return s
}

type GetTrainingDatasetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the training dataset that you are interested
	// in.
	//
	// TrainingDatasetArn is a required field
	TrainingDatasetArn *string `location:"uri" locationName:"trainingDatasetArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrainingDatasetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrainingDatasetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTrainingDatasetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTrainingDatasetInput"}
	if s.TrainingDatasetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrainingDatasetArn"))
	}
	if s.TrainingDatasetArn != nil && len(*s.TrainingDatasetArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("TrainingDatasetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrainingDatasetArn sets the TrainingDatasetArn field's value.
func (s *GetTrainingDatasetInput) SetTrainingDatasetArn(v string) *GetTrainingDatasetInput {
	s.TrainingDatasetArn = &v
	return s
}

type GetTrainingDatasetOutput struct {
	_ struct{} `type:"structure"`

	// The time at which the training dataset was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the training dataset.
	Description *string `locationName:"description" type:"string"`

	// The name of the training dataset.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The IAM role used to read the training data.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" min:"20" type:"string" required:"true"`

	// The status of the training dataset.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TrainingDatasetStatus"`

	// The tags that are assigned to this training dataset.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Metadata about the requested training data.
	//
	// TrainingData is a required field
	TrainingData []*Dataset `locationName:"trainingData" type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the training dataset.
	//
	// TrainingDatasetArn is a required field
	TrainingDatasetArn *string `locationName:"trainingDatasetArn" min:"20" type:"string" required:"true"`

	// The most recent time at which the training dataset was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrainingDatasetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTrainingDatasetOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetTrainingDatasetOutput) SetCreateTime(v time.Time) *GetTrainingDatasetOutput {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetTrainingDatasetOutput) SetDescription(v string) *GetTrainingDatasetOutput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetTrainingDatasetOutput) SetName(v string) *GetTrainingDatasetOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetTrainingDatasetOutput) SetRoleArn(v string) *GetTrainingDatasetOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetTrainingDatasetOutput) SetStatus(v string) *GetTrainingDatasetOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetTrainingDatasetOutput) SetTags(v map[string]*string) *GetTrainingDatasetOutput {
	s.Tags = v
	return s
}

// SetTrainingData sets the TrainingData field's value.
func (s *GetTrainingDatasetOutput) SetTrainingData(v []*Dataset) *GetTrainingDatasetOutput {
	s.TrainingData = v
	return s
}

// SetTrainingDatasetArn sets the TrainingDatasetArn field's value.
func (s *GetTrainingDatasetOutput) SetTrainingDatasetArn(v string) *GetTrainingDatasetOutput {
	s.TrainingDatasetArn = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetTrainingDatasetOutput) SetUpdateTime(v time.Time) *GetTrainingDatasetOutput {
	s.UpdateTime = &v
	return s
}

// Defines the Glue data source that contains the training data.
type GlueDataSource struct {
	_ struct{} `type:"structure"`

	// The Glue catalog that contains the training data.
	CatalogId *string `locationName:"catalogId" min:"12" type:"string"`

	// The Glue database that contains the training data.
	//
	// DatabaseName is a required field
	DatabaseName *string `locationName:"databaseName" min:"1" type:"string" required:"true"`

	// The Glue table that contains the training data.
	//
	// TableName is a required field
	TableName *string `locationName:"tableName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlueDataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GlueDataSource) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GlueDataSource) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GlueDataSource"}
	if s.CatalogId != nil && len(*s.CatalogId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 12))
	}
	if s.DatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *GlueDataSource) SetCatalogId(v string) *GlueDataSource {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *GlueDataSource) SetDatabaseName(v string) *GlueDataSource {
	s.DatabaseName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *GlueDataSource) SetTableName(v string) *GlueDataSource {
	s.TableName = &v
	return s
}

type ListAudienceExportJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the audience generation job that you are
	// interested in.
	AudienceGenerationJobArn *string `location:"querystring" locationName:"audienceGenerationJobArn" min:"20" type:"string"`

	// The maximum size of the results that is returned per call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAudienceExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAudienceExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAudienceExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAudienceExportJobsInput"}
	if s.AudienceGenerationJobArn != nil && len(*s.AudienceGenerationJobArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AudienceGenerationJobArn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudienceGenerationJobArn sets the AudienceGenerationJobArn field's value.
func (s *ListAudienceExportJobsInput) SetAudienceGenerationJobArn(v string) *ListAudienceExportJobsInput {
	s.AudienceGenerationJobArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAudienceExportJobsInput) SetMaxResults(v int64) *ListAudienceExportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAudienceExportJobsInput) SetNextToken(v string) *ListAudienceExportJobsInput {
	s.NextToken = &v
	return s
}

type ListAudienceExportJobsOutput struct {
	_ struct{} `type:"structure"`

	// The audience export jobs that match the request.
	//
	// AudienceExportJobs is a required field
	AudienceExportJobs []*AudienceExportJobSummary `locationName:"audienceExportJobs" type:"list" required:"true"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAudienceExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAudienceExportJobsOutput) GoString() string {
	return s.String()
}

// SetAudienceExportJobs sets the AudienceExportJobs field's value.
func (s *ListAudienceExportJobsOutput) SetAudienceExportJobs(v []*AudienceExportJobSummary) *ListAudienceExportJobsOutput {
	s.AudienceExportJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAudienceExportJobsOutput) SetNextToken(v string) *ListAudienceExportJobsOutput {
	s.NextToken = &v
	return s
}

type ListAudienceGenerationJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the collaboration that contains the audience generation
	// jobs that you are interested in.
	CollaborationId *string `location:"querystring" locationName:"collaborationId" min:"36" type:"string"`

	// The Amazon Resource Name (ARN) of the configured audience model that was
	// used for the audience generation jobs that you are interested in.
	ConfiguredAudienceModelArn *string `location:"querystring" locationName:"configuredAudienceModelArn" min:"20" type:"string"`

	// The maximum size of the results that is returned per call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAudienceGenerationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAudienceGenerationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAudienceGenerationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAudienceGenerationJobsInput"}
	if s.CollaborationId != nil && len(*s.CollaborationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationId", 36))
	}
	if s.ConfiguredAudienceModelArn != nil && len(*s.ConfiguredAudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelArn", 20))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *ListAudienceGenerationJobsInput) SetCollaborationId(v string) *ListAudienceGenerationJobsInput {
	s.CollaborationId = &v
	return s
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *ListAudienceGenerationJobsInput) SetConfiguredAudienceModelArn(v string) *ListAudienceGenerationJobsInput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAudienceGenerationJobsInput) SetMaxResults(v int64) *ListAudienceGenerationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAudienceGenerationJobsInput) SetNextToken(v string) *ListAudienceGenerationJobsInput {
	s.NextToken = &v
	return s
}

type ListAudienceGenerationJobsOutput struct {
	_ struct{} `type:"structure"`

	// The audience generation jobs that match the request.
	//
	// AudienceGenerationJobs is a required field
	AudienceGenerationJobs []*AudienceGenerationJobSummary `locationName:"audienceGenerationJobs" type:"list" required:"true"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAudienceGenerationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAudienceGenerationJobsOutput) GoString() string {
	return s.String()
}

// SetAudienceGenerationJobs sets the AudienceGenerationJobs field's value.
func (s *ListAudienceGenerationJobsOutput) SetAudienceGenerationJobs(v []*AudienceGenerationJobSummary) *ListAudienceGenerationJobsOutput {
	s.AudienceGenerationJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAudienceGenerationJobsOutput) SetNextToken(v string) *ListAudienceGenerationJobsOutput {
	s.NextToken = &v
	return s
}

type ListAudienceModelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum size of the results that is returned per call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAudienceModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAudienceModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAudienceModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAudienceModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAudienceModelsInput) SetMaxResults(v int64) *ListAudienceModelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAudienceModelsInput) SetNextToken(v string) *ListAudienceModelsInput {
	s.NextToken = &v
	return s
}

type ListAudienceModelsOutput struct {
	_ struct{} `type:"structure"`

	// The audience models that match the request.
	//
	// AudienceModels is a required field
	AudienceModels []*AudienceModelSummary `locationName:"audienceModels" type:"list" required:"true"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAudienceModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAudienceModelsOutput) GoString() string {
	return s.String()
}

// SetAudienceModels sets the AudienceModels field's value.
func (s *ListAudienceModelsOutput) SetAudienceModels(v []*AudienceModelSummary) *ListAudienceModelsOutput {
	s.AudienceModels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAudienceModelsOutput) SetNextToken(v string) *ListAudienceModelsOutput {
	s.NextToken = &v
	return s
}

type ListConfiguredAudienceModelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum size of the results that is returned per call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredAudienceModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredAudienceModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListConfiguredAudienceModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListConfiguredAudienceModelsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListConfiguredAudienceModelsInput) SetMaxResults(v int64) *ListConfiguredAudienceModelsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfiguredAudienceModelsInput) SetNextToken(v string) *ListConfiguredAudienceModelsInput {
	s.NextToken = &v
	return s
}

type ListConfiguredAudienceModelsOutput struct {
	_ struct{} `type:"structure"`

	// The configured audience models.
	//
	// ConfiguredAudienceModels is a required field
	ConfiguredAudienceModels []*ConfiguredAudienceModelSummary `locationName:"configuredAudienceModels" type:"list" required:"true"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredAudienceModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListConfiguredAudienceModelsOutput) GoString() string {
	return s.String()
}

// SetConfiguredAudienceModels sets the ConfiguredAudienceModels field's value.
func (s *ListConfiguredAudienceModelsOutput) SetConfiguredAudienceModels(v []*ConfiguredAudienceModelSummary) *ListConfiguredAudienceModelsOutput {
	s.ConfiguredAudienceModels = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListConfiguredAudienceModelsOutput) SetNextToken(v string) *ListConfiguredAudienceModelsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource that you are interested in.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags that are associated with the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTrainingDatasetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum size of the results that is returned per call.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrainingDatasetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrainingDatasetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrainingDatasetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrainingDatasetsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTrainingDatasetsInput) SetMaxResults(v int64) *ListTrainingDatasetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrainingDatasetsInput) SetNextToken(v string) *ListTrainingDatasetsInput {
	s.NextToken = &v
	return s
}

type ListTrainingDatasetsOutput struct {
	_ struct{} `type:"structure"`

	// The token value retrieved from a previous call to access the next page of
	// results.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The training datasets that match the request.
	//
	// TrainingDatasets is a required field
	TrainingDatasets []*TrainingDatasetSummary `locationName:"trainingDatasets" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrainingDatasetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrainingDatasetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrainingDatasetsOutput) SetNextToken(v string) *ListTrainingDatasetsOutput {
	s.NextToken = &v
	return s
}

// SetTrainingDatasets sets the TrainingDatasets field's value.
func (s *ListTrainingDatasetsOutput) SetTrainingDatasets(v []*TrainingDatasetSummary) *ListTrainingDatasetsOutput {
	s.TrainingDatasets = v
	return s
}

type PutConfiguredAudienceModelPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configured audience model that the
	// resource policy will govern.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `location:"uri" locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`

	// The IAM resource policy.
	//
	// ConfiguredAudienceModelPolicy is a required field
	ConfiguredAudienceModelPolicy *string `locationName:"configuredAudienceModelPolicy" min:"1" type:"string" required:"true"`

	// Use this to prevent unexpected concurrent modification of the policy.
	PolicyExistenceCondition *string `locationName:"policyExistenceCondition" type:"string" enum:"PolicyExistenceCondition"`

	// A cryptographic hash of the contents of the policy used to prevent unexpected
	// concurrent modification of the policy.
	PreviousPolicyHash *string `locationName:"previousPolicyHash" min:"64" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutConfiguredAudienceModelPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutConfiguredAudienceModelPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfiguredAudienceModelPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutConfiguredAudienceModelPolicyInput"}
	if s.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if s.ConfiguredAudienceModelArn != nil && len(*s.ConfiguredAudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelArn", 20))
	}
	if s.ConfiguredAudienceModelPolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelPolicy"))
	}
	if s.ConfiguredAudienceModelPolicy != nil && len(*s.ConfiguredAudienceModelPolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelPolicy", 1))
	}
	if s.PreviousPolicyHash != nil && len(*s.PreviousPolicyHash) < 64 {
		invalidParams.Add(request.NewErrParamMinLen("PreviousPolicyHash", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *PutConfiguredAudienceModelPolicyInput) SetConfiguredAudienceModelArn(v string) *PutConfiguredAudienceModelPolicyInput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetConfiguredAudienceModelPolicy sets the ConfiguredAudienceModelPolicy field's value.
func (s *PutConfiguredAudienceModelPolicyInput) SetConfiguredAudienceModelPolicy(v string) *PutConfiguredAudienceModelPolicyInput {
	s.ConfiguredAudienceModelPolicy = &v
	return s
}

// SetPolicyExistenceCondition sets the PolicyExistenceCondition field's value.
func (s *PutConfiguredAudienceModelPolicyInput) SetPolicyExistenceCondition(v string) *PutConfiguredAudienceModelPolicyInput {
	s.PolicyExistenceCondition = &v
	return s
}

// SetPreviousPolicyHash sets the PreviousPolicyHash field's value.
func (s *PutConfiguredAudienceModelPolicyInput) SetPreviousPolicyHash(v string) *PutConfiguredAudienceModelPolicyInput {
	s.PreviousPolicyHash = &v
	return s
}

type PutConfiguredAudienceModelPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The IAM resource policy.
	//
	// ConfiguredAudienceModelPolicy is a required field
	ConfiguredAudienceModelPolicy *string `locationName:"configuredAudienceModelPolicy" min:"1" type:"string" required:"true"`

	// A cryptographic hash of the contents of the policy used to prevent unexpected
	// concurrent modification of the policy.
	//
	// PolicyHash is a required field
	PolicyHash *string `locationName:"policyHash" min:"64" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutConfiguredAudienceModelPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutConfiguredAudienceModelPolicyOutput) GoString() string {
	return s.String()
}

// SetConfiguredAudienceModelPolicy sets the ConfiguredAudienceModelPolicy field's value.
func (s *PutConfiguredAudienceModelPolicyOutput) SetConfiguredAudienceModelPolicy(v string) *PutConfiguredAudienceModelPolicyOutput {
	s.ConfiguredAudienceModelPolicy = &v
	return s
}

// SetPolicyHash sets the PolicyHash field's value.
func (s *PutConfiguredAudienceModelPolicyOutput) SetPolicyHash(v string) *PutConfiguredAudienceModelPolicyOutput {
	s.PolicyHash = &v
	return s
}

// The relevance score of a generated audience.
type RelevanceMetric struct {
	_ struct{} `type:"structure"`

	// The size of the generated audience. Must match one of the sizes in the configured
	// audience model.
	//
	// AudienceSize is a required field
	AudienceSize *AudienceSize `locationName:"audienceSize" type:"structure" required:"true"`

	// The relevance score of the generated audience.
	Score *float64 `locationName:"score" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelevanceMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RelevanceMetric) GoString() string {
	return s.String()
}

// SetAudienceSize sets the AudienceSize field's value.
func (s *RelevanceMetric) SetAudienceSize(v *AudienceSize) *RelevanceMetric {
	s.AudienceSize = v
	return s
}

// SetScore sets the Score field's value.
func (s *RelevanceMetric) SetScore(v float64) *RelevanceMetric {
	s.Score = &v
	return s
}

// The resource you are requesting does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about an Amazon S3 bucket and path.
type S3ConfigMap struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 location URI.
	//
	// S3Uri is a required field
	S3Uri *string `locationName:"s3Uri" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ConfigMap) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3ConfigMap) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ConfigMap) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3ConfigMap"}
	if s.S3Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Uri"))
	}
	if s.S3Uri != nil && len(*s.S3Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Uri sets the S3Uri field's value.
func (s *S3ConfigMap) SetS3Uri(v string) *S3ConfigMap {
	s.S3Uri = &v
	return s
}

// You have exceeded your service quota.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartAudienceExportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the audience generation job that you want
	// to export.
	//
	// AudienceGenerationJobArn is a required field
	AudienceGenerationJobArn *string `locationName:"audienceGenerationJobArn" min:"20" type:"string" required:"true"`

	// The size of the generated audience. Must match one of the sizes in the configured
	// audience model.
	//
	// AudienceSize is a required field
	AudienceSize *AudienceSize `locationName:"audienceSize" type:"structure" required:"true"`

	// The description of the audience export job.
	Description *string `locationName:"description" type:"string"`

	// The name of the audience export job.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAudienceExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAudienceExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartAudienceExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartAudienceExportJobInput"}
	if s.AudienceGenerationJobArn == nil {
		invalidParams.Add(request.NewErrParamRequired("AudienceGenerationJobArn"))
	}
	if s.AudienceGenerationJobArn != nil && len(*s.AudienceGenerationJobArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AudienceGenerationJobArn", 20))
	}
	if s.AudienceSize == nil {
		invalidParams.Add(request.NewErrParamRequired("AudienceSize"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.AudienceSize != nil {
		if err := s.AudienceSize.Validate(); err != nil {
			invalidParams.AddNested("AudienceSize", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudienceGenerationJobArn sets the AudienceGenerationJobArn field's value.
func (s *StartAudienceExportJobInput) SetAudienceGenerationJobArn(v string) *StartAudienceExportJobInput {
	s.AudienceGenerationJobArn = &v
	return s
}

// SetAudienceSize sets the AudienceSize field's value.
func (s *StartAudienceExportJobInput) SetAudienceSize(v *AudienceSize) *StartAudienceExportJobInput {
	s.AudienceSize = v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartAudienceExportJobInput) SetDescription(v string) *StartAudienceExportJobInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartAudienceExportJobInput) SetName(v string) *StartAudienceExportJobInput {
	s.Name = &v
	return s
}

type StartAudienceExportJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAudienceExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAudienceExportJobOutput) GoString() string {
	return s.String()
}

type StartAudienceGenerationJobInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the collaboration that contains the audience generation
	// job.
	CollaborationId *string `locationName:"collaborationId" min:"36" type:"string"`

	// The Amazon Resource Name (ARN) of the configured audience model that is used
	// for this audience generation job.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`

	// The description of the audience generation job.
	Description *string `locationName:"description" type:"string"`

	// Whether the seed audience is included in the audience generation output.
	IncludeSeedInOutput *bool `locationName:"includeSeedInOutput" type:"boolean"`

	// The name of the audience generation job.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The seed audience that is used to generate the audience.
	//
	// SeedAudience is a required field
	SeedAudience *AudienceGenerationJobDataSource `locationName:"seedAudience" type:"structure" required:"true"`

	// The optional metadata that you apply to the resource to help you categorize
	// and organize them. Each tag consists of a key and an optional value, both
	// of which you define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50.
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8.
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8.
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for keys as it is reserved for AWS use. You cannot edit or
	//    delete tag keys with this prefix. Values can have this prefix. If a tag
	//    value has aws as its prefix but the key does not, then Clean Rooms ML
	//    considers it to be a user tag and will count against the limit of 50 tags.
	//    Tags with only the key prefix of aws do not count against your tags per
	//    resource limit.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAudienceGenerationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAudienceGenerationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartAudienceGenerationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartAudienceGenerationJobInput"}
	if s.CollaborationId != nil && len(*s.CollaborationId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CollaborationId", 36))
	}
	if s.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if s.ConfiguredAudienceModelArn != nil && len(*s.ConfiguredAudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelArn", 20))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SeedAudience == nil {
		invalidParams.Add(request.NewErrParamRequired("SeedAudience"))
	}
	if s.SeedAudience != nil {
		if err := s.SeedAudience.Validate(); err != nil {
			invalidParams.AddNested("SeedAudience", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCollaborationId sets the CollaborationId field's value.
func (s *StartAudienceGenerationJobInput) SetCollaborationId(v string) *StartAudienceGenerationJobInput {
	s.CollaborationId = &v
	return s
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *StartAudienceGenerationJobInput) SetConfiguredAudienceModelArn(v string) *StartAudienceGenerationJobInput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *StartAudienceGenerationJobInput) SetDescription(v string) *StartAudienceGenerationJobInput {
	s.Description = &v
	return s
}

// SetIncludeSeedInOutput sets the IncludeSeedInOutput field's value.
func (s *StartAudienceGenerationJobInput) SetIncludeSeedInOutput(v bool) *StartAudienceGenerationJobInput {
	s.IncludeSeedInOutput = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartAudienceGenerationJobInput) SetName(v string) *StartAudienceGenerationJobInput {
	s.Name = &v
	return s
}

// SetSeedAudience sets the SeedAudience field's value.
func (s *StartAudienceGenerationJobInput) SetSeedAudience(v *AudienceGenerationJobDataSource) *StartAudienceGenerationJobInput {
	s.SeedAudience = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartAudienceGenerationJobInput) SetTags(v map[string]*string) *StartAudienceGenerationJobInput {
	s.Tags = v
	return s
}

type StartAudienceGenerationJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the audience generation job.
	//
	// AudienceGenerationJobArn is a required field
	AudienceGenerationJobArn *string `locationName:"audienceGenerationJobArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAudienceGenerationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartAudienceGenerationJobOutput) GoString() string {
	return s.String()
}

// SetAudienceGenerationJobArn sets the AudienceGenerationJobArn field's value.
func (s *StartAudienceGenerationJobOutput) SetAudienceGenerationJobArn(v string) *StartAudienceGenerationJobOutput {
	s.AudienceGenerationJobArn = &v
	return s
}

// Details about the status of a resource.
type StatusDetails struct {
	_ struct{} `type:"structure"`

	// The error message that was returned. The message is intended for human consumption
	// and can change at any time. Use the statusCode for programmatic error handling.
	Message *string `locationName:"message" type:"string"`

	// The status code that was returned. The status code is intended for programmatic
	// error handling. Clean Rooms ML will not change the status code for existing
	// error conditions.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatusDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StatusDetails) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *StatusDetails) SetMessage(v string) *StatusDetails {
	s.Message = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *StatusDetails) SetStatusCode(v string) *StatusDetails {
	s.StatusCode = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to assign tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The optional metadata that you apply to the resource to help you categorize
	// and organize them. Each tag consists of a key and an optional value, both
	// of which you define.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource - 50.
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length - 128 Unicode characters in UTF-8.
	//
	//    * Maximum value length - 256 Unicode characters in UTF-8.
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for keys as it is reserved for AWS use. You cannot edit or
	//    delete tag keys with this prefix. Values can have this prefix. If a tag
	//    value has aws as its prefix but the key does not, then Clean Rooms considers
	//    it to be a user tag and will count against the limit of 50 tags. Tags
	//    with only the key prefix of aws do not count against your tags per resource
	//    limit.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Provides information about the training dataset.
type TrainingDatasetSummary struct {
	_ struct{} `type:"structure"`

	// The time at which the training dataset was created.
	//
	// CreateTime is a required field
	CreateTime *time.Time `locationName:"createTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The description of the training dataset.
	Description *string `locationName:"description" type:"string"`

	// The name of the training dataset.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The status of the training dataset.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"TrainingDatasetStatus"`

	// The Amazon Resource Name (ARN) of the training dataset.
	//
	// TrainingDatasetArn is a required field
	TrainingDatasetArn *string `locationName:"trainingDatasetArn" min:"20" type:"string" required:"true"`

	// The most recent time at which the training dataset was updated.
	//
	// UpdateTime is a required field
	UpdateTime *time.Time `locationName:"updateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingDatasetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrainingDatasetSummary) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *TrainingDatasetSummary) SetCreateTime(v time.Time) *TrainingDatasetSummary {
	s.CreateTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *TrainingDatasetSummary) SetDescription(v string) *TrainingDatasetSummary {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *TrainingDatasetSummary) SetName(v string) *TrainingDatasetSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TrainingDatasetSummary) SetStatus(v string) *TrainingDatasetSummary {
	s.Status = &v
	return s
}

// SetTrainingDatasetArn sets the TrainingDatasetArn field's value.
func (s *TrainingDatasetSummary) SetTrainingDatasetArn(v string) *TrainingDatasetSummary {
	s.TrainingDatasetArn = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *TrainingDatasetSummary) SetUpdateTime(v time.Time) *TrainingDatasetSummary {
	s.UpdateTime = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource that you want to remove tags
	// from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The key values of tags that you want to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateConfiguredAudienceModelInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new audience model that you want to
	// use.
	AudienceModelArn *string `locationName:"audienceModelArn" min:"20" type:"string"`

	// The new audience size configuration.
	AudienceSizeConfig *AudienceSizeConfig `locationName:"audienceSizeConfig" type:"structure"`

	// The Amazon Resource Name (ARN) of the configured audience model that you
	// want to update.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `location:"uri" locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`

	// The new description of the configured audience model.
	Description *string `locationName:"description" type:"string"`

	// The minimum number of users from the seed audience that must match with users
	// in the training data of the audience model.
	MinMatchingSeedSize *int64 `locationName:"minMatchingSeedSize" min:"25" type:"integer"`

	// The new output configuration.
	OutputConfig *ConfiguredAudienceModelOutputConfig `locationName:"outputConfig" type:"structure"`

	// The new value for whether to share audience metrics.
	SharedAudienceMetrics []*string `locationName:"sharedAudienceMetrics" min:"1" type:"list" enum:"SharedAudienceMetrics"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredAudienceModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredAudienceModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConfiguredAudienceModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConfiguredAudienceModelInput"}
	if s.AudienceModelArn != nil && len(*s.AudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("AudienceModelArn", 20))
	}
	if s.ConfiguredAudienceModelArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ConfiguredAudienceModelArn"))
	}
	if s.ConfiguredAudienceModelArn != nil && len(*s.ConfiguredAudienceModelArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ConfiguredAudienceModelArn", 20))
	}
	if s.MinMatchingSeedSize != nil && *s.MinMatchingSeedSize < 25 {
		invalidParams.Add(request.NewErrParamMinValue("MinMatchingSeedSize", 25))
	}
	if s.SharedAudienceMetrics != nil && len(s.SharedAudienceMetrics) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SharedAudienceMetrics", 1))
	}
	if s.AudienceSizeConfig != nil {
		if err := s.AudienceSizeConfig.Validate(); err != nil {
			invalidParams.AddNested("AudienceSizeConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudienceModelArn sets the AudienceModelArn field's value.
func (s *UpdateConfiguredAudienceModelInput) SetAudienceModelArn(v string) *UpdateConfiguredAudienceModelInput {
	s.AudienceModelArn = &v
	return s
}

// SetAudienceSizeConfig sets the AudienceSizeConfig field's value.
func (s *UpdateConfiguredAudienceModelInput) SetAudienceSizeConfig(v *AudienceSizeConfig) *UpdateConfiguredAudienceModelInput {
	s.AudienceSizeConfig = v
	return s
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *UpdateConfiguredAudienceModelInput) SetConfiguredAudienceModelArn(v string) *UpdateConfiguredAudienceModelInput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateConfiguredAudienceModelInput) SetDescription(v string) *UpdateConfiguredAudienceModelInput {
	s.Description = &v
	return s
}

// SetMinMatchingSeedSize sets the MinMatchingSeedSize field's value.
func (s *UpdateConfiguredAudienceModelInput) SetMinMatchingSeedSize(v int64) *UpdateConfiguredAudienceModelInput {
	s.MinMatchingSeedSize = &v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *UpdateConfiguredAudienceModelInput) SetOutputConfig(v *ConfiguredAudienceModelOutputConfig) *UpdateConfiguredAudienceModelInput {
	s.OutputConfig = v
	return s
}

// SetSharedAudienceMetrics sets the SharedAudienceMetrics field's value.
func (s *UpdateConfiguredAudienceModelInput) SetSharedAudienceMetrics(v []*string) *UpdateConfiguredAudienceModelInput {
	s.SharedAudienceMetrics = v
	return s
}

type UpdateConfiguredAudienceModelOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configured audience model that was
	// updated.
	//
	// ConfiguredAudienceModelArn is a required field
	ConfiguredAudienceModelArn *string `locationName:"configuredAudienceModelArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredAudienceModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConfiguredAudienceModelOutput) GoString() string {
	return s.String()
}

// SetConfiguredAudienceModelArn sets the ConfiguredAudienceModelArn field's value.
func (s *UpdateConfiguredAudienceModelOutput) SetConfiguredAudienceModelArn(v string) *UpdateConfiguredAudienceModelOutput {
	s.ConfiguredAudienceModelArn = &v
	return s
}

// The request parameters for this request are incorrect.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AudienceExportJobStatusCreatePending is a AudienceExportJobStatus enum value
	AudienceExportJobStatusCreatePending = "CREATE_PENDING"

	// AudienceExportJobStatusCreateInProgress is a AudienceExportJobStatus enum value
	AudienceExportJobStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// AudienceExportJobStatusCreateFailed is a AudienceExportJobStatus enum value
	AudienceExportJobStatusCreateFailed = "CREATE_FAILED"

	// AudienceExportJobStatusActive is a AudienceExportJobStatus enum value
	AudienceExportJobStatusActive = "ACTIVE"
)

// AudienceExportJobStatus_Values returns all elements of the AudienceExportJobStatus enum
func AudienceExportJobStatus_Values() []string {
	return []string{
		AudienceExportJobStatusCreatePending,
		AudienceExportJobStatusCreateInProgress,
		AudienceExportJobStatusCreateFailed,
		AudienceExportJobStatusActive,
	}
}

const (
	// AudienceGenerationJobStatusCreatePending is a AudienceGenerationJobStatus enum value
	AudienceGenerationJobStatusCreatePending = "CREATE_PENDING"

	// AudienceGenerationJobStatusCreateInProgress is a AudienceGenerationJobStatus enum value
	AudienceGenerationJobStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// AudienceGenerationJobStatusCreateFailed is a AudienceGenerationJobStatus enum value
	AudienceGenerationJobStatusCreateFailed = "CREATE_FAILED"

	// AudienceGenerationJobStatusActive is a AudienceGenerationJobStatus enum value
	AudienceGenerationJobStatusActive = "ACTIVE"

	// AudienceGenerationJobStatusDeletePending is a AudienceGenerationJobStatus enum value
	AudienceGenerationJobStatusDeletePending = "DELETE_PENDING"

	// AudienceGenerationJobStatusDeleteInProgress is a AudienceGenerationJobStatus enum value
	AudienceGenerationJobStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// AudienceGenerationJobStatusDeleteFailed is a AudienceGenerationJobStatus enum value
	AudienceGenerationJobStatusDeleteFailed = "DELETE_FAILED"
)

// AudienceGenerationJobStatus_Values returns all elements of the AudienceGenerationJobStatus enum
func AudienceGenerationJobStatus_Values() []string {
	return []string{
		AudienceGenerationJobStatusCreatePending,
		AudienceGenerationJobStatusCreateInProgress,
		AudienceGenerationJobStatusCreateFailed,
		AudienceGenerationJobStatusActive,
		AudienceGenerationJobStatusDeletePending,
		AudienceGenerationJobStatusDeleteInProgress,
		AudienceGenerationJobStatusDeleteFailed,
	}
}

const (
	// AudienceModelStatusCreatePending is a AudienceModelStatus enum value
	AudienceModelStatusCreatePending = "CREATE_PENDING"

	// AudienceModelStatusCreateInProgress is a AudienceModelStatus enum value
	AudienceModelStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// AudienceModelStatusCreateFailed is a AudienceModelStatus enum value
	AudienceModelStatusCreateFailed = "CREATE_FAILED"

	// AudienceModelStatusActive is a AudienceModelStatus enum value
	AudienceModelStatusActive = "ACTIVE"

	// AudienceModelStatusDeletePending is a AudienceModelStatus enum value
	AudienceModelStatusDeletePending = "DELETE_PENDING"

	// AudienceModelStatusDeleteInProgress is a AudienceModelStatus enum value
	AudienceModelStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// AudienceModelStatusDeleteFailed is a AudienceModelStatus enum value
	AudienceModelStatusDeleteFailed = "DELETE_FAILED"
)

// AudienceModelStatus_Values returns all elements of the AudienceModelStatus enum
func AudienceModelStatus_Values() []string {
	return []string{
		AudienceModelStatusCreatePending,
		AudienceModelStatusCreateInProgress,
		AudienceModelStatusCreateFailed,
		AudienceModelStatusActive,
		AudienceModelStatusDeletePending,
		AudienceModelStatusDeleteInProgress,
		AudienceModelStatusDeleteFailed,
	}
}

const (
	// AudienceSizeTypeAbsolute is a AudienceSizeType enum value
	AudienceSizeTypeAbsolute = "ABSOLUTE"

	// AudienceSizeTypePercentage is a AudienceSizeType enum value
	AudienceSizeTypePercentage = "PERCENTAGE"
)

// AudienceSizeType_Values returns all elements of the AudienceSizeType enum
func AudienceSizeType_Values() []string {
	return []string{
		AudienceSizeTypeAbsolute,
		AudienceSizeTypePercentage,
	}
}

const (
	// ColumnTypeUserId is a ColumnType enum value
	ColumnTypeUserId = "USER_ID"

	// ColumnTypeItemId is a ColumnType enum value
	ColumnTypeItemId = "ITEM_ID"

	// ColumnTypeTimestamp is a ColumnType enum value
	ColumnTypeTimestamp = "TIMESTAMP"

	// ColumnTypeCategoricalFeature is a ColumnType enum value
	ColumnTypeCategoricalFeature = "CATEGORICAL_FEATURE"

	// ColumnTypeNumericalFeature is a ColumnType enum value
	ColumnTypeNumericalFeature = "NUMERICAL_FEATURE"
)

// ColumnType_Values returns all elements of the ColumnType enum
func ColumnType_Values() []string {
	return []string{
		ColumnTypeUserId,
		ColumnTypeItemId,
		ColumnTypeTimestamp,
		ColumnTypeCategoricalFeature,
		ColumnTypeNumericalFeature,
	}
}

const (
	// ConfiguredAudienceModelStatusActive is a ConfiguredAudienceModelStatus enum value
	ConfiguredAudienceModelStatusActive = "ACTIVE"
)

// ConfiguredAudienceModelStatus_Values returns all elements of the ConfiguredAudienceModelStatus enum
func ConfiguredAudienceModelStatus_Values() []string {
	return []string{
		ConfiguredAudienceModelStatusActive,
	}
}

const (
	// DatasetTypeInteractions is a DatasetType enum value
	DatasetTypeInteractions = "INTERACTIONS"
)

// DatasetType_Values returns all elements of the DatasetType enum
func DatasetType_Values() []string {
	return []string{
		DatasetTypeInteractions,
	}
}

const (
	// PolicyExistenceConditionPolicyMustExist is a PolicyExistenceCondition enum value
	PolicyExistenceConditionPolicyMustExist = "POLICY_MUST_EXIST"

	// PolicyExistenceConditionPolicyMustNotExist is a PolicyExistenceCondition enum value
	PolicyExistenceConditionPolicyMustNotExist = "POLICY_MUST_NOT_EXIST"
)

// PolicyExistenceCondition_Values returns all elements of the PolicyExistenceCondition enum
func PolicyExistenceCondition_Values() []string {
	return []string{
		PolicyExistenceConditionPolicyMustExist,
		PolicyExistenceConditionPolicyMustNotExist,
	}
}

const (
	// SharedAudienceMetricsAll is a SharedAudienceMetrics enum value
	SharedAudienceMetricsAll = "ALL"

	// SharedAudienceMetricsNone is a SharedAudienceMetrics enum value
	SharedAudienceMetricsNone = "NONE"
)

// SharedAudienceMetrics_Values returns all elements of the SharedAudienceMetrics enum
func SharedAudienceMetrics_Values() []string {
	return []string{
		SharedAudienceMetricsAll,
		SharedAudienceMetricsNone,
	}
}

const (
	// TagOnCreatePolicyFromParentResource is a TagOnCreatePolicy enum value
	TagOnCreatePolicyFromParentResource = "FROM_PARENT_RESOURCE"

	// TagOnCreatePolicyNone is a TagOnCreatePolicy enum value
	TagOnCreatePolicyNone = "NONE"
)

// TagOnCreatePolicy_Values returns all elements of the TagOnCreatePolicy enum
func TagOnCreatePolicy_Values() []string {
	return []string{
		TagOnCreatePolicyFromParentResource,
		TagOnCreatePolicyNone,
	}
}

const (
	// TrainingDatasetStatusActive is a TrainingDatasetStatus enum value
	TrainingDatasetStatusActive = "ACTIVE"
)

// TrainingDatasetStatus_Values returns all elements of the TrainingDatasetStatus enum
func TrainingDatasetStatus_Values() []string {
	return []string{
		TrainingDatasetStatusActive,
	}
}
