// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains the reasoning that the model used to return the output.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct ReasoningTextBlock {
    /// <p>The reasoning that the model used to return the output.</p>
    pub text: ::std::string::String,
    /// <p>A token that verifies that the reasoning text was generated by the model. If you pass a reasoning block back to the API in a multi-turn conversation, include the text and its signature unmodified.</p>
    pub signature: ::std::option::Option<::std::string::String>,
}
impl ReasoningTextBlock {
    /// <p>The reasoning that the model used to return the output.</p>
    pub fn text(&self) -> &str {
        use std::ops::Deref;
        self.text.deref()
    }
    /// <p>A token that verifies that the reasoning text was generated by the model. If you pass a reasoning block back to the API in a multi-turn conversation, include the text and its signature unmodified.</p>
    pub fn signature(&self) -> ::std::option::Option<&str> {
        self.signature.as_deref()
    }
}
impl ::std::fmt::Debug for ReasoningTextBlock {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("ReasoningTextBlock");
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("signature", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl ReasoningTextBlock {
    /// Creates a new builder-style object to manufacture [`ReasoningTextBlock`](crate::types::ReasoningTextBlock).
    pub fn builder() -> crate::types::builders::ReasoningTextBlockBuilder {
        crate::types::builders::ReasoningTextBlockBuilder::default()
    }
}

/// A builder for [`ReasoningTextBlock`](crate::types::ReasoningTextBlock).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
#[non_exhaustive]
pub struct ReasoningTextBlockBuilder {
    pub(crate) text: ::std::option::Option<::std::string::String>,
    pub(crate) signature: ::std::option::Option<::std::string::String>,
}
impl ReasoningTextBlockBuilder {
    /// <p>The reasoning that the model used to return the output.</p>
    /// This field is required.
    pub fn text(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.text = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The reasoning that the model used to return the output.</p>
    pub fn set_text(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.text = input;
        self
    }
    /// <p>The reasoning that the model used to return the output.</p>
    pub fn get_text(&self) -> &::std::option::Option<::std::string::String> {
        &self.text
    }
    /// <p>A token that verifies that the reasoning text was generated by the model. If you pass a reasoning block back to the API in a multi-turn conversation, include the text and its signature unmodified.</p>
    pub fn signature(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.signature = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>A token that verifies that the reasoning text was generated by the model. If you pass a reasoning block back to the API in a multi-turn conversation, include the text and its signature unmodified.</p>
    pub fn set_signature(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.signature = input;
        self
    }
    /// <p>A token that verifies that the reasoning text was generated by the model. If you pass a reasoning block back to the API in a multi-turn conversation, include the text and its signature unmodified.</p>
    pub fn get_signature(&self) -> &::std::option::Option<::std::string::String> {
        &self.signature
    }
    /// Consumes the builder and constructs a [`ReasoningTextBlock`](crate::types::ReasoningTextBlock).
    /// This method will fail if any of the following fields are not set:
    /// - [`text`](crate::types::builders::ReasoningTextBlockBuilder::text)
    pub fn build(self) -> ::std::result::Result<crate::types::ReasoningTextBlock, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::ReasoningTextBlock {
            text: self.text.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "text",
                    "text was not specified but it is required when building ReasoningTextBlock",
                )
            })?,
            signature: self.signature,
        })
    }
}
impl ::std::fmt::Debug for ReasoningTextBlockBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("ReasoningTextBlockBuilder");
        formatter.field("text", &"*** Sensitive Data Redacted ***");
        formatter.field("signature", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
