﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-runtime/model/CountTokensRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::BedrockRuntime::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CountTokensRequest::SerializePayload() const {
  JsonValue payload;

  if (m_inputHasBeenSet) {
    payload.WithObject("input", m_input.Jsonize());
  }

  return payload.View().WriteReadable();
}
