/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;

class SQLContentFormatter
extends ContentFormatter
implements IContentFormatterExtension {
    private static final Log log = Log.getLog(SQLContentFormatter.class);
    private final SQLEditorBase editor;

    SQLContentFormatter(SQLEditorBase editor) {
        this.editor = editor;
    }

    public void format(IDocument document, IFormattingContext context) {
        IRegion region;
        IFormattingStrategy strategy = this.getFormattingStrategy("__dftl_partition_content_type");
        if (strategy == null) {
            return;
        }
        if (this.editor.getActivePreferenceStore().getBoolean("SQLEditor.format.activeQuery")) {
            SQLScriptElement activeQuery = this.editor.extractActiveQuery();
            if (activeQuery == null) {
                return;
            }
            region = new Region(activeQuery.getOffset(), activeQuery.getLength());
        } else {
            region = (IRegion)context.getProperty((Object)"formatting.context.region");
            if (region == null) {
                region = new Region(0, document.getLength());
            }
        }
        try {
            String source = document.get(region.getOffset(), region.getLength());
            String formatted = strategy.format(source, false, null, null);
            document.replace(region.getOffset(), region.getLength(), formatted);
        }
        catch (BadLocationException e) {
            log.error((Object)"Error formatting the document", (Throwable)e);
        }
    }
}

