/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.security;

import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.security.SSLContextFactory;
import org.eclipse.ecf.internal.core.identity.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ECFSSLContextFactory
implements SSLContextFactory {
    private ServiceTracker<Provider, Provider> providerTracker;
    private final String defaultProtocol;
    private final String defaultProviderName;

    public ECFSSLContextFactory(BundleContext context) throws NoSuchAlgorithmException {
        this(context, null);
    }

    public ECFSSLContextFactory(BundleContext context, String defaultProtocol) throws NoSuchAlgorithmException {
        this(context, defaultProtocol, null);
    }

    public ECFSSLContextFactory(BundleContext context, String defaultProtocol, String defaultProviderName) throws NoSuchAlgorithmException {
        if (context == null) {
            throw new NullPointerException("context must not be null");
        }
        if (defaultProviderName == null) {
            defaultProviderName = SSLContext.getDefault().getProvider().getName();
        }
        if (defaultProtocol == null) {
            defaultProtocol = SSLContext.getDefault().getProtocol();
        }
        this.defaultProtocol = defaultProtocol;
        this.defaultProviderName = defaultProviderName;
        this.providerTracker = new ServiceTracker(context, Provider.class, null);
        this.providerTracker.open();
    }

    @Override
    public SSLContext getDefault() throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.getInstance0(this.defaultProtocol, this.defaultProviderName);
    }

    protected SSLContext getInstance0(String protocol, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (protocol == null) {
            return SSLContext.getDefault();
        }
        Provider provider = this.findProvider(providerName);
        if (provider == null) {
            throw new NoSuchProviderException("No provider registered named '" + providerName + "'");
        }
        return SSLContext.getInstance(protocol, provider);
    }

    @Override
    public SSLContext getInstance(String protocol) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.getInstance0(protocol, this.defaultProviderName);
    }

    public synchronized void close() {
        if (this.providerTracker != null) {
            this.providerTracker.close();
            this.providerTracker = null;
        }
    }

    protected Provider findProvider(String providerName) {
        if (providerName == null) {
            return (Provider)this.providerTracker.getService();
        }
        Optional<Provider> optResult = this.providerTracker.getTracked().values().stream().filter(p -> providerName.equals(p.getName())).findFirst();
        if (optResult.isPresent()) {
            return optResult.get();
        }
        try {
            SSLContext defaultContext = SSLContext.getDefault();
            if (providerName.equals(defaultContext.getProvider().getName())) {
                return defaultContext.getProvider();
            }
        }
        catch (NoSuchAlgorithmException e) {
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.identity", "Could not get SSLContext.getDefault()", (Throwable)e));
        }
        return null;
    }

    @Override
    public SSLContext getInstance(String protocol, String providerName) throws NoSuchAlgorithmException, NoSuchProviderException {
        return this.getInstance0(protocol, providerName);
    }
}

