/*
 * // Copyright (c) Radzivon Bartoshyk 8/2025. All rights reserved.
 * //
 * // Redistribution and use in source and binary forms, with or without modification,
 * // are permitted provided that the following conditions are met:
 * //
 * // 1.  Redistributions of source code must retain the above copyright notice, this
 * // list of conditions and the following disclaimer.
 * //
 * // 2.  Redistributions in binary form must reproduce the above copyright notice,
 * // this list of conditions and the following disclaimer in the documentation
 * // and/or other materials provided with the distribution.
 * //
 * // 3.  Neither the name of the copyright holder nor the names of its
 * // contributors may be used to endorse or promote products derived from
 * // this software without specific prior written permission.
 * //
 * // THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * // AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * // IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * // DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * // FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * // DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * // SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * // CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * // OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * // OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
Generated by SageMath:

```python
values = POW_INVERSE
R = RealField(150)

def hex_to_float(h):
    return struct.unpack('>d', struct.pack('>Q', h))[0]

real_array = [R(hex_to_float(h)) for h in values]

for r in real_array:
    print_double_double("", -RealField(180)(r).log10())

```
**/
pub(crate) static LOG10_NEG_DD: [(u64, u64); 182] = [
    (0xbc0b420b9b202edd, 0xbfc31b3055c47118),
    (0xbc662219537667a2, 0xbfc2cc20b1734279),
    (0xbc4386d677ad2ead, 0xbfc27c9ffae729c1),
    (0x3c6fb908b0ca4062, 0xbfc22cacece26ead),
    (0xbc61b4170b1c73f0, 0xbfc1dc463ca41df8),
    (0x3c5d6679f737585c, 0xbfc18b6a99c7f679),
    (0x3c6c6397435bc5b6, 0xbfc162d082ac9d10),
    (0x3c4b8c4f1b08949b, 0xbfc11142f0811357),
    (0xbc5e17a06836db63, 0xbfc0bf3d0937c41c),
    (0xbc65163143f60061, 0xbfc06cbd67a6c3b6),
    (0xbc6c5e9d9a0e1fd9, 0xbfc019c2a064b486),
    (0x3c5ec7f2dac60a5c, 0xbfbf8c9683468191),
    (0x3c54a69937a2d705, 0xbfbf38c0c8325d86),
    (0x3c53cbb5a6ee659b, 0xbfbe9056bcb315e8),
    (0x3c51bf355bb72ca1, 0xbfbde6ec0f392b05),
    (0x3c5ce84c9eaee37a, 0xbfbd91d5866aa99c),
    (0x3c26f0603909a181, 0xbfbce6e41e463da5),
    (0x3c58b9190212e5ba, 0xbfbc3aea4a5c6eff),
    (0x3c2446d00b829ad4, 0xbfbb8de4d3ab3d98),
    (0x3c5aa2aeaa7bc18d, 0xbfbb36fcb5f8be8a),
    (0x3c5dd366189ac022, 0xbfba885fa2d6151e),
    (0x3c4ebf33e9410429, 0xbfba30a9d609efea),
    (0xbc5c81cca3dd9b7b, 0xbfb9806d9414a209),
    (0x3c5935d381a0844f, 0xbfb8cf183886480d),
    (0x3c3666804e99aabc, 0xbfb8760307d355ab),
    (0xbc21064a1f6dc0c5, 0xbfb7c30164a60836),
    (0x3c5ac4c370ae3c1d, 0xbfb769140a2526fd),
    (0xbc5643835531d8ee, 0xbfb6b45df6f3e2c9),
    (0x3c59d9c8eaf88500, 0xbfb659944f8ba02d),
    (0xbc48cb0dc78c3961, 0xbfb5a32167b32f02),
    (0x3c5e1bcfb0476f5d, 0xbfb5477731973e85),
    (0xbc5782120ed9fd02, 0xbfb48f3ed1df48fb),
    (0x3c51960cbdfcb2d3, 0xbfb432afab5dd3ff),
    (0x3c4a83d8a6eb8e2e, 0xbfb3d5d335c53179),
    (0xbbfb420b9b202edd, 0xbfb31b3055c47118),
    (0xbc59f5fa977fa091, 0xbfb2bd68e4621371),
    (0x3c5c2f24fb8a820d, 0xbfb200eb639a3173),
    (0x3c4f990c2c07d3b5, 0xbfb1a23445501816),
    (0x3c4114d5dc0b3275, 0xbfb1432c31917d08),
    (0x3c3ccc49eb0a89d8, 0xbfb08426fcdb1ee7),
    (0x3c35943d4373d44a, 0xbfb02428c1f08016),
    (0x3c31436f936096a0, 0xbfaf87aebb43ce06),
    (0x3c4d4d643174a412, 0xbfae0471aa1868f5),
    (0x3c47f9dc537bfbfb, 0xbfad41d5164facb4),
    (0x3c4073b6859dc799, 0xbfac7e8d993509f9),
    (0x3c46487d64961833, 0xbfaaf5f92b00e610),
    (0x3c3ebf33e9410429, 0xbfaa30a9d609efea),
    (0x3c41c8c309cdac54, 0xbfa96aaacfefcf3c),
    (0x3c4b144b06126f68, 0xbfa8a3fadeb847f4),
    (0x3c38f0f77fcff1d9, 0xbfa71483427d2a99),
    (0xbc2eff9decc696f6, 0xbfa64bb912d65c07),
    (0xbc4efd454f7ea69a, 0xbfa58238eeb353da),
    (0xbc443795bbf70657, 0xbfa4b8018b21ed4f),
    (0x3c492b9251ee5832, 0xbfa32167c82bdcda),
    (0x3c4ff894a084ae68, 0xbfa25502c0fc314c),
    (0xbc49adc1c7f97f4a, 0xbfa187e12aad8077),
    (0xbc35f1d45244f437, 0xbfa0ba01a8170000),
    (0x3c3e7ffa709828ef, 0xbf9fd6c5b0851c4c),
    (0xbc0af3eb3b443356, 0xbf9e3806acbd058f),
    (0x3c36487d64961833, 0xbf9af5f92b00e610),
    (0x3c1f21279ca1bd16, 0xbf9952a4f22c5ae9),
    (0xbc1b980714c596a3, 0xbf97adc3df3b1ff8),
    (0xbc36ea248137e395, 0xbf960753003a94ef),
    (0xbc3dda7897a55eb5, 0xbf945f4f5acb8be0),
    (0xbc15bcd6d3458191, 0xbf92b5b5ec0209d3),
    (0x3c37b9fd5428084f, 0xbf910a83a8446c78),
    (0xbc1b57b9aec33450, 0xbf8ebb6af653e2ee),
    (0xbbff2e9fe367a511, 0xbf8b5e908eb13790),
    (0xbc28d4a223a5f7c9, 0xbf87fe71ccc4e6b0),
    (0x3c18f207a6d0d0b1, 0xbf849b0851443684),
    (0x3c29383502395c53, 0xbf81344daa2d7553),
    (0x3c03b252df477a75, 0xbf7b9476a4fcd10f),
    (0xbbefb495d6440f14, 0xbf74b99563d2a1bd),
    (0xbc09706ea523f0a5, 0xbf6bafd47221ed26),
    (0x0000000000000000, 0x0000000000000000),
    (0x0000000000000000, 0x0000000000000000),
    (0x3c0dcbdc594292c0, 0x3f64e84e793a474a),
    (0x3c11e6c1240ced74, 0x3f7175085ab85ff0),
    (0x3c0e1d6052707e0e, 0x3f787cff9d9147a5),
    (0xbbee4f45b8df7d67, 0x3f7f8c1b6b0c8d4e),
    (0x3c22495d8b8e25b7, 0x3f8351352a8e733f),
    (0x3c1bc0294772c57f, 0x3f86dffd8d3bbf70),
    (0xbc2b41d4e4ac05d4, 0x3f8a726e53a6056e),
    (0xbc28d01e8ac8a78b, 0x3f8c3d0837784c41),
    (0x3c27d5b73769b64c, 0x3f8fd503c3904f1d),
    (0xbbd646ebcccb6894, 0x3f91b85d6044e9ae),
    (0x3c37b38a223627b5, 0x3f93881a7b818f9e),
    (0x3c0521ad5fa98432, 0x3f9559bd2406c3ba),
    (0xbc29fc37c4e4e576, 0x3f972d4956ca2067),
    (0x3c3c830373882139, 0x3f9817c846828bbd),
    (0x3c0be24ddca8b835, 0x3f99ee3a5e9f57e8),
    (0x3c0999ccc6d592f0, 0x3f9bc6a03117eb97),
    (0xbc34a65cdeb626ca, 0x3f9da0fde8038de9),
    (0xbc29dc1111e3b44c, 0x3f9f7d57badb4ee8),
    (0x3c47db4db93811b8, 0x3fa0362241e638ec),
    (0xbc3f6975f23b8a99, 0x3fa125d0432ea20e),
    (0x3c463610c66f42b2, 0x3fa21681b5c8c213),
    (0x3c3c756ef644213d, 0x3fa28f3c69912a74),
    (0xbc11b16a272d4ddf, 0x3fa381772a00e604),
    (0xbc2197beb0be1c78, 0x3fa474baeb77e904),
    (0xbc0978c592e6c139, 0x3fa4eec0e2458f30),
    (0x3c2bb9cd2fb75402, 0x3fa5e3966b7e9295),
    (0x3c377b340fa390ec, 0x3fa6d97ab3ba5e10),
    (0x3c3ea90ccf791593, 0x3fa754d31b1b179c),
    (0x3c454596cc7150a8, 0x3fa84c51ebee8d15),
    (0xbc476df54932f73e, 0x3fa944e56a0d3450),
    (0xbc286148dd4cfbf5, 0x3fa9c197abf00dd7),
    (0xbc397d2cb982dac2, 0x3faabbcebd84fca0),
    (0x3c36591c969ff97b, 0x3fab39542ba23d73),
    (0xbc40859ccb55560e, 0x3fac3534628016dd),
    (0x3c4a5aca518d962e, 0x3facb38fccd8bfdb),
    (0x3c396e1e0dda0b3d, 0x3fadb11ed766abf4),
    (0x3c332de632195123, 0x3fae30531c76c34a),
    (0xbc23a73e99099cbd, 0x3faf2f96c6754aee),
    (0x3c262f731cfeb27b, 0x3fafafa6d397efdb),
    (0xbc4e0c43230184dc, 0x3fb0585283764178),
    (0x3c5466dc013d46a9, 0x3fb098c9ec61b3ff),
    (0xbc5cae3496ce9852, 0x3fb11a294f2569f6),
    (0xbc56a232c37f20c5, 0x3fb15b11a094a1aa),
    (0xbc4f587e7a233c80, 0x3fb1dd5460c8b16f),
    (0x3c5a0dec3a5a500c, 0x3fb21eaf28f57941),
    (0x3c585a155bb65408, 0x3fb2a1d86b49f1e2),
    (0xbc5aef53f2ecddb9, 0x3fb2e3a740b7800f),
    (0xbc5de49ddb15fb04, 0x3fb367ba3aaa1883),
    (0xbc5514fb6a33e70f, 0x3fb3a9febc60540a),
    (0x3c5c4c753d98645a, 0x3fb3ec6ad5407868),
    (0x3c2ce8e795b6ed98, 0x3fb471ba8a7de2b7),
    (0xbc54f0487863efe6, 0x3fb4b49e86b11e5f),
    (0x3c4bc478d6071be0, 0x3fb53adfb462ce16),
    (0xbc187decde1893f1, 0x3fb57e3d47c3af7b),
    (0x3c481f647ea24688, 0x3fb5c1c3c5557799),
    (0x3c5ad1738d96af06, 0x3fb6494c46ac6e4d),
    (0x3c54c74f6a7880e3, 0x3fb68d4eaf26d7ee),
    (0xbc52a2d69cfac78f, 0x3fb6d17acb3e5f5e),
    (0x3c4e4ba167ee73dd, 0x3fb75a50ebb1624a),
    (0x3c57e469fe31a42f, 0x3fb79efb57b0f803),
    (0xbc4d12e032a3b7af, 0x3fb7e3d04697b704),
    (0xbc53f06091db6450, 0x3fb828cfed29a215),
    (0x3c4da13d5c8cb232, 0x3fb8b350364c6257),
    (0x3be2034e6320e8c0, 0x3fb8f8d144557bdf),
    (0xbc5d0d01941798b6, 0x3fb93e7de0fc3e80),
    (0xbc562d3ed69292b0, 0x3fb9ca5aa1729f45),
    (0x3c5ba75ea17687d3, 0x3fba108b33edb005),
    (0xbc3113a1fc340179, 0x3fba56e8325f5c87),
    (0xbc4f648977febad9, 0x3fba9d71d5258484),
    (0x3c45689de26b43ff, 0x3fbb2b0beb419ad0),
    (0xbc5a8267d18975f3, 0x3fbb721cd17157e3),
    (0xbc5cb0a198331caf, 0x3fbbb95b41ab5ce6),
    (0xbc5b1e2e67b6f4bf, 0x3fbc00c7767225cb),
    (0xbc5b6b51fca7a9a5, 0x3fbc4861aab93a23),
    (0xbc58f377e27bbe25, 0x3fbcd820ffd278f3),
    (0xbc5667bf89866cca, 0x3fbd204698cb42bd),
    (0xbc1100072d011b81, 0x3fbd689b2193f133),
    (0x3c496e1e0dda0b3d, 0x3fbdb11ed766abf4),
    (0x3c55c6bc5d06e932, 0x3fbdf9d1f7f5b674),
    (0xbc5e018e5642e2ef, 0x3fbe42b4c16caaf3),
    (0xbc20a89525f3e005, 0x3fbed50a4a26eafc),
    (0x3c50955b9d99c1b8, 0x3fbf1e7d882b689a),
    (0xbc5c42f76e4345b0, 0x3fbf68216c9cc727),
    (0xbc46749ac407ee87, 0x3fbfb1f6381856f4),
    (0x3c5d60df12c2e13d, 0x3fbffbfc2bbc7803),
    (0x3c4ef8dd8b73f78d, 0x3fc02319c494f951),
    (0x3c5f318aa3021710, 0x3fc0484e4942aa43),
    (0xbc6a12a1c0cb3d7f, 0x3fc093025a19976c),
    (0xbc609801174f88fd, 0x3fc0b88229b71227),
    (0x3c65b619c844d28b, 0x3fc0de1b56356b04),
    (0x3c4dbdf176a1440a, 0x3fc103ce01fae223),
    (0xbc6ce6c847a6598d, 0x3fc1299a4fb3e306),
    (0xbc61f5da9e930834, 0x3fc14f806253c3ed),
    (0x3c5ac676f20a87ab, 0x3fc175805d1587c1),
    (0xbc6e785b3b894bd7, 0x3fc19b9a637ca295),
    (0xbc5db924be9633b4, 0x3fc1c1ce9955c0c6),
    (0x3c6db81c3374e59e, 0x3fc1e81d22b790d4),
    (0xbc67299601268298, 0x3fc20e8624038fed),
    (0x3c6ea54c137b0aea, 0x3fc23509c1e6d937),
    (0x3c50349d03e16325, 0x3fc25ba8215af7fc),
    (0x3c6557d4cdeffe3f, 0x3fc2826167a6bc9c),
    (0xbc1f613823fd2a19, 0x3fc2a935ba5f1479),
    (0xbc63dda694b5fe22, 0x3fc2d0253f67e4cb),
    (0xbc4c7972ce5f8b57, 0x3fc2f7301cf4e87b),
    (0x3c54b79d1957630a, 0x3fc31e56798a910a),
    (0xbc654fd6eb7d970e, 0x3fc345987bfeea91),
];
