/* A binary basically just blocking waiting for input and exiting. It also write
 * its PID and the address of its `_start` function to stdout (unformatted;
 * just a byte dump).
 *
 * It uses raw system calls to avoid dependency on libc, which pulls in
 * start up code and various other artifacts that perturb ELF layout in
 * semi-unforeseeable ways, in an attempt to provide us with maximum
 * control over the final binary.
 *
 * Likely only works on x86_64.
 */

#include <unistd.h>
#include <sys/syscall.h>

void __stack_chk_fail(void) {}

void _start(void) {
  char buf[2];
  int rc;
  int pid;
  asm volatile (
      "syscall"
      : "=a"(pid)
      : "a"(SYS_getpid)
      : "rcx", "r11", "memory"
  );
  asm volatile (
      "syscall"
      : "=a"(rc)
      : "a"(SYS_write), "D"(STDOUT_FILENO), "S"(&pid), "d"(sizeof(pid))
      : "rcx", "r11", "memory"
  );
  void* addr = (void*)&_start;
  asm volatile (
      "syscall"
      : "=a"(rc)
      : "a"(SYS_write), "D"(STDOUT_FILENO), "S"(&addr), "d"(sizeof(addr))
      : "rcx", "r11", "memory"
  );
  asm volatile (
      "syscall"
      : "=a"(rc)
      : "a"(SYS_read), "D"(STDIN_FILENO), "S"(buf), "d"(sizeof(buf))
      : "rcx", "r11", "memory"
  );
  if (rc > 0) {
    /* No error, so we can exit successfully. */
    rc = 0;
  }
  asm volatile (
      "syscall"
      : "=a"(rc)
      : "a"(SYS_exit), "D"(rc)
      : "rcx", "r11", "memory"
  );
}
