---
layout: default
title: Announcements
parent: Release & Milestone Tasks
grand_parent: Contributors
nav_order: 10
---

<!--
© 2021 and later: Unicode, Inc. and others.
License & terms of use: http://www.unicode.org/copyright.html
-->

# Announcements
{: .no_toc }

## Contents
{: .no_toc .text-delta }

1. TOC
{:toc}

---

## First milestone/candidate for a release

We write drafts of announcements in the ["ICU announcements" Google
doc](https://docs.google.com/document/d/1rSVKZaus2K3rF66bMfDjYZnA2KTSJZUBz4C58GQMHsQ/edit).

When there is no section yet for the upcoming release, then copy the whole
section from one of the previous two full releases and adjust the version
numbers everywhere in the copied headings and text.

### Announcement for a release candidate

Adjust the release candidate announcement subsection with a very brief summary
gleaned from the download page.

Share the draft as a link to the doc heading with the ICU team, invite comments
and edits.

When ready, send to the mailing lists as indicated in the doc. Make sure to use
bcc as noted for the "announce" lists.

### Announcement for a new major version

Adjust the final-release announcement subsection with a very brief summary
gleaned from the download page. Adjust the blog & tweet texts as well.

Share the draft as a link to the doc heading with the ICU team, invite comments
and edits.

Share the draft as a link with the Unicode editorial committee, invite comments,
discuss, adjust as agreed.

When ready, send to the mailing lists as indicated in the doc. Make sure to use
bcc as noted for the "announce" lists.

Notify Rick McGowan for the Unicode blog posting and Ken Lunde for tweeting.

Notify Ken Whistler (Unicode) to update the ICU version & date on
<https://www.unicode.org/releases/>

Put a News item on the ICU project site.

### Announcement for a maintenance update

Same as for a release candidate, but start by copying the section for the last
maintenance update in the doc.

## Update the reference for ICU in the external sites

**For freshmeat.net**

1.  <http://www.freshmeat.net/>
2.  Login under the correct account.
3.  I usually search for: icu unicode
4.  Click on the project returned
5.  Under the 'project' drop down, choose 'Add release'
6.  We have (thankfully) only one branch of development- choose Default
7.  Release info
    *   release focus: Choose the one which best fits
    *   Version
    *   Changes: be VERY brief, and include links if needed.
        Please read the other ICU4C/ICU4J updates to get an idea for how we are
        wording these. DO NOT use bulleted lists. DO use short 'sentences'.
        Remember they can go to the release list and/or bug DB for the full
        scoop!
        Put the URL to the 'release notes' (i.e.
        http://oss.software.ibm.com/icu/download/(version)/ ) in the changes
        list.
    *   tar/gz, zip: Put the FULL URLs to the actual files, here
    *   Changelog: Leave BLANK. This is for a single page of ALL release changes
        (Actually: http://oss.software.ibm.com/icu/download/ fits this fairly
        well.)
    *   License - leave at MIT/X
    *   mailing list: I set this to the main mailing list page.
        (http://oss.software.ibm.com/icu/archives/)
    Click 'go on..'
8.  PREVIEW.
    Very important- Check:
    *   SPELLING
    *   links!!!!! Make sure they go where we want
    *   accuracy - version number is OK?
    Remember that this is an important PR face for ICU4C and ICU4J.
9.  Submit!

That's it. Submissions take some time (<24 hrs) to go on. I guess they check the
accuracy as well- not sure here. (Steven Loomis, 2001-06-14)

**Other sites**:

[slashdot](http://slashdot.org/), [newsforge](http://newsforge.com/),
[developerWorks unicode zone](http://www.ibm.com/developerworks/unicode/),
[developerWorks open-source
zone](http://www.ibm.com/developerworks/opensource/), [developerWorks java
zone](http://www.ibm.com/developerworks/java/) (send email to `dWnews <at>
us.ibm.com`)

[ICU sourceforge News](http://sourceforge.net/projects/icu) - login here, go to
News, Admin, and submit a news item as an administrator.

---

#### LanguageTech Net News (tm)

"LanguageTech Net News" features the latest news for language technology and
multilingual computing. It is prepared from materials compiled and maintained by
the research editors at "[MultiLingual Computing &
Technology](http://www.multilingual.com/)" and the Language Technology Research
Center.

Press releases and submissions are always welcomed and encouraged. Please send
e-mail to [news@multilingual.com](mailto:news@multilingual.com), faxes to
208-263-6310 and postal mail to MultiLingual Computing, Inc., 319 North First
Avenue, Sandpoint, ID 83864 USA, or call 208-263-8178.

To view archived issues of "LanguageTech Net News" visit
<http://www.multilingual.com/>.

To subscribe to "LanguageTech Net News" go to
<http://www.multilingual.com/multilingualpress/> or send an e-mail to
[news-l-subscribe@multilingual.com](mailto:news-l-subscribe@multilingual.com).
