/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MultiIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.ItemType;

public class ConditionalPattern
extends Pattern {
    private Expression[] conditions;
    private Pattern[] patterns;

    public ConditionalPattern(Expression[] conditions, Pattern[] patterns) {
        this.conditions = conditions;
        this.patterns = patterns;
    }

    public void setExecutable(Executable executable) {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.patterns[i].setExecutable(executable);
        }
        super.setExecutable(executable);
    }

    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i] = visitor.simplify(this.conditions[i]);
            this.patterns[i] = this.patterns[i].simplify(visitor);
        }
        return this;
    }

    public Pattern analyze(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i] = visitor.typeCheck(this.conditions[i], contextItemType);
            this.patterns[i] = this.patterns[i].analyze(visitor, contextItemType);
        }
        return this;
    }

    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            this.conditions[i] = this.conditions[i].promote(offer, parent);
            this.patterns[i].promote(offer, parent);
        }
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int i = 0; i < this.conditions.length; ++i) {
            found |= this.conditions[i].replaceSubExpression(original, replacement);
            found |= this.patterns[i].replaceSubExpression(original, replacement);
        }
        return found;
    }

    public void setOriginalText(String pattern) {
        super.setOriginalText(pattern);
        for (int i = 0; i < this.conditions.length; ++i) {
            this.patterns[i].setOriginalText(pattern);
        }
    }

    public int allocateSlots(StaticContext env, SlotManager slotManager, int nextFree) {
        for (int i = 0; i < this.conditions.length; ++i) {
            nextFree = ExpressionTool.allocateSlots(this.conditions[i], nextFree, slotManager);
            nextFree = this.patterns[i].allocateSlots(env, slotManager, nextFree);
        }
        return nextFree;
    }

    public boolean matches(NodeInfo e, XPathContext context) throws XPathException {
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean b = this.conditions[i].effectiveBooleanValue(context);
            if (!b) continue;
            return this.patterns[i].matches(e, context);
        }
        return false;
    }

    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        XPathContextMajor c2 = context.newContext();
        UnfailingIterator iter = SingletonIterator.makeIterator(anchor);
        iter.next();
        c2.setCurrentIterator(iter);
        for (int i = 0; i < this.conditions.length; ++i) {
            boolean b = this.conditions[i].effectiveBooleanValue(c2);
            if (!b) continue;
            return this.patterns[i].matchesBeneathAnchor(node, anchor, context);
        }
        return false;
    }

    public int getNodeKind() {
        int type = this.patterns[0].getNodeKind();
        for (int i = 1; i < this.patterns.length; ++i) {
            int p = this.patterns[i].getNodeKind();
            if (p == type) continue;
            return 0;
        }
        return type;
    }

    public NodeTest getNodeTest() {
        int nodeType = this.getNodeKind();
        if (nodeType == 0) {
            return AnyNodeTest.getInstance();
        }
        return NodeKindTest.makeNodeKindTest(nodeType);
    }

    public int getDependencies() {
        int d = 0;
        for (int i = 0; i < this.conditions.length; ++i) {
            d |= this.conditions[i].getDependencies();
            d |= this.patterns[i].getDependencies();
        }
        return d;
    }

    public Iterator iterateSubExpressions() {
        Iterator[] c = new Iterator[this.conditions.length * 2];
        for (int i = 0; i < this.conditions.length; i += 2) {
            c[i] = this.conditions[i].iterateSubExpressions();
            c[i + 1] = this.patterns[i].iterateSubExpressions();
        }
        return new MultiIterator(c);
    }

    public void setSystemId(String systemId) {
        super.setSystemId(systemId);
        for (int i = 0; i < this.conditions.length; i += 2) {
            this.patterns[i].setSystemId(systemId);
        }
    }

    public void setLineNumber(int lineNumber) {
        super.setLineNumber(lineNumber);
        for (int i = 0; i < this.conditions.length; i += 2) {
            this.patterns[i].setLineNumber(lineNumber);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof ConditionalPattern) {
            return Arrays.equals(this.conditions, ((ConditionalPattern)other).conditions) && Arrays.equals(this.patterns, ((ConditionalPattern)other).patterns);
        }
        return false;
    }

    public int hashCode() {
        int h = -2090102112;
        for (int i = 0; i < this.conditions.length; i += 2) {
            h ^= this.patterns[i].hashCode() ^ this.conditions[i].hashCode();
        }
        return h;
    }
}

