/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.config.FoProcessor;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.S9apiUtils;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.XdmNode;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.xml.sax.InputSource;

public class FoFOP
implements FoProcessor {
    XProcRuntime runtime = null;
    FopFactory fopFactory = null;
    Properties options = null;
    XStep step = null;
    URIResolver resolver = null;

    @Override
    public void initialize(XProcRuntime xProcRuntime, XStep xStep, Properties properties) {
        this.runtime = xProcRuntime;
        this.step = xStep;
        this.options = properties;
        this.fopFactory = FopFactory.newInstance();
        this.resolver = xProcRuntime.getResolver();
        if (this.resolver != null) {
            this.fopFactory.setURIResolver(this.resolver);
        }
        try {
            Float f;
            Boolean bl;
            String string = this.getStringProp("BaseURL");
            if (string != null) {
                this.fopFactory.setBaseURL(string);
            }
            if ((bl = this.getBooleanProp("BreakIndentInheritanceOnReferenceAreaBoundary")) != null) {
                this.fopFactory.setBreakIndentInheritanceOnReferenceAreaBoundary(bl.booleanValue());
            }
            if ((string = this.getStringProp("FontBaseURL")) != null) {
                this.fopFactory.getFontManager().setFontBaseURL(string);
            }
            if ((bl = this.getBooleanProp("Base14KerningEnabled")) != null) {
                this.fopFactory.getFontManager().setBase14KerningEnabled(bl.booleanValue());
            }
            if ((string = this.getStringProp("HyphenBaseURL")) != null) {
                this.fopFactory.setHyphenBaseURL(string);
            }
            if ((string = this.getStringProp("PageHeight")) != null) {
                this.fopFactory.setPageHeight(string);
            }
            if ((string = this.getStringProp("PageWidth")) != null) {
                this.fopFactory.setPageWidth(string);
            }
            if ((f = this.getFloatProp("SourceResolution")) != null) {
                this.fopFactory.setSourceResolution(f.floatValue());
            }
            if ((f = this.getFloatProp("TargetResolution")) != null) {
                this.fopFactory.setTargetResolution(f.floatValue());
            }
            if ((bl = this.getBooleanProp("StrictUserConfigValidation")) != null) {
                this.fopFactory.setStrictUserConfigValidation(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("StrictValidation")) != null) {
                this.fopFactory.setStrictUserConfigValidation(bl.booleanValue());
            }
            if ((bl = this.getBooleanProp("UseCache")) != null) {
                this.fopFactory.getFontManager().setUseCache(bl.booleanValue());
            }
            if ((string = this.getStringProp("UserConfig")) != null) {
                this.fopFactory.setUserConfig(string);
            }
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
    }

    @Override
    public void format(XdmNode xdmNode, OutputStream outputStream, String string) {
        String string2 = null;
        if (string == null || "application/pdf".equalsIgnoreCase(string)) {
            string2 = "application/pdf";
        } else if ("application/PostScript".equalsIgnoreCase(string)) {
            string2 = "application/postscript";
        } else if ("application/afp".equalsIgnoreCase(string)) {
            string2 = "application/x-afp";
        } else if ("application/rtf".equalsIgnoreCase(string)) {
            string2 = "application/rtf";
        } else if ("text/plain".equalsIgnoreCase(string)) {
            string2 = "text/plain";
        } else {
            throw new XProcException(this.step.getNode(), "Unsupported content-type on p:xsl-formatter: " + string);
        }
        try {
            Object object;
            Serializable serializable;
            String string3;
            InputSource inputSource = S9apiUtils.xdmToInputSource(this.runtime, xdmNode);
            SAXSource sAXSource = new SAXSource(inputSource);
            Fop fop = this.fopFactory.newFop(string2, outputStream);
            FOUserAgent fOUserAgent = fop.getUserAgent();
            Boolean bl = this.getBooleanProp("Accessibility");
            if (bl != null) {
                fOUserAgent.setAccessibility(bl.booleanValue());
            }
            if ((string3 = this.getStringProp("Author")) != null) {
                fOUserAgent.setAuthor(string3);
            }
            fOUserAgent.setBaseURL(this.step.getNode().getBaseURI().toString());
            string3 = this.getStringProp("BaseURL");
            if (string3 != null) {
                fOUserAgent.setBaseURL(string3);
            }
            if ((bl = this.getBooleanProp("ConserveMemoryPolicy")) != null) {
                fOUserAgent.setConserveMemoryPolicy(bl.booleanValue());
            }
            if ((string3 = this.getStringProp("CreationDate")) != null) {
                serializable = DateFormat.getDateInstance();
                object = ((DateFormat)serializable).parse(string3);
                fOUserAgent.setCreationDate((Date)object);
            }
            if ((string3 = this.getStringProp("Creator")) != null) {
                fOUserAgent.setCreator(string3);
            }
            if ((string3 = this.getStringProp("Keywords")) != null) {
                fOUserAgent.setKeywords(string3);
            }
            if ((bl = this.getBooleanProp("LocatorEnabled")) != null) {
                fOUserAgent.setLocatorEnabled(bl.booleanValue());
            }
            if ((string3 = this.getStringProp("Producer")) != null) {
                fOUserAgent.setProducer(string3);
            }
            if ((string3 = this.getStringProp("Subject")) != null) {
                fOUserAgent.setSubject(string3);
            }
            if ((serializable = this.getFloatProp("TargetResolution")) != null) {
                fOUserAgent.setTargetResolution(((Float)serializable).floatValue());
            }
            if ((string3 = this.getStringProp("Title")) != null) {
                fOUserAgent.setTitle(string3);
            }
            object = TransformerFactory.newInstance();
            Transformer transformer = ((TransformerFactory)object).newTransformer();
            transformer.transform(sAXSource, new SAXResult(fop.getDefaultHandler()));
        }
        catch (Exception exception) {
            throw new XProcException(this.step.getNode(), "Failed to process FO document with FOP", (Throwable)exception);
        }
    }

    private String getStringProp(String string) {
        return this.options.getProperty(string);
    }

    private Float getFloatProp(String string) {
        String string2 = this.getStringProp(string);
        if (string2 != null) {
            try {
                float f = Float.parseFloat(string2);
                return new Float(f);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private Boolean getBooleanProp(String string) {
        String string2 = this.options.getProperty(string);
        if (string2 != null) {
            return "true".equals(string2);
        }
        return null;
    }
}

