/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.nio.charset.Charset;
import java.util.Set;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQMetaData;
import net.sf.saxon.Version;
import net.sf.saxon.xqj.SaxonXQConnection;

public class SaxonXQMetaData
implements XQMetaData {
    private SaxonXQConnection connection;

    public SaxonXQMetaData(SaxonXQConnection connection) {
        this.connection = connection;
    }

    public int getMaxExpressionLength() throws XQException {
        this.checkNotClosed();
        this.checkNotClosed();
        return Integer.MAX_VALUE;
    }

    public int getMaxUserNameLength() throws XQException {
        this.checkNotClosed();
        return Integer.MAX_VALUE;
    }

    public int getProductMajorVersion() throws XQException {
        this.checkNotClosed();
        return Version.getStructuredVersionNumber()[0];
    }

    public int getProductMinorVersion() throws XQException {
        this.checkNotClosed();
        return Version.getStructuredVersionNumber()[1];
    }

    public String getProductName() throws XQException {
        this.checkNotClosed();
        return Version.getProductName();
    }

    public String getProductVersion() throws XQException {
        this.checkNotClosed();
        return Version.getProductVersion();
    }

    public Set getSupportedXQueryEncodings() throws XQException {
        this.checkNotClosed();
        return Charset.availableCharsets().keySet();
    }

    public String getUserName() throws XQException {
        this.checkNotClosed();
        return null;
    }

    public int getXQJMajorVersion() throws XQException {
        this.checkNotClosed();
        return 0;
    }

    public int getXQJMinorVersion() throws XQException {
        this.checkNotClosed();
        return 9;
    }

    public String getXQJVersion() throws XQException {
        this.checkNotClosed();
        return "0.9";
    }

    public boolean isFullAxisFeatureSupported() throws XQException {
        this.checkNotClosed();
        return true;
    }

    public boolean isModuleFeatureSupported() throws XQException {
        this.checkNotClosed();
        return true;
    }

    public boolean isReadOnly() throws XQException {
        this.checkNotClosed();
        return true;
    }

    public boolean isSchemaImportFeatureSupported() throws XQException {
        this.checkNotClosed();
        return this.connection.getConfiguration().isLicensedFeature(4);
    }

    public boolean isSchemaValidationFeatureSupported() throws XQException {
        this.checkNotClosed();
        return this.connection.getConfiguration().isLicensedFeature(4);
    }

    public boolean isSerializationFeatureSupported() throws XQException {
        this.checkNotClosed();
        return true;
    }

    public boolean isStaticTypingExtensionsSupported() throws XQException {
        this.checkNotClosed();
        return false;
    }

    public boolean isStaticTypingFeatureSupported() throws XQException {
        this.checkNotClosed();
        return false;
    }

    public boolean isTransactionSupported() throws XQException {
        this.checkNotClosed();
        return false;
    }

    public boolean isUserDefinedXMLSchemaTypeSupported() throws XQException {
        this.checkNotClosed();
        return this.connection.getConfiguration().isLicensedFeature(4);
    }

    public boolean isXQueryEncodingDeclSupported() throws XQException {
        this.checkNotClosed();
        return true;
    }

    public boolean isXQueryEncodingSupported(String encoding) throws XQException {
        this.checkNotClosed();
        return this.getSupportedXQueryEncodings().contains(encoding);
    }

    public boolean isXQueryXSupported() throws XQException {
        this.checkNotClosed();
        return false;
    }

    public boolean wasCreatedFromJDBCConnection() throws XQException {
        this.checkNotClosed();
        return false;
    }

    private void checkNotClosed() throws XQException {
        this.connection.checkNotClosed();
    }
}

