/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetIntent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import javax.xml.transform.TransformerException;

public abstract class NodeSetExpression
extends Expression {
    public abstract NodeEnumeration enumerate(Context var1, boolean var2) throws XPathException;

    public Value evaluate(Context context) throws XPathException {
        Expression expression = this.reduce(255, context);
        if (expression instanceof NodeSetValue) {
            return (Value)expression;
        }
        if (expression instanceof NodeSetExpression) {
            return new NodeSetIntent((NodeSetExpression)expression, context.getController());
        }
        Value value = expression.evaluate(context);
        if (value instanceof NodeSetValue) {
            return value;
        }
        throw new XPathException("Value must be a node-set: it is a " + expression.getClass());
    }

    public NodeInfo selectFirst(Context context) throws XPathException {
        NodeEnumeration nodeEnumeration = this.enumerate(context, false);
        if (nodeEnumeration.isSorted()) {
            if (nodeEnumeration.hasMoreElements()) {
                return nodeEnumeration.nextElement();
            }
            return null;
        }
        Controller controller = context.getController();
        NodeInfo nodeInfo = null;
        while (nodeEnumeration.hasMoreElements()) {
            NodeInfo nodeInfo2 = nodeEnumeration.nextElement();
            if (nodeInfo != null && controller.compare(nodeInfo2, nodeInfo) >= 0) continue;
            nodeInfo = nodeInfo2;
        }
        return nodeInfo;
    }

    public String evaluateAsString(Context context) throws XPathException {
        NodeInfo nodeInfo = this.selectFirst(context);
        if (nodeInfo == null) {
            return "";
        }
        return nodeInfo.getStringValue();
    }

    public void outputStringValue(Outputter outputter, Context context) throws TransformerException {
        NodeInfo nodeInfo = this.selectFirst(context);
        if (nodeInfo != null) {
            nodeInfo.copyStringValue(outputter);
        }
    }

    public boolean evaluateAsBoolean(Context context) throws XPathException {
        return this.enumerate(context, false).hasMoreElements();
    }

    public NodeSetValue evaluateAsNodeSet(Context context) throws XPathException {
        return (NodeSetValue)this.evaluate(context);
    }

    public int getDataType() {
        return 4;
    }
}

