/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.LastPositionFinder;
import com.icl.saxon.expr.LookaheadEnumerator;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.Comparer;
import com.icl.saxon.sort.NodeOrderComparer;
import com.icl.saxon.sort.QuickSort;
import com.icl.saxon.sort.SortKeyDefinition;
import com.icl.saxon.sort.Sortable;

public final class SortKeyEnumeration
implements NodeEnumeration,
LastPositionFinder,
Sortable {
    protected NodeEnumeration base;
    private SortKeyDefinition[] sortkeys;
    private int recordSize;
    private Object[] nodeKeys;
    private int count = -1;
    private int index = 0;
    private Context context;
    private Controller controller;
    private Comparer[] keyComparers;

    public SortKeyEnumeration(Context context, NodeEnumeration nodeEnumeration, SortKeyDefinition[] sortKeyDefinitionArray) throws XPathException {
        this.context = context.newContext();
        this.controller = context.getController();
        this.base = nodeEnumeration;
        this.sortkeys = sortKeyDefinitionArray;
        this.recordSize = sortKeyDefinitionArray.length + 1;
        this.keyComparers = new Comparer[sortKeyDefinitionArray.length];
        int n = 0;
        while (n < sortKeyDefinitionArray.length) {
            this.keyComparers[n] = sortKeyDefinitionArray[n].getComparer(context);
            ++n;
        }
        if (!this.base.isSorted()) {
            Object object;
            boolean bl = false;
            int n2 = 0;
            while (n2 < sortKeyDefinitionArray.length) {
                object = sortKeyDefinitionArray[n2];
                Expression expression = ((SortKeyDefinition)object).getSortKey();
                if ((expression.getDependencies() & 0x30) != 0) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) {
                object = new NodeSetExtent(this.base, (NodeOrderComparer)this.controller);
                ((NodeSetExtent)object).sort();
                this.base = ((NodeSetExtent)object).enumerate();
            }
        }
    }

    public boolean hasMoreElements() {
        if (this.count < 0) {
            return this.base.hasMoreElements();
        }
        return this.index < this.count;
    }

    public NodeInfo nextElement() throws XPathException {
        if (this.count < 0) {
            this.doSort();
        }
        return (NodeInfo)this.nodeKeys[this.index++ * this.recordSize];
    }

    public boolean isSorted() {
        return true;
    }

    public boolean isReverseSorted() {
        return false;
    }

    public boolean isPeer() {
        return this.base.isPeer();
    }

    public int getLastPosition() throws XPathException {
        if (this.base instanceof LastPositionFinder && !(this.base instanceof LookaheadEnumerator)) {
            return ((LastPositionFinder)((Object)this.base)).getLastPosition();
        }
        if (this.count < 0) {
            this.doSort();
        }
        return this.count;
    }

    private void buildArray() throws XPathException {
        int n;
        if (this.base instanceof LastPositionFinder && !(this.base instanceof LookaheadEnumerator)) {
            n = ((LastPositionFinder)((Object)this.base)).getLastPosition();
            this.context.setLast(n);
        } else {
            n = 100;
        }
        this.nodeKeys = new Object[n * this.recordSize];
        this.count = 0;
        while (this.base.hasMoreElements()) {
            NodeInfo nodeInfo = this.base.nextElement();
            if (this.count == n) {
                Object[] objectArray = new Object[(n *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, objectArray, 0, this.count * this.recordSize);
                this.nodeKeys = objectArray;
            }
            this.context.setCurrentNode(nodeInfo);
            this.context.setContextNode(nodeInfo);
            this.context.setPosition(this.count + 1);
            int n2 = this.count * this.recordSize;
            this.nodeKeys[n2] = nodeInfo;
            int n3 = 0;
            while (n3 < this.sortkeys.length) {
                this.nodeKeys[n2 + n3 + 1] = this.sortkeys[n3].getSortKey().evaluateAsString(this.context);
                ++n3;
            }
            ++this.count;
        }
    }

    private void diag() {
        System.err.println("Diagnostic print of keys");
        int n = 0;
        while (n < this.count * this.recordSize) {
            System.err.println(n + " : " + this.nodeKeys[n]);
            ++n;
        }
    }

    private void doSort() throws XPathException {
        this.buildArray();
        if (this.count < 2) {
            return;
        }
        QuickSort.sort(this, 0, this.count - 1);
    }

    public int compare(int n, int n2) {
        int n3 = n * this.recordSize + 1;
        int n4 = n2 * this.recordSize + 1;
        int n5 = 0;
        while (n5 < this.sortkeys.length) {
            Comparer comparer = this.keyComparers[n5];
            int n6 = comparer.compare(this.nodeKeys[n3 + n5], this.nodeKeys[n4 + n5]);
            if (n6 != 0) {
                return n6;
            }
            ++n5;
        }
        return this.controller.compare((NodeInfo)this.nodeKeys[n3 - 1], (NodeInfo)this.nodeKeys[n4 - 1]);
    }

    public void swap(int n, int n2) {
        int n3 = n * this.recordSize;
        int n4 = n2 * this.recordSize;
        int n5 = 0;
        while (n5 < this.recordSize) {
            Object object = this.nodeKeys[n3 + n5];
            this.nodeKeys[n3 + n5] = this.nodeKeys[n4 + n5];
            this.nodeKeys[n4 + n5] = object;
            ++n5;
        }
    }
}

