/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.lucene.store.RAMDirectory;

class RAMFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<byte[]> buffers = new ArrayList();
    long length;
    RAMDirectory directory;
    long sizeInBytes;
    private long lastModified = System.currentTimeMillis();

    RAMFile() {
    }

    RAMFile(RAMDirectory directory) {
        this.directory = directory;
    }

    synchronized long getLength() {
        return this.length;
    }

    synchronized void setLength(long length) {
        this.length = length;
    }

    synchronized long getLastModified() {
        return this.lastModified;
    }

    synchronized void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized byte[] addBuffer(int size) {
        byte[] buffer = this.newBuffer(size);
        if (this.directory != null) {
            RAMDirectory rAMDirectory = this.directory;
            synchronized (rAMDirectory) {
                this.buffers.add(buffer);
                this.directory.sizeInBytes += (long)size;
                this.sizeInBytes += (long)size;
            }
        } else {
            this.buffers.add(buffer);
        }
        return buffer;
    }

    final synchronized byte[] getBuffer(int index) {
        return this.buffers.get(index);
    }

    final synchronized int numBuffers() {
        return this.buffers.size();
    }

    byte[] newBuffer(int size) {
        return new byte[size];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getSizeInBytes() {
        RAMDirectory rAMDirectory = this.directory;
        synchronized (rAMDirectory) {
            return this.sizeInBytes;
        }
    }
}

