/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import java.util.StringTokenizer;

public class NormalizeSpace
extends Function {
    public String getName() {
        return "normalize-space";
    }

    public int getDataType() {
        return 3;
    }

    public Expression simplify() throws XPathException {
        int n = this.checkArgumentCount(0, 1);
        if (n == 1) {
            this.argument[0] = this.argument[0].simplify();
            if (this.argument[0] instanceof Value) {
                return this.evaluate(null);
            }
        }
        return this;
    }

    public String evaluateAsString(Context context) throws XPathException {
        if (this.getNumberOfArguments() == 1) {
            return NormalizeSpace.normalize(this.argument[0].evaluateAsString(context));
        }
        return NormalizeSpace.normalize(context.getContextNodeInfo().getStringValue());
    }

    public Value evaluate(Context context) throws XPathException {
        return new StringValue(this.evaluateAsString(context));
    }

    public int getDependencies() {
        if (this.getNumberOfArguments() == 1) {
            return this.argument[0].getDependencies();
        }
        return 8;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        if (this.getNumberOfArguments() == 1) {
            NormalizeSpace normalizeSpace = new NormalizeSpace();
            normalizeSpace.addArgument(this.argument[0].reduce(n, context));
            normalizeSpace.setStaticContext(this.getStaticContext());
            return normalizeSpace.simplify();
        }
        if ((n & 8) != 0) {
            return this.evaluate(context);
        }
        return this;
    }

    private static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

