/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSetDISI;

public class CachingWrapperFilter
extends Filter {
    Filter filter;
    transient Map<IndexReader, DocIdSet> cache;
    private final ReentrantLock lock = new ReentrantLock();

    public CachingWrapperFilter(Filter filter) {
        this.filter = filter;
    }

    protected DocIdSet docIdSetToCache(DocIdSet docIdSet, IndexReader reader) throws IOException {
        if (docIdSet.isCacheable()) {
            return docIdSet;
        }
        DocIdSetIterator it = docIdSet.iterator();
        return it == null ? DocIdSet.EMPTY_DOCIDSET : new OpenBitSetDISI(it, reader.maxDoc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        block7: {
            this.lock.lock();
            try {
                DocIdSet cached;
                if (this.cache == null) {
                    this.cache = new WeakHashMap<IndexReader, DocIdSet>();
                }
                if ((cached = this.cache.get(reader)) == null) break block7;
                DocIdSet docIdSet = cached;
                Object var5_4 = null;
                this.lock.unlock();
                return docIdSet;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
        Object var5_5 = null;
        this.lock.unlock();
        DocIdSet docIdSet = this.docIdSetToCache(this.filter.getDocIdSet(reader), reader);
        if (docIdSet != null) {
            this.lock.lock();
            try {
                this.cache.put(reader, docIdSet);
                Object var7_8 = null;
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.lock.unlock();
                throw throwable;
            }
        }
        return docIdSet;
    }

    public String toString() {
        return "CachingWrapperFilter(" + this.filter + ")";
    }

    public boolean equals(Object o) {
        if (!(o instanceof CachingWrapperFilter)) {
            return false;
        }
        return this.filter.equals(((CachingWrapperFilter)o).filter);
    }

    public int hashCode() {
        return this.filter.hashCode() ^ 0x1117BF25;
    }
}

