/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.Outputter;
import com.icl.saxon.output.StringEmitter;
import com.icl.saxon.output.TextFragment;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;

public final class StringOutputter
extends Outputter {
    StringBuffer buffer;
    int ignoreElements = 0;
    ErrorListener errorListener = null;

    public StringOutputter(StringBuffer stringBuffer) {
        this.buffer = stringBuffer;
        this.emitter = new StringEmitter(stringBuffer);
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void reset() throws TransformerException {
    }

    public Properties getOutputProperties() {
        return TextFragment.getProperties();
    }

    public void write(String string) throws TransformerException {
        if (this.ignoreElements == 0) {
            this.buffer.append(string);
        }
    }

    public void writeContent(String string) throws TransformerException {
        if (string == null) {
            return;
        }
        if (this.ignoreElements == 0) {
            this.buffer.append(string);
        }
    }

    public void writeContent(char[] cArray, int n, int n2) throws TransformerException {
        if (this.ignoreElements == 0) {
            this.buffer.append(cArray, n, n2);
        }
    }

    public void writeStartTag(int n) throws TransformerException {
        this.reportRecoverableError();
        ++this.ignoreElements;
    }

    private void reportRecoverableError() throws TransformerException {
        if (this.errorListener != null) {
            this.errorListener.warning(new TransformerException("Non-text output nodes are ignored when writing an attribute, comment, or PI"));
        }
    }

    public int checkAttributePrefix(int n) throws TransformerException {
        return n;
    }

    public void writeNamespaceDeclaration(int n) throws TransformerException {
    }

    public void copyNamespaceNode(int n) throws TransformerException {
    }

    public boolean thereIsAnOpenStartTag() {
        return false;
    }

    public void writeAttribute(int n, String string, boolean bl) throws TransformerException {
        this.reportRecoverableError();
    }

    public void writeEndTag(int n) throws TransformerException {
        --this.ignoreElements;
    }

    public void writeComment(String string) throws TransformerException {
        this.reportRecoverableError();
    }

    public void writePI(String string, String string2) throws TransformerException {
        this.reportRecoverableError();
    }

    public void close() throws TransformerException {
    }
}

