/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.CopyNamespaceSensitiveException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.tiny.TinyParentNodeImpl;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.tree.tiny.WhitespaceTextImpl;
import net.sf.saxon.tree.util.NamespaceCodeIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

public final class TinyElementImpl
extends TinyParentNodeImpl {
    public TinyElementImpl(TinyTree tree, int nodeNr) {
        this.tree = tree;
        this.nodeNr = nodeNr;
    }

    public final int getNodeKind() {
        return 1;
    }

    public String getBaseURI() {
        return Navigator.getBaseURI(this);
    }

    public int getTypeAnnotation() {
        return this.tree.getTypeAnnotation(this.nodeNr);
    }

    public SequenceIterator getTypedValue() throws XPathException {
        return this.tree.getTypedValueOfElement(this).iterate();
    }

    public Value atomize() throws XPathException {
        return this.tree.getTypedValueOfElement(this);
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        return TinyElementImpl.getDeclaredNamespaces(this.tree, this.nodeNr, buffer);
    }

    public static int[] getDeclaredNamespaces(TinyTree tree, int nodeNr, int[] buffer) {
        int ns = tree.beta[nodeNr];
        if (ns > 0) {
            int count = 0;
            while (ns < tree.numberOfNamespaces && tree.namespaceParent[ns] == nodeNr) {
                ++count;
                ++ns;
            }
            if (count == 0) {
                return NodeInfo.EMPTY_NAMESPACE_LIST;
            }
            if (buffer != null && count <= buffer.length) {
                System.arraycopy(tree.namespaceCode, tree.beta[nodeNr], buffer, 0, count);
                if (count < buffer.length) {
                    buffer[count] = -1;
                }
                return buffer;
            }
            int[] array = new int[count];
            System.arraycopy(tree.namespaceCode, tree.beta[nodeNr], array, 0, count);
            return array;
        }
        return NodeInfo.EMPTY_NAMESPACE_LIST;
    }

    public static int[] getInScopeNamespaces(TinyTree tree, int nodeNr, int[] buffer) {
        if (buffer == null || buffer.length == 0) {
            buffer = new int[10];
        }
        buffer[0] = 65537;
        int used = 1;
        if (tree.usesNamespaces) {
            do {
                int ns;
                if ((ns = tree.beta[nodeNr]) <= 0) continue;
                while (ns < tree.numberOfNamespaces && tree.namespaceParent[ns] == nodeNr) {
                    int nscode = tree.namespaceCode[ns];
                    short prefixCode = (short)(nscode >> 16);
                    boolean duplicate = false;
                    for (int i = 0; i < used; ++i) {
                        if (buffer[i] >> 16 != prefixCode) continue;
                        duplicate = true;
                        break;
                    }
                    if (!duplicate) {
                        if (used >= buffer.length) {
                            int[] b2 = new int[used * 2];
                            System.arraycopy(buffer, 0, b2, 0, used);
                            buffer = b2;
                        }
                        buffer[used++] = nscode;
                    }
                    ++ns;
                }
            } while ((nodeNr = TinyElementImpl.getParentNodeNr(tree, nodeNr)) != -1);
            int j = 0;
            for (int i = 0; i < used; ++i) {
                int nscode = buffer[i];
                if ((nscode & 0xFFFF) == 0) continue;
                buffer[j++] = nscode;
            }
            used = j;
        }
        if (used < buffer.length) {
            buffer[used] = -1;
        }
        return buffer;
    }

    public String getAttributeValue(int fingerprint) {
        int a = this.tree.alpha[this.nodeNr];
        if (a < 0) {
            return null;
        }
        while (a < this.tree.numberOfAttributes && this.tree.attParent[a] == this.nodeNr) {
            if ((this.tree.attCode[a] & 0xFFFFF) == fingerprint) {
                return ((Object)this.tree.attValue[a]).toString();
            }
            ++a;
        }
        return null;
    }

    public void copy(Receiver receiver, int copyOptions, int locationId) throws XPathException {
        short level = -1;
        boolean closePending = false;
        short startLevel = this.tree.depth[this.nodeNr];
        boolean first = true;
        boolean disallowNamespaceSensitiveContent = (copyOptions & 4) != 0 && (copyOptions & 3) == 0;
        Configuration config = this.tree.getConfiguration();
        int next = this.nodeNr;
        CopyInformee informee = receiver.getPipelineConfiguration().getCopyInformee();
        do {
            short nodeLevel = this.tree.depth[next];
            if (closePending) {
                level = (short)(level + 1);
            }
            while (level > nodeLevel) {
                receiver.endElement();
                level = (short)(level - 1);
            }
            level = nodeLevel;
            switch (this.tree.nodeKind[next]) {
                case 1: {
                    int typeCode;
                    int n = typeCode = CopyOptions.includes(copyOptions, 4) ? this.tree.getTypeAnnotation(next) : 630;
                    if (disallowNamespaceSensitiveContent) {
                        this.checkNotNamespaceSensitiveElement(config, typeCode, next);
                    }
                    if (informee != null) {
                        locationId = informee.notifyElementNode(this.tree.getNode(next));
                    }
                    int nameCode = this.tree.nameCode[next];
                    receiver.startElement(nameCode, typeCode, locationId, first ? 0 : 64);
                    closePending = true;
                    if ((copyOptions & 3) != 0 && this.tree.usesNamespaces) {
                        if (first) {
                            if ((copyOptions & 1) != 0) {
                                int ns;
                                int[] localNamespaces = this.getDeclaredNamespaces(null);
                                for (int i = 0; i < localNamespaces.length && (ns = localNamespaces[i]) != -1; ++i) {
                                    receiver.namespace(ns, 0);
                                }
                            } else if ((copyOptions & 2) != 0) {
                                NamespaceCodeIterator.sendNamespaces(this, receiver);
                            }
                        } else {
                            int ns = this.tree.beta[next];
                            if (ns > 0) {
                                while (ns < this.tree.numberOfNamespaces && this.tree.namespaceParent[ns] == next) {
                                    int nscode = this.tree.namespaceCode[ns];
                                    receiver.namespace(nscode, 0);
                                    ++ns;
                                }
                            }
                        }
                    }
                    first = false;
                    int att = this.tree.alpha[next];
                    if (att >= 0) {
                        while (att < this.tree.numberOfAttributes && this.tree.attParent[att] == next) {
                            int attType;
                            int attCode = this.tree.attCode[att];
                            int n2 = attType = CopyOptions.includes(copyOptions, 4) ? this.tree.getAttributeAnnotation(att) : 631;
                            if (disallowNamespaceSensitiveContent) {
                                this.checkNotNamespaceSensitiveAttribute(config, attType, att);
                            }
                            receiver.attribute(attCode, attType, this.tree.attValue[att], locationId, 0);
                            ++att;
                        }
                    }
                    receiver.startContent();
                    break;
                }
                case 3: {
                    closePending = false;
                    CharSequence value = TinyTextImpl.getStringValue(this.tree, next);
                    receiver.characters(value, locationId, 1024);
                    break;
                }
                case 4: {
                    closePending = false;
                    CharSequence value = WhitespaceTextImpl.getStringValueCS(this.tree, next);
                    receiver.characters(value, locationId, 1024);
                    break;
                }
                case 8: {
                    closePending = false;
                    int start = this.tree.alpha[next];
                    int len = this.tree.beta[next];
                    if (len > 0) {
                        receiver.comment(this.tree.commentBuffer.subSequence(start, start + len), locationId, 0);
                        break;
                    }
                    receiver.comment("", 0, 0);
                    break;
                }
                case 7: {
                    closePending = false;
                    TinyNodeImpl pi = this.tree.getNode(next);
                    receiver.processingInstruction(pi.getLocalPart(), pi.getStringValue(), locationId, 0);
                    break;
                }
                case 12: {
                    closePending = false;
                }
            }
        } while (++next < this.tree.numberOfNodes && this.tree.depth[next] > startLevel);
        if (closePending) {
            level = (short)(level + 1);
        }
        while (level > startLevel) {
            receiver.endElement();
            level = (short)(level - 1);
        }
    }

    private void checkNotNamespaceSensitiveElement(Configuration config, int typeCode, int nodeNr) throws XPathException {
        SchemaType type = config.getSchemaType(typeCode & 0xFFFFF);
        if (type instanceof SimpleType && ((SimpleType)type).isNamespaceSensitive()) {
            AtomicValue val;
            if (type.isAtomicType()) {
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
            Value value = this.tree.getTypedValueOfElement(nodeNr);
            SequenceIterator iter = value.iterate();
            do {
                if ((val = (AtomicValue)iter.next()) != null) continue;
                return;
            } while (!val.getPrimitiveType().isNamespaceSensitive());
            throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
        }
    }

    private void checkNotNamespaceSensitiveAttribute(Configuration config, int typeCode, int nodeNr) throws XPathException {
        SchemaType type = config.getSchemaType(typeCode & 0xFFFFF);
        if (type instanceof SimpleType && ((SimpleType)type).isNamespaceSensitive()) {
            AtomicValue val;
            if (type.isAtomicType()) {
                throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
            }
            Value value = this.tree.getTypedValueOfAttribute(null, nodeNr);
            SequenceIterator iter = value.iterate();
            do {
                if ((val = (AtomicValue)iter.next()) != null) continue;
                return;
            } while (!val.getPrimitiveType().isNamespaceSensitive());
            throw new CopyNamespaceSensitiveException("Cannot copy QName or NOTATION values without copying namespaces");
        }
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        NodeInfo parent;
        if (!(useDefault || prefix != null && prefix.length() != 0)) {
            return "";
        }
        short prefixCode = this.getNamePool().getCodeForPrefix(prefix);
        if (prefixCode == -1) {
            return null;
        }
        int ns = this.tree.beta[this.nodeNr];
        if (ns > 0) {
            while (ns < this.tree.numberOfNamespaces && this.tree.namespaceParent[ns] == this.nodeNr) {
                int nscode = this.tree.namespaceCode[ns];
                if (nscode >> 16 == prefixCode) {
                    int uriCode = nscode & 0xFFFF;
                    if (uriCode == 0) {
                        if (prefixCode == 0) {
                            return "";
                        }
                        return null;
                    }
                    return this.getNamePool().getURIFromURICode((short)uriCode);
                }
                ++ns;
            }
        }
        if ((parent = this.getParent()) instanceof NamespaceResolver) {
            return ((NamespaceResolver)((Object)parent)).getURIForPrefix(prefix, useDefault);
        }
        return null;
    }

    public boolean isId() {
        return this.tree.isIdElement(this.nodeNr);
    }

    public boolean isIdref() {
        return this.tree.isIdrefElement(this.nodeNr);
    }
}

