# Copyright 2024-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.4

EAPI=8

CRATES="
	adler2@2.0.0
	anstream@0.6.18
	anstyle-parse@0.2.6
	anstyle-query@1.1.2
	anstyle-wincon@3.0.6
	anstyle@1.0.10
	autocfg@1.4.0
	bitflags@1.3.2
	bitflags@2.6.0
	bitvec@1.0.1
	bumpalo@3.16.0
	bytemuck@1.20.0
	byteorder-lite@0.1.0
	cc@1.2.1
	cfg-if@1.0.0
	clap@4.5.21
	clap_builder@4.5.21
	clap_lex@0.7.3
	colorchoice@1.0.3
	crc32fast@1.4.2
	crossbeam-channel@0.5.13
	crossbeam-deque@0.8.5
	crossbeam-epoch@0.9.18
	crossbeam-utils@0.8.20
	either@1.13.0
	env_filter@0.1.2
	env_logger@0.11.5
	equivalent@1.0.1
	errno@0.3.9
	fdeflate@0.3.6
	filetime@0.2.25
	flate2@1.0.35
	funty@2.0.0
	glob@0.3.1
	hashbrown@0.15.1
	image@0.25.5
	indexmap@2.6.0
	is_terminal_polyfill@1.70.1
	libc@0.2.164
	libdeflate-sys@1.22.0
	libdeflater@1.22.0
	libredox@0.1.3
	linux-raw-sys@0.4.14
	lockfree-object-pool@0.1.6
	log@0.4.22
	miniz_oxide@0.8.0
	num-traits@0.2.19
	once_cell@1.20.2
	pkg-config@0.3.31
	png@0.17.14
	radium@0.7.0
	rayon-core@1.12.1
	rayon@1.10.0
	redox_syscall@0.5.7
	rgb@0.8.50
	rustc-hash@2.0.0
	rustix@0.38.41
	shlex@1.3.0
	simd-adler32@0.3.7
	strsim@0.11.1
	tap@1.0.1
	terminal_size@0.4.0
	utf8parse@0.2.2
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.52.6
	wyz@0.5.1
	zopfli@0.8.1
"

RUST_MIN_VER="1.74.0"

inherit cargo

DESCRIPTION="Multithreaded lossless PNG compression optimizer written in Rust"
HOMEPAGE="https://github.com/shssoichiro/oxipng"
SRC_URI="
	https://github.com/shssoichiro/oxipng/archive/v${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+=" Apache-2.0 Boost-1.0 MIT"
SLOT="0"
KEYWORDS="~amd64 ~arm64 ~riscv ~x86"
# oxipng-9.1.3-add-system-libdeflate-feature.patch:
# Force oxipng to use system libdeflate.
# Note that `system-libdeflate` feature will be introduced since the
# next version of oxipng 9.1.3, and then this patch won't be necessary.
# https://github.com/shssoichiro/oxipng/pull/659
PATCHES=( "${FILESDIR}/oxipng-9.1.3-add-system-libdeflate-feature.patch" )

BDEPEND="virtual/pkgconfig"
DEPEND=">=app-arch/libdeflate-1.22:="
RDEPEND="${DEPEND}"

# rust does not use *FLAGS from make.conf, silence portage warning
# update with proper path to binaries this crate installs, omit leading /
QA_FLAGS_IGNORED="usr/bin/${PN}"
QA_PRESTRIPPED="usr/bin/${PN}"

src_prepare() {
	pushd "${WORKDIR}" || die
	eapply "${FILESDIR}"/oxipng-9.1.3-libdeflater-1.22.0-relax-libdeflate-sys-version.patch
	popd > /dev/null || die

	# Remove the linker configs (in `.cargo/config.toml`) specific to GitHub CI.
	# https://bugs.gentoo.org/924946
	rm -rv "${S}/.cargo/config.toml" || die

	default_src_prepare
}

src_configure() {
	export PKG_CONFIG_ALLOW_CROSS=1
	local myfeatures=(
		system-libdeflate
	)

	cargo_src_configure
}

src_install() {
	cargo_src_install

	dodoc CHANGELOG.md README.md
}
