# Copyright 2017-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

CRATES=""

inherit cargo tmpfiles

DESCRIPTION="TUI greeter for greetd login manager"
HOMEPAGE="https://github.com/apognu/tuigreet"
if [ ${PV} == "9999" ] ; then
	inherit git-r3
	EGIT_REPO_URI="https://github.com/apognu/${PN}"
else
	SRC_URI="https://github.com/apognu/${PN}/archive/${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}"
	KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv"
fi

LICENSE="GPL-3+"
# Autogenerated by pycargoebuild
# Dependent crate licenses
LICENSE+=" Apache-2.0 CC0-1.0 GPL-3 MIT Unicode-3.0 Unicode-DFS-2016"
SLOT="0"

QA_FLAGS_IGNORED="usr/bin/tuigreet"

RDEPEND="
	acct-group/greetd
	acct-user/greetd
	gui-libs/greetd"
DEPEND="${RDEPEND}"
BDEPEND="app-text/scdoc"

src_unpack() {
	if [[ "${PV}" == *9999* ]]; then
		git-r3_src_unpack
		cargo_live_src_unpack
	else
		cargo_src_unpack
	fi
}

src_compile() {
	cargo_src_compile
	scdoc < ./contrib/man/tuigreet-1.scd > ./tuigreet.1 || die
}

src_install() {
	newtmpfiles - tuigreet.conf <<-EOF
		d /var/cache/tuigreet 0755 greetd greetd
	EOF
	doman tuigreet.1
	cargo_src_install
}

pkg_postinst() {
	tmpfiles_process tuigreet.conf
}
