# Copyright 2025-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.1

EAPI=8

CRATES="
	aho-corasick@1.1.4
	android_system_properties@0.1.5
	anstream@0.6.21
	anstyle-parse@0.2.7
	anstyle-query@1.1.5
	anstyle-wincon@3.0.11
	anstyle@1.0.13
	autocfg@1.5.0
	bit_field@0.10.3
	bitflags@1.3.2
	bitflags@2.10.0
	block-buffer@0.10.4
	built@0.8.0
	bumpalo@3.19.1
	cc@1.2.53
	cfg-if@1.0.4
	cfg_aliases@0.2.1
	chrono@0.4.43
	clap-num@1.2.0
	clap-verbosity-flag@3.0.4
	clap@4.5.54
	clap_builder@4.5.54
	clap_derive@4.5.49
	clap_lex@0.7.7
	colorchoice@1.0.4
	convert_case@0.4.0
	core-foundation-sys@0.6.2
	core-foundation-sys@0.8.7
	core-foundation@0.6.4
	cpufeatures@0.2.17
	crypto-common@0.1.7
	darling@0.20.11
	darling_core@0.20.11
	darling_macro@0.20.11
	derive_more@0.99.20
	digest@0.10.7
	displaydoc@0.2.5
	embed-resource@3.0.6
	env_filter@0.1.4
	env_logger@0.11.8
	equivalent@1.0.2
	find-msvc-tools@0.1.8
	fnv@1.0.7
	form_urlencoded@1.2.2
	futures-channel@0.3.31
	futures-core@0.3.31
	futures-executor@0.3.31
	futures-io@0.3.31
	futures-macro@0.3.31
	futures-sink@0.3.31
	futures-task@0.3.31
	futures-util@0.3.31
	futures@0.3.31
	generic-array@0.14.7
	getopts@0.2.24
	getrandom@0.3.4
	git2@0.20.3
	guid-create@0.5.2
	hashbrown@0.16.1
	heck@0.5.0
	hidapi@2.6.4
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.64
	icu_collections@2.1.1
	icu_locale_core@2.1.1
	icu_normalizer@2.1.1
	icu_normalizer_data@2.1.1
	icu_properties@2.1.2
	icu_properties_data@2.1.2
	icu_provider@2.1.1
	ident_case@1.0.1
	idna@1.1.0
	idna_adapter@1.2.1
	indexmap@2.13.0
	io-kit-sys@0.1.0
	is_terminal_polyfill@1.70.2
	itoa@1.0.17
	jiff-static@0.2.18
	jiff@0.2.18
	jobserver@0.1.34
	js-sys@0.3.85
	lazy_static@1.5.0
	libc@0.2.180
	libgit2-sys@0.18.3+1.9.2
	libloading@0.8.9
	libusb1-sys@0.7.0
	libz-sys@1.1.23
	litemap@0.8.1
	lock_api@0.4.14
	log@0.4.29
	mach@0.2.3
	mach@0.3.2
	memchr@2.7.6
	memoffset@0.6.5
	nix@0.25.1
	nix@0.30.1
	no-std-compat@0.4.1
	num-complex@0.4.6
	num-derive@0.4.2
	num-integer@0.1.46
	num-iter@0.1.45
	num-rational@0.4.2
	num-traits@0.2.19
	num@0.4.3
	nvml-wrapper-sys@0.9.0
	nvml-wrapper@0.11.0
	once_cell@1.21.3
	once_cell_polyfill@1.70.2
	percent-encoding@2.3.2
	pin-project-lite@0.2.16
	pin-utils@0.1.0
	pkg-config@0.3.32
	plain@0.2.3
	portable-atomic-util@0.2.4
	portable-atomic@1.13.0
	potential_utf@0.1.4
	proc-macro2@1.0.105
	ptr_meta@0.2.0
	ptr_meta_derive@0.2.0
	quote@1.0.43
	r-efi@5.3.0
	regex-automata@0.4.13
	regex-syntax@0.8.8
	regex@1.12.2
	rusb@0.9.4
	rustc_version@0.4.1
	rustversion@1.0.22
	scopeguard@1.2.0
	semver@1.0.27
	serde@1.0.228
	serde_core@1.0.228
	serde_derive@1.0.228
	serde_json@1.0.149
	serde_spanned@1.0.4
	sha2@0.10.9
	shlex@1.3.0
	slab@0.4.11
	smallvec@1.15.1
	spin@0.10.0
	spin@0.9.8
	stable_deref_trait@1.2.1
	static_assertions@1.1.0
	static_vcruntime@3.0.0
	strsim@0.11.1
	syn@1.0.109
	syn@2.0.114
	synstructure@0.13.2
	thiserror-impl@1.0.69
	thiserror-impl@2.0.17
	thiserror@1.0.69
	thiserror@2.0.17
	tinystr@0.8.2
	toml@0.9.11+spec-1.1.0
	toml_datetime@0.7.5+spec-1.1.0
	toml_parser@1.0.6+spec-1.1.0
	toml_writer@1.0.6+spec-1.1.0
	typenum@1.19.0
	ucs2@0.3.3
	uefi-macros@0.11.0
	unicode-ident@1.0.22
	unicode-width@0.2.2
	url@2.5.8
	utf8_iter@1.0.4
	utf8parse@0.2.2
	vcpkg@0.2.15
	version_check@0.9.5
	vswhom-sys@0.1.3
	vswhom@0.1.0
	wasip2@1.0.2+wasi-0.2.9
	wasm-bindgen-macro-support@0.2.108
	wasm-bindgen-macro@0.2.108
	wasm-bindgen-shared@0.2.108
	wasm-bindgen@0.2.108
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-collections@0.3.2
	windows-core@0.62.2
	windows-future@0.3.2
	windows-implement@0.60.2
	windows-interface@0.59.3
	windows-link@0.2.1
	windows-numerics@0.3.1
	windows-result@0.4.1
	windows-strings@0.5.1
	windows-sys@0.48.0
	windows-sys@0.59.0
	windows-sys@0.61.2
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows-threading@0.2.1
	windows-version@0.1.7
	windows@0.62.2
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	winnow@0.7.14
	winreg@0.55.0
	winresource@0.1.29
	wit-bindgen@0.51.0
	wmi@0.18.0
	wrapcenum-derive@0.4.1
	writeable@0.6.2
	yoke-derive@0.8.1
	yoke@0.8.1
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zerotrie@0.2.3
	zerovec-derive@0.11.2
	zerovec@0.11.5
	zmij@1.0.14
"

declare -A GIT_CRATES=(
	[guid-create]='https://github.com/FrameworkComputer/guid-create;84c3ad2e8b64a12beebb460804a65da55434cfd9;guid-create-%commit%'
	[redox_hwio]='https://github.com/FrameworkComputer/rust-hwio;9bcff4277d8f3d7dce2b12c6ad81d092ae35c4ba;rust-hwio-%commit%'
	[smbios-lib]='https://github.com/FrameworkComputer/smbios-lib;b3e2fff8a6f4b8c2d729467cbbf0c8c41974cd1c;smbios-lib-%commit%'
	[uefi-services]='https://github.com/FrameworkComputer/uefi-rs;95165e1adde99da7a460320538d908af8b55f87f;uefi-rs-%commit%/uefi-services'
	[uefi]='https://github.com/FrameworkComputer/uefi-rs;95165e1adde99da7a460320538d908af8b55f87f;uefi-rs-%commit%/uefi'
)

RUST_MIN_VER="1.87.0"

inherit shell-completion cargo

DESCRIPTION="Tool to control Framework Computer systems"
HOMEPAGE="https://github.com/FrameworkComputer/framework-system"
SRC_URI="
	https://github.com/FrameworkComputer/framework-system/archive/refs/tags/v${PV}.tar.gz -> ${P}.gh.tar.gz
	${CARGO_CRATE_URIS}
"
S="${WORKDIR}/framework-system-${PV}/${PN}"

LICENSE="BSD"
# Dependent crate licenses
LICENSE+=" BSD-2 ISC MIT MPL-2.0 Unicode-3.0"
SLOT="0"
KEYWORDS="~amd64"

QA_FLAGS_IGNORED="usr/bin/.*"

DOCS=(
	README.md
	support-matrices.md
)

src_unpack() {
	cargo_src_unpack

	# if more packages require this sort of hack, probably want to change the eclass
	sed -e "s|'https://github.com/FrameworkComputer/uefi-rs'|crates-io|" \
		-i ${CARGO_HOME}/config.toml || die
}

src_install() {
	cargo_src_install

	pushd "${S%${PN}}" > /dev/null || die
	dodoc "${DOCS[@]}"

	dobashcomp completions/bash/${PN}
	dozshcomp completions/zsh/_${PN}
	popd > /dev/null || die
}
