# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

CRATES="
	addr2line@0.24.2
	adler2@2.0.1
	aho-corasick@1.1.3
	allocator-api2@0.2.21
	anstream@0.6.20
	anstyle-parse@0.2.7
	anstyle-query@1.1.4
	anstyle-wincon@3.0.10
	anstyle@1.0.11
	anyhow@1.0.99
	assert_cmd@2.0.17
	autocfg@1.5.0
	backtrace@0.3.75
	base64@0.22.1
	bitflags@1.3.2
	bitflags@2.9.1
	bstr@1.12.0
	byteorder@1.5.0
	cargo-husky@1.5.0
	cassowary@0.3.0
	castaway@0.2.4
	cfg-if@1.0.1
	cfg_aliases@0.1.1
	cfg_aliases@0.2.1
	clap@4.5.45
	clap_builder@4.5.44
	clap_complete@4.5.57
	clap_complete_fig@4.5.2
	clap_complete_nushell@4.5.8
	clap_derive@4.5.45
	clap_lex@0.7.5
	clap_mangen@0.2.29
	colorchoice@1.0.4
	compact_str@0.8.1
	concat-string@1.0.1
	convert_case@0.7.1
	core-foundation-sys@0.8.7
	core-foundation@0.10.1
	crossterm@0.28.1
	crossterm@0.29.0
	crossterm_winapi@0.9.1
	ctrlc@3.4.7
	darling@0.20.11
	darling_core@0.20.11
	darling_macro@0.20.11
	deranged@0.4.0
	derive_more-impl@2.0.1
	derive_more@2.0.1
	difflib@0.4.0
	dirs-sys@0.5.0
	dirs@6.0.0
	doc-comment@0.3.3
	document-features@0.2.11
	downcast-rs@1.2.1
	dyn-clone@1.0.20
	either@1.15.0
	enum-as-inner@0.6.1
	equivalent@1.0.2
	errno@0.3.13
	fastrand@2.3.0
	fern@0.7.1
	filedescriptor@0.8.3
	float-cmp@0.10.0
	fnv@1.0.7
	foldhash@0.1.5
	getrandom@0.2.16
	gimli@0.31.1
	hashbrown@0.15.5
	heck@0.5.0
	humantime@2.2.0
	ident_case@1.0.1
	indexmap@2.10.0
	indoc@2.0.6
	instability@0.3.9
	is_terminal_polyfill@1.70.1
	itertools@0.13.0
	itertools@0.14.0
	itoa@1.0.15
	lazy_static@1.5.0
	lazycell@1.3.0
	libc@0.2.175
	libloading@0.8.8
	libredox@0.1.9
	linux-raw-sys@0.4.15
	linux-raw-sys@0.9.4
	litrs@0.4.2
	lock_api@0.4.13
	log@0.4.27
	lru@0.12.5
	mach2@0.4.3
	memchr@2.7.5
	miniz_oxide@0.8.9
	mio@1.0.4
	nix@0.28.0
	nix@0.30.1
	normalize-line-endings@0.3.0
	ntapi@0.4.1
	num-conv@0.1.0
	num-traits@0.2.19
	num_threads@0.1.7
	nvml-wrapper-sys@0.9.0
	nvml-wrapper@0.11.0
	objc2-core-foundation@0.3.1
	objc2-io-kit@0.3.1
	object@0.36.7
	once_cell@1.21.3
	once_cell_polyfill@1.70.1
	option-ext@0.2.0
	parking_lot@0.12.4
	parking_lot_core@0.9.11
	paste@1.0.15
	plist@1.7.4
	portable-pty@0.9.0
	powerfmt@0.2.0
	predicates-core@1.0.9
	predicates-tree@1.0.12
	predicates@3.1.3
	proc-macro2@1.0.97
	quick-xml@0.38.1
	quote@1.0.40
	ratatui@0.29.0
	redox_syscall@0.5.17
	redox_users@0.5.2
	ref-cast-impl@1.0.24
	ref-cast@1.0.24
	regex-automata@0.4.9
	regex-syntax@0.8.5
	regex@1.11.1
	roff@0.2.2
	rustc-demangle@0.1.26
	rustix@0.38.44
	rustix@1.0.8
	rustversion@1.0.22
	ryu@1.0.20
	same-file@1.0.6
	schemars@0.9.0
	schemars_derive@0.9.0
	scopeguard@1.2.0
	serde@1.0.219
	serde_derive@1.0.219
	serde_derive_internals@0.29.1
	serde_json@1.0.142
	serde_spanned@0.6.9
	serial2@0.2.31
	shared_library@0.1.9
	shell-words@1.1.0
	signal-hook-mio@0.2.4
	signal-hook-registry@1.4.6
	signal-hook@0.3.18
	smallvec@1.15.1
	starship-battery@0.10.2
	static_assertions@1.1.0
	strsim@0.11.1
	strum@0.26.3
	strum@0.27.2
	strum_macros@0.26.4
	strum_macros@0.27.2
	syn@2.0.105
	sysctl@0.6.0
	sysinfo@0.37.0
	tempfile@3.20.0
	terminal_size@0.4.3
	termtree@0.5.1
	thiserror-impl@1.0.69
	thiserror-impl@2.0.14
	thiserror@1.0.69
	thiserror@2.0.14
	time-core@0.1.4
	time-macros@0.2.22
	time@0.3.41
	timeless@0.0.14-alpha
	toml_datetime@0.6.11
	toml_edit@0.22.27
	toml_write@0.1.2
	typenum@1.18.0
	unicode-ellipsis@0.3.0
	unicode-ident@1.0.18
	unicode-segmentation@1.12.0
	unicode-truncate@1.1.0
	unicode-width@0.1.14
	unicode-width@0.2.0
	uom@0.37.0
	utf8parse@0.2.2
	wait-timeout@0.2.1
	walkdir@2.5.0
	wasi@0.11.1+wasi-snapshot-preview1
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.9
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-collections@0.2.0
	windows-core@0.61.2
	windows-future@0.2.1
	windows-implement@0.60.0
	windows-interface@0.59.1
	windows-link@0.1.3
	windows-numerics@0.2.0
	windows-result@0.3.4
	windows-strings@0.4.2
	windows-sys@0.59.0
	windows-sys@0.60.2
	windows-targets@0.52.6
	windows-targets@0.53.3
	windows-threading@0.1.0
	windows@0.61.3
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.52.6
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.52.6
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.52.6
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.52.6
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.52.6
	windows_x86_64_msvc@0.53.0
	winnow@0.7.12
	winreg@0.10.1
	wrapcenum-derive@0.4.1
"

inherit cargo shell-completion

DESCRIPTION="A graphical process/system monitor with a customizable interface"
HOMEPAGE="https://github.com/ClementTsang/bottom"
SRC_URI="
	https://github.com/ClementTsang/bottom/archive/refs/tags/${PV}.tar.gz -> ${P}.tar.gz
	${CARGO_CRATE_URIS}
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+=" Apache-2.0 ISC MIT MPL-2.0 Unicode-DFS-2016"
SLOT="0"
KEYWORDS="amd64 arm64 ~ppc64 ~riscv"
IUSE="+battery +gpu +zfs"

RUST_MIN_VER="1.88"

# Rust packages ignore CFLAGS and LDFLAGS so let's silence the QA warnings
QA_FLAGS_IGNORED="usr/bin/btm"

src_prepare() {
	# Stripping symbols should be the choice of the user.
	sed -i '/strip = "symbols"/d' Cargo.toml || die "Unable to patch out symbol stripping"

	default
}

src_configure() {
	local myfeatures=(
		$(usev battery)
		$(usev gpu)
		$(usev zfs)
	)

	# This will turn on generation of shell completion scripts
	export BTM_GENERATE=true

	# https://github.com/ClementTsang/bottom/blob/bacaca5548c2b23d261ef961ee6584b609529567/Cargo.toml#L63
	# fern and log features are for debugging only, so disable default features
	cargo_src_configure $(usev !debug --no-default-features)
}

src_install() {
	cargo_src_install

	pushd target/tmp/bottom/completion > /dev/null || die
	newbashcomp btm.bash btm
	dofishcomp btm.fish
	dozshcomp _btm
	popd > /dev/null || die

	doman target/tmp/bottom/manpage/btm.1

	local DOCS=( README.md )
	einstalldocs
}
