# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.7.1.1.9999
#hackport: flags: -hans

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit haskell-cabal

DESCRIPTION="TLS/SSL protocol native implementation (Server and Client)"
HOMEPAGE="https://github.com/vincenthz/hs-tls"
SRC_URI="https://hackage.haskell.org/package/${P}/${P}.tar.gz"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="+compat +network"

RDEPEND="dev-haskell/asn1-encoding:=[profile?]
	>=dev-haskell/asn1-types-0.2.0:=[profile?]
	>=dev-haskell/async-2.0:=[profile?]
	>=dev-haskell/cereal-0.5.3:=[profile?]
	>=dev-haskell/cryptonite-0.27:=[profile?]
	dev-haskell/data-default-class:=[profile?]
	dev-haskell/hourglass:=[profile?]
	>=dev-haskell/memory-0.14.6:=[profile?]
	>=dev-haskell/x509-1.7.5:=[profile?]
	>=dev-haskell/x509-store-1.6:=[profile?]
	>=dev-haskell/x509-validation-1.6.5:=[profile?]
	>=dev-lang/ghc-8.4.3:=
	network? ( >=dev-haskell/network-2.4.0.0:=[profile?] )
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-2.2.0.1
	test? ( dev-haskell/quickcheck
		dev-haskell/tasty
		dev-haskell/tasty-quickcheck )
"

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag compat compat) \
		--flag=-hans \
		$(cabal_flag network network)
}
