# Copyright 1999-2024 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=7

inherit toolchain-funcs multilib-minimal

DESCRIPTION="Audio processing system for plugins to extract information from audio data"
HOMEPAGE="https://www.vamp-plugins.org"
SRC_URI="https://github.com/c4dm/${PN}/archive/${PN}-v${PV}.tar.gz -> ${P}.tar.gz"

LICENSE="BSD"
SLOT="0"
KEYWORDS="~alpha amd64 arm arm64 ~hppa ~loong ~mips ppc ppc64 ~riscv ~sparc x86"
IUSE="doc"

RDEPEND="media-libs/libsndfile:0=[${MULTILIB_USEDEP}]"
DEPEND="${RDEPEND}"
BDEPEND="
	virtual/pkgconfig
	doc? ( app-text/doxygen )
"

S="${WORKDIR}/${PN}-${PN}-v${PV}"

src_prepare() {
	default
	multilib_copy_sources
}

multilib_src_configure() {
	MAKEOPTS+=" -j1" # bug #943866

	# multilib for default search paths
	sed -i -e "s:/usr/lib/vamp:${EPREFIX}/usr/$(get_libdir)/vamp:" \
		src/vamp-hostsdk/PluginHostAdapter.cpp || die
	econf
}

multilib_src_compile() {
	emake \
		AR="$(tc-getAR)" \
		RANLIB="$(tc-getRANLIB)"

	if multilib_is_native_abi && use doc; then
		cd build || die
		doxygen || die "creating doxygen doc failed"
		HTML_DOCS=( "${BUILD_DIR}"/build/doc/html/. )
	fi
}

multilib_src_install() {
	emake \
		DESTDIR="${D}" \
		INSTALL_SDK_LIBS="${EPREFIX}"/usr/$(get_libdir) \
		INSTALL_PKGCONFIG="${EPREFIX}"/usr/$(get_libdir)/pkgconfig \
		INSTALL_PLUGINS="${EPREFIX}"/usr/$(get_libdir)/vamp \
		install

	# fix .pc files
	sed -Ei "s/lib$/$(get_libdir)/g" "${D}"/usr/$(get_libdir)/pkgconfig/*.pc
}

multilib_src_install_all() {
	einstalldocs

	# don't want static archives, #474768
	find "${D}" -name '*.a' -delete || die
}

pkg_postinst() {
	elog
	elog "You might also want to install some Vamp plugins."
	elog "See media-plugins/vamp-*"
	elog
}
