# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8
PYTHON_COMPAT=( python3_{11..14} )

inherit gnome2-utils meson python-single-r1 vala xdg

DESCRIPTION="A text editor for the GNOME desktop"
HOMEPAGE="https://gedit-text-editor.org/ https://gitlab.gnome.org/World/gedit"
SRC_URI="https://gitlab.gnome.org/World/gedit/${PN}/-/archive/${PV}/${P}.tar.bz2"
# Upstream does not provide a proper tarball, rely on Fedora snapshot
LIBGD_COMMIT="3cccf99234288a6121b3945a25cd4ec3b7445c74"
SRC_URI+=" https://gitlab.gnome.org/GNOME/libgd/-/archive/${LIBGD_COMMIT}/libgd-${LIBGD_COMMIT}.tar.bz2"

LICENSE="GPL-2+ CC-BY-SA-3.0"
SLOT="0"
KEYWORDS="~amd64 ~arm ~arm64 ~loong ~riscv ~x86"

IUSE="+python gtk-doc"
REQUIRED_USE="python? ( ${PYTHON_REQUIRED_USE} )"

DEPEND="
	>=dev-libs/glib-2.76:2
	>=x11-libs/gtk+-3.22.0:3[introspection]
	>=gui-libs/libgedit-amtk-5.6:=
	>=gui-libs/libgedit-tepl-6.13
	>=dev-libs/libpeas-1.14.1:0[gtk]
	>=dev-libs/gobject-introspection-1.82.0-r2:=
	>=app-text/gspell-0.2.5:0=
	python? (
		${PYTHON_DEPS}
		$(python_gen_cond_dep '
			dev-python/pycairo[${PYTHON_USEDEP}]
			>=dev-python/pygobject-3:3[cairo,${PYTHON_USEDEP}]
			dev-libs/libpeas:0[python,${PYTHON_SINGLE_USEDEP}]
		')
	)

	gui-libs/libgedit-gtksourceview:300
"
RDEPEND="${DEPEND}
	!<app-editors/gedit-plugins-48
	x11-themes/adwaita-icon-theme
	gnome-base/gsettings-desktop-schemas
	gnome-base/gvfs
"
BDEPEND="
	$(vala_depend)
	dev-util/glib-utils
	gtk-doc? ( >=dev-util/gtk-doc-1 )
	dev-util/itstool
	>=sys-devel/gettext-0.18
	virtual/pkgconfig
"

pkg_setup() {
	use python && python-single-r1_pkg_setup
}

src_prepare() {
	# Prepare libgd subproject for building
	rmdir subprojects/libgd || die
	ln -s "${WORKDIR}"/libgd-* subprojects/libgd || die

	default
	vala_setup
	xdg_environment_reset
}

src_configure() {
	local emesonargs=(
		$(meson_use gtk-doc gtk_doc)
		-Duser_documentation=true

	)
	meson_src_configure
}

src_install() {
	meson_src_install
	if use python; then
		python_optimize
		python_optimize "${ED}/usr/$(get_libdir)/gedit/plugins/"
	fi
}

pkg_postinst() {
	xdg_pkg_postinst
	gnome2_schemas_update
}

pkg_postrm() {
	xdg_pkg_postrm
	gnome2_schemas_update
}
