# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit dune

# Note that new "major" versions may change which OCaml version they support
# See:
# https://github.com/ocaml-ppx/ppxlib/issues/243
# https://github.com/ocaml-ppx/ppxlib/issues/232

DESCRIPTION="Base library and tools for ppx rewriters"
HOMEPAGE="https://github.com/ocaml-ppx/ppxlib"

if [[ "${PV}" == *9999* ]] ; then
	inherit git-r3

	EGIT_REPO_URI="https://github.com/ocaml-ppx"
else
	SRC_URI="https://github.com/ocaml-ppx/ppxlib/archive/${PV}.tar.gz
		-> ${P}.gh.tar.gz"

	KEYWORDS="~amd64 ~arm ~arm64 ~riscv ~x86"
fi

LICENSE="Apache-2.0"
SLOT="0/${PV}"
IUSE="+ocamlopt test"
RESTRICT="test"

RDEPEND="
	dev-ml/cmdliner:=[ocamlopt?]
	dev-ml/ocaml-compiler-libs:=[ocamlopt?]
	dev-ml/ppx_derivers:=[ocamlopt?]
	dev-ml/sexplib0:=[ocamlopt?]
	dev-ml/stdlib-shims:=[ocamlopt?]
	dev-ml/yojson:=[ocamlopt?]
"
DEPEND="
	${RDEPEND}
"
BDEPEND="
	>=dev-ml/dune-3.8
"
