# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit linux-info qmake-utils systemd

DESCRIPTION="Multicast proxy for IGMP/MLD"
HOMEPAGE="https://mcproxy.realmv6.org/ https://github.com/mcproxy/mcproxy"
SRC_URI="https://github.com/${PN}/${PN}/archive/v${PV}.tar.gz -> ${P}.tar.gz"
S="${WORKDIR}/${P}/${PN}"

LICENSE="GPL-2+"
SLOT="0"
KEYWORDS="amd64 x86"
IUSE="doc"

DEPEND="
	dev-qt/qtbase:6
	doc? ( app-text/doxygen )
"

PATCHES=(
	"${FILESDIR}/${P}-clang.patch"
	"${FILESDIR}/${P}-fix-checksum-calculation.patch"
)

CONFIG_CHECK="~IP_MULTICAST ~IP_MROUTE"

src_prepare() {
	# Change install path from '/usr/local/bin' to '/usr/bin'
	sed -e 's/local//' -i mcproxy.pro || die

	default
}

src_configure() {
	eqmake6
}

src_compile() {
	default

	use doc && emake doc
}

src_install() {
	emake INSTALL_ROOT="${ED}" install

	insinto /etc
	doins mcproxy.conf

	newinitd "${FILESDIR}"/mcproxy.initd mcproxy
	systemd_dounit "${FILESDIR}"/mcproxy.service

	newconfd "${FILESDIR}"/mcproxy.confd mcproxy

	use doc && dodoc -r ../docs/.
}
