# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.4.0.9999
#hackport: flags: build-examples:examples

CABAL_HACKAGE_REVISION=3

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit ghc-package haskell-cabal

DESCRIPTION="shell-like (systems) programming in Haskell"
HOMEPAGE="https://github.com/yesodweb/Shelly.hs"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="examples lifted"

CABAL_CHDEPS=(
	'time                      >= 1.3 && < 1.10' 'time >=1.3'
)

RDEPEND="dev-haskell/async:=[profile?]
	dev-haskell/enclosed-exceptions:=[profile?]
	dev-haskell/lifted-async:=[profile?]
	dev-haskell/lifted-base:=[profile?]
	>=dev-haskell/monad-control-0.3.2:=[profile?] <dev-haskell/monad-control-1.1:=[profile?]
	dev-haskell/text:=[profile?]
	dev-haskell/transformers-base:=[profile?]
	<dev-haskell/unix-compat-0.6:=[profile?]
	>=dev-lang/ghc-9.0.2:=
"
DEPEND="${RDEPEND}
	>=dev-haskell/cabal-3.4.1.0
	test? ( >=dev-haskell/hspec-2.0
		dev-haskell/hspec-contrib
		>=dev-haskell/hunit-1.2
		>=dev-haskell/text-0.11 )
"

example_exes=(
	"drain"
	"run-handles"
	"Color"
)

src_prepare() {
	for e in "${example_exes[@]}"; do
		export CABAL_CHDEPS+=(
			"Executable ${e}"
			"executable ${PN}-examples-${e}"
		)
	done

	haskell-cabal_src_prepare
}

src_configure() {
	haskell-cabal_src_configure \
		$(cabal_flag examples build-examples) \
		$(cabal_flag lifted lifted)
}

pkg_postinst() {
	ghc-package_pkg_postinst

	elog "The following example executables installed with this package have been"
	elog "renamed to help prevent name collisions:"

	for e in "${example_exes[@]}"; do
		elog "${e} -> ${PN}-examples-${e}"
	done
}
