# Copyright 2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.1

EAPI=8

CRATES="
	actix-codec@0.5.2
	actix-http@3.10.0
	actix-macros@0.2.4
	actix-router@0.5.3
	actix-rt@2.10.0
	actix-server@2.5.1
	actix-service@2.0.3
	actix-utils@3.0.1
	actix-web-codegen@4.3.0
	actix-web@4.10.2
	addr2line@0.24.2
	adler2@2.0.0
	aho-corasick@1.1.3
	alloc-no-stdlib@2.0.4
	alloc-stdlib@0.2.2
	anstream@0.6.18
	anstyle-parse@0.2.6
	anstyle-query@1.1.2
	anstyle-wincon@3.0.7
	anstyle@1.0.10
	autocfg@1.4.0
	backtrace@0.3.74
	base64@0.22.1
	bitflags@2.9.0
	block-buffer@0.10.4
	brotli-decompressor@4.0.2
	brotli@7.0.0
	bytes@1.10.1
	bytestring@1.4.0
	cc@1.2.17
	cfg-if@1.0.0
	clap@4.5.34
	clap_builder@4.5.34
	clap_derive@4.5.32
	clap_lex@0.7.4
	colorchoice@1.0.3
	cookie@0.16.2
	cpufeatures@0.2.17
	crc32fast@1.4.2
	crypto-common@0.1.6
	deranged@0.4.1
	derive_more-impl@2.0.1
	derive_more@2.0.1
	digest@0.10.7
	displaydoc@0.2.5
	encoding_rs@0.8.35
	equivalent@1.0.2
	flate2@1.1.0
	fnv@1.0.7
	foldhash@0.1.5
	form_urlencoded@1.2.1
	futf@0.1.5
	futures-core@0.3.31
	futures-sink@0.3.31
	futures-task@0.3.31
	futures-util@0.3.31
	generic-array@0.14.7
	getrandom@0.3.2
	gimli@0.31.1
	h2@0.3.26
	hashbrown@0.15.2
	heck@0.5.0
	html5ever@0.30.0
	http@0.2.12
	httparse@1.10.1
	httpdate@1.0.3
	icu_collections@1.5.0
	icu_locid@1.5.0
	icu_locid_transform@1.5.0
	icu_locid_transform_data@1.5.1
	icu_normalizer@1.5.0
	icu_normalizer_data@1.5.1
	icu_properties@1.5.1
	icu_properties_data@1.5.1
	icu_provider@1.5.0
	icu_provider_macros@1.5.0
	idna@1.0.3
	idna_adapter@1.2.0
	impl-more@0.1.9
	indexmap@2.8.0
	is_terminal_polyfill@1.70.1
	itoa@1.0.15
	jobserver@0.1.32
	language-tags@0.3.2
	libc@0.2.171
	litemap@0.7.5
	local-channel@0.1.5
	local-waker@0.1.4
	lock_api@0.4.12
	log@0.4.27
	mac@0.1.1
	markup5ever@0.15.0
	match_token@0.1.0
	memchr@2.7.4
	mime@0.3.17
	miniz_oxide@0.8.5
	mio@1.0.3
	new_debug_unreachable@1.0.6
	num-conv@0.1.0
	object@0.36.7
	once_cell@1.21.2
	parking_lot@0.12.3
	parking_lot_core@0.9.10
	percent-encoding@2.3.1
	phf@0.11.3
	phf_codegen@0.11.3
	phf_generator@0.11.3
	phf_shared@0.11.3
	pin-project-lite@0.2.16
	pin-utils@0.1.0
	pkg-config@0.3.32
	powerfmt@0.2.0
	ppv-lite86@0.2.21
	precomputed-hash@0.1.1
	proc-macro2@1.0.94
	quote@1.0.40
	r-efi@5.2.0
	rand@0.8.5
	rand@0.9.0
	rand_chacha@0.9.0
	rand_core@0.6.4
	rand_core@0.9.3
	redox_syscall@0.5.10
	regex-automata@0.4.9
	regex-lite@0.1.6
	regex-syntax@0.8.5
	regex@1.11.1
	rustc-demangle@0.1.24
	ryu@1.0.20
	same-file@1.0.6
	scopeguard@1.2.0
	serde@1.0.219
	serde_derive@1.0.219
	serde_json@1.0.140
	serde_urlencoded@0.7.1
	sha1@0.10.6
	shlex@1.3.0
	signal-hook-registry@1.4.2
	siphasher@1.0.1
	slab@0.4.9
	smallvec@1.14.0
	socket2@0.5.8
	stable_deref_trait@1.2.0
	string_cache@0.8.9
	string_cache_codegen@0.5.4
	strsim@0.11.1
	syn@2.0.100
	synstructure@0.13.1
	tendril@0.4.3
	time-core@0.1.4
	time-macros@0.2.22
	time@0.3.41
	tinystr@0.7.6
	tokio-util@0.7.14
	tokio@1.44.1
	tracing-attributes@0.1.28
	tracing-core@0.1.33
	tracing@0.1.41
	typenum@1.18.0
	unicode-ident@1.0.18
	unicode-xid@0.2.6
	url@2.5.4
	utf-8@0.7.6
	utf16_iter@1.0.5
	utf8_iter@1.0.4
	utf8parse@0.2.2
	version_check@0.9.5
	walkdir@2.5.0
	wasi@0.11.0+wasi-snapshot-preview1
	wasi@0.14.2+wasi-0.2.4
	winapi-util@0.1.9
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.52.6
	wit-bindgen-rt@0.39.0
	write16@1.0.0
	writeable@0.5.5
	yoke-derive@0.7.5
	yoke@0.7.5
	zerocopy-derive@0.8.24
	zerocopy@0.8.24
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zerovec-derive@0.10.3
	zerovec@0.10.4
	zstd-safe@7.2.4
	zstd-sys@2.0.15+zstd.1.5.7
	zstd@0.13.3
"
RUST_MIN_VER="1.81"
VERIFY_SIG_OPENPGP_KEY_PATH=/usr/share/openpgp-keys/marcusb.asc
inherit cargo systemd verify-sig

DESCRIPTION="Feed fake content to bots and robots.txt-ignoring LLM scrapers"
HOMEPAGE="https://marcusb.org/hacks/quixotic.html"
# https://github.com/marcus0x62/quixotic/issues/7 wrt 0.13
SRC_URI="
	https://marcusb.org/releases/${P}.tar.gz
	verify-sig? ( https://marcusb.org/releases/${P}.tar.gz.sig )
	${CARGO_CRATE_URIS}
"

LICENSE="MIT"
# Dependent crate licenses
LICENSE+="
	BSD MIT Unicode-3.0 ZLIB
	|| ( Apache-2.0 Boost-1.0 )
"
SLOT="0"
KEYWORDS="amd64"

RDEPEND="app-arch/zstd:="
DEPEND="${RDEPEND}"
BDEPEND="verify-sig? ( sec-keys/openpgp-keys-marcusb )"

QA_FLAGS_IGNORED="usr/bin/linkmaze usr/bin/quixotic"

src_unpack() {
	if use verify-sig ; then
		verify-sig_verify_detached "${DISTDIR}"/${P}.tar.gz{,.sig}
		unpack ${P}.tar.gz
	fi

	cargo_src_unpack
}

src_prepare() {
	default

	sed -i -e "s:/usr/local/bin/linkmaze:${EPREFIX}/usr/bin/linkmaze:" linkmaze.service || die
}

src_configure() {
	export ZSTD_SYS_USE_PKG_CONFIG=1
	cargo_src_configure
}

src_install() {
	cargo_src_install

	systemd_dounit linkmaze.service
	newinitd "${FILESDIR}"/linkmaze.initd linkmaze
	newconfd "${FILESDIR}"/linkmaze.confd linkmaze
}
