// Code generated by mog. DO NOT EDIT.

package pbconfigentry

import "github.com/hashicorp/consul/agent/structs"

func APIGatewayToStructs(s *APIGateway, t *structs.APIGatewayConfigEntry) {
	if s == nil {
		return
	}
	{
		t.Listeners = make([]structs.APIGatewayListener, len(s.Listeners))
		for i := range s.Listeners {
			if s.Listeners[i] != nil {
				APIGatewayListenerToStructs(s.Listeners[i], &t.Listeners[i])
			}
		}
	}
	if s.Status != nil {
		StatusToStructs(s.Status, &t.Status)
	}
	t.Meta = s.Meta
	t.Hash = s.Hash
}
func APIGatewayFromStructs(t *structs.APIGatewayConfigEntry, s *APIGateway) {
	if s == nil {
		return
	}
	{
		s.Listeners = make([]*APIGatewayListener, len(t.Listeners))
		for i := range t.Listeners {
			{
				var x APIGatewayListener
				APIGatewayListenerFromStructs(&t.Listeners[i], &x)
				s.Listeners[i] = &x
			}
		}
	}
	{
		var x Status
		StatusFromStructs(&t.Status, &x)
		s.Status = &x
	}
	s.Meta = t.Meta
	s.Hash = t.Hash
}
func APIGatewayListenerToStructs(s *APIGatewayListener, t *structs.APIGatewayListener) {
	if s == nil {
		return
	}
	t.Name = s.Name
	t.Hostname = s.Hostname
	t.Port = int(s.Port)
	t.Protocol = apiGatewayProtocolToStructs(s.Protocol)
	if s.TLS != nil {
		APIGatewayTLSConfigurationToStructs(s.TLS, &t.TLS)
	}
	if s.Override != nil {
		var x structs.APIGatewayPolicy
		APIGatewayPolicyToStructs(s.Override, &x)
		t.Override = &x
	}
	if s.Default != nil {
		var x structs.APIGatewayPolicy
		APIGatewayPolicyToStructs(s.Default, &x)
		t.Default = &x
	}
}
func APIGatewayListenerFromStructs(t *structs.APIGatewayListener, s *APIGatewayListener) {
	if s == nil {
		return
	}
	s.Name = t.Name
	s.Hostname = t.Hostname
	s.Port = int32(t.Port)
	s.Protocol = apiGatewayProtocolFromStructs(t.Protocol)
	{
		var x APIGatewayTLSConfiguration
		APIGatewayTLSConfigurationFromStructs(&t.TLS, &x)
		s.TLS = &x
	}
	if t.Override != nil {
		var x APIGatewayPolicy
		APIGatewayPolicyFromStructs(t.Override, &x)
		s.Override = &x
	}
	if t.Default != nil {
		var x APIGatewayPolicy
		APIGatewayPolicyFromStructs(t.Default, &x)
		s.Default = &x
	}
}
func APIGatewayPolicyToStructs(s *APIGatewayPolicy, t *structs.APIGatewayPolicy) {
	if s == nil {
		return
	}
	t.JWT = gwJWTRequirementToStructs(s.JWT)
}
func APIGatewayPolicyFromStructs(t *structs.APIGatewayPolicy, s *APIGatewayPolicy) {
	if s == nil {
		return
	}
	s.JWT = gwJWTRequirementFromStructs(t.JWT)
}
func APIGatewayTLSConfigurationToStructs(s *APIGatewayTLSConfiguration, t *structs.APIGatewayTLSConfiguration) {
	if s == nil {
		return
	}
	{
		t.Certificates = make([]structs.ResourceReference, len(s.Certificates))
		for i := range s.Certificates {
			if s.Certificates[i] != nil {
				ResourceReferenceToStructs(s.Certificates[i], &t.Certificates[i])
			}
		}
	}
	t.MaxVersion = tlsVersionToStructs(s.MaxVersion)
	t.MinVersion = tlsVersionToStructs(s.MinVersion)
	t.CipherSuites = cipherSuitesToStructs(s.CipherSuites)
}
func APIGatewayTLSConfigurationFromStructs(t *structs.APIGatewayTLSConfiguration, s *APIGatewayTLSConfiguration) {
	if s == nil {
		return
	}
	{
		s.Certificates = make([]*ResourceReference, len(t.Certificates))
		for i := range t.Certificates {
			{
				var x ResourceReference
				ResourceReferenceFromStructs(&t.Certificates[i], &x)
				s.Certificates[i] = &x
			}
		}
	}
	s.MaxVersion = tlsVersionFromStructs(t.MaxVersion)
	s.MinVersion = tlsVersionFromStructs(t.MinVersion)
	s.CipherSuites = cipherSuitesFromStructs(t.CipherSuites)
}
func BoundAPIGatewayToStructs(s *BoundAPIGateway, t *structs.BoundAPIGatewayConfigEntry) {
	if s == nil {
		return
	}
	{
		t.Listeners = make([]structs.BoundAPIGatewayListener, len(s.Listeners))
		for i := range s.Listeners {
			if s.Listeners[i] != nil {
				BoundAPIGatewayListenerToStructs(s.Listeners[i], &t.Listeners[i])
			}
		}
	}
	t.Services = serviceRefsToStructs(s.Services)
	t.Meta = s.Meta
	t.Hash = s.Hash
}
func BoundAPIGatewayFromStructs(t *structs.BoundAPIGatewayConfigEntry, s *BoundAPIGateway) {
	if s == nil {
		return
	}
	{
		s.Listeners = make([]*BoundAPIGatewayListener, len(t.Listeners))
		for i := range t.Listeners {
			{
				var x BoundAPIGatewayListener
				BoundAPIGatewayListenerFromStructs(&t.Listeners[i], &x)
				s.Listeners[i] = &x
			}
		}
	}
	s.Services = serviceRefFromStructs(t.Services)
	s.Meta = t.Meta
	s.Hash = t.Hash
}
func BoundAPIGatewayListenerToStructs(s *BoundAPIGatewayListener, t *structs.BoundAPIGatewayListener) {
	if s == nil {
		return
	}
	t.Name = s.Name
	{
		t.Routes = make([]structs.ResourceReference, len(s.Routes))
		for i := range s.Routes {
			if s.Routes[i] != nil {
				ResourceReferenceToStructs(s.Routes[i], &t.Routes[i])
			}
		}
	}
	{
		t.Certificates = make([]structs.ResourceReference, len(s.Certificates))
		for i := range s.Certificates {
			if s.Certificates[i] != nil {
				ResourceReferenceToStructs(s.Certificates[i], &t.Certificates[i])
			}
		}
	}
}
func BoundAPIGatewayListenerFromStructs(t *structs.BoundAPIGatewayListener, s *BoundAPIGatewayListener) {
	if s == nil {
		return
	}
	s.Name = t.Name
	{
		s.Routes = make([]*ResourceReference, len(t.Routes))
		for i := range t.Routes {
			{
				var x ResourceReference
				ResourceReferenceFromStructs(&t.Routes[i], &x)
				s.Routes[i] = &x
			}
		}
	}
	{
		s.Certificates = make([]*ResourceReference, len(t.Certificates))
		for i := range t.Certificates {
			{
				var x ResourceReference
				ResourceReferenceFromStructs(&t.Certificates[i], &x)
				s.Certificates[i] = &x
			}
		}
	}
}
func ConditionToStructs(s *Condition, t *structs.Condition) {
	if s == nil {
		return
	}
	t.Type = s.Type
	t.Status = s.Status
	t.Reason = s.Reason
	t.Message = s.Message
	if s.Resource != nil {
		var x structs.ResourceReference
		ResourceReferenceToStructs(s.Resource, &x)
		t.Resource = &x
	}
	t.LastTransitionTime = timeToStructs(s.LastTransitionTime)
}
func ConditionFromStructs(t *structs.Condition, s *Condition) {
	if s == nil {
		return
	}
	s.Type = t.Type
	s.Status = t.Status
	s.Reason = t.Reason
	s.Message = t.Message
	if t.Resource != nil {
		var x ResourceReference
		ResourceReferenceFromStructs(t.Resource, &x)
		s.Resource = &x
	}
	s.LastTransitionTime = timeFromStructs(t.LastTransitionTime)
}
func CookieConfigToStructs(s *CookieConfig, t *structs.CookieConfig) {
	if s == nil {
		return
	}
	t.Session = s.Session
	t.TTL = structs.DurationFromProto(s.TTL)
	t.Path = s.Path
}
func CookieConfigFromStructs(t *structs.CookieConfig, s *CookieConfig) {
	if s == nil {
		return
	}
	s.Session = t.Session
	s.TTL = structs.DurationToProto(t.TTL)
	s.Path = t.Path
}
func DestinationConfigToStructs(s *DestinationConfig, t *structs.DestinationConfig) {
	if s == nil {
		return
	}
	t.Addresses = s.Addresses
	t.Port = int(s.Port)
}
func DestinationConfigFromStructs(t *structs.DestinationConfig, s *DestinationConfig) {
	if s == nil {
		return
	}
	s.Addresses = t.Addresses
	s.Port = int32(t.Port)
}
func ExportedServicesToStructs(s *ExportedServices, t *structs.ExportedServicesConfigEntry) {
	if s == nil {
		return
	}
	{
		t.Services = make([]structs.ExportedService, len(s.Services))
		for i := range s.Services {
			if s.Services[i] != nil {
				ExportedServicesServiceToStructs(s.Services[i], &t.Services[i])
			}
		}
	}
	t.Meta = s.Meta
	t.Hash = s.Hash
}
func ExportedServicesFromStructs(t *structs.ExportedServicesConfigEntry, s *ExportedServices) {
	if s == nil {
		return
	}
	{
		s.Services = make([]*ExportedServicesService, len(t.Services))
		for i := range t.Services {
			{
				var x ExportedServicesService
				ExportedServicesServiceFromStructs(&t.Services[i], &x)
				s.Services[i] = &x
			}
		}
	}
	s.Meta = t.Meta
	s.Hash = t.Hash
}
func ExportedServicesConsumerToStructs(s *ExportedServicesConsumer, t *structs.ServiceConsumer) {
	if s == nil {
		return
	}
	t.Partition = s.Partition
	t.Peer = s.Peer
	t.SamenessGroup = s.SamenessGroup
}
func ExportedServicesConsumerFromStructs(t *structs.ServiceConsumer, s *ExportedServicesConsumer) {
	if s == nil {
		return
	}
	s.Partition = t.Partition
	s.Peer = t.Peer
	s.SamenessGroup = t.SamenessGroup
}
func ExportedServicesServiceToStructs(s *ExportedServicesService, t *structs.ExportedService) {
	if s == nil {
		return
	}
	t.Name = s.Name
	t.Namespace = s.Namespace
	{
		t.Consumers = make([]structs.ServiceConsumer, len(s.Consumers))
		for i := range s.Consumers {
			if s.Consumers[i] != nil {
				ExportedServicesConsumerToStructs(s.Consumers[i], &t.Consumers[i])
			}
		}
	}
}
func ExportedServicesServiceFromStructs(t *structs.ExportedService, s *ExportedServicesService) {
	if s == nil {
		return
	}
	s.Name = t.Name
	s.Namespace = t.Namespace
	{
		s.Consumers = make([]*ExportedServicesConsumer, len(t.Consumers))
		for i := range t.Consumers {
			{
				var x ExportedServicesConsumer
				ExportedServicesConsumerFromStructs(&t.Consumers[i], &x)
				s.Consumers[i] = &x
			}
		}
	}
}
func ExposeConfigToStructs(s *ExposeConfig, t *structs.ExposeConfig) {
	if s == nil {
		return
	}
	t.Checks = s.Checks
	{
		t.Paths = make([]structs.ExposePath, len(s.Paths))
		for i := range s.Paths {
			if s.Paths[i] != nil {
				ExposePathToStructs(s.Paths[i], &t.Paths[i])
			}
		}
	}
}
func ExposeConfigFromStructs(t *structs.ExposeConfig, s *ExposeConfig) {
	if s == nil {
		return
	}
	s.Checks = t.Checks
	{
		s.Paths = make([]*ExposePath, len(t.Paths))
		for i := range t.Paths {
			{
				var x ExposePath
				ExposePathFromStructs(&t.Paths[i], &x)
				s.Paths[i] = &x
			}
		}
	}
}
func ExposePathToStructs(s *ExposePath, t *structs.ExposePath) {
	if s == nil {
		return
	}
	t.ListenerPort = int(s.ListenerPort)
	t.Path = s.Path
	t.LocalPathPort = int(s.LocalPathPort)
	t.Protocol = s.Protocol
	t.ParsedFromCheck = s.ParsedFromCheck
}
func ExposePathFromStructs(t *structs.ExposePath, s *ExposePath) {
	if s == nil {
		return
	}
	s.ListenerPort = int32(t.ListenerPort)
	s.Path = t.Path
	s.LocalPathPort = int32(t.LocalPathPort)
	s.Protocol = t.Protocol
	s.ParsedFromCheck = t.ParsedFromCheck
}
func GatewayServiceTLSConfigToStructs(s *GatewayServiceTLSConfig, t *structs.GatewayServiceTLSConfig) {
	if s == nil {
		return
	}
	if s.SDS != nil {
		var x structs.GatewayTLSSDSConfig
		GatewayTLSSDSConfigToStructs(s.SDS, &x)
		t.SDS = &x
	}
}
func GatewayServiceTLSConfigFromStructs(t *structs.GatewayServiceTLSConfig, s *GatewayServiceTLSConfig) {
	if s == nil {
		return
	}
	if t.SDS != nil {
		var x GatewayTLSSDSConfig
		GatewayTLSSDSConfigFromStructs(t.SDS, &x)
		s.SDS = &x
	}
}
func GatewayTLSConfigToStructs(s *GatewayTLSConfig, t *structs.GatewayTLSConfig) {
	if s == nil {
		return
	}
	t.Enabled = s.Enabled
	if s.SDS != nil {
		var x structs.GatewayTLSSDSConfig
		GatewayTLSSDSConfigToStructs(s.SDS, &x)
		t.SDS = &x
	}
	t.TLSMinVersion = tlsVersionToStructs(s.TLSMinVersion)
	t.TLSMaxVersion = tlsVersionToStructs(s.TLSMaxVersion)
	t.CipherSuites = cipherSuitesToStructs(s.CipherSuites)
}
func GatewayTLSConfigFromStructs(t *structs.GatewayTLSConfig, s *GatewayTLSConfig) {
	if s == nil {
		return
	}
	s.Enabled = t.Enabled
	if t.SDS != nil {
		var x GatewayTLSSDSConfig
		GatewayTLSSDSConfigFromStructs(t.SDS, &x)
		s.SDS = &x
	}
	s.TLSMinVersion = tlsVersionFromStructs(t.TLSMinVersion)
	s.TLSMaxVersion = tlsVersionFromStructs(t.TLSMaxVersion)
	s.CipherSuites = cipherSuitesFromStructs(t.CipherSuites)
}
func GatewayTLSSDSConfigToStructs(s *GatewayTLSSDSConfig, t *structs.GatewayTLSSDSConfig) {
	if s == nil {
		return
	}
	t.ClusterName = s.ClusterName
	t.CertResource = s.CertResource
}
func GatewayTLSSDSConfigFromStructs(t *structs.GatewayTLSSDSConfig, s *GatewayTLSSDSConfig) {
	if s == nil {
		return
	}
	s.ClusterName = t.ClusterName
	s.CertResource = t.CertResource
}
func HTTPFiltersToStructs(s *HTTPFilters, t *structs.HTTPFilters) {
	if s == nil {
		return
	}
	{
		t.Headers = make([]structs.HTTPHeaderFilter, len(s.Headers))
		for i := range s.Headers {
			if s.Headers[i] != nil {
				HTTPHeaderFilterToStructs(s.Headers[i], &t.Headers[i])
			}
		}
	}
	if s.URLRewrite != nil {
		var x structs.URLRewrite
		URLRewriteToStructs(s.URLRewrite, &x)
		t.URLRewrite = &x
	}
	if s.RetryFilter != nil {
		var x structs.RetryFilter
		RetryFilterToStructs(s.RetryFilter, &x)
		t.RetryFilter = &x
	}
	if s.TimeoutFilter != nil {
		var x structs.TimeoutFilter
		TimeoutFilterToStructs(s.TimeoutFilter, &x)
		t.TimeoutFilter = &x
	}
	t.JWT = routeJWTFilterToStructs(s.JWT)
}
func HTTPFiltersFromStructs(t *structs.HTTPFilters, s *HTTPFilters) {
	if s == nil {
		return
	}
	{
		s.Headers = make([]*HTTPHeaderFilter, len(t.Headers))
		for i := range t.Headers {
			{
				var x HTTPHeaderFilter
				HTTPHeaderFilterFromStructs(&t.Headers[i], &x)
				s.Headers[i] = &x
			}
		}
	}
	if t.URLRewrite != nil {
		var x URLRewrite
		URLRewriteFromStructs(t.URLRewrite, &x)
		s.URLRewrite = &x
	}
	if t.RetryFilter != nil {
		var x RetryFilter
		RetryFilterFromStructs(t.RetryFilter, &x)
		s.RetryFilter = &x
	}
	if t.TimeoutFilter != nil {
		var x TimeoutFilter
		TimeoutFilterFromStructs(t.TimeoutFilter, &x)
		s.TimeoutFilter = &x
	}
	s.JWT = routeJWTFilterFromStructs(t.JWT)
}
func HTTPHeaderFilterToStructs(s *HTTPHeaderFilter, t *structs.HTTPHeaderFilter) {
	if s == nil {
		return
	}
	t.Add = s.Add
	t.Remove = s.Remove
	t.Set = s.Set
}
func HTTPHeaderFilterFromStructs(t *structs.HTTPHeaderFilter, s *HTTPHeaderFilter) {
	if s == nil {
		return
	}
	s.Add = t.Add
	s.Remove = t.Remove
	s.Set = t.Set
}
func HTTPHeaderMatchToStructs(s *HTTPHeaderMatch, t *structs.HTTPHeaderMatch) {
	if s == nil {
		return
	}
	t.Match = httpHeaderMatchToStructs(s.Match)
	t.Name = s.Name
	t.Value = s.Value
}
func HTTPHeaderMatchFromStructs(t *structs.HTTPHeaderMatch, s *HTTPHeaderMatch) {
	if s == nil {
		return
	}
	s.Match = httpHeaderMatchFromStructs(t.Match)
	s.Name = t.Name
	s.Value = t.Value
}
func HTTPHeaderModifiersToStructs(s *HTTPHeaderModifiers, t *structs.HTTPHeaderModifiers) {
	if s == nil {
		return
	}
	t.Add = s.Add
	t.Set = s.Set
	t.Remove = s.Remove
}
func HTTPHeaderModifiersFromStructs(t *structs.HTTPHeaderModifiers, s *HTTPHeaderModifiers) {
	if s == nil {
		return
	}
	s.Add = t.Add
	s.Set = t.Set
	s.Remove = t.Remove
}
func HTTPMatchToStructs(s *HTTPMatch, t *structs.HTTPMatch) {
	if s == nil {
		return
	}
	{
		t.Headers = make([]structs.HTTPHeaderMatch, len(s.Headers))
		for i := range s.Headers {
			if s.Headers[i] != nil {
				HTTPHeaderMatchToStructs(s.Headers[i], &t.Headers[i])
			}
		}
	}
	t.Method = httpMatchMethodToStructs(s.Method)
	if s.Path != nil {
		HTTPPathMatchToStructs(s.Path, &t.Path)
	}
	{
		t.Query = make([]structs.HTTPQueryMatch, len(s.Query))
		for i := range s.Query {
			if s.Query[i] != nil {
				HTTPQueryMatchToStructs(s.Query[i], &t.Query[i])
			}
		}
	}
}
func HTTPMatchFromStructs(t *structs.HTTPMatch, s *HTTPMatch) {
	if s == nil {
		return
	}
	{
		s.Headers = make([]*HTTPHeaderMatch, len(t.Headers))
		for i := range t.Headers {
			{
				var x HTTPHeaderMatch
				HTTPHeaderMatchFromStructs(&t.Headers[i], &x)
				s.Headers[i] = &x
			}
		}
	}
	s.Method = httpMatchMethodFromStructs(t.Method)
	{
		var x HTTPPathMatch
		HTTPPathMatchFromStructs(&t.Path, &x)
		s.Path = &x
	}
	{
		s.Query = make([]*HTTPQueryMatch, len(t.Query))
		for i := range t.Query {
			{
				var x HTTPQueryMatch
				HTTPQueryMatchFromStructs(&t.Query[i], &x)
				s.Query[i] = &x
			}
		}
	}
}
func HTTPPathMatchToStructs(s *HTTPPathMatch, t *structs.HTTPPathMatch) {
	if s == nil {
		return
	}
	t.Match = httpPathMatchToStructs(s.Match)
	t.Value = s.Value
}
func HTTPPathMatchFromStructs(t *structs.HTTPPathMatch, s *HTTPPathMatch) {
	if s == nil {
		return
	}
	s.Match = httpPathMatchFromStructs(t.Match)
	s.Value = t.Value
}
func HTTPQueryMatchToStructs(s *HTTPQueryMatch, t *structs.HTTPQueryMatch) {
	if s == nil {
		return
	}
	t.Match = httpQueryMatchToStructs(s.Match)
	t.Name = s.Name
	t.Value = s.Value
}
func HTTPQueryMatchFromStructs(t *structs.HTTPQueryMatch, s *HTTPQueryMatch) {
	if s == nil {
		return
	}
	s.Match = httpQueryMatchFromStructs(t.Match)
	s.Name = t.Name
	s.Value = t.Value
}
func HTTPResponseFiltersToStructs(s *HTTPResponseFilters, t *structs.HTTPResponseFilters) {
	if s == nil {
		return
	}
	{
		t.Headers = make([]structs.HTTPHeaderFilter, len(s.Headers))
		for i := range s.Headers {
			if s.Headers[i] != nil {
				HTTPHeaderFilterToStructs(s.Headers[i], &t.Headers[i])
			}
		}
	}
}
func HTTPResponseFiltersFromStructs(t *structs.HTTPResponseFilters, s *HTTPResponseFilters) {
	if s == nil {
		return
	}
	{
		s.Headers = make([]*HTTPHeaderFilter, len(t.Headers))
		for i := range t.Headers {
			{
				var x HTTPHeaderFilter
				HTTPHeaderFilterFromStructs(&t.Headers[i], &x)
				s.Headers[i] = &x
			}
		}
	}
}
func HTTPRouteToStructs(s *HTTPRoute, t *structs.HTTPRouteConfigEntry) {
	if s == nil {
		return
	}
	{
		t.Parents = make([]structs.ResourceReference, len(s.Parents))
		for i := range s.Parents {
			if s.Parents[i] != nil {
				ResourceReferenceToStructs(s.Parents[i], &t.Parents[i])
			}
		}
	}
	{
		t.Rules = make([]structs.HTTPRouteRule, len(s.Rules))
		for i := range s.Rules {
			if s.Rules[i] != nil {
				HTTPRouteRuleToStructs(s.Rules[i], &t.Rules[i])
			}
		}
	}
	t.Hostnames = s.Hostnames
	t.Meta = s.Meta
	if s.Status != nil {
		StatusToStructs(s.Status, &t.Status)
	}
	t.Hash = s.Hash
}
func HTTPRouteFromStructs(t *structs.HTTPRouteConfigEntry, s *HTTPRoute) {
	if s == nil {
		return
	}
	{
		s.Parents = make([]*ResourceReference, len(t.Parents))
		for i := range t.Parents {
			{
				var x ResourceReference
				ResourceReferenceFromStructs(&t.Parents[i], &x)
				s.Parents[i] = &x
			}
		}
	}
	{
		s.Rules = make([]*HTTPRouteRule, len(t.Rules))
		for i := range t.Rules {
			{
				var x HTTPRouteRule
				HTTPRouteRuleFromStructs(&t.Rules[i], &x)
				s.Rules[i] = &x
			}
		}
	}
	s.Hostnames = t.Hostnames
	s.Meta = t.Meta
	{
		var x Status
		StatusFromStructs(&t.Status, &x)
		s.Status = &x
	}
	s.Hash = t.Hash
}
func HTTPRouteRuleToStructs(s *HTTPRouteRule, t *structs.HTTPRouteRule) {
	if s == nil {
		return
	}
	if s.Filters != nil {
		HTTPFiltersToStructs(s.Filters, &t.Filters)
	}
	if s.ResponseFilters != nil {
		HTTPResponseFiltersToStructs(s.ResponseFilters, &t.ResponseFilters)
	}
	{
		t.Matches = make([]structs.HTTPMatch, len(s.Matches))
		for i := range s.Matches {
			if s.Matches[i] != nil {
				HTTPMatchToStructs(s.Matches[i], &t.Matches[i])
			}
		}
	}
	{
		t.Services = make([]structs.HTTPService, len(s.Services))
		for i := range s.Services {
			if s.Services[i] != nil {
				HTTPServiceToStructs(s.Services[i], &t.Services[i])
			}
		}
	}
}
func HTTPRouteRuleFromStructs(t *structs.HTTPRouteRule, s *HTTPRouteRule) {
	if s == nil {
		return
	}
	{
		var x HTTPFilters
		HTTPFiltersFromStructs(&t.Filters, &x)
		s.Filters = &x
	}
	{
		var x HTTPResponseFilters
		HTTPResponseFiltersFromStructs(&t.ResponseFilters, &x)
		s.ResponseFilters = &x
	}
	{
		s.Matches = make([]*HTTPMatch, len(t.Matches))
		for i := range t.Matches {
			{
				var x HTTPMatch
				HTTPMatchFromStructs(&t.Matches[i], &x)
				s.Matches[i] = &x
			}
		}
	}
	{
		s.Services = make([]*HTTPService, len(t.Services))
		for i := range t.Services {
			{
				var x HTTPService
				HTTPServiceFromStructs(&t.Services[i], &x)
				s.Services[i] = &x
			}
		}
	}
}
func HTTPServiceToStructs(s *HTTPService, t *structs.HTTPService) {
	if s == nil {
		return
	}
	t.Name = s.Name
	t.Weight = int(s.Weight)
	if s.Filters != nil {
		HTTPFiltersToStructs(s.Filters, &t.Filters)
	}
	if s.ResponseFilters != nil {
		HTTPResponseFiltersToStructs(s.ResponseFilters, &t.ResponseFilters)
	}
	t.EnterpriseMeta = enterpriseMetaToStructs(s.EnterpriseMeta)
}
func HTTPServiceFromStructs(t *structs.HTTPService, s *HTTPService) {
	if s == nil {
		return
	}
	s.Name = t.Name
	s.Weight = int32(t.Weight)
	{
		var x HTTPFilters
		HTTPFiltersFromStructs(&t.Filters, &x)
		s.Filters = &x
	}
	{
		var x HTTPResponseFilters
		HTTPResponseFiltersFromStructs(&t.ResponseFilters, &x)
		s.ResponseFilters = &x
	}
	s.EnterpriseMeta = enterpriseMetaFromStructs(t.EnterpriseMeta)
}
func HashPolicyToStructs(s *HashPolicy, t *structs.HashPolicy) {
	if s == nil {
		return
	}
	t.Field = s.Field
	t.FieldValue = s.FieldValue
	if s.CookieConfig != nil {
		var x structs.CookieConfig
		CookieConfigToStructs(s.CookieConfig, &x)
		t.CookieConfig = &x
	}
	t.SourceIP = s.SourceIP
	t.Terminal = s.Terminal
}
func HashPolicyFromStructs(t *structs.HashPolicy, s *HashPolicy) {
	if s == nil {
		return
	}
	s.Field = t.Field
	s.FieldValue = t.FieldValue
	if t.CookieConfig != nil {
		var x CookieConfig
		CookieConfigFromStructs(t.CookieConfig, &x)
		s.CookieConfig = &x
	}
	s.SourceIP = t.SourceIP
	s.Terminal = t.Terminal
}
func IngressGatewayToStructs(s *IngressGateway, t *structs.IngressGatewayConfigEntry) {
	if s == nil {
		return
	}
	if s.TLS != nil {
		GatewayTLSConfigToStructs(s.TLS, &t.TLS)
	}
	{
		t.Listeners = make([]structs.IngressListener, len(s.Listeners))
		for i := range s.Listeners {
			if s.Listeners[i] != nil {
				IngressListenerToStructs(s.Listeners[i], &t.Listeners[i])
			}
		}
	}
	if s.Defaults != nil {
		var x structs.IngressServiceConfig
		IngressServiceConfigToStructs(s.Defaults, &x)
		t.Defaults = &x
	}
	t.Meta = s.Meta
	t.Hash = s.Hash
}
func IngressGatewayFromStructs(t *structs.IngressGatewayConfigEntry, s *IngressGateway) {
	if s == nil {
		return
	}
	{
		var x GatewayTLSConfig
		GatewayTLSConfigFromStructs(&t.TLS, &x)
		s.TLS = &x
	}
	{
		s.Listeners = make([]*IngressListener, len(t.Listeners))
		for i := range t.Listeners {
			{
				var x IngressListener
				IngressListenerFromStructs(&t.Listeners[i], &x)
				s.Listeners[i] = &x
			}
		}
	}
	if t.Defaults != nil {
		var x IngressServiceConfig
		IngressServiceConfigFromStructs(t.Defaults, &x)
		s.Defaults = &x
	}
	s.Meta = t.Meta
	s.Hash = t.Hash
}
func IngressListenerToStructs(s *IngressListener, t *structs.IngressListener) {
	if s == nil {
		return
	}
	t.Port = int(s.Port)
	t.Protocol = s.Protocol
	if s.TLS != nil {
		var x structs.GatewayTLSConfig
		GatewayTLSConfigToStructs(s.TLS, &x)
		t.TLS = &x
	}
	{
		t.Services = make([]structs.IngressService, len(s.Services))
		for i := range s.Services {
			if s.Services[i] != nil {
				IngressServiceToStructs(s.Services[i], &t.Services[i])
			}
		}
	}
}
func IngressListenerFromStructs(t *structs.IngressListener, s *IngressListener) {
	if s == nil {
		return
	}
	s.Port = int32(t.Port)
	s.Protocol = t.Protocol
	if t.TLS != nil {
		var x GatewayTLSConfig
		GatewayTLSConfigFromStructs(t.TLS, &x)
		s.TLS = &x
	}
	{
		s.Services = make([]*IngressService, len(t.Services))
		for i := range t.Services {
			{
				var x IngressService
				IngressServiceFromStructs(&t.Services[i], &x)
				s.Services[i] = &x
			}
		}
	}
}
func IngressServiceToStructs(s *IngressService, t *structs.IngressService) {
	if s == nil {
		return
	}
	t.Name = s.Name
	t.Hosts = s.Hosts
	if s.TLS != nil {
		var x structs.GatewayServiceTLSConfig
		GatewayServiceTLSConfigToStructs(s.TLS, &x)
		t.TLS = &x
	}
	if s.RequestHeaders != nil {
		var x structs.HTTPHeaderModifiers
		HTTPHeaderModifiersToStructs(s.RequestHeaders, &x)
		t.RequestHeaders = &x
	}
	if s.ResponseHeaders != nil {
		var x structs.HTTPHeaderModifiers
		HTTPHeaderModifiersToStructs(s.ResponseHeaders, &x)
		t.ResponseHeaders = &x
	}
	t.MaxConnections = s.MaxConnections
	t.MaxPendingRequests = s.MaxPendingRequests
	t.MaxConcurrentRequests = s.MaxConcurrentRequests
	if s.PassiveHealthCheck != nil {
		var x structs.PassiveHealthCheck
		PassiveHealthCheckToStructs(s.PassiveHealthCheck, &x)
		t.PassiveHealthCheck = &x
	}
	t.Meta = s.Meta
	t.EnterpriseMeta = enterpriseMetaToStructs(s.EnterpriseMeta)
}
func IngressServiceFromStructs(t *structs.IngressService, s *IngressService) {
	if s == nil {
		return
	}
	s.Name = t.Name
	s.Hosts = t.Hosts
	if t.TLS != nil {
		var x GatewayServiceTLSConfig
		GatewayServiceTLSConfigFromStructs(t.TLS, &x)
		s.TLS = &x
	}
	if t.RequestHeaders != nil {
		var x HTTPHeaderModifiers
		HTTPHeaderModifiersFromStructs(t.RequestHeaders, &x)
		s.RequestHeaders = &x
	}
	if t.ResponseHeaders != nil {
		var x HTTPHeaderModifiers
		HTTPHeaderModifiersFromStructs(t.ResponseHeaders, &x)
		s.ResponseHeaders = &x
	}
	s.MaxConnections = t.MaxConnections
	s.MaxPendingRequests = t.MaxPendingRequests
	s.MaxConcurrentRequests = t.MaxConcurrentRequests
	if t.PassiveHealthCheck != nil {
		var x PassiveHealthCheck
		PassiveHealthCheckFromStructs(t.PassiveHealthCheck, &x)
		s.PassiveHealthCheck = &x
	}
	s.Meta = t.Meta
	s.EnterpriseMeta = enterpriseMetaFromStructs(t.EnterpriseMeta)
}
func IngressServiceConfigToStructs(s *IngressServiceConfig, t *structs.IngressServiceConfig) {
	if s == nil {
		return
	}
	t.MaxConnections = s.MaxConnections
	t.MaxPendingRequests = s.MaxPendingRequests
	t.MaxConcurrentRequests = s.MaxConcurrentRequests
	if s.PassiveHealthCheck != nil {
		var x structs.PassiveHealthCheck
		PassiveHealthCheckToStructs(s.PassiveHealthCheck, &x)
		t.PassiveHealthCheck = &x
	}
}
func IngressServiceConfigFromStructs(t *structs.IngressServiceConfig, s *IngressServiceConfig) {
	if s == nil {
		return
	}
	s.MaxConnections = t.MaxConnections
	s.MaxPendingRequests = t.MaxPendingRequests
	s.MaxConcurrentRequests = t.MaxConcurrentRequests
	if t.PassiveHealthCheck != nil {
		var x PassiveHealthCheck
		PassiveHealthCheckFromStructs(t.PassiveHealthCheck, &x)
		s.PassiveHealthCheck = &x
	}
}
func InlineCertificateToStructs(s *InlineCertificate, t *structs.InlineCertificateConfigEntry) {
	if s == nil {
		return
	}
	t.Certificate = s.Certificate
	t.PrivateKey = s.PrivateKey
	t.Meta = s.Meta
	t.Hash = s.Hash
}
func InlineCertificateFromStructs(t *structs.InlineCertificateConfigEntry, s *InlineCertificate) {
	if s == nil {
		return
	}
	s.Certificate = t.Certificate
	s.PrivateKey = t.PrivateKey
	s.Meta = t.Meta
	s.Hash = t.Hash
}
func InstanceLevelRateLimitsToStructs(s *InstanceLevelRateLimits, t *structs.InstanceLevelRateLimits) {
	if s == nil {
		return
	}
	t.RequestsPerSecond = int(s.RequestsPerSecond)
	t.RequestsMaxBurst = int(s.RequestsMaxBurst)
	{
		t.Routes = make([]structs.InstanceLevelRouteRateLimits, len(s.Routes))
		for i := range s.Routes {
			if s.Routes[i] != nil {
				InstanceLevelRouteRateLimitsToStructs(s.Routes[i], &t.Routes[i])
			}
		}
	}
}
func InstanceLevelRateLimitsFromStructs(t *structs.InstanceLevelRateLimits, s *InstanceLevelRateLimits) {
	if s == nil {
		return
	}
	s.RequestsPerSecond = uint32(t.RequestsPerSecond)
	s.RequestsMaxBurst = uint32(t.RequestsMaxBurst)
	{
		s.Routes = make([]*InstanceLevelRouteRateLimits, len(t.Routes))
		for i := range t.Routes {
			{
				var x InstanceLevelRouteRateLimits
				InstanceLevelRouteRateLimitsFromStructs(&t.Routes[i], &x)
				s.Routes[i] = &x
			}
		}
	}
}
func InstanceLevelRouteRateLimitsToStructs(s *InstanceLevelRouteRateLimits, t *structs.InstanceLevelRouteRateLimits) {
	if s == nil {
		return
	}
	t.PathExact = s.PathExact
	t.PathPrefix = s.PathPrefix
	t.PathRegex = s.PathRegex
	t.RequestsPerSecond = int(s.RequestsPerSecond)
	t.RequestsMaxBurst = int(s.RequestsMaxBurst)
}
func InstanceLevelRouteRateLimitsFromStructs(t *structs.InstanceLevelRouteRateLimits, s *InstanceLevelRouteRateLimits) {
	if s == nil {
		return
	}
	s.PathExact = t.PathExact
	s.PathPrefix = t.PathPrefix
	s.PathRegex = t.PathRegex
	s.RequestsPerSecond = uint32(t.RequestsPerSecond)
	s.RequestsMaxBurst = uint32(t.RequestsMaxBurst)
}
func IntentionHTTPHeaderPermissionToStructs(s *IntentionHTTPHeaderPermission, t *structs.IntentionHTTPHeaderPermission) {
	if s == nil {
		return
	}
	t.Name = s.Name
	t.Present = s.Present
	t.Exact = s.Exact
	t.Prefix = s.Prefix
	t.Suffix = s.Suffix
	t.Regex = s.Regex
	t.Invert = s.Invert
}
func IntentionHTTPHeaderPermissionFromStructs(t *structs.IntentionHTTPHeaderPermission, s *IntentionHTTPHeaderPermission) {
	if s == nil {
		return
	}
	s.Name = t.Name
	s.Present = t.Present
	s.Exact = t.Exact
	s.Prefix = t.Prefix
	s.Suffix = t.Suffix
	s.Regex = t.Regex
	s.Invert = t.Invert
}
func IntentionHTTPPermissionToStructs(s *IntentionHTTPPermission, t *structs.IntentionHTTPPermission) {
	if s == nil {
		return
	}
	t.PathExact = s.PathExact
	t.PathPrefix = s.PathPrefix
	t.PathRegex = s.PathRegex
	{
		t.Header = make([]structs.IntentionHTTPHeaderPermission, len(s.Header))
		for i := range s.Header {
			if s.Header[i] != nil {
				IntentionHTTPHeaderPermissionToStructs(s.Header[i], &t.Header[i])
			}
		}
	}
	t.Methods = s.Methods
}
func IntentionHTTPPermissionFromStructs(t *structs.IntentionHTTPPermission, s *IntentionHTTPPermission) {
	if s == nil {
		return
	}
	s.PathExact = t.PathExact
	s.PathPrefix = t.PathPrefix
	s.PathRegex = t.PathRegex
	{
		s.Header = make([]*IntentionHTTPHeaderPermission, len(t.Header))
		for i := range t.Header {
			{
				var x IntentionHTTPHeaderPermission
				IntentionHTTPHeaderPermissionFromStructs(&t.Header[i], &x)
				s.Header[i] = &x
			}
		}
	}
	s.Methods = t.Methods
}
func IntentionJWTClaimVerificationToStructs(s *IntentionJWTClaimVerification, t *structs.IntentionJWTClaimVerification) {
	if s == nil {
		return
	}
	t.Path = s.Path
	t.Value = s.Value
}
func IntentionJWTClaimVerificationFromStructs(t *structs.IntentionJWTClaimVerification, s *IntentionJWTClaimVerification) {
	if s == nil {
		return
	}
	s.Path = t.Path
	s.Value = t.Value
}
func IntentionJWTProviderToStructs(s *IntentionJWTProvider, t *structs.IntentionJWTProvider) {
	if s == nil {
		return
	}
	t.Name = s.Name
	{
		t.VerifyClaims = make([]*structs.IntentionJWTClaimVerification, len(s.VerifyClaims))
		for i := range s.VerifyClaims {
			if s.VerifyClaims[i] != nil {
				var x structs.IntentionJWTClaimVerification
				IntentionJWTClaimVerificationToStructs(s.VerifyClaims[i], &x)
				t.VerifyClaims[i] = &x
			}
		}
	}
}
func IntentionJWTProviderFromStructs(t *structs.IntentionJWTProvider, s *IntentionJWTProvider) {
	if s == nil {
		return
	}
	s.Name = t.Name
	{
		s.VerifyClaims = make([]*IntentionJWTClaimVerification, len(t.VerifyClaims))
		for i := range t.VerifyClaims {
			if t.VerifyClaims[i] != nil {
				var x IntentionJWTClaimVerification
				IntentionJWTClaimVerificationFromStructs(t.VerifyClaims[i], &x)
				s.VerifyClaims[i] = &x
			}
		}
	}
}
func IntentionJWTRequirementToStructs(s *IntentionJWTRequirement, t *structs.IntentionJWTRequirement) {
	if s == nil {
		return
	}
	{
		t.Providers = make([]*structs.IntentionJWTProvider, len(s.Providers))
		for i := range s.Providers {
			if s.Providers[i] != nil {
				var x structs.IntentionJWTProvider
				IntentionJWTProviderToStructs(s.Providers[i], &x)
				t.Providers[i] = &x
			}
		}
	}
}
func IntentionJWTRequirementFromStructs(t *structs.IntentionJWTRequirement, s *IntentionJWTRequirement) {
	if s == nil {
		return
	}
	{
		s.Providers = make([]*IntentionJWTProvider, len(t.Providers))
		for i := range t.Providers {
			if t.Providers[i] != nil {
				var x IntentionJWTProvider
				IntentionJWTProviderFromStructs(t.Providers[i], &x)
				s.Providers[i] = &x
			}
		}
	}
}
func IntentionPermissionToStructs(s *IntentionPermission, t *structs.IntentionPermission) {
	if s == nil {
		return
	}
	t.Action = intentionActionToStructs(s.Action)
	if s.HTTP != nil {
		var x structs.IntentionHTTPPermission
		IntentionHTTPPermissionToStructs(s.HTTP, &x)
		t.HTTP = &x
	}
	if s.JWT != nil {
		var x structs.IntentionJWTRequirement
		IntentionJWTRequirementToStructs(s.JWT, &x)
		t.JWT = &x
	}
}
func IntentionPermissionFromStructs(t *structs.IntentionPermission, s *IntentionPermission) {
	if s == nil {
		return
	}
	s.Action = intentionActionFromStructs(t.Action)
	if t.HTTP != nil {
		var x IntentionHTTPPermission
		IntentionHTTPPermissionFromStructs(t.HTTP, &x)
		s.HTTP = &x
	}
	if t.JWT != nil {
		var x IntentionJWTRequirement
		IntentionJWTRequirementFromStructs(t.JWT, &x)
		s.JWT = &x
	}
}
func JSONWebKeySetToStructs(s *JSONWebKeySet, t *structs.JSONWebKeySet) {
	if s == nil {
		return
	}
	if s.Local != nil {
		var x structs.LocalJWKS
		LocalJWKSToStructs(s.Local, &x)
		t.Local = &x
	}
	if s.Remote != nil {
		var x structs.RemoteJWKS
		RemoteJWKSToStructs(s.Remote, &x)
		t.Remote = &x
	}
}
func JSONWebKeySetFromStructs(t *structs.JSONWebKeySet, s *JSONWebKeySet) {
	if s == nil {
		return
	}
	if t.Local != nil {
		var x LocalJWKS
		LocalJWKSFromStructs(t.Local, &x)
		s.Local = &x
	}
	if t.Remote != nil {
		var x RemoteJWKS
		RemoteJWKSFromStructs(t.Remote, &x)
		s.Remote = &x
	}
}
func JWKSClusterToStructs(s *JWKSCluster, t *structs.JWKSCluster) {
	if s == nil {
		return
	}
	t.DiscoveryType = structs.ClusterDiscoveryType(s.DiscoveryType)
	if s.TLSCertificates != nil {
		var x structs.JWKSTLSCertificate
		JWKSTLSCertificateToStructs(s.TLSCertificates, &x)
		t.TLSCertificates = &x
	}
	t.ConnectTimeout = structs.DurationFromProto(s.ConnectTimeout)
}
func JWKSClusterFromStructs(t *structs.JWKSCluster, s *JWKSCluster) {
	if s == nil {
		return
	}
	s.DiscoveryType = string(t.DiscoveryType)
	if t.TLSCertificates != nil {
		var x JWKSTLSCertificate
		JWKSTLSCertificateFromStructs(t.TLSCertificates, &x)
		s.TLSCertificates = &x
	}
	s.ConnectTimeout = structs.DurationToProto(t.ConnectTimeout)
}
func JWKSRetryPolicyToStructs(s *JWKSRetryPolicy, t *structs.JWKSRetryPolicy) {
	if s == nil {
		return
	}
	t.NumRetries = int(s.NumRetries)
	if s.RetryPolicyBackOff != nil {
		var x structs.RetryPolicyBackOff
		RetryPolicyBackOffToStructs(s.RetryPolicyBackOff, &x)
		t.RetryPolicyBackOff = &x
	}
}
func JWKSRetryPolicyFromStructs(t *structs.JWKSRetryPolicy, s *JWKSRetryPolicy) {
	if s == nil {
		return
	}
	s.NumRetries = int32(t.NumRetries)
	if t.RetryPolicyBackOff != nil {
		var x RetryPolicyBackOff
		RetryPolicyBackOffFromStructs(t.RetryPolicyBackOff, &x)
		s.RetryPolicyBackOff = &x
	}
}
func JWKSTLSCertProviderInstanceToStructs(s *JWKSTLSCertProviderInstance, t *structs.JWKSTLSCertProviderInstance) {
	if s == nil {
		return
	}
	t.InstanceName = s.InstanceName
	t.CertificateName = s.CertificateName
}
func JWKSTLSCertProviderInstanceFromStructs(t *structs.JWKSTLSCertProviderInstance, s *JWKSTLSCertProviderInstance) {
	if s == nil {
		return
	}
	s.InstanceName = t.InstanceName
	s.CertificateName = t.CertificateName
}
func JWKSTLSCertTrustedCAToStructs(s *JWKSTLSCertTrustedCA, t *structs.JWKSTLSCertTrustedCA) {
	if s == nil {
		return
	}
	t.Filename = s.Filename
	t.EnvironmentVariable = s.EnvironmentVariable
	t.InlineString = s.InlineString
	t.InlineBytes = s.InlineBytes
}
func JWKSTLSCertTrustedCAFromStructs(t *structs.JWKSTLSCertTrustedCA, s *JWKSTLSCertTrustedCA) {
	if s == nil {
		return
	}
	s.Filename = t.Filename
	s.EnvironmentVariable = t.EnvironmentVariable
	s.InlineString = t.InlineString
	s.InlineBytes = t.InlineBytes
}
func JWKSTLSCertificateToStructs(s *JWKSTLSCertificate, t *structs.JWKSTLSCertificate) {
	if s == nil {
		return
	}
	if s.CaCertificateProviderInstance != nil {
		var x structs.JWKSTLSCertProviderInstance
		JWKSTLSCertProviderInstanceToStructs(s.CaCertificateProviderInstance, &x)
		t.CaCertificateProviderInstance = &x
	}
	if s.TrustedCA != nil {
		var x structs.JWKSTLSCertTrustedCA
		JWKSTLSCertTrustedCAToStructs(s.TrustedCA, &x)
		t.TrustedCA = &x
	}
}
func JWKSTLSCertificateFromStructs(t *structs.JWKSTLSCertificate, s *JWKSTLSCertificate) {
	if s == nil {
		return
	}
	if t.CaCertificateProviderInstance != nil {
		var x JWKSTLSCertProviderInstance
		JWKSTLSCertProviderInstanceFromStructs(t.CaCertificateProviderInstance, &x)
		s.CaCertificateProviderInstance = &x
	}
	if t.TrustedCA != nil {
		var x JWKSTLSCertTrustedCA
		JWKSTLSCertTrustedCAFromStructs(t.TrustedCA, &x)
		s.TrustedCA = &x
	}
}
func JWTCacheConfigToStructs(s *JWTCacheConfig, t *structs.JWTCacheConfig) {
	if s == nil {
		return
	}
	t.Size = int(s.Size)
}
func JWTCacheConfigFromStructs(t *structs.JWTCacheConfig, s *JWTCacheConfig) {
	if s == nil {
		return
	}
	s.Size = int32(t.Size)
}
func JWTForwardingConfigToStructs(s *JWTForwardingConfig, t *structs.JWTForwardingConfig) {
	if s == nil {
		return
	}
	t.HeaderName = s.HeaderName
	t.PadForwardPayloadHeader = s.PadForwardPayloadHeader
}
func JWTForwardingConfigFromStructs(t *structs.JWTForwardingConfig, s *JWTForwardingConfig) {
	if s == nil {
		return
	}
	s.HeaderName = t.HeaderName
	s.PadForwardPayloadHeader = t.PadForwardPayloadHeader
}
func JWTLocationToStructs(s *JWTLocation, t *structs.JWTLocation) {
	if s == nil {
		return
	}
	if s.Header != nil {
		var x structs.JWTLocationHeader
		JWTLocationHeaderToStructs(s.Header, &x)
		t.Header = &x
	}
	if s.QueryParam != nil {
		var x structs.JWTLocationQueryParam
		JWTLocationQueryParamToStructs(s.QueryParam, &x)
		t.QueryParam = &x
	}
	if s.Cookie != nil {
		var x structs.JWTLocationCookie
		JWTLocationCookieToStructs(s.Cookie, &x)
		t.Cookie = &x
	}
}
func JWTLocationFromStructs(t *structs.JWTLocation, s *JWTLocation) {
	if s == nil {
		return
	}
	if t.Header != nil {
		var x JWTLocationHeader
		JWTLocationHeaderFromStructs(t.Header, &x)
		s.Header = &x
	}
	if t.QueryParam != nil {
		var x JWTLocationQueryParam
		JWTLocationQueryParamFromStructs(t.QueryParam, &x)
		s.QueryParam = &x
	}
	if t.Cookie != nil {
		var x JWTLocationCookie
		JWTLocationCookieFromStructs(t.Cookie, &x)
		s.Cookie = &x
	}
}
func JWTLocationCookieToStructs(s *JWTLocationCookie, t *structs.JWTLocationCookie) {
	if s == nil {
		return
	}
	t.Name = s.Name
}
func JWTLocationCookieFromStructs(t *structs.JWTLocationCookie, s *JWTLocationCookie) {
	if s == nil {
		return
	}
	s.Name = t.Name
}
func JWTLocationHeaderToStructs(s *JWTLocationHeader, t *structs.JWTLocationHeader) {
	if s == nil {
		return
	}
	t.Name = s.Name
	t.ValuePrefix = s.ValuePrefix
	t.Forward = s.Forward
}
func JWTLocationHeaderFromStructs(t *structs.JWTLocationHeader, s *JWTLocationHeader) {
	if s == nil {
		return
	}
	s.Name = t.Name
	s.ValuePrefix = t.ValuePrefix
	s.Forward = t.Forward
}
func JWTLocationQueryParamToStructs(s *JWTLocationQueryParam, t *structs.JWTLocationQueryParam) {
	if s == nil {
		return
	}
	t.Name = s.Name
}
func JWTLocationQueryParamFromStructs(t *structs.JWTLocationQueryParam, s *JWTLocationQueryParam) {
	if s == nil {
		return
	}
	s.Name = t.Name
}
func JWTProviderToStructs(s *JWTProvider, t *structs.JWTProviderConfigEntry) {
	if s == nil {
		return
	}
	if s.JSONWebKeySet != nil {
		var x structs.JSONWebKeySet
		JSONWebKeySetToStructs(s.JSONWebKeySet, &x)
		t.JSONWebKeySet = &x
	}
	t.Issuer = s.Issuer
	t.Audiences = s.Audiences
	{
		t.Locations = make([]*structs.JWTLocation, len(s.Locations))
		for i := range s.Locations {
			if s.Locations[i] != nil {
				var x structs.JWTLocation
				JWTLocationToStructs(s.Locations[i], &x)
				t.Locations[i] = &x
			}
		}
	}
	if s.Forwarding != nil {
		var x structs.JWTForwardingConfig
		JWTForwardingConfigToStructs(s.Forwarding, &x)
		t.Forwarding = &x
	}
	t.ClockSkewSeconds = int(s.ClockSkewSeconds)
	if s.CacheConfig != nil {
		var x structs.JWTCacheConfig
		JWTCacheConfigToStructs(s.CacheConfig, &x)
		t.CacheConfig = &x
	}
	t.Meta = s.Meta
	t.Hash = s.Hash
}
func JWTProviderFromStructs(t *structs.JWTProviderConfigEntry, s *JWTProvider) {
	if s == nil {
		return
	}
	if t.JSONWebKeySet != nil {
		var x JSONWebKeySet
		JSONWebKeySetFromStructs(t.JSONWebKeySet, &x)
		s.JSONWebKeySet = &x
	}
	s.Issuer = t.Issuer
	s.Audiences = t.Audiences
	{
		s.Locations = make([]*JWTLocation, len(t.Locations))
		for i := range t.Locations {
			if t.Locations[i] != nil {
				var x JWTLocation
				JWTLocationFromStructs(t.Locations[i], &x)
				s.Locations[i] = &x
			}
		}
	}
	if t.Forwarding != nil {
		var x JWTForwardingConfig
		JWTForwardingConfigFromStructs(t.Forwarding, &x)
		s.Forwarding = &x
	}
	s.ClockSkewSeconds = int32(t.ClockSkewSeconds)
	if t.CacheConfig != nil {
		var x JWTCacheConfig
		JWTCacheConfigFromStructs(t.CacheConfig, &x)
		s.CacheConfig = &x
	}
	s.Meta = t.Meta
	s.Hash = t.Hash
}
func LeastRequestConfigToStructs(s *LeastRequestConfig, t *structs.LeastRequestConfig) {
	if s == nil {
		return
	}
	t.ChoiceCount = s.ChoiceCount
}
func LeastRequestConfigFromStructs(t *structs.LeastRequestConfig, s *LeastRequestConfig) {
	if s == nil {
		return
	}
	s.ChoiceCount = t.ChoiceCount
}
func LoadBalancerToStructs(s *LoadBalancer, t *structs.LoadBalancer) {
	if s == nil {
		return
	}
	t.Policy = s.Policy
	if s.RingHashConfig != nil {
		var x structs.RingHashConfig
		RingHashConfigToStructs(s.RingHashConfig, &x)
		t.RingHashConfig = &x
	}
	if s.LeastRequestConfig != nil {
		var x structs.LeastRequestConfig
		LeastRequestConfigToStructs(s.LeastRequestConfig, &x)
		t.LeastRequestConfig = &x
	}
	{
		t.HashPolicies = make([]structs.HashPolicy, len(s.HashPolicies))
		for i := range s.HashPolicies {
			if s.HashPolicies[i] != nil {
				HashPolicyToStructs(s.HashPolicies[i], &t.HashPolicies[i])
			}
		}
	}
}
func LoadBalancerFromStructs(t *structs.LoadBalancer, s *LoadBalancer) {
	if s == nil {
		return
	}
	s.Policy = t.Policy
	if t.RingHashConfig != nil {
		var x RingHashConfig
		RingHashConfigFromStructs(t.RingHashConfig, &x)
		s.RingHashConfig = &x
	}
	if t.LeastRequestConfig != nil {
		var x LeastRequestConfig
		LeastRequestConfigFromStructs(t.LeastRequestConfig, &x)
		s.LeastRequestConfig = &x
	}
	{
		s.HashPolicies = make([]*HashPolicy, len(t.HashPolicies))
		for i := range t.HashPolicies {
			{
				var x HashPolicy
				HashPolicyFromStructs(&t.HashPolicies[i], &x)
				s.HashPolicies[i] = &x
			}
		}
	}
}
func LocalJWKSToStructs(s *LocalJWKS, t *structs.LocalJWKS) {
	if s == nil {
		return
	}
	t.JWKS = s.JWKS
	t.Filename = s.Filename
}
func LocalJWKSFromStructs(t *structs.LocalJWKS, s *LocalJWKS) {
	if s == nil {
		return
	}
	s.JWKS = t.JWKS
	s.Filename = t.Filename
}
func MeshConfigToStructs(s *MeshConfig, t *structs.MeshConfigEntry) {
	if s == nil {
		return
	}
	if s.TransparentProxy != nil {
		TransparentProxyMeshConfigToStructs(s.TransparentProxy, &t.TransparentProxy)
	}
	t.AllowEnablingPermissiveMutualTLS = s.AllowEnablingPermissiveMutualTLS
	if s.TLS != nil {
		var x structs.MeshTLSConfig
		MeshTLSConfigToStructs(s.TLS, &x)
		t.TLS = &x
	}
	if s.HTTP != nil {
		var x structs.MeshHTTPConfig
		MeshHTTPConfigToStructs(s.HTTP, &x)
		t.HTTP = &x
	}
	if s.Peering != nil {
		var x structs.PeeringMeshConfig
		PeeringMeshConfigToStructs(s.Peering, &x)
		t.Peering = &x
	}
	t.Meta = s.Meta
	t.Hash = s.Hash
}
func MeshConfigFromStructs(t *structs.MeshConfigEntry, s *MeshConfig) {
	if s == nil {
		return
	}
	{
		var x TransparentProxyMeshConfig
		TransparentProxyMeshConfigFromStructs(&t.TransparentProxy, &x)
		s.TransparentProxy = &x
	}
	s.AllowEnablingPermissiveMutualTLS = t.AllowEnablingPermissiveMutualTLS
	if t.TLS != nil {
		var x MeshTLSConfig
		MeshTLSConfigFromStructs(t.TLS, &x)
		s.TLS = &x
	}
	if t.HTTP != nil {
		var x MeshHTTPConfig
		MeshHTTPConfigFromStructs(t.HTTP, &x)
		s.HTTP = &x
	}
	if t.Peering != nil {
		var x PeeringMeshConfig
		PeeringMeshConfigFromStructs(t.Peering, &x)
		s.Peering = &x
	}
	s.Meta = t.Meta
	s.Hash = t.Hash
}
func MeshDirectionalTLSConfigToStructs(s *MeshDirectionalTLSConfig, t *structs.MeshDirectionalTLSConfig) {
	if s == nil {
		return
	}
	t.TLSMinVersion = tlsVersionToStructs(s.TLSMinVersion)
	t.TLSMaxVersion = tlsVersionToStructs(s.TLSMaxVersion)
	t.CipherSuites = cipherSuitesToStructs(s.CipherSuites)
}
func MeshDirectionalTLSConfigFromStructs(t *structs.MeshDirectionalTLSConfig, s *MeshDirectionalTLSConfig) {
	if s == nil {
		return
	}
	s.TLSMinVersion = tlsVersionFromStructs(t.TLSMinVersion)
	s.TLSMaxVersion = tlsVersionFromStructs(t.TLSMaxVersion)
	s.CipherSuites = cipherSuitesFromStructs(t.CipherSuites)
}
func MeshGatewayConfigToStructs(s *MeshGatewayConfig, t *structs.MeshGatewayConfig) {
	if s == nil {
		return
	}
	t.Mode = meshGatewayModeToStructs(s.Mode)
}
func MeshGatewayConfigFromStructs(t *structs.MeshGatewayConfig, s *MeshGatewayConfig) {
	if s == nil {
		return
	}
	s.Mode = meshGatewayModeFromStructs(t.Mode)
}
func MeshHTTPConfigToStructs(s *MeshHTTPConfig, t *structs.MeshHTTPConfig) {
	if s == nil {
		return
	}
	t.SanitizeXForwardedClientCert = s.SanitizeXForwardedClientCert
}
func MeshHTTPConfigFromStructs(t *structs.MeshHTTPConfig, s *MeshHTTPConfig) {
	if s == nil {
		return
	}
	s.SanitizeXForwardedClientCert = t.SanitizeXForwardedClientCert
}
func MeshTLSConfigToStructs(s *MeshTLSConfig, t *structs.MeshTLSConfig) {
	if s == nil {
		return
	}
	if s.Incoming != nil {
		var x structs.MeshDirectionalTLSConfig
		MeshDirectionalTLSConfigToStructs(s.Incoming, &x)
		t.Incoming = &x
	}
	if s.Outgoing != nil {
		var x structs.MeshDirectionalTLSConfig
		MeshDirectionalTLSConfigToStructs(s.Outgoing, &x)
		t.Outgoing = &x
	}
}
func MeshTLSConfigFromStructs(t *structs.MeshTLSConfig, s *MeshTLSConfig) {
	if s == nil {
		return
	}
	if t.Incoming != nil {
		var x MeshDirectionalTLSConfig
		MeshDirectionalTLSConfigFromStructs(t.Incoming, &x)
		s.Incoming = &x
	}
	if t.Outgoing != nil {
		var x MeshDirectionalTLSConfig
		MeshDirectionalTLSConfigFromStructs(t.Outgoing, &x)
		s.Outgoing = &x
	}
}
func PassiveHealthCheckToStructs(s *PassiveHealthCheck, t *structs.PassiveHealthCheck) {
	if s == nil {
		return
	}
	t.Interval = structs.DurationFromProto(s.Interval)
	t.MaxFailures = s.MaxFailures
	t.EnforcingConsecutive5xx = pointerToUint32FromUint32(s.EnforcingConsecutive5Xx)
	t.MaxEjectionPercent = pointerToUint32FromUint32(s.MaxEjectionPercent)
	t.BaseEjectionTime = structs.DurationPointerFromProto(s.BaseEjectionTime)
}
func PassiveHealthCheckFromStructs(t *structs.PassiveHealthCheck, s *PassiveHealthCheck) {
	if s == nil {
		return
	}
	s.Interval = structs.DurationToProto(t.Interval)
	s.MaxFailures = t.MaxFailures
	s.EnforcingConsecutive5Xx = uint32FromPointerToUint32(t.EnforcingConsecutive5xx)
	s.MaxEjectionPercent = uint32FromPointerToUint32(t.MaxEjectionPercent)
	s.BaseEjectionTime = structs.DurationPointerToProto(t.BaseEjectionTime)
}
func PeeringMeshConfigToStructs(s *PeeringMeshConfig, t *structs.PeeringMeshConfig) {
	if s == nil {
		return
	}
	t.PeerThroughMeshGateways = s.PeerThroughMeshGateways
}
func PeeringMeshConfigFromStructs(t *structs.PeeringMeshConfig, s *PeeringMeshConfig) {
	if s == nil {
		return
	}
	s.PeerThroughMeshGateways = t.PeerThroughMeshGateways
}
func RateLimitsToStructs(s *RateLimits, t *structs.RateLimits) {
	if s == nil {
		return
	}
	if s.InstanceLevel != nil {
		InstanceLevelRateLimitsToStructs(s.InstanceLevel, &t.InstanceLevel)
	}
}
func RateLimitsFromStructs(t *structs.RateLimits, s *RateLimits) {
	if s == nil {
		return
	}
	{
		var x InstanceLevelRateLimits
		InstanceLevelRateLimitsFromStructs(&t.InstanceLevel, &x)
		s.InstanceLevel = &x
	}
}
func RemoteJWKSToStructs(s *RemoteJWKS, t *structs.RemoteJWKS) {
	if s == nil {
		return
	}
	t.URI = s.URI
	t.RequestTimeoutMs = int(s.RequestTimeoutMs)
	t.CacheDuration = structs.DurationFromProto(s.CacheDuration)
	t.FetchAsynchronously = s.FetchAsynchronously
	if s.RetryPolicy != nil {
		var x structs.JWKSRetryPolicy
		JWKSRetryPolicyToStructs(s.RetryPolicy, &x)
		t.RetryPolicy = &x
	}
	if s.JWKSCluster != nil {
		var x structs.JWKSCluster
		JWKSClusterToStructs(s.JWKSCluster, &x)
		t.JWKSCluster = &x
	}
}
func RemoteJWKSFromStructs(t *structs.RemoteJWKS, s *RemoteJWKS) {
	if s == nil {
		return
	}
	s.URI = t.URI
	s.RequestTimeoutMs = int32(t.RequestTimeoutMs)
	s.CacheDuration = structs.DurationToProto(t.CacheDuration)
	s.FetchAsynchronously = t.FetchAsynchronously
	if t.RetryPolicy != nil {
		var x JWKSRetryPolicy
		JWKSRetryPolicyFromStructs(t.RetryPolicy, &x)
		s.RetryPolicy = &x
	}
	if t.JWKSCluster != nil {
		var x JWKSCluster
		JWKSClusterFromStructs(t.JWKSCluster, &x)
		s.JWKSCluster = &x
	}
}
func ResourceReferenceToStructs(s *ResourceReference, t *structs.ResourceReference) {
	if s == nil {
		return
	}
	t.Kind = s.Kind
	t.Name = s.Name
	t.SectionName = s.SectionName
	t.EnterpriseMeta = enterpriseMetaToStructs(s.EnterpriseMeta)
}
func ResourceReferenceFromStructs(t *structs.ResourceReference, s *ResourceReference) {
	if s == nil {
		return
	}
	s.Kind = t.Kind
	s.Name = t.Name
	s.SectionName = t.SectionName
	s.EnterpriseMeta = enterpriseMetaFromStructs(t.EnterpriseMeta)
}
func RetryFilterToStructs(s *RetryFilter, t *structs.RetryFilter) {
	if s == nil {
		return
	}
	t.NumRetries = s.NumRetries
	t.RetryOn = s.RetryOn
	t.RetryOnStatusCodes = s.RetryOnStatusCodes
	t.RetryOnConnectFailure = s.RetryOnConnectFailure
}
func RetryFilterFromStructs(t *structs.RetryFilter, s *RetryFilter) {
	if s == nil {
		return
	}
	s.NumRetries = t.NumRetries
	s.RetryOn = t.RetryOn
	s.RetryOnStatusCodes = t.RetryOnStatusCodes
	s.RetryOnConnectFailure = t.RetryOnConnectFailure
}
func RetryPolicyBackOffToStructs(s *RetryPolicyBackOff, t *structs.RetryPolicyBackOff) {
	if s == nil {
		return
	}
	t.BaseInterval = structs.DurationFromProto(s.BaseInterval)
	t.MaxInterval = structs.DurationFromProto(s.MaxInterval)
}
func RetryPolicyBackOffFromStructs(t *structs.RetryPolicyBackOff, s *RetryPolicyBackOff) {
	if s == nil {
		return
	}
	s.BaseInterval = structs.DurationToProto(t.BaseInterval)
	s.MaxInterval = structs.DurationToProto(t.MaxInterval)
}
func RingHashConfigToStructs(s *RingHashConfig, t *structs.RingHashConfig) {
	if s == nil {
		return
	}
	t.MinimumRingSize = s.MinimumRingSize
	t.MaximumRingSize = s.MaximumRingSize
}
func RingHashConfigFromStructs(t *structs.RingHashConfig, s *RingHashConfig) {
	if s == nil {
		return
	}
	s.MinimumRingSize = t.MinimumRingSize
	s.MaximumRingSize = t.MaximumRingSize
}
func SamenessGroupToStructs(s *SamenessGroup, t *structs.SamenessGroupConfigEntry) {
	if s == nil {
		return
	}
	t.Name = s.Name
	t.DefaultForFailover = s.DefaultForFailover
	t.IncludeLocal = s.IncludeLocal
	{
		t.Members = make([]structs.SamenessGroupMember, len(s.Members))
		for i := range s.Members {
			if s.Members[i] != nil {
				SamenessGroupMemberToStructs(s.Members[i], &t.Members[i])
			}
		}
	}
	t.Meta = s.Meta
	t.Hash = s.Hash
	t.EnterpriseMeta = enterpriseMetaToStructs(s.EnterpriseMeta)
}
func SamenessGroupFromStructs(t *structs.SamenessGroupConfigEntry, s *SamenessGroup) {
	if s == nil {
		return
	}
	s.Name = t.Name
	s.DefaultForFailover = t.DefaultForFailover
	s.IncludeLocal = t.IncludeLocal
	{
		s.Members = make([]*SamenessGroupMember, len(t.Members))
		for i := range t.Members {
			{
				var x SamenessGroupMember
				SamenessGroupMemberFromStructs(&t.Members[i], &x)
				s.Members[i] = &x
			}
		}
	}
	s.Meta = t.Meta
	s.Hash = t.Hash
	s.EnterpriseMeta = enterpriseMetaFromStructs(t.EnterpriseMeta)
}
func SamenessGroupMemberToStructs(s *SamenessGroupMember, t *structs.SamenessGroupMember) {
	if s == nil {
		return
	}
	t.Partition = s.Partition
	t.Peer = s.Peer
}
func SamenessGroupMemberFromStructs(t *structs.SamenessGroupMember, s *SamenessGroupMember) {
	if s == nil {
		return
	}
	s.Partition = t.Partition
	s.Peer = t.Peer
}
func ServiceDefaultsToStructs(s *ServiceDefaults, t *structs.ServiceConfigEntry) {
	if s == nil {
		return
	}
	t.Protocol = s.Protocol
	t.Mode = proxyModeToStructs(s.Mode)
	if s.TransparentProxy != nil {
		TransparentProxyConfigToStructs(s.TransparentProxy, &t.TransparentProxy)
	}
	t.MutualTLSMode = mutualTLSModeToStructs(s.MutualTLSMode)
	if s.MeshGateway != nil {
		MeshGatewayConfigToStructs(s.MeshGateway, &t.MeshGateway)
	}
	if s.Expose != nil {
		ExposeConfigToStructs(s.Expose, &t.Expose)
	}
	t.ExternalSNI = s.ExternalSNI
	if s.UpstreamConfig != nil {
		var x structs.UpstreamConfiguration
		UpstreamConfigurationToStructs(s.UpstreamConfig, &x)
		t.UpstreamConfig = &x
	}
	if s.Destination != nil {
		var x structs.DestinationConfig
		DestinationConfigToStructs(s.Destination, &x)
		t.Destination = &x
	}
	t.MaxInboundConnections = int(s.MaxInboundConnections)
	t.LocalConnectTimeoutMs = int(s.LocalConnectTimeoutMs)
	t.LocalRequestTimeoutMs = int(s.LocalRequestTimeoutMs)
	t.BalanceInboundConnections = s.BalanceInboundConnections
	if s.RateLimits != nil {
		var x structs.RateLimits
		RateLimitsToStructs(s.RateLimits, &x)
		t.RateLimits = &x
	}
	t.EnvoyExtensions = EnvoyExtensionsToStructs(s.EnvoyExtensions)
	t.Meta = s.Meta
	t.Hash = s.Hash
}
func ServiceDefaultsFromStructs(t *structs.ServiceConfigEntry, s *ServiceDefaults) {
	if s == nil {
		return
	}
	s.Protocol = t.Protocol
	s.Mode = proxyModeFromStructs(t.Mode)
	{
		var x TransparentProxyConfig
		TransparentProxyConfigFromStructs(&t.TransparentProxy, &x)
		s.TransparentProxy = &x
	}
	s.MutualTLSMode = mutualTLSModeFromStructs(t.MutualTLSMode)
	{
		var x MeshGatewayConfig
		MeshGatewayConfigFromStructs(&t.MeshGateway, &x)
		s.MeshGateway = &x
	}
	{
		var x ExposeConfig
		ExposeConfigFromStructs(&t.Expose, &x)
		s.Expose = &x
	}
	s.ExternalSNI = t.ExternalSNI
	if t.UpstreamConfig != nil {
		var x UpstreamConfiguration
		UpstreamConfigurationFromStructs(t.UpstreamConfig, &x)
		s.UpstreamConfig = &x
	}
	if t.Destination != nil {
		var x DestinationConfig
		DestinationConfigFromStructs(t.Destination, &x)
		s.Destination = &x
	}
	s.MaxInboundConnections = int32(t.MaxInboundConnections)
	s.LocalConnectTimeoutMs = int32(t.LocalConnectTimeoutMs)
	s.LocalRequestTimeoutMs = int32(t.LocalRequestTimeoutMs)
	s.BalanceInboundConnections = t.BalanceInboundConnections
	if t.RateLimits != nil {
		var x RateLimits
		RateLimitsFromStructs(t.RateLimits, &x)
		s.RateLimits = &x
	}
	s.EnvoyExtensions = EnvoyExtensionsFromStructs(t.EnvoyExtensions)
	s.Meta = t.Meta
	s.Hash = t.Hash
}
func ServiceIntentionsToStructs(s *ServiceIntentions, t *structs.ServiceIntentionsConfigEntry) {
	if s == nil {
		return
	}
	{
		t.Sources = make([]*structs.SourceIntention, len(s.Sources))
		for i := range s.Sources {
			if s.Sources[i] != nil {
				var x structs.SourceIntention
				SourceIntentionToStructs(s.Sources[i], &x)
				t.Sources[i] = &x
			}
		}
	}
	if s.JWT != nil {
		var x structs.IntentionJWTRequirement
		IntentionJWTRequirementToStructs(s.JWT, &x)
		t.JWT = &x
	}
	t.Meta = s.Meta
	t.Hash = s.Hash
}
func ServiceIntentionsFromStructs(t *structs.ServiceIntentionsConfigEntry, s *ServiceIntentions) {
	if s == nil {
		return
	}
	{
		s.Sources = make([]*SourceIntention, len(t.Sources))
		for i := range t.Sources {
			if t.Sources[i] != nil {
				var x SourceIntention
				SourceIntentionFromStructs(t.Sources[i], &x)
				s.Sources[i] = &x
			}
		}
	}
	if t.JWT != nil {
		var x IntentionJWTRequirement
		IntentionJWTRequirementFromStructs(t.JWT, &x)
		s.JWT = &x
	}
	s.Meta = t.Meta
	s.Hash = t.Hash
}
func ServiceResolverToStructs(s *ServiceResolver, t *structs.ServiceResolverConfigEntry) {
	if s == nil {
		return
	}
	t.DefaultSubset = s.DefaultSubset
	{
		t.Subsets = make(map[string]structs.ServiceResolverSubset, len(s.Subsets))
		for k, v := range s.Subsets {
			var y structs.ServiceResolverSubset
			if v != nil {
				ServiceResolverSubsetToStructs(v, &y)
			}
			t.Subsets[k] = y
		}
	}
	if s.Redirect != nil {
		var x structs.ServiceResolverRedirect
		ServiceResolverRedirectToStructs(s.Redirect, &x)
		t.Redirect = &x
	}
	{
		t.Failover = make(map[string]structs.ServiceResolverFailover, len(s.Failover))
		for k, v := range s.Failover {
			var y structs.ServiceResolverFailover
			if v != nil {
				ServiceResolverFailoverToStructs(v, &y)
			}
			t.Failover[k] = y
		}
	}
	if s.PrioritizeByLocality != nil {
		var x structs.ServiceResolverPrioritizeByLocality
		ServiceResolverPrioritizeByLocalityToStructs(s.PrioritizeByLocality, &x)
		t.PrioritizeByLocality = &x
	}
	t.ConnectTimeout = structs.DurationFromProto(s.ConnectTimeout)
	t.RequestTimeout = structs.DurationFromProto(s.RequestTimeout)
	if s.LoadBalancer != nil {
		var x structs.LoadBalancer
		LoadBalancerToStructs(s.LoadBalancer, &x)
		t.LoadBalancer = &x
	}
	t.Meta = s.Meta
	t.Hash = s.Hash
}
func ServiceResolverFromStructs(t *structs.ServiceResolverConfigEntry, s *ServiceResolver) {
	if s == nil {
		return
	}
	s.DefaultSubset = t.DefaultSubset
	{
		s.Subsets = make(map[string]*ServiceResolverSubset, len(t.Subsets))
		for k, v := range t.Subsets {
			var y *ServiceResolverSubset
			{
				var x ServiceResolverSubset
				ServiceResolverSubsetFromStructs(&v, &x)
				y = &x
			}
			s.Subsets[k] = y
		}
	}
	if t.Redirect != nil {
		var x ServiceResolverRedirect
		ServiceResolverRedirectFromStructs(t.Redirect, &x)
		s.Redirect = &x
	}
	{
		s.Failover = make(map[string]*ServiceResolverFailover, len(t.Failover))
		for k, v := range t.Failover {
			var y *ServiceResolverFailover
			{
				var x ServiceResolverFailover
				ServiceResolverFailoverFromStructs(&v, &x)
				y = &x
			}
			s.Failover[k] = y
		}
	}
	if t.PrioritizeByLocality != nil {
		var x ServiceResolverPrioritizeByLocality
		ServiceResolverPrioritizeByLocalityFromStructs(t.PrioritizeByLocality, &x)
		s.PrioritizeByLocality = &x
	}
	s.ConnectTimeout = structs.DurationToProto(t.ConnectTimeout)
	s.RequestTimeout = structs.DurationToProto(t.RequestTimeout)
	if t.LoadBalancer != nil {
		var x LoadBalancer
		LoadBalancerFromStructs(t.LoadBalancer, &x)
		s.LoadBalancer = &x
	}
	s.Meta = t.Meta
	s.Hash = t.Hash
}
func ServiceResolverFailoverToStructs(s *ServiceResolverFailover, t *structs.ServiceResolverFailover) {
	if s == nil {
		return
	}
	t.Service = s.Service
	t.ServiceSubset = s.ServiceSubset
	t.Namespace = s.Namespace
	t.Datacenters = s.Datacenters
	{
		t.Targets = make([]structs.ServiceResolverFailoverTarget, len(s.Targets))
		for i := range s.Targets {
			if s.Targets[i] != nil {
				ServiceResolverFailoverTargetToStructs(s.Targets[i], &t.Targets[i])
			}
		}
	}
	if s.Policy != nil {
		var x structs.ServiceResolverFailoverPolicy
		ServiceResolverFailoverPolicyToStructs(s.Policy, &x)
		t.Policy = &x
	}
	t.SamenessGroup = s.SamenessGroup
}
func ServiceResolverFailoverFromStructs(t *structs.ServiceResolverFailover, s *ServiceResolverFailover) {
	if s == nil {
		return
	}
	s.Service = t.Service
	s.ServiceSubset = t.ServiceSubset
	s.Namespace = t.Namespace
	s.Datacenters = t.Datacenters
	{
		s.Targets = make([]*ServiceResolverFailoverTarget, len(t.Targets))
		for i := range t.Targets {
			{
				var x ServiceResolverFailoverTarget
				ServiceResolverFailoverTargetFromStructs(&t.Targets[i], &x)
				s.Targets[i] = &x
			}
		}
	}
	if t.Policy != nil {
		var x ServiceResolverFailoverPolicy
		ServiceResolverFailoverPolicyFromStructs(t.Policy, &x)
		s.Policy = &x
	}
	s.SamenessGroup = t.SamenessGroup
}
func ServiceResolverFailoverPolicyToStructs(s *ServiceResolverFailoverPolicy, t *structs.ServiceResolverFailoverPolicy) {
	if s == nil {
		return
	}
	t.Mode = s.Mode
	t.Regions = s.Regions
}
func ServiceResolverFailoverPolicyFromStructs(t *structs.ServiceResolverFailoverPolicy, s *ServiceResolverFailoverPolicy) {
	if s == nil {
		return
	}
	s.Mode = t.Mode
	s.Regions = t.Regions
}
func ServiceResolverFailoverTargetToStructs(s *ServiceResolverFailoverTarget, t *structs.ServiceResolverFailoverTarget) {
	if s == nil {
		return
	}
	t.Service = s.Service
	t.ServiceSubset = s.ServiceSubset
	t.Partition = s.Partition
	t.Namespace = s.Namespace
	t.Datacenter = s.Datacenter
	t.Peer = s.Peer
}
func ServiceResolverFailoverTargetFromStructs(t *structs.ServiceResolverFailoverTarget, s *ServiceResolverFailoverTarget) {
	if s == nil {
		return
	}
	s.Service = t.Service
	s.ServiceSubset = t.ServiceSubset
	s.Partition = t.Partition
	s.Namespace = t.Namespace
	s.Datacenter = t.Datacenter
	s.Peer = t.Peer
}
func ServiceResolverPrioritizeByLocalityToStructs(s *ServiceResolverPrioritizeByLocality, t *structs.ServiceResolverPrioritizeByLocality) {
	if s == nil {
		return
	}
	t.Mode = s.Mode
}
func ServiceResolverPrioritizeByLocalityFromStructs(t *structs.ServiceResolverPrioritizeByLocality, s *ServiceResolverPrioritizeByLocality) {
	if s == nil {
		return
	}
	s.Mode = t.Mode
}
func ServiceResolverRedirectToStructs(s *ServiceResolverRedirect, t *structs.ServiceResolverRedirect) {
	if s == nil {
		return
	}
	t.Service = s.Service
	t.ServiceSubset = s.ServiceSubset
	t.Namespace = s.Namespace
	t.Partition = s.Partition
	t.Datacenter = s.Datacenter
	t.Peer = s.Peer
	t.SamenessGroup = s.SamenessGroup
}
func ServiceResolverRedirectFromStructs(t *structs.ServiceResolverRedirect, s *ServiceResolverRedirect) {
	if s == nil {
		return
	}
	s.Service = t.Service
	s.ServiceSubset = t.ServiceSubset
	s.Namespace = t.Namespace
	s.Partition = t.Partition
	s.Datacenter = t.Datacenter
	s.Peer = t.Peer
	s.SamenessGroup = t.SamenessGroup
}
func ServiceResolverSubsetToStructs(s *ServiceResolverSubset, t *structs.ServiceResolverSubset) {
	if s == nil {
		return
	}
	t.Filter = s.Filter
	t.OnlyPassing = s.OnlyPassing
}
func ServiceResolverSubsetFromStructs(t *structs.ServiceResolverSubset, s *ServiceResolverSubset) {
	if s == nil {
		return
	}
	s.Filter = t.Filter
	s.OnlyPassing = t.OnlyPassing
}
func SourceIntentionToStructs(s *SourceIntention, t *structs.SourceIntention) {
	if s == nil {
		return
	}
	t.Name = s.Name
	t.Action = intentionActionToStructs(s.Action)
	{
		t.Permissions = make([]*structs.IntentionPermission, len(s.Permissions))
		for i := range s.Permissions {
			if s.Permissions[i] != nil {
				var x structs.IntentionPermission
				IntentionPermissionToStructs(s.Permissions[i], &x)
				t.Permissions[i] = &x
			}
		}
	}
	t.Precedence = int(s.Precedence)
	t.LegacyID = s.LegacyID
	t.Type = intentionSourceTypeToStructs(s.Type)
	t.Description = s.Description
	t.LegacyMeta = s.LegacyMeta
	t.LegacyCreateTime = timeToStructs(s.LegacyCreateTime)
	t.LegacyUpdateTime = timeToStructs(s.LegacyUpdateTime)
	t.EnterpriseMeta = enterpriseMetaToStructs(s.EnterpriseMeta)
	t.Peer = s.Peer
	t.SamenessGroup = s.SamenessGroup
}
func SourceIntentionFromStructs(t *structs.SourceIntention, s *SourceIntention) {
	if s == nil {
		return
	}
	s.Name = t.Name
	s.Action = intentionActionFromStructs(t.Action)
	{
		s.Permissions = make([]*IntentionPermission, len(t.Permissions))
		for i := range t.Permissions {
			if t.Permissions[i] != nil {
				var x IntentionPermission
				IntentionPermissionFromStructs(t.Permissions[i], &x)
				s.Permissions[i] = &x
			}
		}
	}
	s.Precedence = int32(t.Precedence)
	s.LegacyID = t.LegacyID
	s.Type = intentionSourceTypeFromStructs(t.Type)
	s.Description = t.Description
	s.LegacyMeta = t.LegacyMeta
	s.LegacyCreateTime = timeFromStructs(t.LegacyCreateTime)
	s.LegacyUpdateTime = timeFromStructs(t.LegacyUpdateTime)
	s.EnterpriseMeta = enterpriseMetaFromStructs(t.EnterpriseMeta)
	s.Peer = t.Peer
	s.SamenessGroup = t.SamenessGroup
}
func StatusToStructs(s *Status, t *structs.Status) {
	if s == nil {
		return
	}
	{
		t.Conditions = make([]structs.Condition, len(s.Conditions))
		for i := range s.Conditions {
			if s.Conditions[i] != nil {
				ConditionToStructs(s.Conditions[i], &t.Conditions[i])
			}
		}
	}
}
func StatusFromStructs(t *structs.Status, s *Status) {
	if s == nil {
		return
	}
	{
		s.Conditions = make([]*Condition, len(t.Conditions))
		for i := range t.Conditions {
			{
				var x Condition
				ConditionFromStructs(&t.Conditions[i], &x)
				s.Conditions[i] = &x
			}
		}
	}
}
func TCPRouteToStructs(s *TCPRoute, t *structs.TCPRouteConfigEntry) {
	if s == nil {
		return
	}
	{
		t.Parents = make([]structs.ResourceReference, len(s.Parents))
		for i := range s.Parents {
			if s.Parents[i] != nil {
				ResourceReferenceToStructs(s.Parents[i], &t.Parents[i])
			}
		}
	}
	{
		t.Services = make([]structs.TCPService, len(s.Services))
		for i := range s.Services {
			if s.Services[i] != nil {
				TCPServiceToStructs(s.Services[i], &t.Services[i])
			}
		}
	}
	t.Meta = s.Meta
	if s.Status != nil {
		StatusToStructs(s.Status, &t.Status)
	}
	t.Hash = s.Hash
}
func TCPRouteFromStructs(t *structs.TCPRouteConfigEntry, s *TCPRoute) {
	if s == nil {
		return
	}
	{
		s.Parents = make([]*ResourceReference, len(t.Parents))
		for i := range t.Parents {
			{
				var x ResourceReference
				ResourceReferenceFromStructs(&t.Parents[i], &x)
				s.Parents[i] = &x
			}
		}
	}
	{
		s.Services = make([]*TCPService, len(t.Services))
		for i := range t.Services {
			{
				var x TCPService
				TCPServiceFromStructs(&t.Services[i], &x)
				s.Services[i] = &x
			}
		}
	}
	s.Meta = t.Meta
	{
		var x Status
		StatusFromStructs(&t.Status, &x)
		s.Status = &x
	}
	s.Hash = t.Hash
}
func TCPServiceToStructs(s *TCPService, t *structs.TCPService) {
	if s == nil {
		return
	}
	t.Name = s.Name
	t.EnterpriseMeta = enterpriseMetaToStructs(s.EnterpriseMeta)
}
func TCPServiceFromStructs(t *structs.TCPService, s *TCPService) {
	if s == nil {
		return
	}
	s.Name = t.Name
	s.EnterpriseMeta = enterpriseMetaFromStructs(t.EnterpriseMeta)
}
func TimeoutFilterToStructs(s *TimeoutFilter, t *structs.TimeoutFilter) {
	if s == nil {
		return
	}
	t.RequestTimeout = structs.DurationFromProto(s.RequestTimeout)
	t.IdleTimeout = structs.DurationFromProto(s.IdleTimeout)
}
func TimeoutFilterFromStructs(t *structs.TimeoutFilter, s *TimeoutFilter) {
	if s == nil {
		return
	}
	s.RequestTimeout = structs.DurationToProto(t.RequestTimeout)
	s.IdleTimeout = structs.DurationToProto(t.IdleTimeout)
}
func TransparentProxyConfigToStructs(s *TransparentProxyConfig, t *structs.TransparentProxyConfig) {
	if s == nil {
		return
	}
	t.OutboundListenerPort = int(s.OutboundListenerPort)
	t.DialedDirectly = s.DialedDirectly
}
func TransparentProxyConfigFromStructs(t *structs.TransparentProxyConfig, s *TransparentProxyConfig) {
	if s == nil {
		return
	}
	s.OutboundListenerPort = int32(t.OutboundListenerPort)
	s.DialedDirectly = t.DialedDirectly
}
func TransparentProxyMeshConfigToStructs(s *TransparentProxyMeshConfig, t *structs.TransparentProxyMeshConfig) {
	if s == nil {
		return
	}
	t.MeshDestinationsOnly = s.MeshDestinationsOnly
}
func TransparentProxyMeshConfigFromStructs(t *structs.TransparentProxyMeshConfig, s *TransparentProxyMeshConfig) {
	if s == nil {
		return
	}
	s.MeshDestinationsOnly = t.MeshDestinationsOnly
}
func URLRewriteToStructs(s *URLRewrite, t *structs.URLRewrite) {
	if s == nil {
		return
	}
	t.Path = s.Path
}
func URLRewriteFromStructs(t *structs.URLRewrite, s *URLRewrite) {
	if s == nil {
		return
	}
	s.Path = t.Path
}
func UpstreamConfigToStructs(s *UpstreamConfig, t *structs.UpstreamConfig) {
	if s == nil {
		return
	}
	t.Name = s.Name
	t.EnterpriseMeta = enterpriseMetaToStructs(s.EnterpriseMeta)
	t.Peer = s.Peer
	t.EnvoyListenerJSON = s.EnvoyListenerJSON
	t.EnvoyClusterJSON = s.EnvoyClusterJSON
	t.Protocol = s.Protocol
	t.ConnectTimeoutMs = int(s.ConnectTimeoutMs)
	if s.Limits != nil {
		var x structs.UpstreamLimits
		UpstreamLimitsToStructs(s.Limits, &x)
		t.Limits = &x
	}
	if s.PassiveHealthCheck != nil {
		var x structs.PassiveHealthCheck
		PassiveHealthCheckToStructs(s.PassiveHealthCheck, &x)
		t.PassiveHealthCheck = &x
	}
	if s.MeshGateway != nil {
		MeshGatewayConfigToStructs(s.MeshGateway, &t.MeshGateway)
	}
	t.BalanceOutboundConnections = s.BalanceOutboundConnections
}
func UpstreamConfigFromStructs(t *structs.UpstreamConfig, s *UpstreamConfig) {
	if s == nil {
		return
	}
	s.Name = t.Name
	s.EnterpriseMeta = enterpriseMetaFromStructs(t.EnterpriseMeta)
	s.Peer = t.Peer
	s.EnvoyListenerJSON = t.EnvoyListenerJSON
	s.EnvoyClusterJSON = t.EnvoyClusterJSON
	s.Protocol = t.Protocol
	s.ConnectTimeoutMs = int32(t.ConnectTimeoutMs)
	if t.Limits != nil {
		var x UpstreamLimits
		UpstreamLimitsFromStructs(t.Limits, &x)
		s.Limits = &x
	}
	if t.PassiveHealthCheck != nil {
		var x PassiveHealthCheck
		PassiveHealthCheckFromStructs(t.PassiveHealthCheck, &x)
		s.PassiveHealthCheck = &x
	}
	{
		var x MeshGatewayConfig
		MeshGatewayConfigFromStructs(&t.MeshGateway, &x)
		s.MeshGateway = &x
	}
	s.BalanceOutboundConnections = t.BalanceOutboundConnections
}
func UpstreamConfigurationToStructs(s *UpstreamConfiguration, t *structs.UpstreamConfiguration) {
	if s == nil {
		return
	}
	{
		t.Overrides = make([]*structs.UpstreamConfig, len(s.Overrides))
		for i := range s.Overrides {
			if s.Overrides[i] != nil {
				var x structs.UpstreamConfig
				UpstreamConfigToStructs(s.Overrides[i], &x)
				t.Overrides[i] = &x
			}
		}
	}
	if s.Defaults != nil {
		var x structs.UpstreamConfig
		UpstreamConfigToStructs(s.Defaults, &x)
		t.Defaults = &x
	}
}
func UpstreamConfigurationFromStructs(t *structs.UpstreamConfiguration, s *UpstreamConfiguration) {
	if s == nil {
		return
	}
	{
		s.Overrides = make([]*UpstreamConfig, len(t.Overrides))
		for i := range t.Overrides {
			if t.Overrides[i] != nil {
				var x UpstreamConfig
				UpstreamConfigFromStructs(t.Overrides[i], &x)
				s.Overrides[i] = &x
			}
		}
	}
	if t.Defaults != nil {
		var x UpstreamConfig
		UpstreamConfigFromStructs(t.Defaults, &x)
		s.Defaults = &x
	}
}
func UpstreamLimitsToStructs(s *UpstreamLimits, t *structs.UpstreamLimits) {
	if s == nil {
		return
	}
	t.MaxConnections = pointerToIntFromInt32(s.MaxConnections)
	t.MaxPendingRequests = pointerToIntFromInt32(s.MaxPendingRequests)
	t.MaxConcurrentRequests = pointerToIntFromInt32(s.MaxConcurrentRequests)
}
func UpstreamLimitsFromStructs(t *structs.UpstreamLimits, s *UpstreamLimits) {
	if s == nil {
		return
	}
	s.MaxConnections = int32FromPointerToInt(t.MaxConnections)
	s.MaxPendingRequests = int32FromPointerToInt(t.MaxPendingRequests)
	s.MaxConcurrentRequests = int32FromPointerToInt(t.MaxConcurrentRequests)
}
